﻿namespace ColorWanted.enums
{
    /// <summary>
    /// 全局快捷键值定义
    /// </summary>
    enum HotKeyValue
    {
        /// <summary>
        /// 切换显示模式
        /// </summary>
        SwitchMode = 0xF00001,
        /// <summary>
        /// 显示更多的颜色格式
        /// </summary>
        ShowMoreFormat,
        /// <summary>
        /// 复制颜色值
        /// </summary>
        CopyColor,
        /// <summary>
        /// 复制策略，控制是否仅复制值（同时对hex和rgb生效）
        /// </summary>
        CopyPolicy,
        /// <summary>
        /// 显示预览窗口，隐藏鼠标
        /// </summary>
        ShowPreview,
        /// <summary>
        /// 显示调色板
        /// </summary>
        ShowColorPicker,
        /// <summary>
        /// 控制是否绘制
        /// </summary>
        DrawControl
    }
}
