function make_FMC(poslist)
	local ret = ""
	local firstPos
	for i,currentPos in ipairs(poslist) do
		if i==1 then
			firstPos = currentPos
			ret = ret..string.format("0x%06x,\"", firstPos.color)
		else
			ret = ret..string.format("%d|%d|0x%06x", currentPos.x - firstPos.x, currentPos.y - firstPos.y, currentPos.color)
			if i~=#poslist then
				ret = ret..","
			end
		end
	end
	return ret..'"'
end

local datacolorfg = {
	{
		title = "Color code",
		fScript = function(poslist,area, degree)
			return string.format("x, y = findColorInRegionFuzzy(0x%06x, %d, %d, %d, %d, %d)\nif x > -1 then\n\nend",
											poslist[1].color,
											degree,
											area[1].x,
											area[1].y,
											area[2].x,
											area[2].y)
		end,
		sScript = function (poslist,area, degree)
			return string.format("x, y = findMultiColorInRegionFuzzy(%s, %d, %d, %d, %d, %d)\nif x > -1 then\n\nend",
													make_FMC(poslist),
													degree,
													area[1].x,
													area[1].y,
													area[2].x,
													area[2].y)
		end
		
	},
	{
		title = "Table data",
		fScript = function(poslist,area, degree)
				local ret = "{\n"
				for _,currentPos in ipairs(poslist) do
					ret = ret..string.format("\t{%d,%d,0x%06x},\r\n", currentPos.x, currentPos.y, currentPos.color)
				end
				return ret.."}"
		end,
		sScript = function (poslist,area, degree)
				return string.format("{\n\t%s,\n\t%d,\n\t%d, %d, %d, %d\n}",
													make_FMC(poslist),
													degree,
													area[1].x,
													area[1].y,
													area[2].x,
													area[2].y)
		end
	},
	{
		title = "Compact table data",
		fScript = function(poslist,area, degree)
				local ret = "{"
				for _,currentPos in ipairs(poslist) do
					ret = ret..string.format("{%d,%d,0x%06x},", currentPos.x, currentPos.y, currentPos.color)
				end
				return ret.."}"
		end,
		sScript = function (poslist,area, degree)
				return string.format("{%s,%d,%d,%d,%d,%d}",
													make_FMC(poslist),
													degree,
													area[1].x,
													area[1].y,
													area[2].x,
													area[2].y)
		end
	},
	

}

return datacolorfg
