--package.path = package.path .. "../config/?.lua"
local color_config = require("data");

function getName()
	local names = {};
	for i,v in pairs(color_config) do
		names[i] = v.title;
	end
	return names;
end

function Split(szFullString, szSeparator)  
	local nFindStartIndex = 1  
	local nSplitIndex = 1  
	local nSplitArray = {}  
	while true do  
	   local nFindLastIndex = string.find(szFullString, szSeparator, nFindStartIndex)  
	   if not nFindLastIndex then  
		nSplitArray[nSplitIndex] = string.sub(szFullString, nFindStartIndex, string.len(szFullString))  
		break  
	   end  
	   nSplitArray[nSplitIndex] = string.sub(szFullString, nFindStartIndex, nFindLastIndex - 1)  
	   nFindStartIndex = nFindLastIndex + string.len(szSeparator)  
	   nSplitIndex = nSplitIndex + 1  
	end  
	return nSplitArray  
end  

function getSplitList(config_string)
	local tables = Split(config_string,"},{");
	local result = {};
	for i,v in pairs(tables) do
		local sub_string = Split(v,",");
		local sub_table = {};
		for j,va in pairs(sub_string) do
			local low_string = Split(va,"=");
			if table.getn(low_string) > 1 then
				sub_table[low_string[1]] = low_string[2];
			end
		end
		result[i] = sub_table;
	end
	return result;
end

function exeConfig(name,config_string,area,degree)
	local code = {};
	local poslist = getSplitList(config_string);
	local arealist = getSplitList(area);
	for i,v in ipairs(getName(color_config)) do
		if v == name then
			code[1] = color_config[i].fScript(poslist,arealist,degree);
			code[2] = color_config[i].sScript(poslist,arealist,degree);
			break;
		end
	end
	if table.getn(code) > 1 then
	return code[1].. "@@@@@@" ..code[2];
	elseif table.getn(code) > 0 then
	return code[1];
	else
	code[1] = "";
	return code[1];
	end
end

local funcdef = "([A-Za-z_][A-Za-z0-9_%.%:]*)%s*"
local decindent = {
  ['else'] = true, ['elseif'] = true, ['until'] = true, ['end'] = true}
local incindent = {
  ['else'] = true, ['elseif'] = true, ['for'] = true, ['do'] = true,
  ['if'] = true, ['repeat'] = true, ['while'] = true}
local function isfndef(str)
  local l
  local s,e,cap,par = string.find(str, "function%s+" .. funcdef .. "(%(.-%))")
  -- try to match without brackets now, but only at the beginning of the line
  if (not s) then
    s,e,cap = string.find(str, "^%s*function%s+" .. funcdef)
  end
  -- try to match "foo = function()"
  if (not s) then
    s,e,cap,par = string.find(str, funcdef .. "=%s*function%s*(%(.-%))")
  end
  if (s) then
    l = string.find(string.sub(str,1,s-1),"local%s+$")
    cap = cap .. " " .. (par or "(?)")
  end
  return s,e,cap,l
end

function isdecindent(str)
    str = str:gsub('%-%-%[=*%[.*%]=*%]',''):gsub('%-%-.*','')
    -- this handles three different cases:
    local term = (str:match("^%s*(%w+)%s*$")
      or str:match("^%s*(elseif)[%s%(]")
      or str:match("^%s*(until)[%s%(]")
      or str:match("^%s*(else)%f[%W]")
    )
    -- (1) 'end', 'elseif', 'else', 'until'
    local match = term and decindent[term]
    -- (2) 'end)', 'end}', 'end,', and 'end;'
    if not term then term, match = str:match("^%s*(end)%s*([%)%}]*)%s*[,;]?") end
    -- endFoo could be captured as well; filter it out
    if term and str:match("^%s*(end)%w") then term = nil end
    -- (3) '},', '};', '),' and ');'
    if not term then match = str:match("^%s*[%)%}]+%s*[,;]?%s*$") end

    return match and 1 or 0, match and term and 1 or 0
  end
  
function isincindent(str)
    -- remove "long" comments and escaped slashes (to process \' and \" below)
    str = str:gsub('%-%-%[=*%[.-%]=*%]',''):gsub('\\[\\\'"]','')
    while true do
      local num, sep = nil, str:match("['\"]")
      if not sep then break end
      str, num = str:gsub(sep..".-\\"..sep,sep):gsub(sep..".-"..sep,"")
      if num == 0 then break end
    end
    str = (str
      :gsub('%[=*%[.-%]=*%]','') -- remove long strings
      :gsub('%[=*%[.*','') -- remove partial long strings
      :gsub('%-%-.*','') -- strip comments after strings are processed
      :gsub("%b()","()") -- remove all function calls
    )

    local term = str:match("^%s*(%w+)%W*")
    local terminc = term and incindent[term] and 1 or 0
    -- fix 'if' not terminated with 'then'
    -- or 'then' not started with 'if'
    if (term == 'if' or term == 'elseif') and not str:match("%f[%w]then%f[%W]")
    or (term == 'for') and not str:match("%S%s+do%f[%W]")
    or (term == 'while') and not str:match("%f[%w]do%f[%W]") then
      terminc = 0
    elseif not (term == 'if' or term == 'elseif') and str:match("%f[%w]then%f[%W]")
    or not (term == 'for') and str:match("%S%s+do%f[%W]")
    or not (term == 'while') and str:match("%f[%w]do%f[%W]") then
      terminc = 1
    end
    local _, opened = str:gsub("([%{%(])", "%1")
    local _, closed = str:gsub("([%}%)])", "%1")
    local func = (isfndef(str) or str:match("%W+function%s*%(")) and 1 or 0
    -- ended should only be used to negate term and func effects
    local anon = str:match("%W+function%s*%(.+%Wend%W")
    local ended = (terminc + func > 0) and (str:match("%W+end%s*$") or anon) and 1 or 0

    return opened - closed + func + terminc - ended
  end

config_names = getName();



--测试函数
--for i,v in ipairs(getName(color_config)) do
--	sysLog(i..":"..v);
--end

--local list = "x=1,y=1,color=0x000000},{x=2,y=2,color=0xff0000";
--local area = "x=1,y=1},{x=2,y=2";

--local value = exeConfig("测试",list,area,95);


--sysLog(value[1]);