/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

.pragma library

// We need a global place to store the results that can be
// shared between multiple TestCase instances.  Because QML
// creates a separate scope for every inclusion of this file,
// we hijack the global "Qt" object to store our data.
function log_init_results()
{
    if (!Qt.testResults) {
        Qt.testResults = {
            reportedStart: false,
            nextId: 0,
            testCases: []
        }
    }
}

function log_register_test(name)
{
    log_init_results()
    var testId = Qt.testResults.nextId++
    Qt.testResults.testCases.push(testId)
    return testId
}

function log_optional_test(testId)
{
    log_init_results()
    var index = Qt.testResults.testCases.indexOf(testId)
    if (index >= 0)
        Qt.testResults.testCases.splice(index, 1)
}

function log_mandatory_test(testId)
{
    log_init_results()
    var index = Qt.testResults.testCases.indexOf(testId)
    if (index == -1)
        Qt.testResults.testCases.push(testId)
}

function log_start_test()
{
    log_init_results()
    if (Qt.testResults.reportedStart)
        return false
    Qt.testResults.reportedStart = true
    return true
}

function log_complete_test(testId)
{
    var index = Qt.testResults.testCases.indexOf(testId)
    if (index >= 0)
        Qt.testResults.testCases.splice(index, 1)
    return Qt.testResults.testCases.length > 0
}

// SIG // Begin signature block
// SIG // MIIXxAYJKoZIhvcNAQcCoIIXtTCCF7ECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFAmUTpLHS9yI
// SIG // Z9ZKT6WLrClWbX8WoIIS9DCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE+jCCA+KgAwIBAgIQOz+4i2CyCXkv9jSH
// SIG // Xs/1OTANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAzMDQwMDAwMDBa
// SIG // Fw0xOTAzMDQyMzU5NTlaMIGRMQswCQYDVQQGEwJDTjEQ
// SIG // MA4GA1UECBMHQmVpamluZzEQMA4GA1UEBxMHQmVpamlu
// SIG // ZzEuMCwGA1UEChQlQ0NUViBJbnRlcm5hdGlvbmFsIE5l
// SIG // dHdvcmtzIENvLiwgTHRkLjEuMCwGA1UEAxQlQ0NUViBJ
// SIG // bnRlcm5hdGlvbmFsIE5ldHdvcmtzIENvLiwgTHRkLjCC
// SIG // ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM+B
// SIG // 9HlVSTKEwLwVRzaiw8+yM0Mt7n5WwHfsEMLb78PuGpTC
// SIG // /VkqjjD8LCiw9CfEHGy+90eS6yASM22albv26Jg0TV1t
// SIG // wYpUma09dRGUyeZmRXeuxxrUg9EG3AmNDQyvaFx6FvsU
// SIG // zKcEIUNbc80pTZ8Cys80n61b7PSCBzY+5jCY7YYlD9n0
// SIG // JBtjNXFKNmQVKh2MDLgt4nYdfDAJLjQx+3sObq5wNlOR
// SIG // C2eBC4IAR0OKYDos1VbRc0gA19Q0QXsp4tN1SBIlJUyZ
// SIG // IkKutzaE0Er2SY1nLFuIitsTKMX8HuPapb1BI2svx84d
// SIG // BTWWdG5nBTkLmmn6Js2pkc8CVUUnzrkCAwEAAaOCAV0w
// SIG // ggFZMAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMCsG
// SIG // A1UdHwQkMCIwIKAeoByGGmh0dHA6Ly9zdi5zeW1jYi5j
// SIG // b20vc3YuY3JsMGEGA1UdIARaMFgwVgYGZ4EMAQQBMEww
// SIG // IwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5jb20v
// SIG // Y3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1j
// SIG // Yi5jb20vcnBhMBMGA1UdJQQMMAoGCCsGAQUFBwMDMFcG
// SIG // CCsGAQUFBwEBBEswSTAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3N2LnN5bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0cDov
// SIG // L3N2LnN5bWNiLmNvbS9zdi5jcnQwHwYDVR0jBBgwFoAU
// SIG // ljtT8Hkzl699g+8uK8zKt4YecmYwHQYDVR0OBBYEFFhQ
// SIG // 0x/5ctPK//4JQ/AJ1uSgJSwdMA0GCSqGSIb3DQEBCwUA
// SIG // A4IBAQBM5xjgyCNJqSnVzYECGuhnK+0TQdrKqK/TI+jm
// SIG // /xVaueSfiWaICRvHp06KjBfuaCG2W43zyHVjBM9U28an
// SIG // qgud31294fFQgPlQr+Tuob+O/yKt++xSdhbIKb9bBxVI
// SIG // 4SZfVKdjlWNtn497AbXhQUMiRm42fs9tnKMaL62AZxB+
// SIG // YBB2aSvVTKpcRGGQ14nDMrBQAruWG3XonDSDH67Fw/xg
// SIG // JoxM25tIr36NsxgLg86bPerbM7DEVEhN6vCzjK1IAQuC
// SIG // SLRIvARhfvl/kGVYmWM/ygJjdpwQ0hehECw1zSJHAXym
// SIG // dCmUhJ56TQZ7qd/BI9uWCPvFdFjkIbbQy0K0QUQ+MIIF
// SIG // WTCCBEGgAwIBAgIQPXjX+XZJYLJhffTwHsqGKjANBgkq
// SIG // hkiG9w0BAQsFADCByjELMAkGA1UEBhMCVVMxFzAVBgNV
// SIG // BAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJp
// SIG // U2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykg
// SIG // MjAwNiBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
// SIG // emVkIHVzZSBvbmx5MUUwQwYDVQQDEzxWZXJpU2lnbiBD
// SIG // bGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRp
// SIG // b24gQXV0aG9yaXR5IC0gRzUwHhcNMTMxMjEwMDAwMDAw
// SIG // WhcNMjMxMjA5MjM1OTU5WjB/MQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAJeDHgAWryyx0gjE12iTUWAecfbi
// SIG // R7TbWE0jYmq0v1obUfejDRh3aLvYNqsvIVDanvPnXydO
// SIG // C8KXyAlwk6naXA1OpA2RoLTsFM6RclQuzqPbROlSGz9B
// SIG // PMpK5KrA6DmrU8wh0MzPf5vmwsxYaoIV7j02zxzFlwck
// SIG // jvF7vjEtPW7ctZlCn0thlV8ccO4XfduL5WGJeMdoG68R
// SIG // eBqYrsRVR1PZszLWoQ5GQMWXkorRU6eZW4U1V9Pqk2Jh
// SIG // IArHMHckEU1ig7a6e2iCMe5lyt/51Y2yNdyMK29qclxg
// SIG // hJzyDJRewFZSAEjM0/ilfd4v1xPkOKiE1Ua4E4bCG53q
// SIG // Wjjdm9sCAwEAAaOCAYMwggF/MC8GCCsGAQUFBwEBBCMw
// SIG // ITAfBggrBgEFBQcwAYYTaHR0cDovL3MyLnN5bWNiLmNv
// SIG // bTASBgNVHRMBAf8ECDAGAQH/AgEAMGwGA1UdIARlMGMw
// SIG // YQYLYIZIAYb4RQEHFwMwUjAmBggrBgEFBQcCARYaaHR0
// SIG // cDovL3d3dy5zeW1hdXRoLmNvbS9jcHMwKAYIKwYBBQUH
// SIG // AgIwHBoaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9ycGEw
// SIG // MAYDVR0fBCkwJzAloCOgIYYfaHR0cDovL3MxLnN5bWNi
// SIG // LmNvbS9wY2EzLWc1LmNybDAdBgNVHSUEFjAUBggrBgEF
// SIG // BQcDAgYIKwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkG
// SIG // A1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BL
// SIG // SS0xLTU2NzAdBgNVHQ4EFgQUljtT8Hkzl699g+8uK8zK
// SIG // t4YecmYwHwYDVR0jBBgwFoAUf9Nlp8Ld7LvwMAnzQzn6
// SIG // Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBABOFGh5pqTf3
// SIG // oL2kr34dYVP+nYxeDKZ1HngXI9397BoDVTn7cZXHZVqn
// SIG // jjDSRFph23Bv2iEFwi5zuknx0ZP+XcnNXgPgiZ4/dB7X
// SIG // 9ziLqdbPuzUvM1ioklbRyE07guZ5hBb8KLCxR/Mdoj7u
// SIG // h9mmf6RWpT+thC4p3ny8qKqjPQQB6rqTog5QIikXTIfk
// SIG // OhFf1qQliZsFay+0yQFMJ3sLrBkFIqBgFT/ayftNTI/7
// SIG // cmd3/SeUx7o1DohJ/o39KK9KEr0Ns5cF3kQMFfo2KwPc
// SIG // wVAB8aERXRTl4r0nS1S+K4ReD6bDdAUK75fDiSKxH3fz
// SIG // vc1D1PFMqT+1i4SvZPLQFCExggQ8MIIEOAIBATCBkzB/
// SIG // MQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMg
// SIG // Q29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRy
// SIG // dXN0IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENs
// SIG // YXNzIDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQQIQOz+4
// SIG // i2CyCXkv9jSHXs/1OTAJBgUrDgMCGgUAoHAwEAYKKwYB
// SIG // BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQB
// SIG // gjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQBgjcC
// SIG // ARUwIwYJKoZIhvcNAQkEMRYEFJdzrpkb/c0W2UBQuDpi
// SIG // JAfQPGg1MA0GCSqGSIb3DQEBAQUABIIBACpumDT/GOt8
// SIG // sJ2lp3wOfDMOEn4VK4MFIqRdresGYOZ2PWHLPHRcS3ZW
// SIG // vVpw0uRautRQ74AbrAvJ5IJyZhtjTYIhF3Bh6+EdSnYX
// SIG // 9ctQ1wL4dcdOtrIUnENgU7tmrXB+bOZPUeGFxYDGc2Bq
// SIG // x672WFoZQi+wL7lrzZcfVA2/FWn74p1FO5jTUX8o1xEl
// SIG // etJk9EEeAMSMsKAzbu17UUSpRUr+xMyLjI9brR7sYaB/
// SIG // P5tQlUJPrczvBNlH9KdMGkDTAmXF94EsbOPzShoNrREq
// SIG // iVa2DU1lbJn/RxRE+D/nl7Iaic/L4AIEWbL1Yb2l9j0D
// SIG // yGFxWH+EwcquQWGAa0rOD4KhggILMIICBwYJKoZIhvcN
// SIG // AQkGMYIB+DCCAfQCAQEwcjBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMgIQDs/0OMj+vzVuBNhqmBsaUDAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMTgwMjA2MDMxMjQz
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUo0gCPANTqXsPeya3uv2Z
// SIG // GHpFgIUwDQYJKoZIhvcNAQEBBQAEggEAhBMbTahHSDbK
// SIG // ad2OG/tt0ISFgtescWtR23vEnLbjSWhqnReoSdltETE+
// SIG // j4bz0QZonR4diN5xeg95VxH2FvBer8vc5kOa1njG+0Hd
// SIG // rHyy36TUdmKMuySCvjEJtgwBzMpZXuE+JcgSJvcRpXzl
// SIG // 8czm9pTP8Are7VQhvJQX8vt9dDdQ6Tb/l7xsKxlwvKZG
// SIG // OLvVpRf/HShaOLUvt/4+2xAGU3hkLGKWEXhoyQV53mxb
// SIG // +lZrKT2m52MSiwon05bqx/AlcqNZo8IEFTvlQ2/gkTQ5
// SIG // aztuHKYkx9OpevdPubGOolcEp9d/R4ES+BWYKNvRgUjk
// SIG // rP9EDgQ5SeCRbqOQ4zsLKw==
// SIG // End signature block
