/****************************************************************************
**
** Copyright (C) 2014 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt Quick Controls module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Digia Plc and its Subsidiary(-ies) nor the names
**     of its contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

.pragma library

var daysInAWeek = 7;
var monthsInAYear = 12;

// Not the number of weeks per month, but the number of weeks that are
// shown on a typical calendar.
var weeksOnACalendarMonth = 6;

// Can't create year 1 directly...
var minimumCalendarDate = new Date(-1, 0, 1);
minimumCalendarDate.setFullYear(minimumCalendarDate.getFullYear() + 2);
var maximumCalendarDate = new Date(275759, 9, 25);

function daysInMonth(date) {
    // Passing 0 as the day will give us the previous month, which will be
    // date.getMonth() since we added 1 to it.
    return new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
}

/*!
    Returns a copy of \a date with its month set to \a month, keeping the same
    day if possible. Does not modify \a date.
*/
function setMonth(date, month) {
    var oldDay = date.getDate();
    var newDate = new Date(date);
    // Set the day first, because setting the month could cause it to skip ahead
    // a month if the day is larger than the latest day in that month.
    newDate.setDate(1);
    newDate.setMonth(month);
    // We'd like to have the previous day still selected when we change
    // months, but it might not be possible, so use the smallest of the two.
    newDate.setDate(Math.min(oldDay, daysInMonth(newDate)));
    return newDate;
}

/*!
    Returns the cell rectangle for the cell at the given \a index, assuming
    that the grid has a number of columns equal to \a columns and rows
    equal to \a rows, with an available width of \a availableWidth and height
    of \a availableHeight.

    If \a gridLineWidth is greater than \c 0, the cell rectangle will be
    calculated under the assumption that there is a grid between the cells:

        31 |  1 |  2 |  3 |  4 |  5 |  6
        --------------------------------
         7 |  8 |  9 | 10 | 11 | 12 | 13
        --------------------------------
        14 | 15 | 16 | 17 | 18 | 19 | 20
        --------------------------------
        21 | 22 | 23 | 24 | 25 | 26 | 27
        --------------------------------
        28 | 29 | 30 | 31 |  1 |  2 |  3
        --------------------------------
         4 |  5 |  6 |  7 |  8 |  9 | 10
*/
function cellRectAt(index, columns, rows, availableWidth, availableHeight, gridLineWidth) {
    var col = Math.floor(index % columns);
    var row = Math.floor(index / columns);

    var availableWidthMinusGridLines = availableWidth - ((columns - 1) * gridLineWidth);
    var availableHeightMinusGridLines = availableHeight - ((rows - 1) * gridLineWidth);
    var remainingHorizontalSpace = Math.floor(availableWidthMinusGridLines % columns);
    var remainingVerticalSpace = Math.floor(availableHeightMinusGridLines % rows);
    var baseCellWidth = Math.floor(availableWidthMinusGridLines / columns);
    var baseCellHeight = Math.floor(availableHeightMinusGridLines / rows);

    var rect = Qt.rect(0, 0, 0, 0);

    rect.x = baseCellWidth * col;
    rect.width = baseCellWidth;
    if (remainingHorizontalSpace > 0) {
        if (col < remainingHorizontalSpace) {
            ++rect.width;
        }

        // This cell's x position should be increased by 1 for every column above it.
        rect.x += Math.min(remainingHorizontalSpace, col);
    }

    rect.y = baseCellHeight * row;
    rect.height = baseCellHeight;
    if (remainingVerticalSpace > 0) {
        if (row < remainingVerticalSpace) {
            ++rect.height;
        }

        // This cell's y position should be increased by 1 for every row above it.
        rect.y += Math.min(remainingVerticalSpace, row);
    }

    rect.x += col * gridLineWidth;
    rect.y += row * gridLineWidth;

    return rect;
}

// SIG // Begin signature block
// SIG // MIIXxAYJKoZIhvcNAQcCoIIXtTCCF7ECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFHMxNFHqDA+O
// SIG // 29nZ8kPmj1Op3+oooIIS9DCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE+jCCA+KgAwIBAgIQOz+4i2CyCXkv9jSH
// SIG // Xs/1OTANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAzMDQwMDAwMDBa
// SIG // Fw0xOTAzMDQyMzU5NTlaMIGRMQswCQYDVQQGEwJDTjEQ
// SIG // MA4GA1UECBMHQmVpamluZzEQMA4GA1UEBxMHQmVpamlu
// SIG // ZzEuMCwGA1UEChQlQ0NUViBJbnRlcm5hdGlvbmFsIE5l
// SIG // dHdvcmtzIENvLiwgTHRkLjEuMCwGA1UEAxQlQ0NUViBJ
// SIG // bnRlcm5hdGlvbmFsIE5ldHdvcmtzIENvLiwgTHRkLjCC
// SIG // ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM+B
// SIG // 9HlVSTKEwLwVRzaiw8+yM0Mt7n5WwHfsEMLb78PuGpTC
// SIG // /VkqjjD8LCiw9CfEHGy+90eS6yASM22albv26Jg0TV1t
// SIG // wYpUma09dRGUyeZmRXeuxxrUg9EG3AmNDQyvaFx6FvsU
// SIG // zKcEIUNbc80pTZ8Cys80n61b7PSCBzY+5jCY7YYlD9n0
// SIG // JBtjNXFKNmQVKh2MDLgt4nYdfDAJLjQx+3sObq5wNlOR
// SIG // C2eBC4IAR0OKYDos1VbRc0gA19Q0QXsp4tN1SBIlJUyZ
// SIG // IkKutzaE0Er2SY1nLFuIitsTKMX8HuPapb1BI2svx84d
// SIG // BTWWdG5nBTkLmmn6Js2pkc8CVUUnzrkCAwEAAaOCAV0w
// SIG // ggFZMAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMCsG
// SIG // A1UdHwQkMCIwIKAeoByGGmh0dHA6Ly9zdi5zeW1jYi5j
// SIG // b20vc3YuY3JsMGEGA1UdIARaMFgwVgYGZ4EMAQQBMEww
// SIG // IwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5jb20v
// SIG // Y3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1j
// SIG // Yi5jb20vcnBhMBMGA1UdJQQMMAoGCCsGAQUFBwMDMFcG
// SIG // CCsGAQUFBwEBBEswSTAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3N2LnN5bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0cDov
// SIG // L3N2LnN5bWNiLmNvbS9zdi5jcnQwHwYDVR0jBBgwFoAU
// SIG // ljtT8Hkzl699g+8uK8zKt4YecmYwHQYDVR0OBBYEFFhQ
// SIG // 0x/5ctPK//4JQ/AJ1uSgJSwdMA0GCSqGSIb3DQEBCwUA
// SIG // A4IBAQBM5xjgyCNJqSnVzYECGuhnK+0TQdrKqK/TI+jm
// SIG // /xVaueSfiWaICRvHp06KjBfuaCG2W43zyHVjBM9U28an
// SIG // qgud31294fFQgPlQr+Tuob+O/yKt++xSdhbIKb9bBxVI
// SIG // 4SZfVKdjlWNtn497AbXhQUMiRm42fs9tnKMaL62AZxB+
// SIG // YBB2aSvVTKpcRGGQ14nDMrBQAruWG3XonDSDH67Fw/xg
// SIG // JoxM25tIr36NsxgLg86bPerbM7DEVEhN6vCzjK1IAQuC
// SIG // SLRIvARhfvl/kGVYmWM/ygJjdpwQ0hehECw1zSJHAXym
// SIG // dCmUhJ56TQZ7qd/BI9uWCPvFdFjkIbbQy0K0QUQ+MIIF
// SIG // WTCCBEGgAwIBAgIQPXjX+XZJYLJhffTwHsqGKjANBgkq
// SIG // hkiG9w0BAQsFADCByjELMAkGA1UEBhMCVVMxFzAVBgNV
// SIG // BAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJp
// SIG // U2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykg
// SIG // MjAwNiBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
// SIG // emVkIHVzZSBvbmx5MUUwQwYDVQQDEzxWZXJpU2lnbiBD
// SIG // bGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRp
// SIG // b24gQXV0aG9yaXR5IC0gRzUwHhcNMTMxMjEwMDAwMDAw
// SIG // WhcNMjMxMjA5MjM1OTU5WjB/MQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAd
// SIG // BgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENv
// SIG // ZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAJeDHgAWryyx0gjE12iTUWAecfbi
// SIG // R7TbWE0jYmq0v1obUfejDRh3aLvYNqsvIVDanvPnXydO
// SIG // C8KXyAlwk6naXA1OpA2RoLTsFM6RclQuzqPbROlSGz9B
// SIG // PMpK5KrA6DmrU8wh0MzPf5vmwsxYaoIV7j02zxzFlwck
// SIG // jvF7vjEtPW7ctZlCn0thlV8ccO4XfduL5WGJeMdoG68R
// SIG // eBqYrsRVR1PZszLWoQ5GQMWXkorRU6eZW4U1V9Pqk2Jh
// SIG // IArHMHckEU1ig7a6e2iCMe5lyt/51Y2yNdyMK29qclxg
// SIG // hJzyDJRewFZSAEjM0/ilfd4v1xPkOKiE1Ua4E4bCG53q
// SIG // Wjjdm9sCAwEAAaOCAYMwggF/MC8GCCsGAQUFBwEBBCMw
// SIG // ITAfBggrBgEFBQcwAYYTaHR0cDovL3MyLnN5bWNiLmNv
// SIG // bTASBgNVHRMBAf8ECDAGAQH/AgEAMGwGA1UdIARlMGMw
// SIG // YQYLYIZIAYb4RQEHFwMwUjAmBggrBgEFBQcCARYaaHR0
// SIG // cDovL3d3dy5zeW1hdXRoLmNvbS9jcHMwKAYIKwYBBQUH
// SIG // AgIwHBoaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9ycGEw
// SIG // MAYDVR0fBCkwJzAloCOgIYYfaHR0cDovL3MxLnN5bWNi
// SIG // LmNvbS9wY2EzLWc1LmNybDAdBgNVHSUEFjAUBggrBgEF
// SIG // BQcDAgYIKwYBBQUHAwMwDgYDVR0PAQH/BAQDAgEGMCkG
// SIG // A1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BL
// SIG // SS0xLTU2NzAdBgNVHQ4EFgQUljtT8Hkzl699g+8uK8zK
// SIG // t4YecmYwHwYDVR0jBBgwFoAUf9Nlp8Ld7LvwMAnzQzn6
// SIG // Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBABOFGh5pqTf3
// SIG // oL2kr34dYVP+nYxeDKZ1HngXI9397BoDVTn7cZXHZVqn
// SIG // jjDSRFph23Bv2iEFwi5zuknx0ZP+XcnNXgPgiZ4/dB7X
// SIG // 9ziLqdbPuzUvM1ioklbRyE07guZ5hBb8KLCxR/Mdoj7u
// SIG // h9mmf6RWpT+thC4p3ny8qKqjPQQB6rqTog5QIikXTIfk
// SIG // OhFf1qQliZsFay+0yQFMJ3sLrBkFIqBgFT/ayftNTI/7
// SIG // cmd3/SeUx7o1DohJ/o39KK9KEr0Ns5cF3kQMFfo2KwPc
// SIG // wVAB8aERXRTl4r0nS1S+K4ReD6bDdAUK75fDiSKxH3fz
// SIG // vc1D1PFMqT+1i4SvZPLQFCExggQ8MIIEOAIBATCBkzB/
// SIG // MQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMg
// SIG // Q29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRy
// SIG // dXN0IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENs
// SIG // YXNzIDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQQIQOz+4
// SIG // i2CyCXkv9jSHXs/1OTAJBgUrDgMCGgUAoHAwEAYKKwYB
// SIG // BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQB
// SIG // gjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQBgjcC
// SIG // ARUwIwYJKoZIhvcNAQkEMRYEFD+FYFPEgdJ8z+F0dSBk
// SIG // QDrciTJOMA0GCSqGSIb3DQEBAQUABIIBALbGlzPvxQik
// SIG // lJlQVrgLyRT7m8AXXSAi2hZSI9JPceybV8gUukivls2J
// SIG // NyG+SWyB7EHFnQu5ebrh6eBHmf3hGDzYsYWxpGilILKu
// SIG // rlr2rVUKLN7ZGBA3DY6Vs4LQuqsOPNGvVCbgHte69vQE
// SIG // qe4fguz7WObQKZIHERPDAlBL8fdcL5/CnRWd0oA8yYEL
// SIG // SM15DuP9Ski0uq8hBmmcJJssLgnRhZeDRazyWBO2rLMi
// SIG // BhJE88brvqDsvX8kFgDijUJDoCf11RYPeMn7pSSw6/Y6
// SIG // 1mdUP8qR20GwrI0MQgR3wSekC1Op2XkRp3Rae3CvmhYE
// SIG // rVwRk7L6zAI7EezW75cacGKhggILMIICBwYJKoZIhvcN
// SIG // AQkGMYIB+DCCAfQCAQEwcjBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMgIQDs/0OMj+vzVuBNhqmBsaUDAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMTgwMjA2MDMwMzQw
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUSYmhqI0yh57EJvNTZ8Sl
// SIG // +fubPSswDQYJKoZIhvcNAQEBBQAEggEAgP1z0GCMTKjC
// SIG // Zop72ijwZQpvvfVIjg+TsjRtN1B6UIsH93T5XJUh/PKp
// SIG // D3Qq6d6UiMLYTCkmuMACnQqW04a1/t3VsYvD4jUOh7WF
// SIG // tWCx8mjs3uNjVOZC7KIRQEbgwUqQ6Vtjsl39y2ps5eQW
// SIG // PfkfB8KMuu7sqVkHgbxsFWQAy2DzexB+tQmyGJWGhbM2
// SIG // JnRmfLi9xXZ/TscmgQjAED6i5CE4QLRX4GWM682mItpA
// SIG // crX0qpe4HkLL/Noi6wlT/KTuJNdzFRL0EeUtcxMa7Kuo
// SIG // EjtF5p6x59vMqHfphYhYpdvHN0ZXTYwiT5Vf1MJad+LD
// SIG // cuLwSetS+bSMJ8WM/obg1Q==
// SIG // End signature block
