/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PageNumberParser {
    public static Set<Integer> parsePageNumber(String input) throws ParseException {
        Pattern p = Pattern.compile("[^0-9-;]");
        Matcher m = p.matcher(input);
        if (m.find()) {
            throw new ParseException("Allowed characters: \"0-9\" \";\" \"-\" ", 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(input, ";");
        HashSet<Integer> pNS = new HashSet<Integer>();
        while (tokenizer.hasMoreElements()) {
            pNS.addAll(PageNumberParser.extractPageNumbers(tokenizer.nextToken()));
        }
        return pNS;
    }

    private static Set<Integer> extractPageNumbers(String input) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(input, "-");
        HashSet<Integer> returnSet = new HashSet<Integer>();
        if (tokenizer.countTokens() == 1) {
            Integer pageNumber = Integer.parseInt(input);
            returnSet.add(pageNumber);
            return returnSet;
        }
        if (tokenizer.countTokens() == 2) {
            int end;
            int start = Integer.parseInt(tokenizer.nextToken());
            if (start > (end = Integer.parseInt(tokenizer.nextToken()))) {
                throw new ParseException("End must be bigger than start in \"" + input + "\"", 0);
            }
            int i = start;
            while (i <= end) {
                returnSet.add(i);
                ++i;
            }
            return returnSet;
        }
        throw new ParseException("\"" + input + "\" has to many - characters!", 0);
    }
}

