/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

public class PDFPageCluster
implements Comparable<PDFPageCluster> {
    private static final int MERGE_VARIABILITY = 20;
    private static final int MAX_MERGE_PAGES = 20;
    private static final int MAX_PAGE_HEIGHT = 900;
    private static final int MAX_IMAGE_RENDER_SIZE = 4000000;
    private List<Integer> pagesToMerge;
    private List<Integer> allPages;
    private BufferedImage previewImage;
    private WritableRaster raster = null;
    private double[][] imageData = null;
    private List<Float[]> cropRatiosList = new ArrayList<Float[]>();
    private int excludedPageNumber = -1;
    private boolean renderable;
    private boolean evenPage;
    private int pageWidth;
    private int pageHeight;

    public PDFPageCluster(boolean isEvenPage, int pageWidth, int pageHeight, int excludedPageNumber) {
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.renderable = pageWidth * pageHeight < 4000000;
        this.evenPage = isEvenPage;
        this.excludedPageNumber = excludedPageNumber;
        this.pagesToMerge = new ArrayList<Integer>();
    }

    public void addImageToPreview(BufferedImage imageToAdd) {
        if (!this.renderable) {
            return;
        }
        if (this.previewImage == null) {
            int pageHeight = imageToAdd.getHeight() > 900 ? 900 : imageToAdd.getHeight();
            float scaleFactor = (float)pageHeight / (float)imageToAdd.getHeight();
            int pageWidth = (int)((float)imageToAdd.getWidth() * scaleFactor);
            this.previewImage = new BufferedImage(pageWidth, pageHeight, 10);
            this.previewImage.getGraphics().drawImage(PDFPageCluster.scaleImage(imageToAdd, pageWidth, pageHeight), 0, 0, null);
            this.raster = this.previewImage.getRaster().createCompatibleWritableRaster();
            this.imageData = new double[this.previewImage.getWidth()][this.previewImage.getHeight()];
        }
        PDFPageCluster.average(PDFPageCluster.scaleImage(imageToAdd, this.previewImage.getWidth(), this.previewImage.getHeight()), this.imageData);
    }

    private static void average(BufferedImage image, double[][] values) {
        int k = 0;
        while (k < image.getHeight()) {
            int j = 0;
            while (j < image.getWidth()) {
                double[] dArray = values[j];
                int n = k;
                dArray[n] = dArray[n] + (double)image.getRaster().getSample(j, k, 0);
                ++j;
            }
            ++k;
        }
    }

    private static BufferedImage scaleImage(BufferedImage bsrc, int width, int height) {
        BufferedImage bdest = new BufferedImage(width, height, 10);
        Graphics2D g = bdest.createGraphics();
        AffineTransform at = AffineTransform.getScaleInstance((double)bdest.getWidth() / (double)bsrc.getWidth(), (double)bdest.getHeight() / (double)bsrc.getHeight());
        g.drawRenderedImage(bsrc, at);
        g.dispose();
        return bdest;
    }

    private static BufferedImage getUnrenderableImage() {
        int width = 200;
        int height = 200;
        BufferedImage bimage = new BufferedImage(width, height, 1);
        Graphics2D g2d = bimage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.drawRect(5, 5, 190, 190);
        Font font = new Font("Sansserif", 1, 22);
        g2d.setFont(font);
        g2d.setColor(Color.WHITE);
        g2d.drawString("Image to Big!", 10, 110);
        g2d.dispose();
        return bimage;
    }

    public BufferedImage getPreviewImage() {
        if (!this.renderable) {
            return PDFPageCluster.getUnrenderableImage();
        }
        int k = 0;
        while (k < this.previewImage.getHeight()) {
            int j = 0;
            while (j < this.previewImage.getWidth()) {
                this.raster.setSample(j, k, 0, Math.round(this.imageData[j][k] / (double)this.getPagesToMerge().size()));
                ++j;
            }
            ++k;
        }
        this.previewImage.setData(this.raster);
        return this.previewImage;
    }

    public List<Float[]> getRatiosList() {
        return this.cropRatiosList;
    }

    public void clearRatios() {
        this.cropRatiosList.clear();
    }

    public void addRatios(Float[] ratios) {
        this.cropRatiosList.add(ratios);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.evenPage ? 1231 : 1237);
        result = 31 * result + this.excludedPageNumber;
        result = 31 * result + this.getRoundedPageHeight();
        result = 31 * result + this.getRoundedPageWidth();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PDFPageCluster other = (PDFPageCluster)obj;
        if (this.evenPage != other.evenPage) {
            return false;
        }
        if (this.excludedPageNumber != other.excludedPageNumber) {
            return false;
        }
        if (this.getRoundedPageHeight() != other.getRoundedPageHeight()) {
            return false;
        }
        return this.getRoundedPageWidth() == other.getRoundedPageWidth();
    }

    public boolean isEvenPage() {
        return this.evenPage;
    }

    public int getRoundedPageHeight() {
        int tmp = this.pageHeight / 20;
        return tmp * 20;
    }

    public int getRoundedPageWidth() {
        int tmp = this.pageWidth / 20;
        return tmp * 20;
    }

    public void choosePagesToMerge(List<Integer> pages) {
        this.allPages = pages;
        if (pages.size() < 20) {
            this.pagesToMerge = pages;
        } else {
            float stepWidth = (float)pages.size() / 20.0f;
            float totalStepped = 0.0f;
            int i = 0;
            while (i < 20) {
                this.pagesToMerge.add(pages.get(new Double(Math.floor(totalStepped)).intValue()));
                totalStepped += stepWidth;
                ++i;
            }
        }
    }

    public List<Integer> getAllPages() {
        return this.allPages;
    }

    public List<Integer> getPagesToMerge() {
        return this.pagesToMerge;
    }

    public boolean isFunctional() {
        return this.renderable;
    }

    @Override
    public int compareTo(PDFPageCluster that) {
        return this.getFirstPage() - that.getFirstPage();
    }

    private int getFirstPage() {
        int small = Integer.MAX_VALUE;
        for (Integer tmp : this.allPages) {
            if (tmp >= small) continue;
            small = tmp;
        }
        return small;
    }
}

