/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.PDFPageCluster;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class MergedPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static CropRect lastCrop;
    private static CropRect curCrop;
    private static Point lastDragPoint;
    private static Point cropStartPoint;
    private static int dragCropIndex;
    private static final Composite compositeSmooth;
    private static final Composite compositeXor;
    private final List<CropRect> crops = new ArrayList<CropRect>();
    private final PDFPageCluster cluster;
    private BufferedImage img;

    static {
        dragCropIndex = -1;
        compositeSmooth = AlphaComposite.getInstance(3, 0.2f);
        compositeXor = AlphaComposite.getInstance(3, 0.8f);
    }

    public MergedPanel(PDFPageCluster cluster) {
        this.cluster = cluster;
        this.img = cluster.getPreviewImage();
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
        if (cluster.isFunctional()) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }
        this.setToolTipText(this.createInfoString(cluster));
    }

    private String createInfoString(PDFPageCluster cluster) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(cluster.isEvenPage() ? "Even " : "Odd ").append("page<br>");
        sb.append(String.valueOf(cluster.getAllPages().size()) + " pages: ");
        int pagecounter = 0;
        for (Integer pageNumber : cluster.getAllPages()) {
            sb.append(pageNumber + " ");
            if (pagecounter++ <= 10) continue;
            pagecounter = 0;
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        if (!this.isEnabled()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.img, null, 0, 0);
        int cropCnt = 0;
        Font currentFont = g2.getFont();
        g2.setComposite(compositeSmooth);
        for (CropRect crop : this.crops) {
            g2.setColor(Color.BLUE);
            g2.fill(crop);
            g2.setColor(Color.BLACK);
            Font scaledFont = MergedPanel.scaleFont(String.valueOf(cropCnt++), crop, g2, currentFont);
            g2.setFont(scaledFont);
            g2.drawString(String.valueOf(cropCnt), crop.x, crop.y + crop.height);
            if (!crop.isSelected()) continue;
            g2.setComposite(compositeXor);
            g2.setColor(Color.BLACK);
            scaledFont = MergedPanel.scaleFont("Selected", crop, g2, currentFont);
            g2.setFont(scaledFont);
            g2.fill(crop);
            g2.setColor(Color.YELLOW);
            g2.setComposite(compositeSmooth);
            g2.drawString("Selected", crop.x, crop.y + crop.height);
        }
        g2.setColor(Color.BLUE);
        if (curCrop != null) {
            g2.fill(curCrop);
            if (lastCrop != null) {
                g2.setColor(Color.GREEN);
                g2.setStroke(new BasicStroke(3.0f));
                g2.setComposite(compositeXor);
                g2.drawRect(MergedPanel.curCrop.x, MergedPanel.curCrop.y, MergedPanel.lastCrop.width, MergedPanel.lastCrop.height);
            }
        }
        g2.dispose();
    }

    @Override
    public void mouseDragged(MouseEvent mE) {
        Point curPoint = mE.getPoint();
        if (dragCropIndex == -1) {
            if (cropStartPoint == null) {
                cropStartPoint = curPoint;
            }
            curCrop = new CropRect();
            MergedPanel.curCrop.x = curPoint.x < MergedPanel.cropStartPoint.x ? curPoint.x : MergedPanel.cropStartPoint.x;
            MergedPanel.curCrop.width = Math.abs(curPoint.x - MergedPanel.cropStartPoint.x);
            MergedPanel.curCrop.y = curPoint.y < MergedPanel.cropStartPoint.y ? curPoint.y : MergedPanel.cropStartPoint.y;
            MergedPanel.curCrop.height = Math.abs(curPoint.y - MergedPanel.cropStartPoint.y);
        } else {
            if (lastDragPoint == null) {
                lastDragPoint = curPoint;
            }
            this.crops.get(dragCropIndex).translate(curPoint.x - MergedPanel.lastDragPoint.x, curPoint.y - MergedPanel.lastDragPoint.y);
            lastDragPoint = curPoint;
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent mE) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent mE) {
        Point p = mE.getPoint();
        if (mE.isControlDown()) {
            for (CropRect cropRect : this.crops) {
                if (!cropRect.contains(p)) continue;
                cropRect.setSelected(!cropRect.isSelected());
            }
            this.repaint();
            return;
        }
        if (mE.getButton() == 1) {
            for (Rectangle rectangle : this.crops) {
                if (!rectangle.contains(p)) continue;
                dragCropIndex = this.crops.indexOf(rectangle);
            }
            if (dragCropIndex == -1) {
                cropStartPoint = p;
            }
        } else {
            int n;
            int n2 = -1;
            for (Rectangle rectangle : this.crops) {
                if (!rectangle.contains(p)) continue;
                n = this.crops.indexOf(rectangle);
            }
            if (n != -1) {
                this.crops.remove(n);
            }
            this.cluster.clearRatios();
            this.repaint();
        }
    }

    public int getWidestRect() {
        int max = -1;
        for (CropRect crop : this.crops) {
            if (!crop.isSelected() || crop.width <= max) continue;
            max = crop.width;
        }
        return max;
    }

    public int getHeighestRect() {
        int max = -1;
        for (CropRect crop : this.crops) {
            if (!crop.isSelected() || crop.height <= max) continue;
            max = crop.height;
        }
        return max;
    }

    public void setSelCropWidth(int width) {
        for (CropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            int diffToMax = width - crop.width;
            crop.grow(diffToMax / 2, 0);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    public void setSelCropHeight(int height) {
        for (CropRect crop : this.crops) {
            if (!crop.isSelected()) continue;
            int diffToMax = height - crop.height;
            crop.grow(0, diffToMax / 2);
        }
        this.updateClusterRatios(this.crops);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (curCrop != null) {
            this.crops.add(curCrop);
            lastCrop = curCrop;
        }
        ArrayList<Rectangle> cropsToTrash = new ArrayList<Rectangle>();
        for (Rectangle rectangle : this.crops) {
            if (!(rectangle.getWidth() < 5.0) && !(rectangle.getHeight() < 5.0)) continue;
            cropsToTrash.add(rectangle);
        }
        this.crops.removeAll(cropsToTrash);
        this.updateClusterRatios(this.crops);
        cropStartPoint = null;
        lastDragPoint = null;
        dragCropIndex = -1;
        curCrop = null;
        this.repaint();
    }

    private void updateClusterRatios(List<CropRect> tmpCrops) {
        this.cluster.clearRatios();
        for (Rectangle rectangle : tmpCrops) {
            this.cluster.addRatios(MergedPanel.getCutRatiosForPdf(rectangle, this.img.getWidth(), this.img.getHeight()));
        }
    }

    private static Float[] getCutRatiosForPdf(Rectangle crop, int imgWidth, int imgHeight) {
        int x1 = crop.x;
        int x2 = x1 + crop.width;
        int y1 = crop.y;
        int y2 = y1 + crop.height;
        if (x1 < 0) {
            x1 = 0;
        }
        if (x2 > imgWidth) {
            x2 = imgWidth;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 > imgHeight) {
            y2 = imgHeight;
        }
        Float[] ratios = new Float[]{Float.valueOf((float)x1 / (float)imgWidth), Float.valueOf((float)(imgHeight - y2) / (float)imgHeight), Float.valueOf(1.0f - (float)x2 / (float)imgWidth), Float.valueOf(1.0f - (float)(imgHeight - y1) / (float)imgHeight)};
        return ratios;
    }

    private static Font scaleFont(String text, Rectangle rect, Graphics g, Font pFont) {
        Font font = pFont;
        float fontSize = font.getSize();
        font = g.getFont().deriveFont(fontSize);
        int width = g.getFontMetrics(font).stringWidth(text);
        int height = g.getFontMetrics(font).getHeight();
        float scaleFactorWidth = rect.width / width;
        float scaleFactorHeight = rect.height / height;
        float scaledWidth = scaleFactorWidth * fontSize;
        float scaledHeight = scaleFactorHeight * fontSize;
        return g.getFont().deriveFont(scaleFactorHeight > scaleFactorWidth ? scaledWidth : scaledHeight);
    }

    private class CropRect
    extends Rectangle {
        private boolean selected = false;

        private CropRect() {
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

