/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.ClusterManager;
import at.laborg.briss.PDFPageCluster;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CropManager {
    public static void crop(File origFile, File croppedFile, ClusterManager cM) {
        try {
            PdfReader reader = new PdfReader(origFile.getAbsolutePath());
            Document document = new Document();
            HashMap<String, String> metaInfo = reader.getInfo();
            File tmpFile = File.createTempFile("cropped", ".pdf");
            PdfSmartCopy pdfCopy = new PdfSmartCopy(document, (OutputStream)new FileOutputStream(tmpFile));
            document.open();
            int origPageCount = reader.getNumberOfPages();
            List<HashMap<String, Object>> bookmarks = null;
            int pageNumber = 1;
            while (pageNumber <= origPageCount) {
                PDFPageCluster currentCluster = cM.getCluster(pageNumber);
                PdfImportedPage page = pdfCopy.getImportedPage(reader, pageNumber);
                bookmarks = SimpleBookmark.getBookmark(reader);
                pdfCopy.addPage(page);
                int j = 1;
                while (j < currentCluster.getRatiosList().size()) {
                    pdfCopy.addPage(page);
                    ++j;
                }
                ++pageNumber;
            }
            document.close();
            pdfCopy.close();
            reader = new PdfReader(tmpFile.getAbsolutePath());
            PdfStamper stamper = new PdfStamper(reader, new FileOutputStream(croppedFile));
            stamper.setMoreInfo(metaInfo);
            int newPageNumber = 1;
            int origPageNumber = 1;
            while (origPageNumber <= origPageCount) {
                PDFPageCluster currentCluster = cM.getCluster(origPageNumber);
                if (currentCluster.getRatiosList().size() == 0) {
                    ++newPageNumber;
                } else {
                    for (Float[] ratios : currentCluster.getRatiosList()) {
                        PdfDictionary pageDict = reader.getPageN(newPageNumber);
                        ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
                        boxes.add(reader.getBoxSize(newPageNumber, "media"));
                        boxes.add(reader.getBoxSize(newPageNumber, "crop"));
                        int rotation = reader.getPageRotation(newPageNumber);
                        Rectangle scaledBox = CropManager.calculateScaledRectangle(boxes, ratios, rotation);
                        PdfArray scaleBoxArray = new PdfArray();
                        scaleBoxArray.add(new PdfNumber(scaledBox.getLeft()));
                        scaleBoxArray.add(new PdfNumber(scaledBox.getBottom()));
                        scaleBoxArray.add(new PdfNumber(scaledBox.getRight()));
                        scaleBoxArray.add(new PdfNumber(scaledBox.getTop()));
                        pageDict.put(PdfName.CROPBOX, scaleBoxArray);
                        pageDict.put(PdfName.MEDIABOX, scaleBoxArray);
                        ++newPageNumber;
                    }
                    int[] range = new int[]{newPageNumber - 1, origPageCount + (newPageNumber - origPageNumber)};
                    SimpleBookmark.shiftPageNumbers(bookmarks, currentCluster.getRatiosList().size() - 1, range);
                }
                ++origPageNumber;
            }
            stamper.setOutlines(bookmarks);
            stamper.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private static Rectangle calculateScaledRectangle(List<Rectangle> boxes, Float[] ratios, int rotation) {
        if (ratios == null || boxes.size() == 0) {
            return null;
        }
        Rectangle sBox = null;
        float smallestSquare = Float.MAX_VALUE;
        for (Rectangle box : boxes) {
            if (box == null) continue;
            if (sBox == null) {
                sBox = box;
            }
            if (!(smallestSquare > box.getWidth() * box.getHeight())) continue;
            smallestSquare = box.getWidth() * box.getHeight();
            sBox = box;
        }
        if (sBox == null) {
            return null;
        }
        float[] rotRatios = CropManager.rotateRatios(ratios, rotation);
        Rectangle scaledBox = new Rectangle(sBox);
        scaledBox.setLeft(sBox.getLeft() + sBox.getWidth() * rotRatios[0]);
        scaledBox.setBottom(sBox.getBottom() + sBox.getHeight() * rotRatios[1]);
        scaledBox.setRight(sBox.getLeft() + sBox.getWidth() * (1.0f - rotRatios[2]));
        scaledBox.setTop(sBox.getBottom() + sBox.getHeight() * (1.0f - rotRatios[3]));
        return scaledBox;
    }

    private static float[] rotateRatios(Float[] ratios, int rotation) {
        float[] tmpRatios = new float[4];
        int i = 0;
        while (i < 4) {
            tmpRatios[i] = ratios[i].floatValue();
            ++i;
        }
        while (rotation > 0 && rotation < 360) {
            float tmpValue = tmpRatios[0];
            tmpRatios[0] = tmpRatios[1];
            tmpRatios[1] = tmpRatios[2];
            tmpRatios[2] = tmpRatios[3];
            tmpRatios[3] = tmpValue;
            rotation += 90;
        }
        return tmpRatios;
    }
}

