/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.PDFPageCluster;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class ClusterManager {
    private HashMap<Integer, PDFPageCluster> pagesToClustersMapping;
    private HashMap<PDFPageCluster, List<Integer>> clustersToPagesMapping;
    private boolean dirty = true;
    private int pageCount;
    private Set<Integer> excludedPageSet;
    private PdfReader reader;
    private PdfDecoder pdfDecoder;

    public void reset() {
        this.pagesToClustersMapping = null;
        this.clustersToPagesMapping = null;
        this.dirty = true;
    }

    public PDFPageCluster getCluster(int pageNumber) {
        if (this.dirty) {
            for (PDFPageCluster cluster : this.clustersToPagesMapping.keySet()) {
                for (Integer page : this.clustersToPagesMapping.get(cluster)) {
                    this.pagesToClustersMapping.put(page - 1, cluster);
                }
            }
            this.dirty = false;
        }
        return this.pagesToClustersMapping.get(pageNumber - 1);
    }

    public void init(int pageCount) {
        this.pagesToClustersMapping = new HashMap();
        this.clustersToPagesMapping = new HashMap();
        this.dirty = true;
    }

    public void init(File pdfFile, Set<Integer> excludedPages) throws IOException, PdfException {
        this.reader = new PdfReader(pdfFile.getAbsolutePath());
        this.excludedPageSet = excludedPages;
        this.pageCount = this.reader.getNumberOfPages();
        this.pagesToClustersMapping = new HashMap();
        this.clustersToPagesMapping = new HashMap();
        this.dirty = true;
        this.pdfDecoder = new PdfDecoder(true);
        this.pdfDecoder.openPdfFile(pdfFile.getAbsolutePath());
    }

    private <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public List<PDFPageCluster> getClusterAsList() {
        return this.asSortedList(this.clustersToPagesMapping.keySet());
    }

    public void addPage(PDFPageCluster tmpCluster, int pageNumber) {
        if (this.clustersToPagesMapping.containsKey(tmpCluster)) {
            List<Integer> pageNumbers = this.clustersToPagesMapping.get(tmpCluster);
            pageNumbers.add(pageNumber);
        } else {
            ArrayList<Integer> pageNumbers = new ArrayList<Integer>();
            pageNumbers.add(pageNumber);
            this.clustersToPagesMapping.put(tmpCluster, pageNumbers);
        }
        this.dirty = true;
    }

    public Set<PDFPageCluster> getClusters() {
        return this.clustersToPagesMapping.keySet();
    }

    public void clusterPages() {
        int i = 1;
        while (i <= this.pageCount) {
            Rectangle layoutBox = this.reader.getBoxSize(i, "crop");
            if (layoutBox == null) {
                layoutBox = this.reader.getBoxSize(i, "media");
            }
            int pageNumber = -1;
            if (this.excludedPageSet != null && this.excludedPageSet.contains(i)) {
                pageNumber = i;
            }
            PDFPageCluster tmpCluster = new PDFPageCluster(i % 2 == 0, (int)layoutBox.getWidth(), (int)layoutBox.getHeight(), pageNumber);
            this.addPage(tmpCluster, i);
            ++i;
        }
        for (PDFPageCluster cluster : this.clustersToPagesMapping.keySet()) {
            cluster.choosePagesToMerge(this.clustersToPagesMapping.get(cluster));
        }
    }

    public int getTotWorkUnits() {
        int size = 0;
        for (PDFPageCluster cluster : this.clustersToPagesMapping.keySet()) {
            size += cluster.getPagesToMerge().size();
        }
        return size;
    }

    public class WorkerThread
    extends Thread {
        public int workerUnitCounter = 1;

        @Override
        public void run() {
            for (PDFPageCluster cluster : ClusterManager.this.getClusters()) {
                for (Integer pageNumber : cluster.getPagesToMerge()) {
                    try {
                        if (!cluster.isFunctional()) continue;
                        BufferedImage renderedPage = ClusterManager.this.pdfDecoder.getPageAsImage(pageNumber);
                        cluster.addImageToPreview(renderedPage);
                        ++this.workerUnitCounter;
                    }
                    catch (PdfException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

