/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss;

import at.laborg.briss.ClusterManager;
import at.laborg.briss.CropManager;
import at.laborg.briss.JHelpDialog;
import at.laborg.briss.MergedPanel;
import at.laborg.briss.PDFPageCluster;
import at.laborg.briss.PageNumberParser;
import at.laborg.briss.WrapLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.jpedal.exception.PdfException;

public class Briss
extends JFrame
implements ActionListener,
PropertyChangeListener {
    private static final String LOAD = "Load File";
    private static final String CROP = "Crop PDF";
    private static final String EXIT = "Exit";
    private static final String MAXIMIZE_WIDTH = "Maximize to width";
    private static final String MAXIMIZE_HEIGHT = "Maximize to height";
    private static final String PREVIEW = "Preview";
    private static final String DONATE = "Donate";
    private static final String HELP = "Show help";
    private static final String DONATION_URI_STRING = "http://sourceforge.net/project/project_donations.php?group_id=320676";
    private static final String RES_ICON_PATH = "/Briss_icon_032x032.gif";
    private ClusterManager cM;
    private JMenuBar menuBar;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JMenuItem loadItem;
    private JMenuItem cropItem;
    private JMenuItem maxWItem;
    private JMenuItem maxHItem;
    private JMenuItem previewItem;
    private JMenuItem helpItem;
    private JMenuItem donateItem;
    private ClusterPagesTask clusterTask;
    private File lastOpenDir;
    private File origFile = null;
    private File croppedFile = null;
    private List<MergedPanel> mergedPanels = null;

    public Briss() {
        super("BRISS - BRigt Snippet Sire");
        this.init();
    }

    private File loadPDF(String recommendation, boolean saveDialog) {
        JFileChooser fc;
        JFileChooser jFileChooser = fc = this.lastOpenDir == null ? new JFileChooser() : new JFileChooser(this.lastOpenDir);
        if (recommendation != null) {
            File recommendedFile = new File(recommendation);
            fc.setSelectedFile(recommendedFile);
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return pathname.toString().toLowerCase().endsWith(".pdf");
            }

            @Override
            public String getDescription() {
                return null;
            }
        });
        int retval = saveDialog ? fc.showSaveDialog(this) : fc.showOpenDialog(this);
        if (retval == 0) {
            if (fc.getSelectedFile() != null) {
                this.lastOpenDir = fc.getSelectedFile().getParentFile();
            }
            return fc.getSelectedFile();
        }
        return null;
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ex) {
            System.out.println("Unable to load native look and feel");
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
            // empty catch block
        }
        InputStream is = this.getClass().getResourceAsStream(RES_ICON_PATH);
        byte[] buf = new byte[102400];
        try {
            int cnt = is.read(buf);
            byte[] imgBuf = Arrays.copyOf(buf, cnt);
            this.setIconImage(new ImageIcon(imgBuf).getImage());
        }
        catch (IOException cnt) {
            // empty catch block
        }
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu actionMenu = new JMenu("Action");
        this.menuBar.add(fileMenu);
        this.menuBar.add(actionMenu);
        this.loadItem = new JMenuItem(LOAD, 76);
        this.loadItem.addActionListener(this);
        this.loadItem.setEnabled(true);
        fileMenu.add(this.loadItem);
        fileMenu.addSeparator();
        this.donateItem = new JMenuItem(DONATE);
        this.donateItem.addActionListener(this);
        fileMenu.add(this.donateItem);
        this.helpItem = new JMenuItem(HELP);
        this.helpItem.addActionListener(this);
        fileMenu.add(this.helpItem);
        fileMenu.addSeparator();
        JMenuItem menuItem = new JMenuItem(EXIT, 69);
        menuItem.addActionListener(this);
        fileMenu.add(menuItem);
        this.cropItem = new JMenuItem(CROP, 67);
        this.cropItem.addActionListener(this);
        this.cropItem.setEnabled(false);
        actionMenu.add(this.cropItem);
        this.previewItem = new JMenuItem(PREVIEW, 80);
        this.previewItem.addActionListener(this);
        this.previewItem.setEnabled(false);
        actionMenu.add(this.previewItem);
        this.maxWItem = new JMenuItem(MAXIMIZE_WIDTH, 87);
        this.maxWItem.addActionListener(this);
        this.maxWItem.setEnabled(false);
        actionMenu.add(this.maxWItem);
        this.maxHItem = new JMenuItem(MAXIMIZE_HEIGHT, 72);
        this.maxHItem.addActionListener(this);
        this.maxHItem.setEnabled(false);
        actionMenu.add(this.maxHItem);
        this.setJMenuBar(this.menuBar);
        this.previewPanel = new JPanel();
        this.previewPanel.setLayout(new WrapLayout(0));
        this.previewPanel.setEnabled(true);
        this.previewPanel.setBackground(Color.BLACK);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(400, 30));
        this.progressBar.setEnabled(true);
        JScrollPane scrollPane = new JScrollPane(this.previewPanel, 22, 30);
        scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.progressBar, "Last");
        this.pack();
        this.setVisible(true);
        this.cM = new ClusterManager();
    }

    public static void main(String[] args) {
        new Briss();
    }

    @Override
    public void actionPerformed(ActionEvent aE) {
        block26: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block25: {
                                        if (!aE.getActionCommand().equals(DONATE)) break block25;
                                        if (!Desktop.isDesktopSupported()) break block26;
                                        Desktop desktop = Desktop.getDesktop();
                                        try {
                                            URI donationURI = new URI(DONATION_URI_STRING);
                                            desktop.browse(donationURI);
                                        }
                                        catch (URISyntaxException uRISyntaxException) {
                                        }
                                        catch (IOException iOException) {}
                                        break block26;
                                    }
                                    if (!aE.getActionCommand().equals(EXIT)) break block27;
                                    System.exit(0);
                                    break block26;
                                }
                                if (!aE.getActionCommand().equals(HELP)) break block28;
                                new JHelpDialog((Frame)this, "Briss Help", Dialog.ModalityType.MODELESS);
                                break block26;
                            }
                            if (!aE.getActionCommand().equals(MAXIMIZE_HEIGHT)) break block29;
                            int maxHeight = -1;
                            for (MergedPanel mp : this.mergedPanels) {
                                int mpMax = mp.getHeighestRect();
                                if (maxHeight >= mpMax) continue;
                                maxHeight = mpMax;
                            }
                            if (maxHeight == -1) {
                                return;
                            }
                            for (MergedPanel mp : this.mergedPanels) {
                                mp.setSelCropHeight(maxHeight);
                            }
                            break block26;
                        }
                        if (!aE.getActionCommand().equals(MAXIMIZE_WIDTH)) break block30;
                        int maxWidth = -1;
                        for (MergedPanel mp : this.mergedPanels) {
                            int mpMax = mp.getWidestRect();
                            if (maxWidth >= mpMax) continue;
                            maxWidth = mpMax;
                        }
                        if (maxWidth == -1) {
                            return;
                        }
                        for (MergedPanel mp : this.mergedPanels) {
                            mp.setSelCropWidth(maxWidth);
                        }
                        break block26;
                    }
                    if (!aE.getActionCommand().equals(LOAD)) break block31;
                    File loadFile = this.loadPDF(null, false);
                    if (loadFile == null) break block26;
                    this.origFile = loadFile;
                    this.cM.reset();
                    this.previewPanel.removeAll();
                    this.progressBar.setString("loading PDF");
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.clusterTask = new ClusterPagesTask();
                    this.clusterTask.addPropertyChangeListener(this);
                    this.clusterTask.execute();
                    break block26;
                }
                if (!aE.getActionCommand().equals(CROP)) break block32;
                String origName = this.origFile.getAbsolutePath();
                String recommendedName = String.valueOf(origName.substring(0, origName.length() - 4)) + "_cropped.pdf";
                this.croppedFile = this.loadPDF(recommendedName, true);
                if (this.croppedFile == null) {
                    return;
                }
                if (!this.croppedFile.exists()) {
                    try {
                        this.croppedFile.createNewFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.progressBar.setString("loading PDF");
                this.setCursor(Cursor.getPredefinedCursor(3));
                CropManager.crop(this.origFile, this.croppedFile, this.cM);
                this.progressBar.setValue(0);
                this.progressBar.setString("");
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(this.croppedFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                break block26;
            }
            if (!aE.getActionCommand().equals(PREVIEW)) break block26;
            try {
                this.croppedFile = File.createTempFile("briss", ".pdf");
                if (this.croppedFile == null) {
                    return;
                }
                if (!this.croppedFile.exists()) {
                    try {
                        this.croppedFile.createNewFile();
                    }
                    catch (IOException origName) {
                        // empty catch block
                    }
                }
                this.progressBar.setString("loading PDF");
                this.setCursor(Cursor.getPredefinedCursor(3));
                CropManager.crop(this.origFile, this.croppedFile, this.cM);
                this.progressBar.setValue(0);
                this.progressBar.setString("");
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(this.croppedFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            this.progressBar.setValue((Integer)evt.getNewValue());
        }
    }

    private class ClusterPagesTask
    extends SwingWorker<Void, Void> {
        public ClusterPagesTask() {
            Briss.this.progressBar.setString("Analysing PDF pages");
            try {
                Briss.this.cM.init(Briss.this.origFile, this.getExcludedPages());
            }
            catch (PdfException pdfException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private Set<Integer> getExcludedPages() {
            boolean inputIsValid = false;
            String rememberInputString = "";
            while (!inputIsValid) {
                String inputString;
                rememberInputString = inputString = JOptionPane.showInputDialog("Enter pages to be excluded from merging (e.g.: \"1-4;6;9\").\nFirst page has number: 1\nIf you don't know what you should do just press \"Cancel\"", (Object)rememberInputString);
                if (inputString == null || inputString.equals("")) {
                    return null;
                }
                try {
                    return PageNumberParser.parsePageNumber(inputString);
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Input Error", 0);
                }
            }
            return null;
        }

        @Override
        protected void done() {
            Briss.this.setCursor(Cursor.getPredefinedCursor(0));
            Briss.this.mergedPanels = new ArrayList();
            List<PDFPageCluster> tmpClusterList = Briss.this.cM.getClusterAsList();
            for (PDFPageCluster cluster : tmpClusterList) {
                MergedPanel p = new MergedPanel(cluster);
                Briss.this.previewPanel.add(p);
                Briss.this.mergedPanels.add(p);
            }
            Briss.this.progressBar.setString("PDF loaded - Select crop size and press crop");
            Briss.this.cropItem.setEnabled(true);
            Briss.this.maxWItem.setEnabled(true);
            Briss.this.maxHItem.setEnabled(true);
            Briss.this.previewItem.setEnabled(true);
            this.setProgress(0);
            Briss.this.pack();
            Briss.this.setExtendedState(6);
        }

        @Override
        protected Void doInBackground() {
            Briss.this.cM.clusterPages();
            int totWorkUnits = Briss.this.cM.getTotWorkUnits();
            ClusterManager.WorkerThread wT = Briss.this.cM.new ClusterManager.WorkerThread();
            wT.start();
            Briss.this.progressBar.setString("PDF analysed - creating merged previews");
            while (wT.isAlive()) {
                int percent = (int)((float)wT.workerUnitCounter / (float)totWorkUnits * 100.0f);
                this.setProgress(percent);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

