/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.utils.TimeNow;

public class LogWriter {
    public static boolean debug = false;
    public static String log_name = null;
    private static int debug_level = 0;
    public static boolean testing = false;
    private static boolean verbose = false;

    public static final void resetLogFile() {
        if (log_name != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(log_name, false));
                printWriter.println(TimeNow.getTimeNow() + " Running Storypad");
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final void writeLog(String string) {
        if (verbose) {
            System.out.println(string);
        }
        if (log_name != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(log_name, true));
                if (!testing) {
                    printWriter.println(TimeNow.getTimeNow() + ' ' + string);
                }
                printWriter.println(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
            }
            printWriter = null;
        }
    }

    public static final void debugFile(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter("D://debug.txt", true));
            printWriter.println(string);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
        }
        printWriter = null;
    }

    public static final boolean testLogFileWriteable() {
        boolean bl = false;
        File file = null;
        try {
            file = new File(log_name);
        }
        catch (Exception exception) {
            ShowGUIMessage.showGUIMessage("Exception " + exception + " testing log. Check logdir exists.", "Problem with logfile");
            throw new RuntimeException("Exception " + exception + " testing log. Check logdir exists.");
        }
        if (!file.exists()) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(log_name, true));
                if (!testing) {
                    printWriter.println(TimeNow.getTimeNow() + " Log created");
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + file);
            }
        }
        if (file.exists() && !file.canWrite()) {
            System.err.println("Log " + log_name + " exists, but cannot written - Check permissions");
            bl = true;
        }
        return bl;
    }

    public static final void setupLogFile(boolean bl, int n, String string, String string2, boolean bl2) {
        if (string.length() == 0) {
            string = "4.40b77-OS";
        }
        if ((debug_level = n) > 0) {
            debug = true;
        }
        if (string2 != null) {
            if (string2.indexOf(118) != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
        }
        if (!testing) {
            LogWriter.writeLog("Software version - " + string);
            LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        }
        LogWriter.writeLog("=======================================================");
    }

    public static final void writeLogWithoutCR(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(log_name, true));
            printWriter.print(string);
            if (verbose) {
                System.out.print(string);
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
        }
        printWriter = null;
    }

    public static final void noLogging() {
        verbose = false;
        log_name = null;
    }

    public static final void writeMethod(String string) {
        long l = Runtime.getRuntime().freeMemory() / 1024L;
        long l2 = Runtime.getRuntime().totalMemory() / 1024L;
        long l3 = l2 - l;
        string = string + " MEM=" + l3 + " ( " + l2 + " - " + l + ')';
        LogWriter.writeLog(string);
    }

    public static final void writeMethod(String string, int n) {
        if (debug_level > n) {
            LogWriter.writeLog(string);
        }
    }

    public static final void write(Map map, int n) {
        if (debug_level > n) {
            for (Map.Entry entry : map.entrySet()) {
                LogWriter.writeLog(entry.getKey().toString() + '=' + entry.getValue().toString());
            }
        }
    }

    public static void writeFormLog(String string, boolean bl) {
        if (bl) {
            System.out.println("[forms] " + string);
        }
        LogWriter.writeLog("[forms] " + string);
    }
}

