/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.external.JPedalCustomDrawObject;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.FontFactory;
import org.jpedal.render.ImageObject;
import org.jpedal.render.TextObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public final class DynamicVectorRenderer {
    private static boolean drawPDFShapes = true;
    private int pageNumber = 0;
    private boolean optimisedTurnCode = true;
    private boolean noRepaint = false;
    private int lastItemPainted = -1;
    private boolean extraRot = false;
    private boolean optimsePainting = false;
    private String rawKey = null;
    private static final boolean samplingDebug = false;
    private PdfPaint fillCol = null;
    private PdfPaint strokeCol = null;
    private static boolean flagException = false;
    private int pageX1 = 9999;
    private int pageX2 = -9999;
    private int pageY1 = -9999;
    private int pageY2 = 9999;
    private boolean highlightsNeedToBeGenerated = false;
    private ImageHandler customImageHandler = null;
    private ColorHandler customColorHandler = null;
    private BufferedImage singleImage = null;
    private int imageCount = 0;
    private static final int defaultSize = 5000;
    int endItem = -1;
    public static boolean debugPaint = false;
    private boolean useHiResImageForDisplay = false;
    private static RenderingHints hints = null;
    private ObjectStore objectStoreRef;
    private boolean isPrinting;
    private final Map cachedWidths = new HashMap();
    private final Map cachedHeights = new HashMap();
    private Map fonts = new HashMap();
    private Map fontsUsed = new HashMap();
    protected GlyphFactory factory = null;
    private PdfGlyphs glyphs;
    private boolean isType3Font = false;
    private Map imageID = new HashMap();
    private final Map imageIDtoName = new HashMap();
    private Map storedImageValues = new HashMap();
    private int[] textHighlightsX;
    private int[] textHighlightsWidth;
    private int[] textHighlightsHeight;
    private boolean stopG2setting;
    private int w = 0;
    private int h = 0;
    private Color backgroundColor = Color.white;
    private float[] x_coord;
    private float[] y_coord;
    private Map largeImages = new WeakHashMap();
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Object pageObjects;
    private Vector_Int shapeType;
    private Vector_Rectangle areas;
    private Vector_Rectangle fontBounds;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int imageOptions;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Shape clips;
    private Vector_Int objectType;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    public static final int TEXT = 1;
    public static final int SHAPE = 2;
    public static final int IMAGE = 3;
    public static final int TRUETYPE = 4;
    public static final int TYPE1C = 5;
    public static final int TYPE3 = 6;
    public static final int CLIP = 7;
    public static final int COLOR = 8;
    public static final int AF = 9;
    public static final int TEXTCOLOR = 10;
    public static final int FILLCOLOR = 11;
    public static final int STROKECOLOR = 12;
    public static final int STROKE = 14;
    public static final int TR = 15;
    public static final int STRING = 16;
    public static final int STROKEOPACITY = 17;
    public static final int FILLOPACITY = 18;
    public static final int STROKEDSHAPE = 19;
    public static final int FILLEDSHAPE = 20;
    public static final int FONTSIZE = 21;
    public static final int LINEWIDTH = 22;
    public static final int CUSTOM = 23;
    public static final int fontBB = 24;
    public static final int XFORM = 25;
    public static final int DELETED_IMAGE = 27;
    public static final int REUSED_IMAGE = 29;
    public static final int MARKER = 200;
    private boolean addBackground = true;
    private int currentItem = 0;
    private int lastFillTextCol;
    private int lastFillCol;
    private int lastStrokeCol;
    private Stroke lastStroke = null;
    private double[] lastAf = new double[4];
    private int lastTR = 2;
    private int lastFS = -1;
    private int lastLW = -1;
    private boolean resetTextColors = true;
    private boolean fillSet = false;
    private boolean strokeSet = false;
    public static final boolean newCode2 = true;
    public static boolean invertHighlight;
    private boolean needsHighlights = true;
    int xx = 0;
    int yy = 0;
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = -1.0;
    private double maxY = -1.0;
    private int rotation = 0;
    private boolean colorsLocked;
    private boolean optimiseDrawing;
    private boolean renderFailed;
    private Container frame = null;
    private static boolean userAlerted;
    private int paintThreadCount = 0;
    private int paintThreadID = 0;
    private boolean[] drawnHighlights;
    private boolean hasOCR = false;
    boolean ignoreHighlight = false;
    boolean hasClips = false;
    Area lastClip = null;
    private double cropX;
    private double cropH;
    private float scaling;
    private float lastScaling;
    public boolean needsHorizontalInvert = false;
    public boolean needsVerticalInvert = false;

    public DynamicVectorRenderer(int n, boolean bl, int n2, ObjectStore objectStore) {
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.setupArrays(n2);
    }

    private void setupArrays(int n) {
        this.x_coord = new float[n];
        this.y_coord = new float[n];
        this.text_color = new Vector_Object(n);
        this.textFillType = new Vector_Int(n);
        this.stroke_color = new Vector_Object(n);
        this.fill_color = new Vector_Object(n);
        this.stroke = new Vector_Object(n);
        this.pageObjects = new Vector_Object(n);
        this.javaObjects = new Vector_Object(n);
        this.shapeType = new Vector_Int(n);
        this.areas = new Vector_Rectangle(n);
        this.af1 = new Vector_Double(n);
        this.af2 = new Vector_Double(n);
        this.af3 = new Vector_Double(n);
        this.af4 = new Vector_Double(n);
        this.fontBounds = new Vector_Rectangle(n);
        this.clips = new Vector_Shape(n);
        this.objectType = new Vector_Int(n);
    }

    public DynamicVectorRenderer(int n, ObjectStore objectStore, boolean bl) {
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.isPrinting = bl;
        this.setupArrays(5000);
    }

    public void setOptimsePainting(boolean bl) {
        this.optimsePainting = bl;
        this.lastItemPainted = -1;
    }

    public final void renderHighlight(Rectangle rectangle, Graphics2D graphics2D) {
        if (rectangle != null && !this.ignoreHighlight) {
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(null);
            Composite composite = graphics2D.getComposite();
            Paint paint = graphics2D.getPaint();
            graphics2D.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
            if (invertHighlight) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.setXORMode(Color.BLACK);
            } else {
                graphics2D.setPaint(PdfDecoder.highlightColor);
            }
            graphics2D.fill(rectangle);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
            this.needsHighlights = false;
            graphics2D.setClip(shape);
        }
    }

    public final void renderText(float f, float f2, int n, Area area, Graphics2D graphics2D, Rectangle rectangle, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f3, float f4) {
        Color color;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        if ((n & 2) == 2) {
            if (pdfPaint2 != null) {
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, f, f2);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
            } else {
                graphics2D.setPaint(pdfPaint2);
            }
            if (f4 != 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f4));
            }
            if (rectangle != null) {
                if (invertHighlight) {
                    color = graphics2D.getColor();
                    graphics2D.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                } else if (PdfDecoder.backgroundColor != null) {
                    graphics2D.setColor(PdfDecoder.backgroundColor);
                }
            }
            graphics2D.fill(area);
            graphics2D.setComposite(composite);
        }
        if ((n & 1) == 1) {
            float f5;
            if (pdfPaint != null) {
                pdfPaint.setScaling(this.cropX + (double)f, this.cropH + (double)f2, this.scaling, f, f2);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(graphics2D, pdfPaint, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(graphics2D, pdfPaint, this.pageNumber, this.isPrinting);
            } else {
                graphics2D.setPaint(pdfPaint);
            }
            if (f3 != 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f3));
            }
            if (rectangle != null) {
                if (invertHighlight) {
                    color = graphics2D.getColor();
                    graphics2D.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                } else if (PdfDecoder.backgroundColor != null) {
                    graphics2D.setColor(PdfDecoder.backgroundColor);
                }
            }
            if ((f5 = (float)(1.0 / graphics2D.getTransform().getScaleX())) < 0.0f) {
                f5 = -f5;
            }
            graphics2D.setStroke(new BasicStroke(f5));
            if (f5 < 0.1f) {
                graphics2D.draw(area);
            } else {
                graphics2D.fill(area);
            }
            graphics2D.setComposite(composite);
        }
        graphics2D.setPaint(paint);
    }

    public final void renderEmbeddedText(GraphicsState graphicsState, int n, Object object, int n2, Graphics2D graphics2D, AffineTransform affineTransform, Rectangle rectangle, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f, float f2, Rectangle rectangle2, int n3) {
        float f3 = 0.0f;
        if (n == 1 && (double)n3 >= 1.0) {
            f3 = this.scaling;
        }
        boolean bl = graphicsState != null;
        PdfGlyph pdfGlyph = FontFactory.chooseGlyph(n2, object);
        if (bl) {
            int n4 = (int)graphicsState.CTM[1][1];
            if (n4 < 0) {
                n4 = -n4;
            }
            if (n4 == 0) {
                n4 = (int)graphicsState.CTM[0][1];
            }
            if (n4 < 0) {
                n4 = -n4;
            }
            this.areas.addElement(new Rectangle((int)graphicsState.CTM[2][0], (int)graphicsState.CTM[2][1], n4, n4));
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        if (pdfGlyph != null) {
            Color color;
            Stroke stroke = graphics2D.getStroke();
            if (n3 != 0) {
                graphics2D.setStroke(new BasicStroke(n3));
            }
            graphics2D.transform(affineTransform);
            Composite composite = graphics2D.getComposite();
            Object var21_22 = null;
            if ((n & 2) == 2) {
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
                } else if (PdfDecoder.Helper != null) {
                    PdfDecoder.Helper.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
                } else {
                    graphics2D.setPaint(pdfPaint2);
                }
                if (f2 != 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                }
                if (rectangle != null) {
                    if (invertHighlight) {
                        color = graphics2D.getColor();
                        graphics2D.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                    } else if (PdfDecoder.backgroundColor != null) {
                        graphics2D.setColor(PdfDecoder.backgroundColor);
                    }
                }
                pdfGlyph.render(2, graphics2D, this.scaling, false);
                graphics2D.setComposite(composite);
            }
            if (n == 1) {
                pdfGlyph.setStrokedOnly(true);
            }
            if (!(PdfDecoder.isRunningOnMac && this.isPrinting && n == 3 || (n & 1) != 1)) {
                if (pdfPaint != null) {
                    pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                }
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(graphics2D, pdfPaint, this.pageNumber, this.isPrinting);
                } else if (PdfDecoder.Helper != null) {
                    PdfDecoder.Helper.setPaint(graphics2D, pdfPaint, this.pageNumber, this.isPrinting);
                } else {
                    graphics2D.setPaint(pdfPaint);
                }
                if (f != 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                }
                if (rectangle != null) {
                    if (invertHighlight) {
                        color = graphics2D.getColor();
                        graphics2D.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                    } else if (PdfDecoder.backgroundColor != null) {
                        graphics2D.setColor(PdfDecoder.backgroundColor);
                    }
                }
                try {
                    pdfGlyph.render(1, graphics2D, f3, false);
                }
                catch (Exception exception) {
                    System.out.println("Exception " + exception + " rendering glyph");
                    exception.printStackTrace();
                }
                graphics2D.setComposite(composite);
            }
            graphics2D.setTransform(affineTransform2);
            if (n3 != 0) {
                graphics2D.setStroke(stroke);
            }
        }
    }

    public final void renderImage(AffineTransform affineTransform, BufferedImage object, float f, GraphicsState graphicsState, Graphics2D graphics2D, float f2, float f3, int n) {
        Object object2;
        Object object3;
        Object object4;
        int n2;
        Object object5;
        float f4;
        Object object6;
        int n3;
        boolean bl;
        boolean bl2 = bl = graphicsState != null;
        if (object == null) {
            return;
        }
        int n4 = ((BufferedImage)object).getWidth();
        int n5 = ((BufferedImage)object).getHeight();
        if (bl) {
            int n6 = (int)graphicsState.CTM[0][0];
            if (n6 < 0) {
                n6 = -n6;
            }
            if (n6 == 0) {
                n6 = (int)graphicsState.CTM[0][1];
            }
            if (n6 < 0) {
                n6 = -n6;
            }
            if ((n3 = (int)graphicsState.CTM[1][1]) < 0) {
                n3 = -n3;
            }
            if (n3 == 0) {
                n3 = (int)graphicsState.CTM[1][0];
            }
            if (n3 < 0) {
                n3 = -n3;
            }
            this.areas.addElement(new Rectangle((int)graphicsState.CTM[2][0], (int)graphicsState.CTM[2][1], n6, n3));
        }
        AffineTransform affineTransform2 = new AffineTransform();
        n3 = 0;
        float[][] fArray = new float[3][3];
        if (graphicsState != null) {
            fArray = graphicsState.CTM;
        }
        if (fArray[0][0] < 0.0f && fArray[1][1] < 0.0f && fArray[1][0] > -2.0f && fArray[1][0] < 0.0f && fArray[0][1] > 0.0f && fArray[0][1] < 10.0f) {
            fArray[0][1] = 0.0f;
            fArray[1][0] = 0.0f;
        }
        AffineTransform affineTransform3 = graphics2D.getTransform();
        boolean bl3 = false;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (bl || this.useHiResImageForDisplay) {
            if (bl) {
                affineTransform2 = null;
                if ((n & 1) != 1) {
                    Object object7;
                    if (!this.optimisedTurnCode) {
                        object = DynamicVectorRenderer.invertImage(fArray, (BufferedImage)object);
                    } else if (fArray[0][1] < 0.0f && fArray[1][0] > 0.0f && fArray[0][0] * fArray[1][1] == 0.0f) {
                        affineTransform2 = new AffineTransform(fArray[0][0] / (float)n4, fArray[0][1] / (float)n4, -fArray[1][0] / (float)n5, fArray[1][1] / (float)n5, fArray[2][0] + fArray[1][0], fArray[2][1]);
                    } else if (fArray[0][1] < 0.0f || fArray[1][0] < 0.0f) {
                        object7 = new float[][]{{1.0f / (float)n4, 0.0f, 0.0f}, {0.0f, -1.0f / (float)n5, 0.0f}, {0.0f, 1.0f / (float)n5, 1.0f}};
                        object6 = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                        object7 = Matrix.multiply(object7, (float[][])object6);
                        affineTransform2 = new AffineTransform(object7[0][0], object7[0][1], object7[1][0], object7[1][1], object7[2][0], object7[2][1]);
                        f5 = fArray[2][0] - (float)((BufferedImage)object).getHeight() * object7[1][0];
                        f6 = fArray[2][1];
                        if (!(fArray[0][0] < 0.0f && fArray[1][0] < 0.0f && fArray[0][1] > 0.0f && fArray[1][1] < 0.0f || fArray[1][1] == 0.0f)) {
                            f6 += fArray[1][1];
                        }
                    } else if (fArray[0][0] * fArray[0][1] == 0.0f && fArray[1][1] * fArray[1][0] == 0.0f && fArray[0][1] > 0.0f && fArray[1][0] > 0.0f) {
                        object7 = new float[][]{{-1.0f / (float)n4, 0.0f, 0.0f}, {0.0f, 1.0f / (float)n5, 0.0f}, {1.0f / (float)n4, 0.0f, 1.0f}};
                        object6 = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                        object7 = Matrix.multiply(object7, (float[][])object6);
                        affineTransform2 = new AffineTransform(object7[0][0], object7[1][0], object7[0][1], object7[1][1], object7[2][0], object7[2][1]);
                        f5 = fArray[2][0] - (float)((BufferedImage)object).getHeight() * object7[0][1];
                        f6 = fArray[2][1];
                    } else if (fArray[1][1] != 0.0f) {
                        bl3 = true;
                    }
                }
                if (affineTransform2 == null) {
                    affineTransform2 = new AffineTransform(fArray[0][0] / (float)n4, fArray[0][1] / (float)n4, fArray[1][0] / (float)n5, fArray[1][1] / (float)n5, fArray[2][0], fArray[2][1]);
                }
            } else {
                affineTransform2 = affineTransform;
                bl3 = (n & 4) == 4;
            }
            n3 = 1;
        } else if (n5 > 1 && (f4 = (float)PdfDecoder.dpi) != 72.0f) {
            affineTransform2.scale(72.0f / f4, 72.0f / f4);
            affineTransform2.translate(0.0, (float)n5 * (f4 / 72.0f - 1.0f));
            n3 = 1;
        }
        Composite composite = graphics2D.getComposite();
        object6 = graphics2D.getClip();
        boolean bl4 = false;
        if (f != 1.0f) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        if (this.colorsLocked) {
            object5 = new int[4];
            n2 = this.fillCol.getRGB();
            object5[0] = n2 >> 16 & 0xFF;
            object5[1] = n2 >> 8 & 0xFF;
            object5[2] = n2 & 0xFF;
            object5[3] = 255;
            if (object5[0] != 0 || object5[1] != 0 || object5[2] != 0) {
                object4 = new BufferedImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), ((BufferedImage)object).getType());
                object3 = ((BufferedImage)object).getRaster();
                object2 = ((BufferedImage)object4).getRaster();
                for (int i = 0; i < ((BufferedImage)object).getHeight(); ++i) {
                    for (int j = 0; j < ((BufferedImage)object).getWidth(); ++j) {
                        int[] nArray = new int[4];
                        ((Raster)object3).getPixel(j, i, nArray);
                        if (nArray[3] <= 2) continue;
                        ((WritableRaster)object2).setPixel(j, i, (int[])object5);
                    }
                }
                object = object4;
            }
        }
        if (bl || this.useHiResImageForDisplay) {
            try {
                boolean bl5;
                if (this.optimisedTurnCode && bl3 && (n & 1) != 1) {
                    object5 = new double[6];
                    affineTransform2.getMatrix((double[])object5);
                    f5 = object5[4] + object5[1] * (double)((BufferedImage)object).getWidth();
                    f6 = object5[5] + (double)((BufferedImage)object).getHeight() * object5[3];
                    if (object5[0] > 0.0 && object5[1] > 0.0 && object5[2] > 0.0 && object5[3] < 0.0) {
                        object5[2] = -object5[2];
                    }
                    object5[3] = -object5[3];
                    object5[4] = (int)0.0;
                    object5[5] = (int)0.0;
                    affineTransform2 = new AffineTransform((double[])object5);
                }
                boolean bl6 = bl5 = this.customImageHandler != null;
                if (bl5) {
                    bl5 = this.customImageHandler.drawImageOnscreen((BufferedImage)object, n, affineTransform2, null, graphics2D, bl, this.objectStoreRef, this.isPrinting);
                }
                if (bl5) {
                    graphics2D.setComposite(composite);
                    return;
                }
                n2 = 0;
                if (n2 != 0) {
                    object4 = graphics2D.getTransform();
                    object3 = new double[6];
                    ((AffineTransform)object4).getMatrix((double[])object3);
                    object2 = new double[6];
                    affineTransform2.getMatrix((double[])object2);
                    object3[0] = object3[0] * object2[0];
                    object3[3] = object3[3] * object2[3];
                    graphics2D.setTransform(new AffineTransform((double[])object3));
                    graphics2D.translate((double)f5 / object2[0], (double)f6 / object2[3]);
                    object2[0] = 1.0;
                    object2[3] = 1.0;
                    graphics2D.drawImage((Image)object, 0, 0, null);
                } else {
                    graphics2D.translate(f5, f6);
                    if (this.customColorHandler != null) {
                        object4 = this.customColorHandler.processImage((BufferedImage)object, this.pageNumber, this.isPrinting);
                        if (object4 != null) {
                            object = object4;
                        }
                    } else if (PdfDecoder.Helper != null && (object4 = PdfDecoder.Helper.processImage((BufferedImage)object, this.pageNumber, this.isPrinting)) != null) {
                        object = object4;
                    }
                    object4 = graphics2D.getClip();
                    boolean bl7 = false;
                    if (object4 != null) {
                        double d = graphics2D.getClip().getBounds2D().getY();
                        double d2 = graphics2D.getClip().getBounds2D().getHeight();
                        double d3 = (double)((BufferedImage)object).getHeight() - d2;
                        if (d3 < 0.0) {
                            d3 = -d3;
                        }
                        if (d3 > 0.0 && d3 < 1.0 && d < 0.0 && ((BufferedImage)object).getHeight() > 1 && ((BufferedImage)object).getHeight() < 10) {
                            int n7;
                            PathIterator pathIterator = graphics2D.getClip().getPathIterator(null);
                            for (n7 = 0; !pathIterator.isDone() && n7 < 6; ++n7) {
                                pathIterator.next();
                            }
                            if (n7 < 6) {
                                double d4 = graphics2D.getClip().getBounds2D().getX();
                                double d5 = graphics2D.getClip().getBounds2D().getWidth();
                                graphics2D.setClip(new Rectangle((int)d4, (int)d, (int)d5, (int)d2));
                                bl7 = false;
                            }
                        }
                    }
                    graphics2D.drawImage((Image)object, affineTransform2, null);
                    if (bl7) {
                        graphics2D.setClip((Shape)object4);
                    }
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                if (n3 != 0) {
                    object5 = new AffineTransformOp(affineTransform2, ColorSpaces.hints);
                    object = ((AffineTransformOp)object5).filter((BufferedImage)object, null);
                }
                graphics2D.translate(f2, f3);
                if (this.optimisedTurnCode && (n & 4) == 4) {
                    float[] fArray2 = new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, ((BufferedImage)object).getHeight()};
                    if (this.rotation == 0) {
                        object5 = new AffineTransform(fArray2);
                    } else if (this.rotation == 90) {
                        object5 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object5).rotate(Math.PI, 0.0, 0.0);
                        } else {
                            ((AffineTransform)object5).rotate(1.5707963267948966, 0.0, 0.0);
                        }
                        ((AffineTransform)object5).translate(-((BufferedImage)object).getWidth(), -((BufferedImage)object).getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, ((BufferedImage)object).getWidth(), 0.0f};
                        object4 = new AffineTransform(fArray2);
                        ((AffineTransform)object5).concatenate((AffineTransform)object4);
                    } else if (this.rotation == 180) {
                        object5 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object5).rotate(Math.PI, 0.0, 0.0);
                        }
                        ((AffineTransform)object5).translate(-((BufferedImage)object).getWidth(), -((BufferedImage)object).getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, ((BufferedImage)object).getWidth(), 0.0f};
                        object4 = new AffineTransform(fArray2);
                        ((AffineTransform)object5).concatenate((AffineTransform)object4);
                    } else {
                        object5 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object5).rotate(Math.PI, 0.0, 0.0);
                        } else {
                            ((AffineTransform)object5).rotate(4.71238898038469, 0.0, 0.0);
                        }
                        ((AffineTransform)object5).translate(-((BufferedImage)object).getWidth(), -((BufferedImage)object).getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, ((BufferedImage)object).getWidth(), 0.0f};
                        object4 = new AffineTransform(fArray2);
                        ((AffineTransform)object5).concatenate((AffineTransform)object4);
                    }
                    graphics2D.drawImage((Image)object, (AffineTransform)object5, null);
                } else {
                    graphics2D.drawImage((Image)object, 0, 0, null);
                }
                graphics2D.translate(-f2, -f3);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                error.printStackTrace();
            }
        }
        graphics2D.setTransform(affineTransform3);
        if (bl4 && PdfDecoder.isRunningOnMac && object6 != null) {
            graphics2D.setClip((Shape)object6);
        }
        graphics2D.setComposite(composite);
    }

    public final void renderShape(Shape shape, int n, PdfPaint pdfPaint, PdfPaint pdfPaint2, Stroke stroke, Shape shape2, Graphics2D graphics2D, float f, float f2, boolean bl) {
        Shape shape3 = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        if (bl) {
            this.areas.addElement(shape2.getBounds());
        }
        if (n == 2 || n == 3) {
            pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
            } else {
                graphics2D.setPaint(pdfPaint2);
            }
            if (f2 != 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
            }
            graphics2D.fill(shape2);
            graphics2D.setComposite(composite);
        }
        if (n == 1 || n == 3) {
            Stroke stroke2 = graphics2D.getStroke();
            if (shape2.getBounds2D().getWidth() < 1.0 && ((BasicStroke)stroke).getLineWidth() > 10.0f) {
                graphics2D.setStroke(new BasicStroke(1.0f));
            } else {
                graphics2D.setStroke(stroke);
            }
            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(graphics2D, pdfPaint, this.pageNumber, this.isPrinting);
            } else if (PdfDecoder.Helper != null) {
                PdfDecoder.Helper.setPaint(graphics2D, pdfPaint, this.pageNumber, this.isPrinting);
            } else {
                graphics2D.setPaint(pdfPaint);
            }
            if (f != 1.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            if (!this.isPrinting && shape3 != null && (shape3.getBounds2D().getHeight() < 1.0 || shape3.getBounds2D().getWidth() < 1.0)) {
                graphics2D.setClip(shape);
            }
            graphics2D.draw(shape2);
            graphics2D.setStroke(stroke2);
            graphics2D.setComposite(composite);
        }
        graphics2D.setClip(shape3);
    }

    public void flush() {
        this.singleImage = null;
        this.imageCount = 0;
        this.lastFS = -1;
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[5000];
            this.y_coord = new float[5000];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues = null;
            }
            if (this.imageOptions != null) {
                this.imageOptions = null;
            }
            if (this.fs != null) {
                this.fs = null;
            }
            if (this.lw != null) {
                this.lw = null;
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            this.fontBounds.clear();
            if (this.opacity != null) {
                this.opacity = null;
            }
            if (this.isPrinting) {
                this.largeImages.clear();
            }
            this.endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
        this.imageID.clear();
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.lastScaling = 0.0f;
    }

    public void dispose() {
        this.singleImage = null;
        this.shapeType = null;
        this.pageObjects = null;
        this.objectType = null;
        this.areas = null;
        this.clips = null;
        this.x_coord = null;
        this.y_coord = null;
        this.textFillType = null;
        this.text_color = null;
        this.fill_color = null;
        this.stroke_color = null;
        this.stroke = null;
        this.TRvalues = null;
        this.imageOptions = null;
        this.fs = null;
        this.lw = null;
        this.af1 = null;
        this.af2 = null;
        this.af3 = null;
        this.af4 = null;
        this.fontBounds = null;
        this.opacity = null;
        this.largeImages = null;
        this.lastClip = null;
        this.lastStroke = null;
        this.lastAf = null;
        this.fonts = null;
        this.fontsUsed = null;
        this.imageID = null;
        this.storedImageValues = null;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.addBackground = false;
        } else {
            this.backgroundColor = color;
        }
    }

    private void paint(Graphics2D graphics2D, int n, int n2) {
        this.xx = n < 0 ? n : 0;
        this.yy = n2 < 0 ? n2 : 0;
        this.paint(graphics2D, null, null, null, false, false);
    }

    public void setInset(int n, int n2) {
        this.xx = n;
        this.yy = n2;
    }

    public Rectangle paint(Graphics2D graphics2D, Rectangle[] rectangleArray, AffineTransform affineTransform, Rectangle rectangle, boolean bl, boolean bl2) {
        int n;
        Object object;
        int n2;
        Shape shape;
        Vector_Rectangle vector_Rectangle = null;
        HashMap<Object, String> hashMap = null;
        if (this.hasOCR) {
            vector_Rectangle = new Vector_Rectangle(4000);
            hashMap = new HashMap<Object, String>();
        }
        int n3 = ++this.paintThreadID;
        if (bl2) {
            ++this.paintThreadCount;
        }
        if (rectangleArray != null) {
            this.drawnHighlights = new boolean[rectangleArray.length];
            for (int i = 0; i != this.drawnHighlights.length; ++i) {
                this.drawnHighlights[i] = false;
            }
        }
        if (bl2 && this.paintThreadCount > 1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (n3 != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
        }
        int n4 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Rectangle rectangle2 = null;
        int[] nArray = this.objectType.get();
        int[] nArray2 = this.textFillType.get();
        int n5 = this.currentItem;
        Area[] areaArray = this.clips.get();
        double[] dArray = this.af1.get();
        int[] nArray3 = null;
        if (this.fs != null) {
            nArray3 = this.fs.get();
        }
        Rectangle[] rectangleArray2 = this.fontBounds.get();
        int[] nArray4 = null;
        if (this.lw != null) {
            nArray4 = this.lw.get();
        }
        double[] dArray2 = this.af2.get();
        double[] dArray3 = this.af3.get();
        double[] dArray4 = this.af4.get();
        Object[] objectArray = this.text_color.get();
        Object[] objectArray2 = this.fill_color.get();
        Object[] objectArray3 = this.stroke_color.get();
        Object[] objectArray4 = this.pageObjects.get();
        Object[] objectArray5 = this.javaObjects.get();
        Object[] objectArray6 = this.stroke.get();
        int[] nArray5 = this.shapeType.get();
        float[] fArray = null;
        if (this.opacity != null) {
            fArray = this.opacity.get();
        }
        int[] nArray6 = null;
        if (this.TRvalues != null) {
            nArray6 = this.TRvalues.get();
        }
        Rectangle[] rectangleArray3 = null;
        if (this.areas != null) {
            rectangleArray3 = this.areas.get();
        }
        int[] nArray7 = null;
        if (this.imageOptions != null) {
            nArray7 = this.imageOptions.get();
        }
        if ((shape = graphics2D.getClip()) != null) {
            rectangle2 = shape.getBounds();
        }
        boolean bl3 = false;
        Shape shape2 = graphics2D.getClip();
        Area area = null;
        boolean bl4 = false;
        if (this.noRepaint) {
            this.noRepaint = false;
        } else if (!bl && this.lastItemPainted == -1) {
            this.paintBackground(graphics2D, rectangle2);
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
            shape2 = graphics2D.getClip();
        }
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = -1.0;
        this.maxY = -1.0;
        int n6 = 2;
        int n7 = 0;
        float f5 = 1.0f;
        float f6 = 1.0f;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = -1;
        int n12 = 0;
        int n13 = -1;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        PdfPaint pdfPaint = null;
        PdfPaint pdfPaint2 = null;
        PdfPaint pdfPaint3 = null;
        PdfPaint pdfPaint4 = null;
        Stroke stroke = null;
        if (this.colorsLocked) {
            pdfPaint4 = this.strokeCol;
            pdfPaint3 = this.fillCol;
        }
        if (this.highlightsNeedToBeGenerated && rectangleArray3 != null && rectangleArray != null) {
            this.generateHighlights(graphics2D, n5, nArray, objectArray4, f, f2, f3, f4, dArray, dArray2, dArray3, dArray4, nArray3, rectangleArray2);
        }
        block38: for (n2 = 0; drawPDFShapes && n2 < n5; ++n2) {
            int n21;
            boolean bl5 = false;
            int n22 = nArray[n2];
            if (n22 == 27) continue;
            object = null;
            if (bl2 && n3 != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
            if (n22 <= 0) continue;
            float f7 = this.x_coord[n2];
            float f8 = this.y_coord[n2];
            Object object2 = objectArray4[n2];
            if (n22 == 29) {
                n22 = 3;
                n21 = (Integer)object2;
                object2 = objectArray4[n21];
            } else {
                n21 = -1;
            }
            if (object == null) {
                if (dArray != null && n22 == 3) {
                    if (rectangleArray3 != null) {
                        object = rectangleArray3[n2];
                    }
                } else if (dArray != null && n22 == 2) {
                    object = ((Shape)objectArray4[n2]).getBounds();
                } else if (n22 == 1 && n13 > -1) {
                    object = DynamicVectorRenderer.getAreaForGlyph(new float[][]{{(float)dArray[n13], (float)dArray2[n13], 0.0f}, {(float)dArray3[n13], (float)dArray4[n13], 0.0f}, {f7, f8, 1.0f}});
                } else if (n11 != -1 && dArray != null) {
                    n = nArray3[n11];
                    object = n < 0 ? new Rectangle((int)f7 + n, (int)f8, -n, -n) : new Rectangle((int)f7, (int)f8, n, n);
                }
            }
            bl5 = false;
            if (object != null) {
                if (n22 < 7 && rectangle != null && !rectangle.intersects((Rectangle)object) && ((Rectangle)object).width > 0) {
                    bl5 = true;
                }
            } else if (this.optimiseDrawing && this.rotation == 0 && rectangle2 != null && n22 != 17 && n22 != 18 && n22 != 7 && object != null && !rectangle2.intersects((Rectangle)object)) {
                bl5 = true;
            }
            if (bl5 || this.lastItemPainted != -1 && n2 < this.lastItemPainted) {
                switch (n22) {
                    case 2: {
                        ++n10;
                        break;
                    }
                    case 3: {
                        ++n8;
                        break;
                    }
                    case 29: {
                        ++n8;
                        break;
                    }
                    case 7: {
                        ++n9;
                        break;
                    }
                    case 21: {
                        ++n11;
                        break;
                    }
                    case 22: {
                        ++n12;
                        break;
                    }
                    case 10: {
                        ++n14;
                        break;
                    }
                    case 11: {
                        ++n16;
                        break;
                    }
                    case 12: {
                        ++n17;
                        break;
                    }
                    case 14: {
                        ++n15;
                        break;
                    }
                    case 15: {
                        ++n18;
                    }
                }
                continue;
            }
            if (!bl3 && !this.stopG2setting) {
                graphics2D.setRenderingHints(hints);
                bl3 = true;
            }
            ++n4;
            if (n6 == 4) {
                this.needsHighlights = true;
            }
            switch (n22) {
                case 2: {
                    if (!bl) {
                        if (bl4) {
                            DynamicVectorRenderer.renderClip(area, rectangle2, shape2, graphics2D);
                            bl4 = false;
                        }
                        Shape shape3 = null;
                        if (this.endItem != -1 && this.endItem < n2) {
                            shape3 = graphics2D.getClip();
                            graphics2D.setClip(shape2);
                        }
                        this.renderShape(shape2, nArray5[n10], pdfPaint4, pdfPaint3, stroke, (Shape)object2, graphics2D, f6, f5, false);
                        if (this.endItem != -1 && this.endItem < n2) {
                            graphics2D.setClip(shape3);
                        }
                    }
                    ++n10;
                    continue block38;
                }
                case 1: {
                    Object object3;
                    if (bl4) {
                        DynamicVectorRenderer.renderClip(area, rectangle2, shape2, graphics2D);
                        bl4 = false;
                    }
                    if (bl && this.textHighlightsX == null) continue block38;
                    Rectangle rectangle3 = null;
                    if (!invertHighlight) {
                        rectangle3 = this.setHighlightForGlyph((Rectangle)object, nArray, rectangleArray, n2);
                    }
                    if (this.hasOCR && rectangle3 != null && hashMap.get(object3 = rectangle3.x + " " + rectangle3.y) == null) {
                        hashMap.put(object3, "x");
                        vector_Rectangle.addElement(rectangle3);
                    }
                    object3 = graphics2D.getTransform();
                    this.renderHighlight(rectangle3, graphics2D);
                    graphics2D.transform(new AffineTransform(dArray[n13], dArray2[n13], -dArray3[n13], -dArray4[n13], (double)f7, (double)f8));
                    this.renderText(f7, f8, n6, (Area)object2, graphics2D, rectangle3, pdfPaint, pdfPaint2, f6, f5);
                    graphics2D.setTransform((AffineTransform)object3);
                    continue block38;
                }
                case 4: {
                    String string;
                    if (bl4) {
                        DynamicVectorRenderer.renderClip(area, rectangle2, shape2, graphics2D);
                        bl4 = false;
                    }
                    AffineTransform affineTransform3 = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f7, (double)f8);
                    if (bl && this.textHighlightsX == null) continue block38;
                    Rectangle rectangle4 = null;
                    if (!invertHighlight) {
                        rectangle4 = this.setHighlightForGlyph((Rectangle)object, nArray, rectangleArray, n2);
                    }
                    if (this.hasOCR && rectangle4 != null && hashMap.get(string = rectangle4.x + " " + rectangle4.y) == null) {
                        hashMap.put(string, "x");
                        vector_Rectangle.addElement(rectangle4);
                    }
                    this.renderHighlight(rectangle4, graphics2D);
                    this.renderEmbeddedText(null, n6, object2, 4, graphics2D, affineTransform3, rectangle4, pdfPaint, pdfPaint2, f6, f5, (Rectangle)object, n7);
                    continue block38;
                }
                case 5: {
                    String string;
                    if (bl4) {
                        DynamicVectorRenderer.renderClip(area, rectangle2, shape2, graphics2D);
                        bl4 = false;
                    }
                    AffineTransform affineTransform4 = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f7, (double)f8);
                    if (bl && this.textHighlightsX == null) continue block38;
                    Rectangle rectangle5 = null;
                    if (!invertHighlight) {
                        rectangle5 = this.setHighlightForGlyph((Rectangle)object, nArray, rectangleArray, n2);
                    }
                    if (this.hasOCR && rectangle5 != null && hashMap.get(string = rectangle5.x + " " + rectangle5.y) == null) {
                        hashMap.put(string, "x");
                        vector_Rectangle.addElement(rectangle5);
                    }
                    this.renderHighlight(rectangle5, graphics2D);
                    this.renderEmbeddedText(null, n6, object2, 5, graphics2D, affineTransform4, rectangle5, pdfPaint, pdfPaint2, f6, f5, (Rectangle)object, n7);
                    continue block38;
                }
                case 6: {
                    String string;
                    if (bl4) {
                        DynamicVectorRenderer.renderClip(area, rectangle2, shape2, graphics2D);
                        bl4 = false;
                    }
                    AffineTransform affineTransform5 = new AffineTransform(dArray[n13], dArray2[n13], dArray3[n13], dArray4[n13], (double)f7, (double)f8);
                    if (bl && this.textHighlightsX == null) continue block38;
                    Rectangle rectangle6 = null;
                    if (!invertHighlight) {
                        rectangle6 = this.setHighlightForGlyph((Rectangle)object, nArray, rectangleArray, n2);
                    }
                    if (this.hasOCR && rectangle6 != null && hashMap.get(string = rectangle6.x + " " + rectangle6.y) == null) {
                        hashMap.put(string, "x");
                        vector_Rectangle.addElement(rectangle6);
                    }
                    this.renderHighlight(rectangle6, graphics2D);
                    this.renderEmbeddedText(null, n6, object2, 6, graphics2D, affineTransform5, rectangle6, pdfPaint, pdfPaint2, f6, f5, (Rectangle)object, n7);
                    continue block38;
                }
                case 3: {
                    Object object4;
                    int n23 = 1;
                    int n24 = 0;
                    if (nArray7 != null) {
                        n24 = nArray7[n8];
                    }
                    int n25 = 0;
                    int n26 = 0;
                    int n27 = 1;
                    byte[] byArray = null;
                    Integer n28 = new Integer(this.pageNumber);
                    Integer n29 = new Integer(n8);
                    String string = n28.toString() + n29.toString();
                    if (this.useHiResImageForDisplay && !this.isType3Font && this.objectStoreRef.isRawImageDataSaved(string)) {
                        float f9 = this.scaling;
                        if (this.useHiResImageForDisplay && this.scaling < 1.0f) {
                            f9 = 1.0f;
                        }
                        int n30 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_pX);
                        int n31 = (int)((float)n30 * f9);
                        int n32 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_pY);
                        n26 = (int)((float)n32 * f9);
                        n25 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_WIDTH);
                        int n33 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_HEIGHT);
                        byArray = (byte[])this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_MASKCOL);
                        object4 = null;
                        if (n31 > 0) {
                            int n34;
                            int n35;
                            int n36;
                            int n37 = n25;
                            int n38 = n26 << 2;
                            int n39 = n31 << 2;
                            for (n36 = n33; n37 > n39 && n36 > n38; n37 >>= 1, n36 >>= 1) {
                                n23 <<= 1;
                            }
                            int n40 = n25 / n31;
                            if (n40 < 1) {
                                n40 = 1;
                            }
                            if ((n35 = n33 / n26) < 1) {
                                n35 = 1;
                            }
                            if ((n23 = n40) > n35) {
                                n23 = n35;
                            }
                            int n41 = n25;
                            int n42 = n26 << 2;
                            int n43 = n31 << 2;
                            for (int i = n33; n41 > n43 && i > n42; n41 >>= 1, i >>= 1) {
                                n27 <<= 1;
                            }
                            int n44 = n25 / n30;
                            if (n44 < 1) {
                                n44 = 1;
                            }
                            if ((n34 = n33 / n32) < 1) {
                                n34 = 1;
                            }
                            if ((n27 = n44) > n34) {
                                n27 = n34;
                            }
                            if ((this.scaling > 1.0f || this.lastScaling > 1.0f) && n23 >= 1 && this.lastScaling != this.scaling) {
                                WritableRaster writableRaster;
                                Object object5;
                                n37 = n25 / n23;
                                n36 = n33 / n23;
                                byte[] byArray2 = this.objectStoreRef.getRawImageData(string);
                                byte[] byArray3 = null;
                                if (byArray != null) {
                                    byArray3 = byArray;
                                }
                                int n45 = n37 * n36;
                                if (byArray3 != null) {
                                    n45 *= 3;
                                }
                                byte[] byArray4 = new byte[n45];
                                int[] nArray8 = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                                int n46 = n25 + 7 >> 3;
                                int n47 = 0;
                                for (int i = 0; i < n36; ++i) {
                                    for (int j = 0; j < n37; ++j) {
                                        int n48;
                                        int n49 = 0;
                                        int n50 = 0;
                                        int n51 = n23;
                                        int n52 = n23;
                                        int n53 = n25 - j;
                                        int n54 = n33 - i;
                                        if (n51 > n53) {
                                            n51 = n53;
                                        }
                                        if (n52 > n54) {
                                            n52 = n54;
                                        }
                                        for (n48 = 0; n48 < n52; ++n48) {
                                            for (int k = 0; k < n51; ++k) {
                                                byte by = byArray2[(n48 + i * n23) * n46 + (j * n23 + k >> 3)];
                                                int n55 = by & nArray8[7 - (j * n23 + k & 7)];
                                                if (n55 != 0) {
                                                    ++n49;
                                                }
                                                ++n50;
                                            }
                                        }
                                        if (n50 > 0) {
                                            if (byArray3 == null) {
                                                byArray4[j + n37 * i] = (byte)(255 * n49 / n50);
                                                continue;
                                            }
                                            for (n48 = 0; n48 < 3; ++n48) {
                                                byArray4[n47] = (float)(n49 / n50) < 0.5f ? (int)(byArray[n48] & 0xFF) : -1;
                                                ++n47;
                                            }
                                            continue;
                                        }
                                        if (byArray3 == null) {
                                            byArray4[j + n37 * i] = -1;
                                            continue;
                                        }
                                        for (n48 = 0; n48 < 3; ++n48) {
                                            byArray4[n47] = -1;
                                            ++n47;
                                        }
                                    }
                                }
                                if (byArray3 == null) {
                                    object5 = new int[]{0};
                                    writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray4, byArray4.length), n37, n36, n37, 1, object5, null);
                                    object4 = new BufferedImage(n37, n36, 10);
                                    ((BufferedImage)object4).setData(writableRaster);
                                } else {
                                    n24 = 4;
                                    if (nArray7 != null) {
                                        nArray7[n8] = n24;
                                    }
                                    object4 = new BufferedImage(n37, n36, 1);
                                    object5 = new DataBufferByte(byArray4, byArray4.length);
                                    writableRaster = Raster.createInterleavedRaster((DataBuffer)object5, n37, n36, n37 * 3, 3, new int[]{0, 1, 2}, null);
                                    ((BufferedImage)object4).setData(writableRaster);
                                }
                            }
                        }
                        if (object4 != null) {
                            if (this.singleImage != null) {
                                this.singleImage = object4;
                            }
                            objectArray4[n2] = object4;
                            object2 = object4;
                        }
                    }
                    if (!bl) {
                        if (bl4) {
                            DynamicVectorRenderer.renderClip(area, rectangle2, shape2, graphics2D);
                            bl4 = false;
                        }
                        if (!this.useHiResImageForDisplay) {
                            AffineTransform affineTransform6 = graphics2D.getTransform();
                            this.extraRot = false;
                            if (n26 > 0) {
                                object4 = new double[6];
                                graphics2D.getTransform().getMatrix((double[])object4);
                                double d = (float)n26 / (float)((BufferedImage)object2).getHeight();
                                object4[0] = d;
                                object4[1] = 0.0;
                                object4[2] = 0.0;
                                object4[3] = -d;
                                graphics2D.scale(1.0f / this.scaling, 1.0f / this.scaling);
                                graphics2D.setTransform(new AffineTransform((double[])object4));
                            } else {
                                this.extraRot = true;
                            }
                            this.renderImage(null, (BufferedImage)object2, f5, null, graphics2D, f7, f8, n24);
                            graphics2D.setTransform(affineTransform6);
                        }
                    }
                    ++n8;
                    continue block38;
                }
                case 7: {
                    area = areaArray[n9];
                    bl4 = true;
                    ++n9;
                    continue block38;
                }
                case 9: {
                    ++n13;
                    continue block38;
                }
                case 21: {
                    ++n11;
                    continue block38;
                }
                case 22: {
                    n7 = nArray4[n12];
                    ++n12;
                    continue block38;
                }
                case 10: {
                    int n56 = nArray2[n14];
                    if (n56 == 1) {
                        pdfPaint = (PdfPaint)objectArray[n14];
                    } else {
                        pdfPaint2 = (PdfPaint)objectArray[n14];
                    }
                    ++n14;
                    continue block38;
                }
                case 11: {
                    if (!this.colorsLocked) {
                        pdfPaint3 = (PdfPaint)objectArray2[n16];
                    }
                    ++n16;
                    continue block38;
                }
                case 12: {
                    if (!this.colorsLocked && (pdfPaint4 = (PdfPaint)objectArray3[n17]) != null) {
                        pdfPaint4.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    ++n17;
                    continue block38;
                }
                case 14: {
                    stroke = (Stroke)objectArray6[n15];
                    ++n15;
                    continue block38;
                }
                case 15: {
                    n6 = nArray6[n18];
                    ++n18;
                    continue block38;
                }
                case 17: {
                    f6 = fArray[n19];
                    ++n19;
                    continue block38;
                }
                case 18: {
                    f5 = fArray[n19];
                    ++n19;
                    continue block38;
                }
                case 16: {
                    if (bl) continue block38;
                    Shape shape4 = graphics2D.getClip();
                    graphics2D.setClip(shape2);
                    Object object4 = graphics2D.getTransform();
                    String string = (String)object2;
                    double[] dArray5 = new double[6];
                    graphics2D.getTransform().getMatrix(dArray5);
                    if (dArray5[2] != 0.0) {
                        dArray5[2] = -dArray5[2];
                    }
                    if (dArray5[3] != 0.0) {
                        dArray5[3] = -dArray5[3];
                    }
                    graphics2D.setTransform(new AffineTransform(dArray5));
                    Font font = (Font)objectArray5[n20];
                    graphics2D.setFont(font);
                    if ((n6 & 2) == 2) {
                        if (pdfPaint2 != null) {
                            pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
                        } else if (PdfDecoder.Helper != null) {
                            PdfDecoder.Helper.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
                        } else {
                            graphics2D.setPaint(pdfPaint2);
                        }
                    }
                    if ((n6 & 1) == 1) {
                        if (pdfPaint != null) {
                            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
                        } else if (PdfDecoder.Helper != null) {
                            PdfDecoder.Helper.setPaint(graphics2D, pdfPaint2, this.pageNumber, this.isPrinting);
                        } else {
                            graphics2D.setPaint(pdfPaint2);
                        }
                    }
                    graphics2D.drawString(string, f7, f8);
                    graphics2D.setTransform((AffineTransform)object4);
                    graphics2D.setClip(shape4);
                    ++n20;
                    continue block38;
                }
                case 25: {
                    this.renderXForm(graphics2D, (DynamicVectorRenderer)object2, f5);
                    continue block38;
                }
                case 23: {
                    Shape shape5 = graphics2D.getClip();
                    graphics2D.setClip(shape2);
                    Object object4 = graphics2D.getTransform();
                    JPedalCustomDrawObject jPedalCustomDrawObject = (JPedalCustomDrawObject)object2;
                    if (this.isPrinting) {
                        jPedalCustomDrawObject.print(graphics2D, this.pageNumber);
                    } else {
                        jPedalCustomDrawObject.paint(graphics2D);
                    }
                    graphics2D.setTransform((AffineTransform)object4);
                    graphics2D.setClip(shape5);
                }
            }
        }
        if (this.needsHighlights && rectangleArray != null) {
            for (n2 = 0; n2 != rectangleArray.length; ++n2) {
                this.ignoreHighlight = false;
                this.renderHighlight(rectangleArray[n2], graphics2D);
            }
        }
        if (vector_Rectangle != null) {
            Rectangle[] rectangleArray4 = vector_Rectangle.get();
            Composite composite = graphics2D.getComposite();
            object = graphics2D.getPaint();
            for (n = 0; n != rectangleArray4.length; ++n) {
                if (rectangleArray4[n] != null) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
                    graphics2D.setPaint(PdfDecoder.highlightColor);
                    graphics2D.fill(rectangleArray4[n]);
                }
                graphics2D.setComposite(composite);
                graphics2D.setPaint((Paint)object);
            }
        }
        graphics2D.setClip(shape2);
        graphics2D.setTransform(affineTransform2);
        if (debugPaint) {
            System.err.println("Painted " + n4);
        }
        if (this.frame != null && this.renderFailed && !userAlerted) {
            userAlerted = true;
            if (PdfDecoder.showErrorMessages) {
                String string = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                JOptionPane.showMessageDialog(this.frame, string);
                this.frame.invalidate();
                this.frame.repaint();
            }
        }
        if (bl2) {
            --this.paintThreadCount;
        }
        this.lastItemPainted = this.optimsePainting ? n5 : -1;
        this.lastScaling = this.scaling;
        if (this.minX == -1.0) {
            return null;
        }
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    public void renderXForm(Graphics2D graphics2D, DynamicVectorRenderer dynamicVectorRenderer, float f) {
        Rectangle rectangle = dynamicVectorRenderer.getOccupiedArea();
        int n = rectangle.x;
        int n2 = rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.height;
        if (n < 0) {
            n = 0;
        }
        if (n3 > 0) {
            n4 += n3;
        }
        if (n2 <= 0 || n4 <= 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n4, 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.translate(-n, 0);
        dynamicVectorRenderer.paint(graphics2D2, null, null, null, false, true);
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.CTM[0][0] = n2;
        graphicsState.CTM[1][0] = 0.0f;
        graphicsState.CTM[2][0] = 0.0f;
        graphicsState.CTM[0][1] = 0.0f;
        graphicsState.CTM[1][1] = n4;
        graphicsState.CTM[2][1] = 0.0f;
        graphicsState.CTM[0][2] = 0.0f;
        graphicsState.CTM[1][2] = 0.0f;
        graphicsState.CTM[2][2] = 1.0f;
        graphics2D.translate(n, 0);
        this.renderImage(new AffineTransform(), bufferedImage, f, graphicsState, graphics2D, rectangle.x, rectangle.y, 1);
        graphics2D.translate(-n, 0);
    }

    private static Rectangle getAreaForGlyph(float[][] fArray) {
        int n = (int)Math.sqrt(fArray[0][0] * fArray[0][0] + fArray[1][0] * fArray[1][0]);
        int n2 = (int)Math.sqrt(fArray[1][1] * fArray[1][1] + fArray[0][1] * fArray[0][1]);
        float f = 0.0f;
        float f2 = 0.0f;
        if (fArray[0][0] < 0.0f) {
            f = fArray[0][0];
        } else if (fArray[1][0] < 0.0f) {
            f = fArray[1][0];
        }
        if (fArray[1][1] < 0.0f) {
            f2 = fArray[1][1];
        } else if (fArray[0][1] < 0.0f) {
            f2 = fArray[0][1];
        }
        return new Rectangle((int)(fArray[2][0] + f), (int)(fArray[2][1] + f2), n, n2);
    }

    public void setMessageFrame(Container container) {
        this.frame = container;
    }

    public void paintBackground(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.addBackground) {
            graphics2D.setColor(this.backgroundColor);
            if (rectangle == null) {
                graphics2D.fill(new Rectangle(this.xx, this.yy, (int)((float)this.w * this.scaling), (int)((float)this.h * this.scaling)));
            } else {
                graphics2D.fill(rectangle);
            }
        }
    }

    public static void renderClip(Area area, Rectangle rectangle, Shape shape, Graphics2D graphics2D) {
        if (area != null) {
            graphics2D.setClip(area);
            if (rectangle != null) {
                graphics2D.clip(rectangle);
            }
        } else {
            graphics2D.setClip(shape);
        }
    }

    private Rectangle setHighlightForGlyph(Rectangle rectangle, int[] nArray, Rectangle[] rectangleArray, int n) {
        if (rectangleArray == null || this.textHighlightsX == null) {
            return null;
        }
        this.ignoreHighlight = false;
        for (int i = 0; i != rectangleArray.length; ++i) {
            if (rectangleArray[i] == null || !rectangleArray[i].intersects(rectangle)) continue;
            Rectangle rectangle2 = rectangleArray[i].intersection(rectangle);
            float f = rectangle2.width * rectangle2.height;
            float f2 = (float)(rectangle.width * rectangle.height) / 4.0f;
            if (!(rectangleArray[i].contains(rectangle.x, rectangle.y) && f > f2) && !(f > (float)(rectangle.width * rectangle.height) / 1.667f)) continue;
            if (!this.drawnHighlights[i]) {
                this.ignoreHighlight = false;
                this.drawnHighlights[i] = true;
                return rectangleArray[i];
            }
            this.ignoreHighlight = true;
            return rectangleArray[i];
        }
        return null;
    }

    public final void drawText(float[][] fArray, String string, GraphicsState graphicsState, float f, float f2, Font font) {
        int n;
        int n2;
        double[] dArray;
        PdfPaint pdfPaint = null;
        if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        if (((n2 = graphicsState.getTextRenderType()) & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n) {
                    this.lastFillTextCol = n;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n2 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.pageObjects.addElement(string);
        this.javaObjects.addElement(font);
        this.objectType.addElement(16);
        n = font.getSize();
        if (n > 100) {
            this.areas.addElement(new Rectangle((int)f, (int)f2, n, n));
        } else {
            this.areas.addElement(null);
        }
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    private static float[] checkSize(float[] fArray, int n) {
        int n2 = fArray.length;
        if (n2 <= n) {
            int n3 = n2 * 2;
            float[] fArray2 = new float[n3];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            fArray = fArray2;
        }
        return fArray;
    }

    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = null;
        if (this.areas != null) {
            Rectangle rectangle3 = rectangle.getBounds();
            int n = rectangle3.x;
            int n2 = rectangle3.y;
            int n3 = n + rectangle3.width;
            int n4 = n2 + rectangle3.height;
            boolean bl2 = false;
            Rectangle[] rectangleArray = this.areas.get();
            int n5 = rectangleArray.length;
            for (int i = 0; i < n5; ++i) {
                int n6;
                if (rectangleArray[i] == null || !rectangle.contains(rectangleArray[i])) continue;
                bl2 = true;
                int n7 = rectangleArray[i].x;
                if (n3 > n7) {
                    n3 = n7;
                }
                if (n < (n7 = rectangleArray[i].x + rectangleArray[i].width)) {
                    n = n7;
                }
                if (n4 > (n6 = rectangleArray[i].y)) {
                    n4 = n6;
                }
                if (n2 >= (n6 = rectangleArray[i].y + rectangleArray[i].height)) continue;
                n2 = n6;
            }
            if (bl2) {
                rectangle2 = new Rectangle(n3 - 1, n4 + 1, n - n3 + 2, n2 - n4 + 2);
            }
        }
        return rectangle2;
    }

    public final void init(int n, int n2, int n3) {
        this.w = n;
        this.h = n2;
        this.rotation = n3;
    }

    public final BufferedImage getPageAsImage(float f, int n, int n2, int n3, int n4, int n5, AffineTransform affineTransform, int n6) {
        if (n3 < 0) {
            n3 = this.w;
            n4 = this.h;
        } else {
            n3 = (int)((float)n3 * f);
            n4 = (int)((float)n4 * f);
        }
        this.lastItemPainted = -1;
        BufferedImage bufferedImage = new BufferedImage(n3, n4, n6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (n6 == 1) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n3, n4);
        }
        AffineTransform affineTransform2 = graphics2D.getTransform();
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        this.paint(graphics2D, n, n2);
        graphics2D.setTransform(affineTransform2);
        return bufferedImage;
    }

    public static boolean isRotationreversed(float[][] fArray) {
        return fArray[0][0] > 0.0f && fArray[0][1] < 0.0f && fArray[1][0] > 0.0f && fArray[1][1] > 0.0f;
    }

    public static boolean isRotated(float[][] fArray) {
        if (DynamicVectorRenderer.isRotationreversed(fArray)) {
            return true;
        }
        return fArray[0][0] == 0.0f && fArray[1][1] == 0.0f;
    }

    public final int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2) {
        int n3;
        this.pageNumber = n;
        float[][] fArray = graphicsState.CTM;
        float f = graphicsState.x;
        float f2 = graphicsState.y;
        double[] dArray = new double[6];
        boolean bl2 = bufferedImage.getWidth() < 100 && bufferedImage.getHeight() < 100 || bufferedImage.getHeight() == 1;
        String string2 = this.rawKey == null ? n + "_" + (this.currentItem + 1) : this.rawKey + '_' + (this.currentItem + 1);
        if (this.imageOptions == null) {
            this.imageOptions = new Vector_Int(5000);
            this.imageOptions.setCheckpoint();
        }
        if (!bl && bufferedImage.getHeight() > 1 && (n2 & 1) != 1) {
            boolean bl3;
            boolean bl4 = bl3 = this.optimisedTurnCode && fArray[0][0] * fArray[0][1] == 0.0f && fArray[1][1] * fArray[1][0] == 0.0f && !DynamicVectorRenderer.isRotated(fArray);
            if (!this.optimisedTurnCode || !bl3) {
                bufferedImage = DynamicVectorRenderer.invertImage(fArray, bufferedImage);
            }
            if (bl3) {
                n2 += 4;
            }
        }
        this.imageOptions.addElement(n2);
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        this.objectType.addElement(3);
        float f3 = 1.0f;
        float f4 = 1.0f;
        if (this.useHiResImageForDisplay) {
            if (!bl) {
                f3 = bufferedImage.getWidth();
                f4 = bufferedImage.getHeight();
            } else {
                f3 = ((Integer)this.cachedWidths.get(string2)).intValue();
                f4 = ((Integer)this.cachedHeights.get(string2)).intValue();
            }
        }
        this.w = (int)(fArray[0][0] * f3);
        if (this.w == 0) {
            this.w = (int)(fArray[0][1] * f3);
        }
        this.h = (int)(fArray[1][1] * f4);
        if (this.h == 0) {
            this.h = (int)(fArray[1][0] * f4);
        }
        if (!this.useHiResImageForDisplay && fArray[1][0] < 0.0f && fArray[0][1] > 0.0f && fArray[0][0] == 0.0f && fArray[1][1] == 0.0f) {
            n3 = this.w;
            this.w = -this.h;
            this.h = n3;
        }
        if (this.h < 0 && !this.useHiResImageForDisplay) {
            this.h = -this.h;
        }
        n3 = (int)graphicsState.x;
        int n4 = (int)graphicsState.y;
        int n5 = this.w;
        int n6 = this.h;
        if (n6 < 0) {
            n4 += n6;
            n6 = -n6;
        }
        if (n6 == 0) {
            n6 = 1;
        }
        Rectangle rectangle = new Rectangle(n3, n4, n5, n6);
        this.areas.addElement(rectangle);
        this.checkWidth(rectangle);
        if (this.useHiResImageForDisplay && !bl2) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        this.imageID.put(string, new Integer(this.currentItem));
        this.storedImageValues.put("imageOptions-" + this.currentItem, new Integer(n2));
        this.storedImageValues.put("imageAff-" + this.currentItem, dArray);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    public final int redrawImage(int n, GraphicsState graphicsState, String string, int n2) {
        this.pageNumber = n;
        float f = graphicsState.x;
        float f2 = graphicsState.y;
        this.imageOptions.addElement((Integer)this.storedImageValues.get("imageOptions-" + n2));
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        this.objectType.addElement(29);
        Rectangle rectangle = this.areas.elementAt(n2);
        Rectangle rectangle2 = null;
        if (rectangle != null) {
            rectangle2 = new Rectangle((int)f, (int)f2, rectangle.width, rectangle.height);
        }
        this.areas.addElement(rectangle2);
        if (rectangle != null) {
            this.checkWidth(rectangle2);
        }
        this.pageObjects.addElement(new Integer(n2));
        this.imageID.put(string, new Integer(n2));
        ++this.currentItem;
        return this.currentItem - 1;
    }

    public static boolean isInverted(float[][] fArray) {
        return fArray[0][0] > 0.0f && fArray[1][1] > 0.0f || fArray[0][0] < 0.0f && fArray[1][1] < 0.0f || fArray[0][0] * fArray[1][1] < 0.0f && fArray[2][1] >= 0.0f;
    }

    private static BufferedImage invertImage(float[][] fArray, BufferedImage bufferedImage) {
        boolean bl = false;
        bl = fArray == null ? true : DynamicVectorRenderer.isInverted(fArray);
        if (bl) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -bufferedImage.getHeight());
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
            boolean bl2 = false;
            if (JAIHelper.isJAIused()) {
                bl2 = true;
                try {
                    bufferedImage = JAI.create((String)"affine", (RenderedImage)bufferedImage, (Object)affineTransform, (Object)new InterpolationNearest()).getAsBufferedImage();
                }
                catch (Exception exception) {
                    bl2 = false;
                    exception.printStackTrace();
                }
                catch (Error error) {
                    bl2 = false;
                    error.printStackTrace();
                }
                if (!bl2) {
                    LogWriter.writeLog("Unable to use JAI for image inversion");
                }
            }
            if (!bl2) {
                if (bufferedImage.getType() == 12) {
                    BufferedImage bufferedImage2 = bufferedImage;
                    bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                    affineTransformOp.filter(bufferedImage2, bufferedImage);
                } else {
                    boolean bl3 = false;
                    try {
                        bufferedImage = affineTransformOp.filter(bufferedImage, null);
                    }
                    catch (Exception exception) {
                        bl3 = true;
                    }
                    if (bl3) {
                        try {
                            affineTransformOp = new AffineTransformOp(affineTransform, null);
                            bufferedImage = affineTransformOp.filter(bufferedImage, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return bufferedImage;
    }

    private static BufferedImage invertImageBeforeSave(BufferedImage bufferedImage, boolean bl) {
        AffineTransform affineTransform = new AffineTransform();
        if (bl) {
            affineTransform.scale(-1.0, 1.0);
            affineTransform.translate(-bufferedImage.getWidth(), 0.0);
        } else {
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -bufferedImage.getHeight());
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
        boolean bl2 = false;
        if (JAIHelper.isJAIused()) {
            bl2 = true;
            try {
                bufferedImage = JAI.create((String)"affine", (RenderedImage)bufferedImage, (Object)affineTransform, (Object)new InterpolationNearest()).getAsBufferedImage();
            }
            catch (Exception exception) {
                bl2 = false;
                exception.printStackTrace();
            }
            catch (Error error) {
                bl2 = false;
                error.printStackTrace();
            }
            if (!bl2) {
                LogWriter.writeLog("Unable to use JAI for image inversion");
            }
        }
        if (!bl2) {
            if (bufferedImage.getType() == 12) {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                affineTransformOp.filter(bufferedImage2, bufferedImage);
            } else {
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            }
        }
        return bufferedImage;
    }

    public final void drawImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getHeight();
        if (n > 1) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(0.0, n);
            affineTransform.scale(1.0, -1.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
            bufferedImage = affineTransformOp.filter(bufferedImage, null);
        }
        if (this.useHiResImageForDisplay) {
            // empty if block
        }
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        this.objectType.addElement(3);
        this.areas.addElement(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        if (this.useHiResImageForDisplay) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        ++this.currentItem;
    }

    private void checkWidth(Rectangle rectangle) {
        int n = rectangle.getBounds().x;
        int n2 = rectangle.getBounds().y;
        int n3 = n2 + rectangle.getBounds().height;
        int n4 = n + rectangle.getBounds().width;
        if (n < this.pageX1) {
            this.pageX1 = n;
        }
        if (n4 > this.pageX2) {
            this.pageX2 = n4;
        }
        if (n3 > this.pageY1) {
            this.pageY1 = n3;
        }
        if (n2 < this.pageY2) {
            this.pageY2 = n2;
        }
    }

    public Rectangle getOccupiedArea() {
        return new Rectangle(this.pageX1, this.pageY1, this.pageX2 - this.pageX1, this.pageY1 - this.pageY2);
    }

    public final void drawShape(Shape shape, GraphicsState graphicsState) {
        int n;
        PdfPaint pdfPaint;
        int n2 = graphicsState.getFillType();
        if (shape.getBounds().getWidth() == 1.0 && shape.getBounds().getHeight() == 1.0 && graphicsState.getLineWidth() < 1.0f) {
            shape = new Rectangle(shape.getBounds().x, shape.getBounds().y, 1, 1);
        }
        if (n2 == 2 || n2 == 3) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawFillColor(pdfPaint);
                this.fillSet = true;
            } else {
                n = pdfPaint.getRGB();
                if (!this.fillSet || this.lastFillCol != n) {
                    this.lastFillCol = n;
                    this.drawFillColor(pdfPaint);
                    this.fillSet = true;
                }
            }
        }
        if (n2 == 1 || n2 == 3) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint instanceof Color) {
                n = pdfPaint.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawStrokeColor(pdfPaint);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(pdfPaint);
                this.strokeSet = true;
            }
        }
        Stroke stroke = graphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(stroke)) {
            this.lastStroke = stroke;
            this.drawStroke(stroke);
        }
        this.pageObjects.addElement(shape);
        this.objectType.addElement(2);
        this.areas.addElement(shape.getBounds());
        this.checkWidth(shape.getBounds());
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = graphicsState.x;
        this.y_coord[this.currentItem] = graphicsState.y;
        this.shapeType.addElement(n2);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    public final void drawColor(PdfPaint pdfPaint, int n) {
        this.areas.addElement(null);
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(n);
        this.text_color.addElement(pdfPaint);
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    public final void drawXForm(DynamicVectorRenderer dynamicVectorRenderer) {
        this.areas.addElement(null);
        this.pageObjects.addElement(dynamicVectorRenderer);
        this.objectType.addElement(25);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public void resetOnColorspaceChange() {
        this.fillSet = false;
        this.strokeSet = false;
    }

    public final void drawFillColor(PdfPaint pdfPaint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(pdfPaint);
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = pdfPaint.getRGB();
    }

    public final void setGraphicsState(int n, float f) {
        if (f != 1.0f || this.opacity != null) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(5000);
                this.opacity.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            if (n == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(f);
            this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
            this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final void drawAdditionalObjectsOverPage(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (objectArray == null) {
            return;
        }
        if (this.endItem == -1) {
            this.endItem = this.currentItem;
            this.objectType.setCheckpoint();
            this.shapeType.setCheckpoint();
            this.pageObjects.setCheckpoint();
            this.areas.setCheckpoint();
            this.clips.setCheckpoint();
            this.textFillType.setCheckpoint();
            this.text_color.setCheckpoint();
            this.fill_color.setCheckpoint();
            this.stroke_color.setCheckpoint();
            this.stroke.setCheckpoint();
            if (this.imageOptions != null) {
                this.imageOptions.setCheckpoint();
            }
            if (this.TRvalues != null) {
                this.TRvalues.setCheckpoint();
            }
            if (this.fs != null) {
                this.fs.setCheckpoint();
            }
            if (this.lw != null) {
                this.lw.setCheckpoint();
            }
            this.af1.setCheckpoint();
            this.af2.setCheckpoint();
            this.af3.setCheckpoint();
            this.af4.setCheckpoint();
            this.fontBounds.setCheckpoint();
            if (this.opacity != null) {
                this.opacity.setCheckpoint();
            }
        }
        int n = nArray.length;
        block10: for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            switch (n2) {
                case 18: {
                    this.setGraphicsState(2, ((Float)objectArray[i]).floatValue());
                    continue block10;
                }
                case 17: {
                    this.setGraphicsState(1, ((Float)objectArray[i]).floatValue());
                    continue block10;
                }
                case 19: {
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.setFillType(1);
                    graphicsState.setStrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawShape((Shape)objectArray[i], graphicsState);
                    continue block10;
                }
                case 20: {
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.setFillType(2);
                    graphicsState.setNonstrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawShape((Shape)objectArray[i], graphicsState);
                    continue block10;
                }
                case 23: {
                    this.drawCustom(objectArray[i]);
                    continue block10;
                }
                case 3: {
                    ImageObject imageObject = (ImageObject)objectArray[i];
                    GraphicsState graphicsState = new GraphicsState();
                    graphicsState.CTM = new float[][]{{imageObject.image.getWidth(), 0.0f, 1.0f}, {0.0f, imageObject.image.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
                    graphicsState.x = imageObject.x;
                    graphicsState.y = imageObject.y;
                    this.drawImage(this.pageNumber, imageObject.image, graphicsState, false, "extImg" + i, 0);
                    continue block10;
                }
                case 16: {
                    TextObject textObject = (TextObject)objectArray[i];
                    GraphicsState graphicsState = new GraphicsState();
                    float f = textObject.font.getSize();
                    double[] dArray = new double[]{f, 0.0, 0.0, f, 0.0, 0.0};
                    this.drawAffine(dArray);
                    this.drawTR(2);
                    graphicsState.setTextRenderType(2);
                    graphicsState.setNonstrokeColor(new PdfColor(colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue()));
                    this.drawText(null, textObject.text, graphicsState, textObject.x, -textObject.y, textObject.font);
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
                default: {
                    throw new PdfException("Unrecognised type " + n2);
                }
            }
        }
    }

    public final void flushAdditionalObjOnPage() {
        if (this.endItem != -1) {
            this.currentItem = this.endItem;
        }
        this.endItem = -1;
        this.objectType.resetToCheckpoint();
        this.shapeType.resetToCheckpoint();
        this.pageObjects.resetToCheckpoint();
        this.areas.resetToCheckpoint();
        this.clips.resetToCheckpoint();
        this.textFillType.resetToCheckpoint();
        this.text_color.resetToCheckpoint();
        this.fill_color.resetToCheckpoint();
        this.stroke_color.resetToCheckpoint();
        this.stroke.resetToCheckpoint();
        if (this.imageOptions != null) {
            this.imageOptions.resetToCheckpoint();
        }
        if (this.TRvalues != null) {
            this.TRvalues.resetToCheckpoint();
        }
        if (this.fs != null) {
            this.fs.resetToCheckpoint();
        }
        if (this.lw != null) {
            this.lw.resetToCheckpoint();
        }
        this.af1.resetToCheckpoint();
        this.af2.resetToCheckpoint();
        this.af3.resetToCheckpoint();
        this.af4.resetToCheckpoint();
        this.fontBounds.resetToCheckpoint();
        if (this.opacity != null) {
            this.opacity.resetToCheckpoint();
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.fillSet = false;
        this.strokeSet = false;
    }

    public final void drawStrokeColor(Paint paint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(paint);
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    public final void drawCustom(Object object) {
        this.pageObjects.addElement(object);
        this.objectType.addElement(23);
        this.areas.addElement(null);
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public final void drawTR(int n) {
        if (n != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
                this.TRvalues.setCheckpoint();
            }
            this.lastTR = n;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(n);
            this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
            this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final void drawStroke(Stroke stroke) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(stroke);
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public final void drawClip(GraphicsState graphicsState) {
        Area area = graphicsState.getClippingShape();
        if (!this.hasClips || this.lastClip != null || area != null) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = area;
            if (area == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement((Area)area.clone());
            }
            this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
            this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = graphicsState.x;
            this.y_coord[this.currentItem] = graphicsState.y;
            ++this.currentItem;
        }
        this.hasClips = true;
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform) {
        int n3;
        PdfPaint pdfPaint;
        int n4 = graphicsState.getTextRenderType();
        if ((n4 & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n3 = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n3) {
                    this.lastFillTextCol = n3;
                    this.drawColor(pdfPaint, 2);
                    this.resetTextColors = false;
                }
            }
        }
        if ((n4 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n3 = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n3) {
                    this.resetTextColors = false;
                    this.lastStrokeCol = n3;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.setLineWidth((int)graphicsState.getLineWidth());
        this.drawFontSize(n);
        if (object != null) {
            double[] dArray;
            if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
                this.drawAffine(dArray);
                this.lastAf[0] = dArray[0];
                this.lastAf[1] = dArray[1];
                this.lastAf[2] = dArray[2];
                this.lastAf[3] = dArray[3];
            }
            if (!(object instanceof Area)) {
                n2 = -n2;
            }
        } else {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            if (this.lastAf[0] != dArray[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3]) {
                this.drawAffine(dArray);
                this.lastAf[0] = dArray[0];
                this.lastAf[1] = dArray[1];
                this.lastAf[2] = dArray[2];
                this.lastAf[3] = dArray[3];
            }
        }
        if (pdfGlyph == null) {
            this.pageObjects.addElement(object);
        } else {
            this.pageObjects.addElement(pdfGlyph);
        }
        this.objectType.addElement(n2);
        if (n2 < 0) {
            this.areas.addElement(null);
        } else if (object != null) {
            this.areas.addElement(new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n));
            this.checkWidth(new Rectangle((int)fArray[2][0], (int)fArray[2][1], n, n));
        } else {
            int n5 = n;
            if (n5 < 0) {
                n5 = -n5;
            }
            Rectangle rectangle = new Rectangle((int)fArray[2][0], (int)fArray[2][1], n5, n5);
            this.areas.addElement(rectangle);
            this.checkWidth(rectangle);
        }
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = fArray[2][0];
        this.y_coord[this.currentItem] = fArray[2][1];
        ++this.currentItem;
    }

    public void drawFontBounds(Rectangle rectangle) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(24);
        this.areas.addElement(null);
        this.fontBounds.addElement(rectangle);
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public void drawAffine(double[] dArray) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(dArray[0]);
        this.af2.addElement(dArray[1]);
        this.af3.addElement(dArray[2]);
        this.af4.addElement(dArray[3]);
        this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
        this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)dArray[4];
        this.y_coord[this.currentItem] = (float)dArray[5];
        ++this.currentItem;
    }

    public void drawFontSize(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            this.areas.addElement(null);
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
                this.fs.setCheckpoint();
            }
            this.fs.addElement(n);
            this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
            this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = n2;
        }
    }

    public void setLineWidth(int n) {
        if (n != this.lastLW) {
            this.areas.addElement(null);
            this.pageObjects.addElement(null);
            this.objectType.addElement(22);
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
                this.lw.setCheckpoint();
            }
            this.lw.addElement(n);
            this.x_coord = DynamicVectorRenderer.checkSize(this.x_coord, this.currentItem);
            this.y_coord = DynamicVectorRenderer.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastLW = n;
        }
    }

    public boolean addBackground() {
        return this.addBackground;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void lockColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.colorsLocked = true;
        Color color = Color.white;
        Color color2 = Color.white;
        if (!pdfPaint.isPattern()) {
            color = (Color)((Object)pdfPaint);
        }
        this.strokeCol = new PdfColor(color.getRed(), color.getGreen(), color.getBlue());
        if (!pdfPaint2.isPattern()) {
            color2 = (Color)((Object)pdfPaint2);
        }
        this.fillCol = new PdfColor(color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    public void setHiResImageForDisplayMode(boolean bl) {
    }

    public void setOptimiseDrawing(boolean bl) {
        this.optimiseDrawing = bl;
    }

    public void setScalingValues(double d, double d2, float f) {
        this.cropX = d;
        this.cropH = d2;
        this.scaling = f;
    }

    public DynamicVectorRenderer(byte[] byArray, Map map) {
        try {
            Object object;
            int n;
            this.fonts = map;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            int n2 = byteArrayInputStream.read();
            if (n2 != 1) {
                throw new PdfException("Unknown version in serialised object " + n2);
            }
            int n3 = byteArrayInputStream.read();
            this.useHiResImageForDisplay = n3 == 1;
            this.pageNumber = byteArrayInputStream.read();
            this.x_coord = (float[])DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.y_coord = (float[])DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.text_color = (Vector_Object)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.textFillType = (Vector_Int)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.stroke_color = new Vector_Object();
            this.stroke_color.restoreFromStream(byteArrayInputStream);
            this.fill_color = new Vector_Object();
            this.fill_color.restoreFromStream(byteArrayInputStream);
            this.stroke = new Vector_Object();
            this.stroke.restoreFromStream(byteArrayInputStream);
            this.pageObjects = new Vector_Object();
            this.pageObjects.restoreFromStream(byteArrayInputStream);
            this.javaObjects = (Vector_Object)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.shapeType = (Vector_Int)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.af1 = (Vector_Double)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.af2 = (Vector_Double)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.af3 = (Vector_Double)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.af4 = (Vector_Double)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.fontBounds = new Vector_Rectangle();
            this.fontBounds.restoreFromStream(byteArrayInputStream);
            this.clips = new Vector_Shape();
            this.clips.restoreFromStream(byteArrayInputStream);
            this.objectType = (Vector_Int)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.opacity = (Vector_Float)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.imageOptions = (Vector_Int)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.TRvalues = (Vector_Int)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.fs = (Vector_Int)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            this.lw = (Vector_Int)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            int n4 = (Integer)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            for (n = 0; n < n4; ++n) {
                Object object2 = DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
                object = DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
                map.put(object2, object);
            }
            n = (Integer)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
            for (int i = 0; i < n; ++i) {
                object = DynamicVectorRenderer.restoreFromStream(byteArrayInputStream);
                PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)map.get(object);
                pdfJavaGlyphs.setDisplayValues((Map)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream));
                pdfJavaGlyphs.setCharGlyphs((Map)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream));
                pdfJavaGlyphs.setEmbeddedEncs((Map)DynamicVectorRenderer.restoreFromStream(byteArrayInputStream));
            }
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.currentItem = this.pageObjects.get().length;
    }

    public void stopClearOnNextRepaint(boolean bl) {
        this.noRepaint = bl;
    }

    public byte[] serializeToByteArray(Set set) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(1);
        if (this.useHiResImageForDisplay) {
            byteArrayOutputStream.write(1);
        } else {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(this.pageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.fontBounds.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.imageOptions != null) {
            this.imageOptions.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.x_coord, "x_coord");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.y_coord, "y_coord");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.text_color, "text_color");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.textFillType, "textFillType");
        this.stroke_color.writeToStream(byteArrayOutputStream);
        this.fill_color.writeToStream(byteArrayOutputStream);
        this.stroke.writeToStream(byteArrayOutputStream);
        this.pageObjects.writeToStream(byteArrayOutputStream);
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.javaObjects, "javaObjects");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.shapeType, "shapeType");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.af1, "af1");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.af2, "af2");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.af3, "af3");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.af4, "af4");
        this.fontBounds.writeToStream(byteArrayOutputStream);
        this.clips.writeToStream(byteArrayOutputStream);
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.objectType, "objectType");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.opacity, "opacity");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.imageOptions, "imageOptions");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.TRvalues, "TRvalues");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.fs, "fs");
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.lw, "lw");
        int n = 0;
        int n2 = 0;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (Object k : this.fontsUsed.keySet()) {
            if (!set.contains(k)) {
                ++n;
                hashMap2.put(k, "x");
                continue;
            }
            ++n2;
            hashMap.put(k, "x");
        }
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, new Integer(n), "new Integer(fontCount)");
        for (Object k : hashMap2.keySet()) {
            DynamicVectorRenderer.writeToStream(byteArrayOutputStream, k, "key");
            DynamicVectorRenderer.writeToStream(byteArrayOutputStream, this.fonts.get(k), "font");
            set.add(k);
        }
        DynamicVectorRenderer.writeToStream(byteArrayOutputStream, new Integer(n2), "new Integer(existingfontCount)");
        for (Object k : hashMap.keySet()) {
            DynamicVectorRenderer.writeToStream(byteArrayOutputStream, k, "key");
            PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)this.fonts.get(k);
            DynamicVectorRenderer.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getDisplayValues(), "display");
            DynamicVectorRenderer.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getCharGlyphs(), "char");
            DynamicVectorRenderer.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getEmbeddedEncs(), "emb");
        }
        byteArrayOutputStream.close();
        this.fontsUsed.clear();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object restoreFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static void writeToStream(ByteArrayOutputStream byteArrayOutputStream, Object object, String string) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
    }

    public void checkFontSaved(Object object, String string, PdfFont pdfFont) {
        this.pageObjects.addElement(object);
        this.objectType.addElement(200);
        this.areas.addElement(null);
        ++this.currentItem;
        if (this.fontsUsed.get(string) == null || pdfFont.isFontSubsetted()) {
            this.fonts.put(string, pdfFont.getGlyphData());
            this.fontsUsed.put(string, "x");
        }
    }

    public boolean hasObjectsBehind(float[][] fArray) {
        double d;
        boolean bl = false;
        double d2 = fArray[2][0];
        double d3 = fArray[2][1];
        double d4 = fArray[0][0];
        if (d4 == 0.0) {
            d4 = fArray[0][1];
        }
        if ((d = (double)fArray[1][1]) == 0.0) {
            d = fArray[1][0];
        }
        Rectangle[] rectangleArray = this.areas.get();
        int n = rectangleArray.length;
        for (int i = 0; i < n; ++i) {
            if (rectangleArray[i] == null) continue;
            if (d < 0.0) {
                d = (d3 += d) - d;
            }
            if (d4 < 0.0) {
                d4 = (d2 += d4) - d4;
            }
            Rectangle rectangle = rectangleArray[i];
            Rectangle rectangle2 = new Rectangle((int)d2, (int)d3, (int)d4, (int)d);
            if (d4 * d > (double)(rectangleArray[i].width * rectangleArray[i].height)) {
                rectangle = new Rectangle((int)d2, (int)d3, (int)d4, (int)d);
                rectangle2 = rectangleArray[i];
            }
            if (!rectangle2.intersects(rectangle) && !rectangle.contains(rectangle2)) continue;
            i = n;
            bl = true;
        }
        return bl;
    }

    public Rectangle getArea(int n) {
        return this.areas.elementAt(n);
    }

    public static boolean rectangleContains(Rectangle rectangle, int n, int n2, int n3) {
        int n4;
        int n5 = rectangle.x;
        int n6 = rectangle.x + rectangle.width;
        int n7 = rectangle.y;
        int n8 = rectangle.y + rectangle.height;
        boolean bl = false;
        if (n5 > n6) {
            n4 = n5;
            n5 = n6;
            n6 = n4;
        }
        if (n7 > n8) {
            n4 = n7;
            n7 = n8;
            n8 = n4;
        }
        if (n7 < n2 && n2 < n8 && n5 < n && n < n6) {
            bl = true;
        }
        return bl;
    }

    public int isInsideImage(int n, int n2) {
        int n3 = -1;
        Rectangle[] rectangleArray = this.areas.get();
        Rectangle rectangle = null;
        int n4 = rectangleArray.length;
        int[] nArray = this.objectType.get();
        for (int i = 0; i < n4; ++i) {
            if (rectangleArray[i] == null || !DynamicVectorRenderer.rectangleContains(rectangleArray[i], n, n2, i) || nArray[i] != 3) continue;
            if (rectangle != null) {
                int n5 = rectangleArray[i].height * rectangleArray[i].width;
                int n6 = rectangle.height * rectangle.width;
                if (n5 < n6) {
                    rectangle = rectangleArray[i];
                }
                n3 = i;
                continue;
            }
            rectangle = rectangleArray[i];
            n3 = i;
        }
        return n3;
    }

    public void setObjectStoreRef(ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
    }

    public void setType3Glyph(String string) {
        this.rawKey = string;
        this.isType3Font = true;
    }

    public void saveImage(int n, String string, String string2) {
        String string3 = (String)this.imageIDtoName.get(new Integer(n));
        BufferedImage bufferedImage = null;
        if (this.useHiResImageForDisplay) {
            bufferedImage = this.objectStoreRef.loadStoredImage(string3);
            if (bufferedImage == null) {
                bufferedImage = (BufferedImage)this.pageObjects.elementAt(n);
            }
        } else {
            bufferedImage = (BufferedImage)this.pageObjects.elementAt(n);
        }
        if (bufferedImage != null) {
            if (!this.optimisedTurnCode) {
                bufferedImage = DynamicVectorRenderer.invertImage(null, bufferedImage);
            }
            if ((bufferedImage.getType() == 0 || string2.equals("jpg") && bufferedImage.getType() == 2) && (bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage)).getType() == 0 && PdfDecoder.showErrorMessages) {
                JOptionPane.showMessageDialog(null, "This is a custom Image, Java's standard libraries may not be able to save the image as a jpg correctly.\nEnabling JAI will ensure correct output. \n\nFor information on how to do this please go to http://www.jpedal.org/flags.php");
            }
            if (this.needsHorizontalInvert) {
                bufferedImage = DynamicVectorRenderer.invertImageBeforeSave(bufferedImage, true);
            }
            if (this.needsVerticalInvert) {
                bufferedImage = DynamicVectorRenderer.invertImageBeforeSave(bufferedImage, false);
            }
            if (JAIHelper.isJAIused() && string2.toLowerCase().startsWith("tif")) {
                JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)string, (Object)string2);
            } else if (string2.toLowerCase().startsWith("tif")) {
                if (PdfDecoder.showErrorMessages) {
                    JOptionPane.showMessageDialog(null, "Please setup JAI library for Tiffs");
                }
                LogWriter.writeLog("Please setup JAI library for Tiffs");
            } else {
                try {
                    ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void setCustomImageHandler(ImageHandler imageHandler) {
        this.customImageHandler = imageHandler;
    }

    public void setCustomColorHandler(ColorHandler colorHandler) {
        this.customColorHandler = colorHandler;
    }

    public void flagDecodingFinished() {
        this.highlightsNeedToBeGenerated = true;
    }

    private void generateHighlights(Graphics2D graphics2D, int n, int[] nArray, Object[] objectArray, float f, float f2, float f3, float f4, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int[] nArray2, Rectangle[] rectangleArray) {
        int n2;
        this.highlightsNeedToBeGenerated = false;
        int[] nArray3 = new int[n];
        int n3 = -1;
        int n4 = 0;
        Rectangle rectangle = null;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        boolean[] blArray = new boolean[n];
        int[] nArray4 = new int[n];
        float[] fArray5 = new float[n];
        this.textHighlightsX = new int[n];
        int[] nArray5 = new int[n];
        this.textHighlightsWidth = new int[n];
        this.textHighlightsHeight = new int[n];
        int n5 = 0;
        int n6 = 1000;
        int n7 = 1000;
        int n8 = 1;
        int n9 = 1;
        double[] dArray5 = new double[6];
        graphics2D.getTransform().getMatrix(dArray5);
        int n10 = 0;
        if (dArray5[1] < 0.0 && dArray5[2] < 0.0) {
            n10 = 270;
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n11 = nArray[n2];
            if (n11 <= 0) continue;
            float f5 = this.x_coord[n2];
            float f6 = this.y_coord[n2];
            if (n9 < 0) {
                f5 += (float)n9;
            }
            Object object = null;
            object = objectArray[n2];
            if (n11 == 24) {
                rectangle = rectangleArray[n4];
                n6 = rectangle.height;
                n5 = rectangle.y;
                n7 = rectangle.width;
                ++n4;
                continue;
            }
            if (n11 == 21) {
                if ((n9 = nArray2[++n3]) < 0) {
                    n8 = -n9;
                    continue;
                }
                n8 = n9;
                continue;
            }
            if (n11 != 4 && n11 != 5 && n11 != 1) continue;
            float f7 = 1.0f;
            if (n11 == 4 || n11 == 5) {
                PdfGlyph pdfGlyph = (PdfGlyph)object;
                f7 = (float)n8 / 1000.0f;
                this.textHighlightsX[n2] = pdfGlyph.getFontBB(1);
                nArray5[n2] = n5;
                this.textHighlightsWidth[n2] = pdfGlyph.getFontBB(3);
                this.textHighlightsHeight[n2] = n6;
                blArray[n2] = true;
                if (n10 == 90) {
                    fArray2[n2] = -((float)nArray5[n2] * f7) + f5;
                    fArray3[n2] = (float)this.textHighlightsX[n2] * f7 + f6;
                } else if (n10 == 270) {
                    fArray2[n2] = (float)nArray5[n2] * f7 + f5;
                    fArray3[n2] = -((float)this.textHighlightsX[n2] * f7 + f6);
                } else {
                    fArray2[n2] = (float)nArray5[n2] * f7 + f6;
                    fArray3[n2] = (float)this.textHighlightsX[n2] * f7 + f5;
                }
                fArray[n2] = fArray2[n2] + (float)this.textHighlightsHeight[n2] * f7;
                fArray4[n2] = fArray3[n2] + (float)this.textHighlightsWidth[n2] * f7;
                fArray5[n2] = 10.0f;
                nArray4[n2] = n8;
            } else {
                f7 = 1.0f;
                float f8 = 1000.0f / (float)n8;
                this.textHighlightsX[n2] = (int)f5;
                nArray5[n2] = (int)(f6 + (float)n5 / f8);
                this.textHighlightsWidth[n2] = (int)((float)n7 / f8);
                this.textHighlightsHeight[n2] = (int)((float)(n6 - n5) / f8);
                if (n10 == 90) {
                    fArray2[n2] = -nArray5[n2];
                    fArray3[n2] = this.textHighlightsX[n2];
                } else if (n10 == 270) {
                    fArray2[n2] = nArray5[n2];
                    fArray3[n2] = -this.textHighlightsX[n2];
                } else {
                    fArray2[n2] = nArray5[n2];
                    fArray3[n2] = this.textHighlightsX[n2];
                }
                fArray[n2] = fArray2[n2] + (float)this.textHighlightsHeight[n2];
                fArray4[n2] = fArray3[n2] + (float)this.textHighlightsWidth[n2];
                fArray5[n2] = ((Area)object).getBounds().width;
                nArray4[n2] = n8;
            }
            nArray3[n2] = n2;
        }
        n2 = -31;
        for (int i = 0; i < n - 1; ++i) {
            int n12 = nArray3[i];
            if (n12 == n2) {
                System.out.println("*" + n12 + " = " + " left=" + fArray3[n12] + " bottom=" + fArray2[n12] + " right=" + fArray4[n12] + " top=" + fArray[n12]);
            }
            int n13 = 0;
            for (int j = i + 1; j < n; ++j) {
                boolean bl;
                int n14 = nArray3[j];
                if (blArray[n14] != blArray[n12] || fArray5[n14] < 1.0f) continue;
                if (n12 == n2) {
                    System.out.println("compare with=" + n14 + " left=" + fArray3[n14] + " right=" + fArray4[n14] + ' ' + (fArray3[n14] > fArray3[n12] && fArray3[n14] < fArray4[n12]));
                }
                if (!(fArray3[n14] > fArray3[n12] && fArray3[n14] < fArray4[n12]) && (!(fArray3[n14] > (fArray3[n12] + fArray4[n12]) / 2.0f) || !(fArray4[n12] < fArray4[n14]))) continue;
                int n15 = this.textHighlightsWidth[n12];
                int n16 = this.textHighlightsX[n12];
                if (blArray[n14]) {
                    float f9 = fArray3[n14] - fArray4[n12];
                    f9 = f9 > 0.0f ? (f9 += 0.5f) : (f9 += 0.5f);
                    n13 = (int)(f9 * 1000.0f / (float)nArray4[n12]);
                    if (this.textHighlightsX[n14] > 0) {
                        n13 += this.textHighlightsX[n14];
                    }
                } else {
                    n13 = (int)(fArray3[n14] - fArray4[n12]);
                }
                if (n12 == n2) {
                    System.out.println(fArray3[n14] - fArray4[n12] + " gap=" + n13 + ' ' + (fArray3[n14] - fArray4[n12]) * 1000.0f / (float)nArray4[n12] + " currentX=" + n16 + " scaling=" + this.scaling + ' ' + n7);
                }
                boolean bl2 = bl = n13 > 0 || n13 < 0 && fArray3[n12] < fArray3[n14] && fArray4[n12] > fArray3[n14] && fArray4[n12] < fArray4[n14] && fArray3[n12] < fArray4[n12] && (-n13 < nArray4[n12] && !blArray[n12] || -n13 < n7 && blArray[n12]);
                if (!(fArray2[n12] < fArray[n14]) || !(fArray2[n14] < fArray[n12]) || n13 <= 0 && !bl) continue;
                if (bl && (!blArray[n12] && n13 < nArray4[n12] && n15 + n13 < nArray4[n12] || blArray[n12] && n13 < n7)) {
                    if (n12 == n2) {
                        System.out.println(n14 + " = " + " left=" + fArray3[n14] + " bottom=" + fArray2[n14] + " right=" + fArray4[n14] + " top=" + fArray[n14]);
                    }
                    this.textHighlightsWidth[n12] = blArray[n12] ? (n13 > 0 ? n15 + n13 : n15 - n13) : (n13 > 0 ? n13 : n15 + n13);
                    if (n12 == n2) {
                        System.out.println("new=" + this.textHighlightsWidth[n12]);
                    }
                    j = n;
                    continue;
                }
                if (n13 <= n7) continue;
            }
        }
    }

    public void setPrintPage(int n) {
        this.pageNumber = n;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setOptimisedRotation(boolean bl) {
        this.optimisedTurnCode = bl;
    }

    public int getObjectUnderneath(int n, int n2) {
        int n3 = -1;
        Rectangle[] rectangleArray = this.areas.get();
        int n4 = rectangleArray.length;
        int[] nArray = this.objectType.get();
        boolean bl = true;
        for (int i = n4 - 1; i > -1; --i) {
            if (rectangleArray[i] == null || !DynamicVectorRenderer.rectangleContains(rectangleArray[i], n, n2, i) || nArray[i] == 2 || nArray[i] == 7) continue;
            bl = false;
            n3 = nArray[i];
            i = -1;
        }
        if (bl) {
            return -1;
        }
        return n3;
    }

    public void flagImageDeleted(int n) {
        this.objectType.setElementAt(27, n);
    }

    public void stopG2HintSetting(boolean bl) {
        this.stopG2setting = bl;
    }

    public void setOCR(boolean bl) {
        this.hasOCR = bl;
    }

    static {
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        invertHighlight = false;
        userAlerted = false;
    }
}

