/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;

public class ReadOnlyTextIcon
extends ImageIcon
implements Icon,
SwingConstants {
    private static final long serialVersionUID = 8946195842453749725L;
    private int iconWidth = -1;
    private int iconHeight = -1;
    private BufferedImage rootImage = null;
    private BufferedImage finalImage = null;
    private PdfObject fakeObj = null;
    private boolean textChanged = false;
    private String textStream1;
    private String textStream2;
    private String textStream3;
    private String text;
    private String fontName;
    private String fontSize;
    private String fontCommand;
    private String fullCommandString;
    private int iconRotation = 0;
    private int iconOpp = 180;
    private int pageRotate = 0;
    private boolean displaySingle = false;
    private PdfObjectReader currentpdffile = null;
    private int subtype;

    public ReadOnlyTextIcon(PdfObject pdfObject, int n, PdfObjectReader pdfObjectReader, int n2) {
        this.fakeObj = pdfObject;
        this.iconRotation = n;
        this.iconOpp = this.iconRotation - 180;
        if (this.iconOpp < 0) {
            this.iconOpp += 360;
        }
        this.currentpdffile = pdfObjectReader;
        this.subtype = n2;
    }

    public void setAttributes(int n, int n2, int n3, boolean bl) {
        int n4 = this.validateRotationValue(n3 - this.iconRotation);
        this.pageRotate = n3;
        if (n4 == this.iconRotation || n4 == this.iconOpp) {
            this.iconWidth = n;
            this.iconHeight = n2;
        } else {
            this.iconWidth = n2;
            this.iconHeight = n;
        }
        this.displaySingle = bl;
    }

    private int validateRotationValue(int n) {
        if ((n %= 360) < 0) {
            n += 360;
        }
        return n;
    }

    public int getIconHeight() {
        if (this.iconHeight == -1) {
            Image image = this.getImage();
            if (image == null) {
                return -1;
            }
            return image.getHeight(null);
        }
        return this.iconHeight;
    }

    public int getIconWidth() {
        if (this.iconWidth == -1) {
            Image image = this.getImage();
            if (image == null) {
                return -1;
            }
            return image.getWidth(null);
        }
        return this.iconWidth;
    }

    public Image getImage() {
        this.checkAndCreateimage();
        BufferedImage bufferedImage = this.finalImage;
        return bufferedImage;
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage = (BufferedImage)this.getImage();
        if (bufferedImage == null) {
            return;
        }
        if (component.isEnabled()) {
            graphics.setColor(component.getBackground());
        } else {
            graphics.setColor(Color.gray);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int n3 = this.iconWidth;
            int n4 = this.iconHeight;
            if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                n3 = this.iconHeight;
                n4 = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float f;
                float f2 = (float)n3 / (float)bufferedImage.getWidth(null);
                if (f2 < (f = (float)n4 / (float)bufferedImage.getHeight(null))) {
                    n3 = (int)(f2 * (float)bufferedImage.getWidth(null));
                    n4 = (int)(f2 * (float)bufferedImage.getHeight(null));
                } else {
                    n3 = (int)(f * (float)bufferedImage.getWidth(null));
                    n4 = (int)(f * (float)bufferedImage.getHeight(null));
                }
            }
            int n5 = 0;
            int n6 = 0;
            if (this.currentpdffile != null) {
                if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                    n5 = (this.iconHeight - n3) / 2;
                    n6 = (this.iconWidth - n4) / 2;
                } else {
                    n5 = (this.iconWidth - n3) / 2;
                    n6 = (this.iconHeight - n4) / 2;
                }
            }
            int n7 = 0;
            n7 = this.displaySingle ? this.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate;
            if (n7 == 270) {
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate(-n3, 0);
                graphics2D.drawImage(bufferedImage, -n5, n6, n3, n4, null);
            } else if (n7 == 90) {
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(0, -n4);
                graphics2D.drawImage(bufferedImage, n5, -n6, n3, n4, null);
            } else if (n7 == 180) {
                graphics2D.rotate(Math.PI);
                graphics2D.translate(-n3, -n4);
                graphics2D.drawImage(bufferedImage, -n5, -n6, n3, n4, null);
            } else {
                graphics2D.drawImage(bufferedImage, n5, n6, n3, n4, null);
            }
        } else {
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        graphics2D.translate(-n, -n2);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int n = this.iconWidth;
        int n2 = this.iconHeight;
        if (this.textChanged || this.rootImage == null || this.rootImage.getWidth(null) < n || this.rootImage.getHeight(null) < n2) {
            this.rootImage = FormStream.decode(this.currentpdffile, this.fakeObj, this.subtype, n, n2, 0, this.iconRotation);
            this.finalImage = FormStream.rotate(this.rootImage, this.iconRotation);
            this.textChanged = false;
        }
    }

    public void setCommandStrings(String string, String string2, String string3) {
        this.textStream1 = string;
        this.textStream2 = string2;
        this.textStream3 = string3;
    }

    public void setFont(String string, float f, String string2) {
        this.fontName = string;
        this.fontSize = string.length() != 0 ? " " + f + ' ' : "";
        this.fontCommand = string2;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.textChanged = true;
        this.text = "(" + string + ")Tj ";
        this.fullCommandString = this.textStream1 + this.fontName + this.fontSize + this.fontCommand + this.textStream2 + this.text + this.textStream3;
        this.fakeObj.setDecodedStream(this.fullCommandString.getBytes());
    }
}

