/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jpedal.constants.PDFflags;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.SetSecurity;
import org.jpedal.io.TextTokens;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.DecodeParmsObject;
import org.jpedal.objects.raw.EncryptionObject;
import org.jpedal.objects.raw.FDFObject;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.MetadataObject;
import org.jpedal.objects.raw.NamesObject;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ObjectCloneFactory;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfReader
extends PdfFilteredReader
implements PdfObjectReader,
Serializable {
    private int newCacheSize = -1;
    private static final boolean debugAES = false;
    private byte[] lastCompressedStream = null;
    private Vector_Int xref = new Vector_Int(100);
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private PdfObject compressedObj;
    private int lastFirst = -1;
    private int lastCompressedID = -1;
    private PdfObject encyptionObj = null;
    private final Map nameLookup = new HashMap();
    private PdfFileInformation currentFileInformation = new PdfFileInformation();
    private static final String pattern = "obj";
    private boolean extractionIsAllowed = true;
    private static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    private static final byte[] oldPattern = "xref".getBytes();
    private static final byte[] endObj = new byte[]{32, 111, 98, 106};
    private static final byte[] lengthString = new byte[]{47, 76, 101, 110, 103, 116, 104};
    private static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private boolean isEncrypted = false;
    private boolean isInitialised = false;
    private byte[] encryptionPassword = new byte[0];
    private PdfObject infoObject = null;
    private byte[] encryptionKey = null;
    private boolean isFileViewable = true;
    private int rev = 0;
    private int keyLength = 5;
    private int P = 0;
    private byte[] O = new byte[0];
    private byte[] U = new byte[0];
    private byte[] ID = null;
    private static final byte[] EOFpattern = new byte[]{37, 37, 69, 79, 70};
    private static final byte[] trailerpattern = new byte[]{116, 114, 97, 105, 108, 101, 114};
    private boolean isPasswordSupplied = false;
    private Cipher cipher = null;
    private static final String[] pad = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private int[] ObjLengthTable;
    private boolean refTableInvalid = false;
    private boolean isMetaDataEncypted = true;
    private PdfObject StmFObj;
    private PdfObject StrFObj;
    private boolean stringsEncoded = false;
    private int passwordStatus = 0;
    private Javascript javascript;
    private boolean isAESIdentity = false;
    private boolean isAES = false;
    private static boolean alwaysReinitCipher = false;
    private static final boolean debugFastCode = false;
    private String padding = "";
    private static final int[] powers;

    public PdfReader() {
    }

    public PdfReader(String string) {
        if (string == null) {
            string = "";
        }
        this.setEncryptionPassword(string);
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    private int readFirstStartRef() throws PdfException {
        int n;
        this.refTableInvalid = false;
        int n2 = -1;
        int n3 = 1019;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 1024;
        byte[] byArray = new byte[n4];
        int[] nArray = new int[]{37, 37, 69, 79};
        int n5 = 3;
        boolean bl = false;
        try {
            int n6;
            long l;
            block19: {
                l = this.eof;
                n = 255;
                do {
                    byte[] byArray2 = new byte[n];
                    this.movePointer(l - (long)n);
                    this.pdf_datafile.read(byArray2);
                    n6 = 0;
                    for (int i = n - 1; i > -1; --i) {
                        if (!bl) {
                            n5 = 3;
                        }
                        if (byArray2[i] == nArray[n5]) {
                            --n5;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        --n6;
                        if (n5 >= 0) continue;
                        i = -1;
                    }
                    if (n5 >= 0) continue;
                    l -= (long)n6;
                    break block19;
                } while ((l -= (long)n) >= 0L);
                l = this.eof;
            }
            int n7 = (int)(l - (long)n4);
            if (n7 < 0) {
                n7 = 0;
                n6 = (int)this.eof;
                byArray = new byte[n6];
                n3 = n6 + 3;
            }
            this.movePointer(n7);
            this.pdf_datafile.read(byArray);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading last 1024 bytes");
            throw new PdfException(exception + " reading last 1024 bytes");
        }
        n = byArray.length;
        if (n3 > n) {
            n3 = n - 5;
        }
        while (n3 > -1 && (byArray[n3] != 116 || byArray[n3 + 1] != 120 || byArray[n3 + 2] != 114 || byArray[n3 + 3] != 101 || byArray[n3 + 4] != 102)) {
            --n3;
        }
        if (n3 == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        n3 += 5;
        while (n3 < 1024 && (byArray[n3] == 10 || byArray[n3] == 32 || byArray[n3] == 13)) {
            ++n3;
        }
        while (n3 < 1024 && byArray[n3] != 10 && byArray[n3] != 32 && byArray[n3] != 13) {
            stringBuffer.append((char)byArray[n3]);
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            n2 = Integer.parseInt(stringBuffer.toString());
        }
        if (n2 == -1) {
            LogWriter.writeLog("No Startref found in last 1024 bytes ");
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return n2;
    }

    public void setEncryptionPassword(String string) {
        this.encryptionPassword = string.getBytes();
        this.cipher = null;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readObjectData(int n, PdfObject pdfObject) {
        byte[] byArray;
        int n2;
        if (this.pdf_datafile == null) {
            return new byte[0];
        }
        int n3 = -1;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        long l = -1L;
        if (pdfObject != null) {
            n3 = this.newCacheSize;
        }
        int n5 = n;
        int n6 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n < 1) {
            n = 128;
        }
        if (n3 != -1 && n > n3) {
            n = n3;
        }
        int n7 = 0;
        int n8 = n;
        byte[] byArray2 = new byte[n8];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        boolean bl5 = false;
        long l2 = -1L;
        long l3 = -1L;
        int n12 = n - 1;
        int n13 = -n;
        int n14 = 0;
        int n15 = -1;
        int n16 = -1;
        while (true) {
            void var30_29;
            if (++n12 == n) {
                if (n14 == 1) {
                    byArray4 = byArray3;
                } else if (n14 > 1) {
                    n2 = byArray4.length;
                    int n17 = byArray3.length;
                    byte[] byArray5 = new byte[n2 + n17];
                    System.arraycopy(byArray4, 0, byArray5, 0, n2);
                    System.arraycopy(byArray3, 0, byArray5, n2, n17);
                    byArray4 = byArray5;
                }
                if (bl4 && bl2) break;
                ++n14;
                long l4 = this.getPointer();
                if (l == -1L) {
                    l = l4;
                }
                if (l4 + (long)n > this.eof) {
                    n = (int)(this.eof - l4);
                }
                byArray3 = new byte[n += 6];
                try {
                    this.pdf_datafile.read(byArray3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (n14 == 1) {
                    int n18 = 0;
                    while (byArray3[n18] == 101 || byArray3[n18] == 110 || byArray3[n18] == 100 || byArray3[n18] == 111 || byArray3[n18] == 98 || byArray3[n18] == 106) {
                        ++n18;
                    }
                    if (n18 > 0) {
                        byte[] byArray6 = byArray3;
                        int n19 = byArray3.length - n18;
                        byArray3 = new byte[n19];
                        System.arraycopy(byArray6, n18, byArray3, 0, n19);
                    }
                }
                n13 += n12;
                n12 = 0;
            }
            if ((var30_29 = byArray3[n12]) == 37) {
                n16 = n6;
            }
            n9 = var30_29 == endPattern[n9] && !bl5 ? ++n9 : 0;
            n10 = bl4 && var30_29 == endObj[n10] && !bl5 ? ++n10 : 0;
            if (n3 != -1 && !bl2) {
                n4 = n4 < 6 && var30_29 == startStream[n4] ? ++n4 : 0;
                if (!bl && n4 == 6) {
                    bl = true;
                }
                if (bl && (byArray3 != null && byArray3.length > n3 || byArray4 != null && byArray4.length > n3)) {
                    pdfObject.setCache(l, this);
                    bl2 = true;
                }
            }
            if (!bl3 && n5 != -1) {
                if (!bl4 && var30_29 == lengthString[n11] && !bl5) {
                    if (++n11 == 6) {
                        bl3 = true;
                    }
                } else {
                    n11 = 0;
                }
            }
            if (n9 == 6 || n10 == 4) {
                if (!bl3) break;
                n9 = 0;
                n10 = 0;
                n15 = n6;
            }
            if (bl3 && n6 >= n5) break;
            if (!bl5) {
                byArray2[n7] = var30_29;
                if (++n7 == n8) {
                    n8 = n8 < 0x200000 ? (n8 *= 2) : (n8 += 100000);
                    byte[] byArray7 = new byte[n8];
                    System.arraycopy(byArray2, 0, byArray7, 0, byArray2.length);
                    byArray2 = byArray7;
                }
            }
            ++n6;
        }
        if (n14 == 1) {
            byArray = new byte[n12];
            System.arraycopy(byArray3, 0, byArray, 0, n12);
        } else {
            n2 = byArray4.length;
            byArray = new byte[n2 + n12];
            System.arraycopy(byArray4, 0, byArray, 0, n2);
            System.arraycopy(byArray3, 0, byArray, n2, n12);
        }
        if (bl3 && n15 != -1 && n16 != -1 && n16 > n15) {
            byte[] byArray8 = new byte[n15];
            System.arraycopy(byArray, 0, byArray8, 0, n15);
            byArray = byArray8;
        }
        if (!bl3) {
            byArray = PdfReader.checkEndObject(byArray, l3, l2);
        }
        return byArray;
    }

    public void spoolStreamDataToDisk(File file, long l) throws Exception {
        this.movePointer(l);
        boolean bl = false;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int n = -1;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = n;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n < 1) {
            n = 128;
        }
        int n5 = 0;
        int n6 = n;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        byte[] byArray2 = null;
        boolean bl5 = false;
        try {
            int n10 = n - 1;
            int n11 = -n;
            int n12 = 0;
            while (true) {
                if (++n10 == n) {
                    ++n12;
                    long l2 = this.getPointer();
                    if (l == -1L) {
                        l = l2;
                    }
                    if (l2 + (long)n > this.eof) {
                        n = (int)(this.eof - l2);
                    }
                    byArray2 = new byte[n += 6];
                    this.pdf_datafile.read(byArray2);
                    n11 += n10;
                    n10 = 0;
                }
                void var26_25 = byArray2[n10];
                boolean bl6 = false;
                n7 = var26_25 == endPattern[n7] && !bl5 ? ++n7 : 0;
                n8 = bl4 && var26_25 == endObj[n8] && !bl5 ? ++n8 : 0;
                if (bl2 && (bl || var26_25 != 13 && var26_25 != 10)) {
                    bufferedOutputStream.write((int)var26_25);
                    bl = true;
                }
                n2 = n2 < 6 && var26_25 == startStream[n2] ? ++n2 : 0;
                if (!bl2 && n2 == 6) {
                    bl2 = true;
                }
                if (!bl3 && n3 != -1) {
                    if (!bl4 && var26_25 == lengthString[n9] && !bl5) {
                        if (++n9 == 6) {
                            bl3 = true;
                        }
                    } else {
                        n9 = 0;
                    }
                }
                if (n7 == 6 || n8 == 4) {
                    if (!bl3) break;
                    n7 = 0;
                    n8 = 0;
                }
                if (!bl3 || n4 < n3) {
                    if (!bl6 && !bl5) {
                        byArray[n5] = var26_25;
                        if (++n5 == n6) {
                            n6 = n6 < 0x200000 ? (n6 *= 2) : (n6 += 100000);
                            byte[] byArray3 = new byte[n6];
                            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                            byArray = byArray3;
                        }
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWriter.writeLog("Exception " + exception + " reading object");
        }
        if (bufferedOutputStream != null) {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    private static byte[] checkEndObject(byte[] byArray, long l, long l2) {
        int n = 0;
        for (int i = 0; i < byArray.length - 8; ++i) {
            if (n < 2 && byArray[i] == 32 && byArray[i + 1] == 111 && byArray[i + 2] == 98 && byArray[i + 3] == 106) {
                ++n;
                l = i;
            }
            if (n >= 2 || byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
            l2 = i + 9;
        }
        if (l2 > 0L && l > l2) {
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
            byArray = byArray2;
        }
        return byArray;
    }

    public int readDictionaryAsObject(PdfObject pdfObject, String string, int n, byte[] byArray, int n2, boolean bl) {
        int n3 = 0;
        int n4 = byArray.length;
        if (bl) {
            n3 = 1;
        }
        while (n < n4) {
            if (byArray[n] == 37) {
                while (n < n4 && byArray[n] != 10 && byArray[n] != 13) {
                    ++n;
                }
                while (n < n4 && (byArray[n] == 9 || byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 60)) {
                    ++n;
                }
            } else if (byArray[n] == 115 && byArray[n + 1] == 116 && byArray[n + 2] == 114 && byArray[n + 3] == 101 && byArray[n + 4] == 97 && byArray[n + 5] == 109) break;
            if (n >= n4 || n2 != -1 && n >= n2 || byArray[n] == 101 && byArray[n + 1] == 110 && byArray[n + 2] == 100 && byArray[n + 3] == 111) break;
            if (byArray[n] == 60 && byArray[n + 1] == 60) {
                ++n;
                ++n3;
            } else if (byArray[n] == 62 && n + 1 != n4 && byArray[n + 1] == 62) {
                ++n;
                if (--n3 == 0) {
                    break;
                }
            } else if (byArray[n] == 47 && (byArray[n + 1] == 47 || byArray[n + 1] == 32)) {
                ++n;
            } else if (byArray[n] == 47) {
                boolean bl2;
                int n5;
                Object object;
                int n6;
                int n7;
                int n8;
                int n9 = 0;
                int n10 = ++n;
                while (byArray[n] != 32 && byArray[n] != 13 && byArray[n] != 9 && byArray[n] != 10 && byArray[n] != 91 && byArray[n] != 47 && byArray[n] != 40 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n9;
                    if (++n != n4) continue;
                }
                if (n == n4) break;
                int n11 = pdfObject.getObjectType();
                boolean bl3 = false;
                if (pdfObject.getID() == 1184787) {
                    n8 = byArray.length;
                    for (n7 = n; n7 < n8; ++n7) {
                        if (byArray[n7] == 40) {
                            n7 = n8;
                            bl3 = true;
                            continue;
                        }
                        if (byArray[n7] == 47 || byArray[n7] == 62 || byArray[n7] == 60 || byArray[n7] == 91 || byArray[n7] == 82) {
                            n7 = n8;
                            continue;
                        }
                        if (byArray[n7] != 77 || byArray[n7 + 1] != 67 || byArray[n7 + 2] != 73 || byArray[n7 + 3] != 68) continue;
                        n7 = n8;
                    }
                }
                if (n11 == 487790868 && (pdfObject.getID() == 893350012 || pdfObject.getID() == 1184787 && bl3 || pdfObject.getID() == 17 && byArray[n - 2] == 47)) {
                    n6 = 30;
                    object = PdfDictionary.getKey(n10, n9, byArray);
                    n5 = 487790868;
                    bl2 = true;
                } else {
                    bl2 = false;
                    object = null;
                    n5 = PdfDictionary.getIntKey(n10, n9, byArray);
                    if (n5 == 895578984 && (n11 == 7451 || n11 == 373244477 || n11 == 2004845231)) {
                        n5 = 25;
                    }
                    if (bl) {
                        n5 = PdfObjectFactory.getInlineID(n5);
                    }
                    if (n11 == 2004251818 && (n5 == 2087749783 || n5 == -1938465939 || n5 == 878474856 || n5 == 979194486 || n5 == 373243460 || n5 == 1146450818)) {
                        n6 = 2;
                    } else if (n11 == 1485011327 && n5 == 20) {
                        n5 = 339034948;
                        n6 = 18;
                    } else if ((n11 == 373244477 || n11 == 7451) && n5 == 20) {
                        if (pdfObject.getID() == 4384 || pdfObject.getID() == 4369) {
                            n6 = 40;
                        } else if (pdfObject.getID() == 2570558) {
                            n6 = 25;
                        } else {
                            n5 = 339034948;
                            n6 = 18;
                        }
                    } else {
                        n6 = !(n11 != 373244477 && n11 != 7451 || pdfObject.getID() != 4384 && pdfObject.getID() != 4369 || n5 != 17) ? 40 : (n5 == 1110717793 && n11 == -1567847737 ? 22 : (n5 == 506543413 && n11 == -1567847737 ? 25 : ((n11 == 2087749783 || n11 == 1518239089) && n5 == 30 ? 7 : (n5 == 826096968 && n11 == 2087749783 && pdfObject.getParameterConstant(2087749783) == 391471749 ? 7 : (pdfObject.getID() == 2570558 && pdfObject.getObjectType() == 373244477 && (n5 == 32 || n5 == 31) ? 25 : (bl && n5 == 2087749783 ? 1 : PdfDictionary.getKeyType(n5, n11)))))));
                    }
                    n6 = PdfReader.getPairedValues(pdfObject, n, byArray, n6, n4, n9, n10);
                    if (n5 == 1888135062) {
                        for (n8 = n; n8 < n4 && (byArray[n8] == 32 || byArray[n8] == 9 || byArray[n8] == 13 || byArray[n8] == 10); ++n8) {
                        }
                        if (byArray[n8] != 60) {
                            while (n8 < n4 && (byArray[n8] == 32 || byArray[n8] == 9 || byArray[n8] == 13 || byArray[n8] == 10 || byArray[n8] == 91)) {
                                ++n8;
                            }
                            if (byArray[n8] == 60) {
                                n6 = 22;
                            }
                        }
                    }
                }
                if (byArray[n] == 47 || byArray[n] == 40 || byArray[n] == 91) {
                    --n;
                }
                if (n6 == -1) {
                    n = PdfReader.handleUnknownType(n, byArray, n4);
                }
                if (n5 != -1 && n6 != -1) {
                    n8 = pdfObject.ignoreRecursion() ? 1 : 0;
                    if (n6 == 5 && pdfObject.isDataExternal()) {
                        n6 = 1;
                    }
                    switch (n6) {
                        case 25: {
                            n = this.setTextStreamValue(pdfObject, string, n, byArray, n5, n8 != 0);
                            break;
                        }
                        case 35: {
                            int n12;
                            int n13;
                            int n14;
                            n7 = 0;
                            while (byArray[n] != 91) {
                                if (byArray[n] == 40) {
                                    n7 = 0;
                                    break;
                                }
                                if (byArray[n] >= 48 && byArray[n] <= 57) {
                                    n7 = 1;
                                    break;
                                }
                                ++n;
                            }
                            byte[] byArray2 = byArray;
                            int n15 = n;
                            int n16 = n;
                            int n17 = 0;
                            if (n7 != 0) {
                                n14 = n;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                }
                                n13 = PdfReader.parseInt(n14, n, byArray);
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                n14 = n;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                }
                                n12 = PdfReader.parseInt(n14, n, byArray);
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                if (byArray[n] != 82) {
                                    throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
                                }
                                if (n8 == 0) {
                                    byArray2 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n13, n12), n13, n12);
                                    if (byArray2 == null) {
                                        pdfObject.setFullyResolved(false);
                                        LogWriter.writeLog("[Linearized] " + string + " not yet available (1)");
                                        n = n4;
                                        break;
                                    }
                                    n16 = 3;
                                    while (byArray2[n16 - 1] != 106 && byArray2[n16 - 2] != 98 && byArray2[n16 - 3] != 111) {
                                        ++n16;
                                    }
                                    while (byArray2[n16] == 10 || byArray2[n16] == 13 || byArray2[n16] == 32) {
                                        ++n16;
                                    }
                                    n15 = n16;
                                }
                            }
                            while (n16 < byArray2.length) {
                                if (byArray2[n16] == 91 || byArray2[n16] == 40) {
                                    ++n17;
                                } else if (byArray2[n16] == 93 || byArray2[n16] == 41) {
                                    --n17;
                                }
                                if (n17 == 0) break;
                                ++n16;
                            }
                            if (n8 == 0) {
                                n14 = n16 - n15 + 1;
                                byte[] byArray3 = new byte[n14];
                                System.arraycopy(byArray2, n15, byArray3, 0, n14);
                                if (pdfObject.getObjectType() != 1113489015) {
                                    try {
                                        byArray3 = this.decrypt(byArray3, string, false, null, false, false);
                                    }
                                    catch (PdfSecurityException pdfSecurityException) {
                                        pdfSecurityException.printStackTrace();
                                    }
                                }
                                pdfObject.setTextStreamValue(n5, byArray3);
                            }
                            if (n7 != 0) break;
                            n = n16;
                            break;
                        }
                        case 2: {
                            boolean bl4;
                            int n14;
                            int n17;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            byte[] byArray4 = byArray;
                            int n18 = n;
                            boolean bl5 = bl4 = byArray4[n18] != 60;
                            if (bl4) {
                                int n19 = n;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                }
                                n17 = PdfReader.parseInt(n19, n, byArray);
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                n19 = n;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                }
                                n14 = PdfReader.parseInt(n19, n, byArray);
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                if (byArray[n] != 82) {
                                    throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
                                }
                                if (n8 == 0) {
                                    byArray4 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n17, n14), n17, n14);
                                    if (byArray4 == null) {
                                        pdfObject.setFullyResolved(false);
                                        LogWriter.writeLog("[Linearized] " + string + " not yet available (2)");
                                        n = n4;
                                        break;
                                    }
                                    n18 = 3;
                                    while (byArray4[n18 - 1] != 106 && byArray4[n18 - 2] != 98 && byArray4[n18 - 3] != 111) {
                                        if (byArray4[n18] == 47) {
                                            n18 = 0;
                                            break;
                                        }
                                        if (++n18 != byArray4.length) continue;
                                        n18 = 0;
                                        break;
                                    }
                                    while (byArray4[n18] == 10 || byArray4[n18] == 13 || byArray4[n18] == 32) {
                                        ++n18;
                                    }
                                }
                            }
                            PdfObject pdfObject2 = ObjectFactory.createObject(n5, string, pdfObject.getObjectType(), pdfObject.getID());
                            pdfObject2.setID(n5);
                            if (n8 != 0) {
                                n18 = this.readKeyPairs(n5, byArray4, n18, -2, null, this.padding);
                            } else {
                                n17 = this.readKeyPairs(n5, byArray4, n18, -1, null, this.padding);
                                n18 = this.readKeyPairs(n5, byArray4, n18, n17, pdfObject2, this.padding);
                                pdfObject.setDictionary(n5, pdfObject2);
                            }
                            if (bl4) break;
                            n = n18;
                            break;
                        }
                        case 20: {
                            n = this.readArray(n8 != 0, n, n2, 20, byArray, string, pdfObject, n5, null, -1);
                            break;
                        }
                        case 12: {
                            n = this.readArray(false, n, n2, 12, byArray, string, pdfObject, n5, null, -1);
                            break;
                        }
                        case 14: {
                            n = this.readArray(n8 != 0, n, n2, 14, byArray, string, pdfObject, n5, null, -1);
                            break;
                        }
                        case 18: {
                            n = this.readArray(n8 != 0, n, n2, 18, byArray, string, pdfObject, n5, null, -1);
                            break;
                        }
                        case 22: {
                            n = this.readArray(false, n, n2, 22, byArray, string, pdfObject, n5, null, -1);
                            break;
                        }
                        case 16: {
                            n = this.readArray(false, n, n2, 16, byArray, string, pdfObject, n5, null, -1);
                            break;
                        }
                        case 9: {
                            n = this.readArray(false, n, n2, 9, byArray, string, pdfObject, n5, null, -1);
                            break;
                        }
                        case 10: {
                            n = this.readArray(false, n, n2, 10, byArray, string, pdfObject, n5, null, -1);
                            break;
                        }
                        case 30: {
                            n = this.readNameString(pdfObject, string, n, byArray, n5, bl2, object);
                            break;
                        }
                        case 8: {
                            n = this.setBooleanValue(pdfObject, n, byArray, object, n5);
                            break;
                        }
                        case 3: {
                            n = this.setStringConstantValue(pdfObject, n, byArray, n5);
                            break;
                        }
                        case 4: {
                            ++n;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            n10 = n;
                            n9 = 1;
                            n7 = 0;
                            while (byArray[n] != 82 && n7 == 0) {
                                if (n5 == 1110793845 && byArray[n] == 110 && byArray[n + 1] == 117 && byArray[n + 2] == 108 && byArray[n + 3] == 108) {
                                    n7 = 1;
                                }
                                ++n;
                                ++n9;
                            }
                            --n;
                            if (n7 != 0) break;
                            byte[] byArray5 = new byte[n9];
                            System.arraycopy(byArray, n10, byArray5, 0, n9);
                            pdfObject.setStringKey(n5, byArray5);
                            break;
                        }
                        case 6: {
                            ++n;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            n = this.readNumber(pdfObject, string, n, byArray, n5, object);
                            break;
                        }
                        case 7: {
                            int n20;
                            int n14;
                            int n17;
                            ++n;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                                ++n;
                            }
                            n10 = n;
                            n9 = 0;
                            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                ++n;
                                ++n9;
                            }
                            float f = PdfReader.parseFloat(n10, n, byArray);
                            for (n20 = n; n20 < n4 && (byArray[n20] == 32 || byArray[n20] == 13 || byArray[n20] == 10); ++n20) {
                            }
                            if (byArray[n20] >= 48 && byArray[n20] <= 57) {
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                n10 = n;
                                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                    ++n;
                                }
                                int n21 = PdfReader.parseInt(n10, n, byArray);
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                    ++n;
                                }
                                if (byArray[n] != 82) {
                                    throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
                                }
                                byte[] byArray6 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed((int)f, n21), (int)f, n21);
                                if (byArray6 == null) {
                                    pdfObject.setFullyResolved(false);
                                    LogWriter.writeLog("[Linearized] " + string + " not yet available (3)");
                                    n = n4;
                                    break;
                                }
                                n17 = 3;
                                while (byArray6[n17 - 1] != 106 && byArray6[n17 - 2] != 98 && byArray6[n17 - 3] != 111) {
                                    ++n17;
                                }
                                while (byArray6[n17] == 10 || byArray6[n17] == 13 || byArray6[n17] == 32) {
                                    ++n17;
                                }
                                n14 = n17;
                                while (byArray6[n14] != 10 && byArray6[n14] != 13 && byArray6[n14] != 32) {
                                    ++n14;
                                }
                                f = PdfReader.parseFloat(n17, n14, byArray6);
                            }
                            pdfObject.setFloatNumber(n5, f);
                            --n;
                            break;
                        }
                        case 5: {
                            n = PdfReader.getUnreadDictionary(pdfObject, string, n, byArray, bl, n5);
                            break;
                        }
                        case 40: {
                            int n22;
                            int n12;
                            if (byArray[n] != 60) {
                                ++n;
                            }
                            if (byArray[n] == 47) {
                                n = this.readNameString(pdfObject, string, n, byArray, n5, bl2, object);
                                break;
                            }
                            if (byArray[n] == 102 && byArray[n + 1] == 97 && byArray[n + 2] == 108 && byArray[n + 3] == 115 && byArray[n + 4] == 101) {
                                pdfObject.setBoolean(n5, false);
                                n += 4;
                                break;
                            }
                            if (byArray[n] == 116 && byArray[n + 1] == 114 && byArray[n + 2] == 117 && byArray[n + 3] == 101) {
                                pdfObject.setBoolean(n5, true);
                                n += 3;
                                break;
                            }
                            if (byArray[n] == 40 || byArray[n] == 60 && byArray[n - 1] != 60 && byArray[n + 1] != 60) {
                                n = this.readTextStream(pdfObject, string, n, byArray, n5, n8 != 0);
                                break;
                            }
                            if (byArray[n] == 91) {
                                if (n5 == 2627089) {
                                    n = this.readArray(n8 != 0, n, n2, 18, byArray, string, pdfObject, n5, null, -1);
                                    break;
                                }
                                if (n5 == 27) {
                                    n = this.readArray(n8 != 0, n, n2, 20, byArray, string, pdfObject, n5, null, -1);
                                    break;
                                }
                                if (n5 == 19) {
                                    n = this.readArray(n8 != 0, n, n2, 10, byArray, string, pdfObject, n5, null, -1);
                                    break;
                                }
                                n = this.readArray(n8 != 0, n, n2, 20, byArray, string, pdfObject, n5, null, -1);
                                break;
                            }
                            n7 = n;
                            int n23 = n + 1;
                            byte[] byArray7 = byArray;
                            int n24 = 0;
                            int n17 = 1;
                            int n14 = 0;
                            int n13 = 0;
                            do {
                                if (byArray7[n23] == 82 && n13 == 0) {
                                    n14 = 1;
                                    n12 = n23;
                                    n23 = n;
                                    n = n12;
                                    while (byArray7[n23] == 91 || byArray7[n23] == 32 || byArray7[n23] == 13 || byArray7[n23] == 10) {
                                        ++n23;
                                    }
                                    n10 = n23;
                                    int n25 = n23;
                                    while (byArray7[n23] != 10 && byArray7[n23] != 13 && byArray7[n23] != 32 && byArray7[n23] != 47 && byArray7[n23] != 60 && byArray7[n23] != 62) {
                                        ++n23;
                                    }
                                    n22 = PdfReader.parseInt(n10, n23, byArray7);
                                    while (byArray7[n23] == 10 || byArray7[n23] == 13 || byArray7[n23] == 32) {
                                        ++n23;
                                    }
                                    n10 = n23;
                                    while (byArray7[n23] != 10 && byArray7[n23] != 13 && byArray7[n23] != 32 && byArray7[n23] != 47 && byArray7[n23] != 60 && byArray7[n23] != 62) {
                                        ++n23;
                                    }
                                    int n26 = PdfReader.parseInt(n10, n23, byArray7);
                                    while (byArray7[n23] == 10 || byArray7[n23] == 13 || byArray7[n23] == 32 || byArray7[n23] == 47 || byArray7[n23] == 60) {
                                        ++n23;
                                    }
                                    if (byArray7[n23] != 82) {
                                        throw new RuntimeException("ref=" + n22 + " gen=" + n22 + " 1. Unexpected value " + byArray7[n23] + " in file - please send to IDRsolutions for analysis char=" + (char)byArray7[n23]);
                                    }
                                    string = new String(byArray7, n25, 1 + n23 - n25);
                                    byte[] byArray8 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n22, n26), n22, n26);
                                    int n27 = n13 = byArray8[0] == 40 ? 1 : 0;
                                    if (pdfObject.getID() == 4369 && byArray8[0] == 60 && byArray8[1] == 60) {
                                        PdfObject pdfObject3 = ObjectFactory.createObject(n5, string, pdfObject.getObjectType(), pdfObject.getID());
                                        pdfObject3.setID(n5);
                                        pdfObject.setDictionary(n5, pdfObject3);
                                        pdfObject3.setStatus(2);
                                        pdfObject3.setUnresolvedData(byArray8, 2);
                                        n17 = 0;
                                        n24 = 4;
                                        n = n23;
                                        break;
                                    }
                                    byArray7 = byArray8;
                                    if (byArray7 == null) {
                                        pdfObject.setFullyResolved(false);
                                        LogWriter.writeLog("[Linearized] " + string + " not yet available (4)");
                                        n = n4;
                                        break;
                                    }
                                    n7 = 3;
                                    if (byArray7.length < 3) {
                                        n7 = 0;
                                    } else {
                                        while (byArray7[n7 - 2] != 111 || byArray7[n7 - 1] != 98 || byArray7[n7] != 106) {
                                            if (++n7 != byArray7.length) continue;
                                            n7 = 0;
                                            break;
                                        }
                                    }
                                    if (byArray7[n7] != 40) {
                                        ++n7;
                                    }
                                    while (byArray7[n7] == 10 || byArray7[n7] == 13 || byArray7[n7] == 32) {
                                        ++n7;
                                    }
                                    n23 = n7;
                                    continue;
                                }
                                if (byArray7[n23] == 91 || byArray7[n23] == 40) break;
                                if (byArray7[n23] == 60) {
                                    n24 = 0;
                                    break;
                                }
                                if (byArray7[n23] == 62 || byArray7[n23] == 47) {
                                    n24 = 1;
                                    break;
                                }
                                if (byArray7[n23] == 32 || byArray7[n23] == 10 || byArray7[n23] == 13 || byArray7[n23] >= 48 && byArray7[n23] <= 57 || byArray7[n23] == 46) continue;
                                n17 = 0;
                            } while (++n23 != byArray7.length);
                            n12 = 0;
                            for (n22 = n7 + 1; n22 < byArray7.length; ++n22) {
                                if (byArray7[n22] != 47) continue;
                                ++n12;
                            }
                            while (byArray7[n7] == 10 || byArray7[n7] == 13 || byArray7[n7] == 32) {
                                ++n7;
                            }
                            if (n24 != 4) {
                                if (n12 == 0 && byArray7[n7] == 47) {
                                    n7 = this.readNameString(pdfObject, string, n7, byArray7, n5, bl2, object);
                                } else if (byArray7[n7] == 40) {
                                    n7 = this.readTextStream(pdfObject, string, n7, byArray7, n5, n8 != 0);
                                } else if (byArray7[n7] == 91) {
                                    n7 = this.readArray(n8 != 0, n7, n2, 20, byArray7, string, pdfObject, n5, null, -1);
                                } else if (n24 == 0) {
                                    try {
                                        n7 = this.readDictionaryFromRefOrDirect(-1, pdfObject, string, n7, byArray7, n5);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                } else if (n17 != 0) {
                                    n7 = this.readNumber(pdfObject, string, n7, byArray7, n5, object);
                                } else if (n24 == 1) {
                                    n7 = this.readNameString(pdfObject, string, n7, byArray7, n5, bl2, object);
                                }
                            }
                            if (n14 != 0) break;
                            n = n7;
                            break;
                        }
                        case 1: {
                            boolean bl6;
                            n7 = n;
                            if (byArray[n] != 60 && byArray[n + 1] != 60) {
                                n7 += 2;
                            }
                            boolean bl7 = true;
                            boolean bl8 = bl6 = byArray[n7 - 1] == 47;
                            while (bl7) {
                                if (byArray[n7] == 60 && byArray[n7 + 1] == 60) {
                                    int n28 = 1;
                                    ++n7;
                                    while (n28 > 0) {
                                        if (byArray[n7] == 60 && byArray[n7 + 1] == 60) {
                                            ++n28;
                                            n7 += 2;
                                            continue;
                                        }
                                        if (byArray[n7 - 1] == 62 && byArray[n7] == 62) {
                                            if (--n28 <= 0) continue;
                                            n7 += 2;
                                            continue;
                                        }
                                        ++n7;
                                    }
                                    bl7 = false;
                                    continue;
                                }
                                if (byArray[n7] == 82) {
                                    bl7 = false;
                                    continue;
                                }
                                if (bl6 && (byArray[n7] == 32 || byArray[n7] == 13 || byArray[n7] == 10 || byArray[n7] == 9)) {
                                    bl7 = false;
                                    continue;
                                }
                                if (byArray[n7] == 47) {
                                    bl7 = false;
                                    --n7;
                                    continue;
                                }
                                if (byArray[n7] == 62 && byArray[n7 + 1] == 62) {
                                    bl7 = false;
                                    --n7;
                                    continue;
                                }
                                ++n7;
                            }
                            n = this.readDictionary(pdfObject, string, n, byArray, this.padding, bl, n5, n8 != 0);
                            n = n7;
                            break;
                        }
                    }
                }
            }
            ++n;
        }
        if (!pdfObject.ignoreStream()) {
            this.readStreamData(pdfObject, n, byArray, n4);
        }
        if (pdfObject.getObjectType() == 373244477) {
            this.setFieldNames(pdfObject);
        }
        return n;
    }

    private int setStringConstantValue(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        ++n;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
            ++n;
        }
        int n3 = n;
        int n4 = 0;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
            ++n;
            ++n4;
        }
        int n5 = pdfObject.setConstant(n2, n3, n4, byArray);
        return --n;
    }

    private int setBooleanValue(PdfObject pdfObject, int n, byte[] byArray, Object object, int n2) {
        ++n;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
            ++n;
        }
        int n3 = n;
        int n4 = 0;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
            ++n;
            ++n4;
        }
        --n;
        if (byArray[n3] == 116 && byArray[n3 + 1] == 114 && byArray[n3 + 2] == 117 && byArray[n3 + 3] == 101) {
            pdfObject.setBoolean(n2, true);
        } else if (byArray[n3] == 102 && byArray[n3 + 1] == 97 && byArray[n3 + 2] == 108 && byArray[n3 + 3] == 115 && byArray[n3 + 4] == 101) {
            pdfObject.setBoolean(n2, false);
        } else {
            throw new RuntimeException("Unexpected value for Boolean value for" + n2 + "=" + object);
        }
        return n;
    }

    private int setTextStreamValue(PdfObject pdfObject, String string, int n, byte[] byArray, int n2, boolean bl) {
        if (byArray[n + 1] == 40 && byArray[n + 2] == 41) {
            pdfObject.setTextStreamValue(n2, new byte[1]);
            if (byArray[n += 3] == 47) {
                --n;
            }
        } else {
            n = this.readTextStream(pdfObject, string, n, byArray, n2, bl);
        }
        return n;
    }

    private static int handleUnknownType(int n, byte[] byArray, int n2) {
        int n3 = n2 - 1;
        for (int i = n; i < n3; ++i) {
            if (byArray[i] == 82 && byArray[i - 2] == 48) {
                n = i;
                i = n3;
                continue;
            }
            if (byArray[i] == 60 && byArray[i + 1] == 60) {
                int n4 = 0;
                do {
                    if (byArray[i] == 60 && byArray[i + 1] == 60) {
                        ++n4;
                        continue;
                    }
                    if (byArray[i] != 62 || byArray[i + 1] != 62) continue;
                    --n4;
                } while (n4 != 0 && ++i < n3);
                n = i;
                i = n3;
                continue;
            }
            if (byArray[i] == 47) {
                i = n3;
                continue;
            }
            if (byArray[i] == 62 && byArray[i + 1] == 62) {
                n = i - 1;
                i = n3;
                continue;
            }
            if (byArray[i] != 40) continue;
            while (i < n3 && (byArray[i] != 41 || PdfReader.isEscaped(byArray, i))) {
                ++i;
            }
            n = i;
            i = n3;
        }
        return n;
    }

    private void setFieldNames(PdfObject pdfObject) {
        String string = pdfObject.getTextStreamValue(36);
        if (string != null) {
            String string2 = pdfObject.getStringKey(1110793845);
            boolean bl = false;
            while (string2 != null) {
                FormObject formObject = new FormObject(string2, false);
                this.readObject(formObject);
                String string3 = formObject.getTextStreamValue(36);
                if (string == null && string3 != null) {
                    string = string3;
                } else if (string3 != null && !string.equals(string3)) {
                    string = string3 + "." + string;
                    bl = true;
                }
                if (string3 == null) break;
                string2 = formObject.getParentRef();
            }
            if (bl) {
                pdfObject.setTextStreamValue(36, string.getBytes());
            }
        }
    }

    private void readStreamData(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        for (int i = n; i < n2 - 5 && (byArray[i] != 62 || byArray[i + 1] != 62); ++i) {
            if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
            if (!pdfObject.isCached()) {
                this.readStreamIntoObject(pdfObject, i, byArray, pdfObject, this.padding);
            }
            i = n2;
        }
    }

    private static int getPairedValues(PdfObject pdfObject, int n, byte[] byArray, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        if (n2 == -1 && pdfObject.getID() == 1448698499 || (n2 == -1 || n4 == 1 && (pdfObject.getID() == 30 || pdfObject.getID() == 20 || pdfObject.getID() == 34)) && pdfObject.getParentID() == 4384 && pdfObject.getObjectType() == 373244477 && (pdfObject.getID() == 20 || pdfObject.getID() == 30 || pdfObject.getID() == 34)) {
            int n6 = n;
            while (n6 < n3) {
                while (n6 < n3 && (byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13 || byArray[n6] == 10)) {
                    ++n6;
                }
                if (n6 == n3) break;
                if (byArray[n6] >= 48 && byArray[n6] <= 57) {
                    while (n6 < n3 && byArray[n6] >= 48 && byArray[n6] <= 57) {
                        ++n6;
                    }
                    while (n6 < n3 && (byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13 || byArray[n6] == 10)) {
                        ++n6;
                    }
                    while (n6 < n3 && byArray[n6] >= 48 && byArray[n6] <= 57) {
                        ++n6;
                    }
                    while (n6 < n3 && (byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13 || byArray[n6] == 10)) {
                        ++n6;
                    }
                    if (n6 >= n3 || byArray[n6] != 82) break;
                    ++n6;
                }
                while (n6 < n3 && (byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13 || byArray[n6] == 10)) {
                    ++n6;
                }
                if (byArray[n6] == 62 && byArray[n6 + 1] == 62) {
                    bl = true;
                    break;
                }
                if (byArray[n6] != 47) break;
                ++n6;
                while (n6 < n3 && byArray[n6] != 32 && byArray[n6] != 10 && byArray[n6] != 13 && byArray[n6] != 10) {
                    ++n6;
                }
            }
        }
        if (bl) {
            n2 = 5;
            pdfObject.setCurrentKey(PdfDictionary.getKey(n5, n4, byArray));
        }
        return n2;
    }

    private static void showData(int n, String string, PdfObject pdfObject, int n2, int n3, byte[] byArray, String string2) {
        System.out.println("\n\n" + string2 + "level=" + n + " ------------readDictionaryAsObject ref=" + string + " into " + pdfObject + "-----------------\ni=" + n2 + "\nData=>>>>");
        System.out.print(string2);
        for (int i = n2; i < n3; ++i) {
            System.out.print((char)byArray[i]);
            if (byArray[i] == 37) {
                while (i < n3 && byArray[i] != 10 && byArray[i] != 13) {
                    ++i;
                }
                while (i < n3 && (byArray[i] == 9 || byArray[i] == 10 || byArray[i] == 13 || byArray[i] == 32 || byArray[i] == 60)) {
                    ++i;
                }
            }
            if (i > 5 && byArray[i - 5] == 115 && byArray[i - 4] == 116 && byArray[i - 3] == 114 && byArray[i - 2] == 101 && byArray[i - 1] == 97 && byArray[i] == 109) {
                i = n3;
            }
            if (i <= 2 || byArray[i - 2] != 66 || byArray[i - 1] != 68 || byArray[i] != 67) continue;
            i = n3;
        }
        System.out.println(string2 + "\n<<<<-----------------------------------------------------\n");
    }

    private static int getUnreadDictionary(PdfObject pdfObject, String string, int n, byte[] byArray, boolean bl, int n2) {
        int n3;
        if (byArray[n] != 60) {
            ++n;
        }
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 9) {
            ++n;
        }
        int n4 = n;
        PdfObject pdfObject2 = ObjectFactory.createObject(n2, string, pdfObject.getObjectType(), pdfObject.getID());
        pdfObject2.setID(n2);
        if (byArray[n] != 110 || byArray[n + 1] != 117 || byArray[n + 2] != 108 || byArray[n + 3] != 108) {
            pdfObject.setDictionary(n2, pdfObject2);
        }
        int n5 = 2;
        if (byArray[n] == 47) {
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            int n6 = n;
            int n7 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
                ++n7;
            }
            --n;
            n3 = pdfObject2.setConstant(n2, n6, n7, byArray);
            if (n3 == -1 || bl) {
                byte[] byArray2 = new byte[n7];
                System.arraycopy(byArray, n6, byArray2, 0, n7);
                String string2 = new String(byArray2);
                pdfObject2.setGeneralStringValue(string2);
            }
            n5 = 0;
        } else if (byArray[n] != 101 || byArray[n + 1] != 110 || byArray[n + 2] != 100 || byArray[n + 3] != 111 || byArray[n + 4] != 98) {
            while (byArray[n] == 91 && n2 != 2087749783 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                ++n;
            }
            if (byArray[n] == 60 && byArray[n + 1] == 60) {
                n += 2;
                n3 = 1;
                while (n3 > 0) {
                    if (byArray[n] == 60 && byArray[n + 1] == 60) {
                        n += 2;
                        ++n3;
                        continue;
                    }
                    if (byArray[n] == 62 && byArray[n + 1] == 62) {
                        n += 2;
                        --n3;
                        continue;
                    }
                    ++n;
                }
            } else if (byArray[n] == 91) {
                ++n;
                n3 = 1;
                while (n3 > 0) {
                    if (byArray[n] == 40) {
                        ++n;
                        while (byArray[n] != 41 || PdfReader.isEscaped(byArray, n)) {
                            ++n;
                        }
                    } else if (byArray[n] == 91) {
                        ++n3;
                    } else if (byArray[n] == 93) {
                        --n3;
                    }
                    ++n;
                }
                --n;
            } else if (byArray[n] == 110 && byArray[n + 1] == 117 && byArray[n + 2] == 108 && byArray[n + 3] == 108) {
                n += 4;
            } else {
                n5 = 1;
                while ((byArray[n] != 82 || byArray[n - 1] == 101) && ++n != byArray.length) {
                }
                if (++n >= byArray.length) {
                    n = byArray.length - 1;
                }
            }
        }
        pdfObject2.setStatus(n5);
        if (n5 != 0) {
            n3 = n - n4;
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n4, byArray3, 0, n3);
            if (byArray3[n3 - 1] == 82) {
                for (int i = 0; i < n3; ++i) {
                    if (byArray3[i] != 10 && byArray3[i] != 13) continue;
                    byArray3[i] = 32;
                }
            }
            pdfObject2.setUnresolvedData(byArray3, n2);
        }
        if (byArray[n] == 47 || byArray[n] == 62) {
            --n;
        }
        return n;
    }

    private int readDictionary(PdfObject pdfObject, String string, int n, byte[] byArray, String string2, boolean bl, int n2, boolean bl2) {
        if (byArray[n] != 60) {
            ++n;
        }
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            ++n;
        }
        if (byArray[n] == 47) {
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            int n3 = n;
            int n4 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
                ++n4;
            }
            --n;
            if (!bl2) {
                PdfObject pdfObject2 = ObjectFactory.createObject(n2, string, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject2.setID(n2);
                int n5 = pdfObject2.setConstant(n2, n3, n4, byArray);
                if (n5 == -1 || bl) {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, n3, byArray2, 0, n4);
                    String string3 = new String(byArray2);
                    pdfObject2.setGeneralStringValue(string3);
                }
                pdfObject.setDictionary(n2, pdfObject2);
                if (pdfObject.isDataExternal()) {
                    pdfObject2.isDataExternal(true);
                    if (!this.resolveFully(pdfObject2)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else if (byArray[n] != 101 || byArray[n + 1] != 110 || byArray[n + 2] != 100 || byArray[n + 3] != 111 || byArray[n + 4] != 98) {
            if (byArray[n] == 40 && n2 == 6691) {
                int n6 = ++n;
                while (n < byArray.length && (byArray[++n] != 41 || PdfReader.isEscaped(byArray, n))) {
                }
                byte[] byArray3 = PdfReader.readEscapedValue(n, byArray, n6, false);
                NamesObject namesObject = new NamesObject(string);
                namesObject.setDecodedStream(byArray3);
                pdfObject.setDictionary(6691, namesObject);
            } else if (bl2) {
                while (byArray[n] == 91 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                    ++n;
                }
                if (byArray[n] == 60 && byArray[n + 1] == 60) {
                    n += 2;
                    int n7 = 1;
                    while (n7 > 0) {
                        if (byArray[n] == 60 && byArray[n + 1] == 60) {
                            n += 2;
                            ++n7;
                            continue;
                        }
                        if (byArray[n] == 62 && byArray[n + 1] == 62) {
                            n += 2;
                            --n7;
                            continue;
                        }
                        ++n;
                    }
                    --n;
                } else {
                    n = this.readDictionaryFromRefOrDirect(n2, pdfObject, string, n, byArray, n2);
                }
                if (n < byArray.length && byArray[n] == 47) {
                    --n;
                }
            } else {
                n = this.readDictionaryFromRefOrDirect(n2, pdfObject, string, n, byArray, n2);
            }
        }
        return n;
    }

    private int readTextStream(PdfObject pdfObject, String string, int n, byte[] byArray, int n2, boolean bl) {
        if (n2 == 39) {
            int n3;
            int n4;
            boolean bl2 = false;
            while (byArray[n] != 91) {
                if (byArray[n] == 40) {
                    bl2 = false;
                    break;
                }
                if (byArray[n] >= 48 && byArray[n] <= 57) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            byte[] byArray2 = byArray;
            int n5 = n;
            int n6 = n;
            int n7 = 0;
            if (bl2) {
                n4 = n;
                int n8 = 0;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                    ++n8;
                }
                n3 = PdfReader.parseInt(n4, n, byArray);
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                    ++n;
                }
                n4 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                int n9 = PdfReader.parseInt(n4, n, byArray);
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                    ++n;
                }
                if (byArray[n] != 82) {
                    throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
                }
                if (!bl) {
                    byArray2 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n3, n9), n3, n9);
                    if (byArray2 == null) {
                        pdfObject.setFullyResolved(false);
                        LogWriter.writeLog("[Linearized] " + string + " not yet available (6)");
                        return byArray.length;
                    }
                    n6 = 3;
                    while (byArray2[n6 - 1] != 106 && byArray2[n6 - 2] != 98 && byArray2[n6 - 3] != 111) {
                        if (++n6 != byArray2.length) continue;
                        n6 = 0;
                        break;
                    }
                    while (byArray2[n6] == 10 || byArray2[n6] == 13 || byArray2[n6] == 32) {
                        ++n6;
                    }
                    n5 = n6;
                }
            }
            while (n6 < byArray2.length) {
                if (byArray2[n6] == 91 || byArray2[n6] == 40) {
                    ++n7;
                } else if (byArray2[n6] == 93 || byArray2[n6] == 41) {
                    --n7;
                }
                if (n7 == 0) break;
                ++n6;
            }
            if (!bl) {
                n4 = n6 - n5 + 1;
                byte[] byArray3 = new byte[n4];
                System.arraycopy(byArray2, n5, byArray3, 0, n4);
                if (n2 != 6691) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (byArray3[n3] != 10 && byArray3[n3] != 13) continue;
                        byArray3[n3] = 32;
                    }
                }
                pdfObject.setTextStreamValue(n2, byArray3);
            }
            if (!bl2) {
                n = n6;
            }
        } else {
            byte[] byArray4 = null;
            try {
                int n10;
                int n11;
                int n12;
                int n13;
                if (byArray[n] != 60 && byArray[n] != 40) {
                    ++n;
                }
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
                    ++n;
                }
                if (byArray[n] == 47) {
                    pdfObject.setTextStreamValue(n2, new byte[1]);
                    return --n;
                }
                boolean bl3 = byArray[n] != 60 && byArray[n] != 40;
                int n14 = n;
                byArray4 = byArray;
                if (bl3) {
                    n13 = n;
                    n12 = 0;
                    while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                        ++n;
                        ++n12;
                    }
                    n11 = PdfReader.parseInt(n13, n, byArray);
                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                        ++n;
                    }
                    n13 = n;
                    while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                        ++n;
                    }
                    n10 = PdfReader.parseInt(n13, n, byArray);
                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                        ++n;
                    }
                    if (byArray[n] != 82) {
                        throw new RuntimeException("3. Unexpected value in file " + (char)byArray[n] + " - please send to IDRsolutions for analysis " + pdfObject);
                    }
                    if (!bl) {
                        byArray4 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n11, n10), n11, n10);
                        if (byArray4 == null) {
                            pdfObject.setFullyResolved(false);
                            LogWriter.writeLog("[Linearized] " + string + " not yet available (7)");
                            return byArray.length;
                        }
                        if (byArray4[0] == 40) {
                            n14 = 0;
                        } else {
                            n14 = 3;
                            while (byArray4[n14 - 1] != 106 && byArray4[n14 - 2] != 98 && byArray4[n14 - 3] != 111) {
                                ++n14;
                            }
                            while (byArray4[n14] == 10 || byArray4[n14] == 13 || byArray4[n14] == 32) {
                                ++n14;
                            }
                        }
                    }
                }
                n13 = 0;
                if (!bl3 || !bl) {
                    while (byArray4[n14] != 40 && byArray4[n14] != 60) {
                        ++n14;
                    }
                    n12 = byArray4[n14];
                    n13 = n14;
                    n11 = 1;
                    while (n14 < byArray4.length) {
                        if (!(n12 != 40 || byArray4[++n14] != 41 && byArray4[n14] != 40 || PdfReader.isEscaped(byArray4, n14))) {
                            if (byArray4[n14] == 40) {
                                ++n11;
                            } else if (byArray4[n14] == 41) {
                                --n11;
                            }
                            if (n11 == 0) break;
                        }
                        if (n12 != 60 || byArray4[n14] != 62) continue;
                    }
                }
                if (!bl) {
                    byte[] byArray5 = null;
                    if (byArray4[n13] == 60) {
                        n11 = n14 - ++n13 >> 1;
                        byArray5 = new byte[n11];
                        n10 = 0;
                        while (n13 != n14) {
                            while (byArray4[n13] == 32 || byArray4[n13] == 10 || byArray4[n13] == 13) {
                                ++n13;
                            }
                            int n15 = byArray4[n13];
                            if (n15 >= 65 && n15 <= 70) {
                                n15 -= 55;
                            } else if (n15 >= 97 && n15 <= 102) {
                                n15 -= 87;
                            } else if (n15 >= 48 && n15 <= 57) {
                                n15 -= 48;
                            } else {
                                throw new RuntimeException("Unexpected number " + (char)byArray4[n13]);
                            }
                            ++n13;
                            while (byArray4[n13] == 32 || byArray4[n13] == 10 || byArray4[n13] == 13) {
                                ++n13;
                            }
                            int n16 = byArray4[n13];
                            if (n16 >= 65 && n16 <= 70) {
                                n16 -= 55;
                            } else if (n16 >= 97 && n16 <= 102) {
                                n16 -= 87;
                            } else if (n16 >= 48 && n16 <= 57) {
                                n16 -= 48;
                            } else {
                                throw new RuntimeException("Unexpected number " + (char)byArray4[n13]);
                            }
                            ++n13;
                            int n17 = n16 + (n15 << 4);
                            byArray5[n10] = (byte)n17;
                            ++n10;
                        }
                    } else {
                        if (byArray4[n13] == 40) {
                            ++n13;
                        }
                        byArray5 = PdfReader.readEscapedValue(n14, byArray4, n13, n2 == 6420);
                    }
                    if (pdfObject.getObjectType() != 1113489015) {
                        try {
                            if ((!this.isAES || this.stringsEncoded || this.isMetaDataEncypted) && !pdfObject.isInCompressedStream()) {
                                byArray5 = this.decrypt(byArray5, string, false, null, false, true);
                            }
                        }
                        catch (PdfSecurityException pdfSecurityException) {
                            pdfSecurityException.printStackTrace();
                        }
                    }
                    pdfObject.setTextStreamValue(n2, byArray5);
                }
                if (!bl3) {
                    n = n14;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    private static byte[] readEscapedValue(int n, byte[] byArray, int n2, boolean bl) {
        byte[] byArray2;
        int n3;
        boolean bl2 = false;
        for (n3 = n2; n3 < n; ++n3) {
            if (byArray[n3] != 92 && byArray[n3] != 10 && byArray[n3] != 13) continue;
            bl2 = true;
            n3 = n;
        }
        if (!bl2) {
            n3 = n - n2;
            if (n3 < 1) {
                return new byte[0];
            }
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        } else {
            n3 = 0;
            int n4 = n - n2;
            byArray2 = new byte[n4];
            for (int i = n2; i < n; ++i) {
                if (byArray[i] == 92) {
                    byte by;
                    if ((by = byArray[++i]) == 98) {
                        byArray2[n3] = 8;
                    } else if (by == 110) {
                        byArray2[n3] = 10;
                    } else if (by == 116) {
                        byArray2[n3] = 9;
                    } else if (by == 114) {
                        byArray2[n3] = 13;
                    } else if (by == 102) {
                        byArray2[n3] = 12;
                    } else if (by == 92) {
                        byArray2[n3] = 92;
                    } else if (by > 47 && by < 58) {
                        StringBuffer stringBuffer = new StringBuffer(3);
                        boolean bl3 = false;
                        for (int j = 0; j < 3; ++j) {
                            if (byArray[i] == 92 || byArray[i] == 41 || byArray[i] < 48 || byArray[i] > 57) {
                                j = 3;
                                continue;
                            }
                            stringBuffer.append((char)byArray[i]);
                            if (byArray[i] > 55) {
                                bl3 = true;
                            }
                            ++i;
                        }
                        --i;
                        byArray2[n3] = bl3 ? (byte)Integer.parseInt(stringBuffer.toString()) : (byte)Integer.parseInt(stringBuffer.toString(), 8);
                    } else if (by == 13 || by == 10) {
                        --n3;
                    } else {
                        byArray2[n3] = by;
                    }
                    ++n3;
                    continue;
                }
                if (!(bl || byArray[i] != 13 && byArray[i] != 10)) {
                    byArray2[n3] = 32;
                    ++n3;
                    continue;
                }
                byArray2[n3] = byArray[i];
                ++n3;
            }
            byte[] byArray3 = byArray2;
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, 0, n3);
        }
        return byArray2;
    }

    private int readNumber(PdfObject pdfObject, String string, int n, byte[] byArray, int n2, Object object) {
        int n3;
        int n4;
        int n5 = n;
        int n6 = 0;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 40 && byArray[n] != 46) {
            ++n;
            ++n6;
        }
        int n7 = PdfReader.parseInt(n5, n, byArray);
        for (n4 = n; n4 < byArray.length && (byArray[n4] == 32 || byArray[n4] == 13 || byArray[n4] == 10); ++n4) {
        }
        boolean bl = false;
        if (byArray[n4] >= 48 && byArray[n4] <= 57) {
            n3 = n4;
            while (byArray[n3] != 10 && byArray[n3] != 13 && byArray[n3] != 32 && byArray[n3] != 47 && byArray[n3] != 60 && byArray[n3] != 62) {
                ++n3;
            }
            while (n3 < byArray.length && (byArray[n3] == 10 || byArray[n3] == 13 || byArray[n3] == 32 || byArray[n3] == 47)) {
                ++n3;
            }
            boolean bl2 = bl = n3 < byArray.length && byArray[n3] == 82;
        }
        if (bl) {
            int n8;
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n5 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            n3 = PdfReader.parseInt(n5, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byte[] byArray2 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n7, n3), n7, n3);
            if (byArray2 == null) {
                pdfObject.setFullyResolved(false);
                LogWriter.writeLog("[Linearized] " + string + " not yet available (8)");
                return byArray.length;
            }
            int n9 = 0;
            int n10 = byArray2.length;
            if (n10 <= 1 || byArray2[0] != 60 || byArray2[1] != 60) {
                n9 = 3;
                while (byArray2[n9 - 1] != 106 && byArray2[n9 - 2] != 98 && byArray2[n9 - 3] != 111) {
                    if (++n9 != n10) continue;
                    n9 = 0;
                    break;
                }
            }
            while (byArray2[n9] == 9 || byArray2[n9] == 10 || byArray2[n9] == 13 || byArray2[n9] == 32) {
                ++n9;
            }
            for (n8 = n9; n8 < n10 && byArray2[n8] != 9 && byArray2[n8] != 10 && byArray2[n8] != 13 && byArray2[n8] != 32; ++n8) {
            }
            n7 = PdfReader.parseInt(n9, n8, byArray2);
        }
        pdfObject.setIntNumber(n2, n7);
        return --n;
    }

    private int handleColorSpaces(PdfObject pdfObject, int n, byte[] byArray) {
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 91) {
            if (byArray[n] == 91) {
                pdfObject.maybeIndirect(true);
            }
            ++n;
        }
        if (byArray[n] == 47) {
            ++n;
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                ++n;
            }
            int n2 = n;
            int n3 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 91 && byArray[n] != 93) {
                ++n3;
                if (++n != byArray.length) continue;
            }
            --n;
            int n4 = pdfObject.setConstant(2087749783, n2, n3, byArray);
            if (n4 == 25) {
                n4 = 895578984;
            }
            ++n;
            switch (n4) {
                case 1008872003: {
                    n = this.handleColorSpaces(pdfObject, n, byArray);
                    ++n;
                    break;
                }
                case 391471749: {
                    n = this.handleColorSpaces(pdfObject, n, byArray);
                    ++n;
                    break;
                }
                case 1498837125: {
                    break;
                }
                case 1568372915: {
                    break;
                }
                case 960981604: {
                    int n5;
                    for (n5 = n; n5 < byArray.length && byArray[n5] != 93; ++n5) {
                    }
                    n = this.readArray(false, n, n5, 20, byArray, "", pdfObject, 1920898752, null, -1);
                    while (byArray[n] == 93 || byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                        ++n;
                    }
                    ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0);
                    n = this.handleColorSpaces(colorSpaceObject, n, byArray);
                    pdfObject.setDictionary(-1247101998, colorSpaceObject);
                    ++n;
                    FunctionObject functionObject = new FunctionObject(-1, 0);
                    n = this.handleColorSpaces(functionObject, n, byArray);
                    pdfObject.setDictionary(-1313946392, functionObject);
                    for (int i = n; i < byArray.length; ++i) {
                        if (byArray[i] == 93) {
                            i = byArray.length;
                            break;
                        }
                        if (byArray[i] == 32 || byArray[i] == 10 || byArray[i] == 13) continue;
                        n = i;
                        ColorSpaceObject colorSpaceObject2 = new ColorSpaceObject(-1, 0);
                        n = this.handleColorSpaces(colorSpaceObject2, n, byArray);
                        pdfObject.setDictionary(861242754, colorSpaceObject2);
                        return n;
                    }
                    ++n;
                    break;
                }
                case 1785221209: {
                    break;
                }
                case 1247168582: {
                    n = this.readDictionaryFromRefOrDirect(-1, pdfObject, "", n, byArray, 2087749783);
                    break;
                }
                case 895578984: {
                    ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0, true);
                    pdfObject.setDictionary(895578984, colorSpaceObject);
                    for (n = this.handleColorSpaces(colorSpaceObject, n, byArray); n < byArray.length && (byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10 || byArray[n] == 93 || byArray[n] == 62); ++n) {
                    }
                    if (byArray[n = this.readNumber(pdfObject, "", n, byArray, 960901492, "hival")] != 40) {
                        ++n;
                    }
                    while (n < byArray.length && (byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10)) {
                        ++n;
                    }
                    ColorSpaceObject colorSpaceObject3 = null;
                    boolean bl = byArray[n] == 91 || byArray[n] == 40 || byArray[n] == 60;
                    colorSpaceObject3 = bl ? new ColorSpaceObject(pdfObject.getObjectRefAsString()) : new ColorSpaceObject(-1, 0);
                    pdfObject.setDictionary(1060856191, colorSpaceObject3);
                    n = this.handleColorSpaces(colorSpaceObject3, n, byArray);
                    ++n;
                    break;
                }
                case 1847602: {
                    n = this.handleColorSpaces(pdfObject, n, byArray);
                    ++n;
                    break;
                }
                case 1146450818: {
                    break;
                }
                case -2073385820: {
                    int n6 = n;
                    while (byArray[n6] == 47 || byArray[n6] == 32 || byArray[n6] == 10 || byArray[n6] == 13) {
                        ++n6;
                    }
                    int n7 = n6;
                    while (n6 < byArray.length && byArray[n6] != 47 && byArray[n6] != 32 && byArray[n6] != 13 && byArray[n6] != 10) {
                        ++n6;
                    }
                    n3 = n6 - n7;
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, n7, byArray2, 0, n3);
                    pdfObject.setName(506543413, byArray2);
                    n = n6;
                    if (byArray[n] != 47) {
                        ++n;
                    }
                    ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0);
                    n = this.handleColorSpaces(colorSpaceObject, n, byArray);
                    pdfObject.setDictionary(-1247101998, colorSpaceObject);
                    if (byArray[n] != 60) {
                        ++n;
                    }
                    FunctionObject functionObject = new FunctionObject(-1, 0);
                    n = this.handleColorSpaces(functionObject, n, byArray);
                    pdfObject.setDictionary(-1313946392, functionObject);
                    ++n;
                    break;
                }
            }
        } else if (byArray[n] == 60 && byArray[n + 1] == 60) {
            n = this.convertDirectDictionaryToObject(pdfObject, "", n, byArray, -1);
            if (pdfObject.hasStream()) {
                int n8 = byArray.length;
                int n9 = 0;
                for (int i = n; i < n8 - 5; ++i) {
                    if (byArray[i] == 62 && byArray[i + 1] == 62) {
                        ++n9;
                    }
                    if (n9 != 2) {
                        if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
                        this.readStreamIntoObject(pdfObject, i, byArray, pdfObject, this.padding);
                        i = n8;
                        continue;
                    }
                    break;
                }
            }
        } else if (byArray[n] == 37) {
            while (byArray[n] != 10 && byArray[n] != 13) {
                ++n;
            }
        } else if (byArray[n] == 60) {
            int n10 = ++n;
            int n11 = 0;
            while (byArray[n10] != 62) {
                if (byArray[n10] != 32 && byArray[n10] != 10 && byArray[n10] != 13) {
                    ++n11;
                }
                ++n10;
            }
            int n12 = n11 >> 1;
            byte[] byArray3 = new byte[n12];
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            while (true) {
                if (byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                    continue;
                }
                n14 = byArray[n];
                if (n14 >= 65 && n14 <= 70) {
                    n14 -= 55;
                } else if (n14 >= 97 && n14 <= 102) {
                    n14 -= 87;
                } else if (n14 >= 48 && n14 <= 57) {
                    n14 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)byArray[n]);
                }
                ++n;
                while (byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                }
                n15 = byArray[n];
                if (n15 >= 65 && n15 <= 70) {
                    n15 -= 55;
                } else if (n15 >= 97 && n15 <= 102) {
                    n15 -= 87;
                } else if (n15 >= 48 && n15 <= 57) {
                    n15 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)byArray[n]);
                }
                ++n;
                int n16 = n15 + (n14 << 4);
                byArray3[n13] = (byte)n16;
                if (++n13 == n12) break;
            }
            pdfObject.setDecodedStream(byArray3);
        } else if (byArray[n] == 40) {
            int n17 = ++n;
            while (byArray[n] != 41 || PdfReader.isEscaped(byArray, n)) {
                ++n;
            }
            byte[] byArray4 = PdfReader.readEscapedValue(++n, byArray, n17, false);
            try {
                byArray4 = this.decrypt(byArray4, pdfObject.getObjectRefAsString(), false, null, false, false);
            }
            catch (PdfSecurityException pdfSecurityException) {
                pdfSecurityException.printStackTrace();
            }
            pdfObject.setDecodedStream(byArray4);
        } else {
            byte[] byArray5;
            int n18 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n19 = PdfReader.parseInt(n18, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n18 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n20 = PdfReader.parseInt(n18, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + (char)byArray[n] + " - please send to IDRsolutions for analysis");
            }
            ++n;
            if (pdfObject.getObjectRefID() == -1 || pdfObject.maybeIndirect()) {
                pdfObject.setRef(n19, n20);
            }
            if ((byArray5 = this.readObjectAsByteArray(pdfObject, "1", this.isCompressed(n19, n20), n19, n20)) == null) {
                pdfObject.setFullyResolved(false);
                LogWriter.writeLog("[Linearized] " + n19 + " " + n20 + " R not yet available (9)");
                return byArray.length;
            }
            if (byArray5[0] == 47) {
                this.handleColorSpaces(pdfObject, 0, byArray5);
            } else {
                int n21 = 0;
                if (byArray5[0] != 91 && byArray5[0] != 60) {
                    n21 = 3;
                    while (byArray5[n21 - 1] != 106 && byArray5[n21 - 2] != 98 && byArray5[n21 - 3] != 111) {
                        ++n21;
                    }
                }
                this.handleColorSpaces(pdfObject, n21, byArray5);
            }
        }
        if (n < byArray.length && (byArray[n] == 47 || byArray[n] == 62)) {
            --n;
        }
        return n;
    }

    public byte[] getBytesFromPDF(long l, int n) {
        byte[] byArray = new byte[n];
        this.movePointer(l);
        try {
            this.pdf_datafile.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static boolean isEscaped(byte[] byArray, int n) {
        int n2 = n - 1;
        int n3 = 0;
        while (n2 > -1 && byArray[n2] == 92) {
            --n2;
            ++n3;
        }
        return n3 & true;
    }

    private int readDictionaryFromRefOrDirect(int n, PdfObject pdfObject, String string, int n2, byte[] byArray, int n3) {
        int n4 = -1;
        while (byArray[n2] == 91 || byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) {
            if (byArray[n2] == 91) {
                n4 = n2;
            }
            ++n2;
        }
        if (n3 == 2087749783 || n == 2087749783 || pdfObject.getPDFkeyInt() == 2087749783) {
            return this.processColorSpace(pdfObject, string, n2, byArray, this.padding);
        }
        if (n4 != -1 && (n3 == 489767739 || n3 == 9250 || n3 == 2037870513)) {
            return this.processArray(pdfObject, string, byArray, n3, n4);
        }
        if (byArray[n2] == 37) {
            while (byArray[n2] != 13 && byArray[n2] != 10) {
                ++n2;
            }
            while (byArray[n2] == 91 || byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) {
                ++n2;
            }
        }
        if (byArray[n2] == 60) {
            n2 = this.convertDirectDictionaryToObject(pdfObject, string, n2, byArray, n3);
        } else if (byArray[n2] == 47) {
            n2 = PdfReader.setDirectValue(pdfObject, n2, byArray, n3);
        } else {
            int n5;
            int n6;
            int n7;
            int n8;
            boolean bl;
            int n9 = n2;
            byte[] byArray2 = byArray;
            while (true) {
                block43: {
                    if (byArray2[n9] == 91 || byArray2[n9] == 32 || byArray2[n9] == 13 || byArray2[n9] == 10) {
                        ++n9;
                        continue;
                    }
                    bl = false;
                    do {
                        if (bl && byArray2[n9] == 93) {
                            return n9;
                        }
                        n8 = n9;
                        while (byArray2[n9] != 10 && byArray2[n9] != 13 && byArray2[n9] != 32 && byArray2[n9] != 47 && byArray2[n9] != 60 && byArray2[n9] != 62) {
                            if (byArray2[n9] == 108 && byArray2[n9 - 1] == 108 && byArray2[n9 - 2] == 117 && byArray2[n9 - 3] == 110) {
                                bl = true;
                            }
                            if (bl && byArray2[n9] == 93) {
                                return n9;
                            }
                            ++n9;
                        }
                        n7 = PdfReader.parseInt(n8, n9, byArray2);
                        while (byArray2[n9] == 10 || byArray2[n9] == 13 || byArray2[n9] == 32) {
                            ++n9;
                        }
                        if (n7 != 69560 || byArray2[n8] != 110) break block43;
                        bl = true;
                    } while (byArray2[n9] != 60);
                    return this.readDictionaryFromRefOrDirect(n, pdfObject, string, n9, byArray, n3);
                }
                n8 = n9;
                while (byArray2[n9] != 10 && byArray2[n9] != 13 && byArray2[n9] != 32 && byArray2[n9] != 47 && byArray2[n9] != 60 && byArray2[n9] != 62) {
                    ++n9;
                }
                n6 = PdfReader.parseInt(n8, n9, byArray2);
                while (byArray2[n9] == 10 || byArray2[n9] == 13 || byArray2[n9] == 32 || byArray2[n9] == 47 || byArray2[n9] == 60) {
                    ++n9;
                }
                if (byArray2[n9] != 82) {
                    throw new RuntimeException("ref=" + n7 + " gen=" + n7 + " 1. Unexpected value " + byArray2[n9] + " in file - please send to IDRsolutions for analysis char=" + (char)byArray2[n9]);
                }
                byArray2 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n7, n6), n7, n6);
                if (byArray2 == null) {
                    pdfObject.setFullyResolved(false);
                    LogWriter.writeLog("[Linearized] " + string + " not yet available (11)");
                    return byArray.length;
                }
                if (byArray2 != null && byArray2.length > 4 && byArray2[0] == 37 && byArray2[1] == 80 && byArray2[2] == 68 && byArray2[3] == 70) {
                    byArray2 = null;
                }
                if (byArray2 == null) break;
                n5 = 0;
                if (byArray2[n5] != 91) {
                    while ((n5 < 3 || n5 > 2 && byArray2[n5 - 1] != 106 && byArray2[n5 - 2] != 98 && byArray2[n5 - 3] != 111) && byArray2[n5] != 47) {
                        ++n5;
                    }
                    while (byArray2[n5] != 91 && (byArray2[n5] == 10 || byArray2[n5] == 13 || byArray2[n5] == 32)) {
                        ++n5;
                    }
                }
                if (byArray2[n5] != 91) {
                    n9 = 0;
                    break;
                }
                n9 = n5;
            }
            if (byArray2 != null) {
                while (byArray2[n9] == 10 || byArray2[n9] == 13 || byArray2[n9] == 32) {
                    ++n9;
                }
                boolean bl2 = bl = n9 < byArray.length && byArray[n9] == 60;
                if (bl) {
                    for (n5 = n9; n5 < byArray2.length && (byArray[n5] == 60 || byArray[n5] == 10 || byArray[n5] == 13 || byArray[n5] == 32); ++n5) {
                    }
                    if (byArray[n5] == 47) {
                        bl = false;
                    }
                }
                if (bl) {
                    n8 = n9;
                    while (byArray2[n9] != 10 && byArray2[n9] != 13 && byArray2[n9] != 32 && byArray2[n9] != 47 && byArray2[n9] != 60 && byArray2[n9] != 62) {
                        ++n9;
                    }
                    n7 = PdfReader.parseInt(n8, n9, byArray2);
                    while (byArray2[n9] == 10 || byArray2[n9] == 13 || byArray2[n9] == 32 || byArray2[n9] == 47 || byArray2[n9] == 60) {
                        ++n9;
                    }
                    n8 = n9;
                    while (byArray2[n9] != 10 && byArray2[n9] != 13 && byArray2[n9] != 32 && byArray2[n9] != 47 && byArray2[n9] != 60 && byArray2[n9] != 62) {
                        ++n9;
                    }
                    n6 = PdfReader.parseInt(n8, n9, byArray2);
                    while (byArray2[n9 - 1] != 106 && byArray2[n9 - 2] != 98 && byArray2[n9 - 3] != 111 && byArray2[n9] != 60) {
                        ++n9;
                    }
                }
                while (byArray2[n9] == 10 || byArray2[n9] == 13 || byArray2[n9] == 32 || byArray2[n9] == 9) {
                    ++n9;
                }
                if (byArray2[0] != 60) {
                    while (byArray2[n9] != 60 && byArray2[n9 + 1] != 60) {
                        if (byArray2[n9] == 110 && byArray2[n9 + 1] == 117 && byArray2[n9 + 2] == 108 && byArray2[n9 + 3] == 108) {
                            return n2;
                        }
                        if (byArray2[n9] == 47) break;
                        if (byArray2[n9] == 40) {
                            n9 = this.readTextStream(pdfObject, string, n9, byArray2, n3, true);
                            break;
                        }
                        ++n9;
                    }
                }
                n2 = this.handleValue(pdfObject, n2, n3, n9, n7, n6, byArray2);
            }
        }
        return n2;
    }

    private static int setDirectValue(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        int n3 = ++n;
        while (n < byArray.length && byArray[n] != 32 && byArray[n] != 10 && byArray[n] != 13) {
            ++n;
        }
        pdfObject.setConstant(n2, n3, n - n3, byArray);
        return n;
    }

    private int processArray(PdfObject pdfObject, String string, byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = n2; byArray[n3] != 93 && n3 <= byArray.length; ++n3) {
        }
        PdfObject pdfObject2 = ObjectFactory.createObject(n, null, pdfObject.getObjectType(), pdfObject.getID());
        pdfObject2.setID(n);
        pdfObject.setDictionary(n, pdfObject2);
        pdfObject2.ignoreRecursion(pdfObject.ignoreRecursion());
        if (pdfObject2.isDataExternal()) {
            pdfObject2.isDataExternal(true);
            if (!this.resolveFully(pdfObject2)) {
                pdfObject.setFullyResolved(false);
            }
        }
        int n4 = 9;
        if (n == 9250) {
            n4 = 14;
        }
        int n5 = this.readArray(pdfObject.ignoreRecursion(), n2, n3, n4, byArray, string, pdfObject2, n, null, -1);
        return n5;
    }

    private int processColorSpace(PdfObject pdfObject, String string, int n, byte[] byArray, String string2) {
        PdfObject pdfObject2 = (PdfObject)this.cachedColorspaces.get(string);
        if (pdfObject2 == null) {
            pdfObject2 = (PdfObject)this.cachedColorspaces.get(pdfObject.getObjectRefAsString());
        }
        if (pdfObject2 == null && !pdfObject.ignoreRecursion()) {
            if (pdfObject.getObjectType() == 2087749783) {
                return this.handleColorSpaces(pdfObject, n, byArray);
            }
            boolean bl = byArray[n] == 47;
            pdfObject2 = bl ? new ColorSpaceObject(string) : new ColorSpaceObject(-1, 0);
            pdfObject.setDictionary(2087749783, pdfObject2);
            if (pdfObject2.isDataExternal()) {
                pdfObject2.isDataExternal(true);
                if (!this.resolveFully(pdfObject2)) {
                    pdfObject.setFullyResolved(false);
                }
            }
            return this.handleColorSpaces(pdfObject2, n, byArray);
        }
        pdfObject.setDictionary(2087749783, pdfObject2);
        if (pdfObject2.isDataExternal()) {
            pdfObject2.isDataExternal(true);
            if (!this.resolveFully(pdfObject2)) {
                pdfObject.setFullyResolved(false);
            }
        }
        if (byArray[n] == 60 && byArray[n + 1] == 60) {
            n += 2;
            int n2 = 1;
            while (n2 > 0) {
                if (byArray[n] == 60 && byArray[n + 1] == 60) {
                    n += 2;
                    ++n2;
                    continue;
                }
                if (byArray[n] == 62 && byArray[n + 1] == 62) {
                    n += 2;
                    --n2;
                    continue;
                }
                ++n;
            }
        } else {
            while (byArray[n] != 82) {
                ++n;
            }
            ++n;
        }
        return n;
    }

    private int handleValue(PdfObject pdfObject, int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (byArray[n3] == 47) {
            int n6 = ++n3;
            int n7 = 0;
            while (byArray[n3] != 10 && byArray[n3] != 13 && byArray[n3] != 32 && byArray[n3] != 47 && byArray[n3] != 60 && byArray[n3] != 62) {
                ++n3;
                ++n7;
            }
            --n;
            if (n2 == -1) {
                int n8 = pdfObject.setConstant(n2, n6, n7, byArray);
            } else {
                PdfObject pdfObject2 = ObjectFactory.createObject(n2, null, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject2.setID(n2);
                int n9 = pdfObject2.setConstant(n2, n6, n7, byArray);
                pdfObject.setDictionary(n2, pdfObject2);
                if (pdfObject.isDataExternal()) {
                    pdfObject2.isDataExternal(true);
                    if (!this.resolveFully(pdfObject2)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else {
            PdfObject pdfObject3;
            if (n2 == -1) {
                pdfObject3 = pdfObject;
            } else {
                pdfObject3 = ObjectFactory.createObject(n2, n4, n5, pdfObject.getObjectType());
                pdfObject3.setID(n2);
                pdfObject3.setInCompressedStream(pdfObject.isInCompressedStream());
                if (pdfObject.isDataExternal()) {
                    pdfObject3.isDataExternal(true);
                    if (!this.resolveFully(pdfObject3)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
                if (n2 != 2004251818) {
                    pdfObject3.ignoreRecursion(pdfObject.ignoreRecursion());
                }
            }
            n3 = this.readDictionaryAsObject(pdfObject3, n4 + " " + n5 + " R", n3, byArray, byArray.length, false);
            if (n2 != -1) {
                pdfObject.setDictionary(n2, pdfObject3);
            }
        }
        return n;
    }

    private int convertDirectDictionaryToObject(PdfObject pdfObject, String string, int n, byte[] byArray, int n2) {
        int n3;
        PdfObject pdfObject2;
        if (n2 == -1) {
            pdfObject2 = pdfObject;
            n3 = 0;
            int n4 = -1;
            int n5 = -1;
            if (byArray[0] == 60) {
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == 47) {
                        ++n3;
                    }
                    if (n3 != 1) continue;
                    if (n4 == -1) {
                        if (byArray[i] <= 48 || byArray[i] >= 57) continue;
                        n4 = i;
                        continue;
                    }
                    if (byArray[i] != 82) continue;
                    n5 = i + 1;
                }
                if (n3 == 1 && n4 != -1 && n5 != -1) {
                    string = new String(byArray, n4, n5 - n4);
                    pdfObject2.setRef(string);
                }
            }
        } else {
            pdfObject2 = ObjectFactory.createObject(n2, string, pdfObject.getObjectType(), pdfObject.getID());
            pdfObject2.setInCompressedStream(pdfObject.isInCompressedStream());
            pdfObject2.setID(n2);
        }
        n = this.readDictionaryAsObject(pdfObject2, string, n, byArray, byArray.length, false);
        if (n < byArray.length && byArray[n] == 62) {
            --n;
        }
        if (n2 != -1) {
            pdfObject.setDictionary(n2, pdfObject2);
        }
        n3 = byArray.length;
        while (n < n3 - 1 && byArray[n] == 62 && byArray[n + 1] == 62 && (++n + 1 >= byArray.length || byArray[n + 1] != 62)) {
        }
        return n;
    }

    private int readKeyPairs(int n, byte[] byArray, int n2, int n3, PdfObject pdfObject, String string) {
        int n4 = n2;
        int n5 = 1;
        int n6 = byArray.length;
        int n7 = n3;
        boolean bl = false;
        boolean bl2 = false;
        Object object = null;
        Object object2 = null;
        PdfObject[] pdfObjectArray = null;
        if (n3 == -1) {
            bl = true;
        } else if (n3 == -2) {
            bl = true;
            bl2 = true;
        } else {
            object = new byte[n7][];
            object2 = new byte[n7][];
            pdfObjectArray = new PdfObject[n7];
        }
        n3 = 0;
        while (true) {
            PdfObject pdfObject2;
            Object object3;
            int n8;
            int n9;
            int n10;
            if (byArray[n4] == 9 || byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 60) {
                ++n4;
                continue;
            }
            if (byArray[n4] == 37) {
                while (byArray[n4] != 10 && byArray[n4] != 13) {
                    ++n4;
                }
                while (byArray[n4] == 9 || byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 60) {
                    ++n4;
                }
            }
            if (byArray[n4] == 62) break;
            if (byArray[n4] == 47) {
                ++n3;
            } else {
                throw new RuntimeException("Unexpected value " + byArray[n4] + " - not key pair");
            }
            int n11 = ++n4;
            while (byArray[n4] != 32 && byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 91 && byArray[n4] != 60 && byArray[n4] != 47) {
                ++n4;
            }
            int n12 = n4 - n11;
            byte[] byArray2 = new byte[n12];
            System.arraycopy(byArray, n11, byArray2, 0, n12);
            if (!bl) {
                object[n3 - 1] = byArray2;
            }
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32) {
                ++n4;
            }
            boolean bl3 = byArray[n4] == 60 || byArray[n4] == 91 || byArray[n4] == 47;
            byte[] byArray3 = null;
            if (bl3) {
                while (byArray[n4 - 1] != 60 && byArray[n4] != 60 && byArray[n4] != 91 && byArray[n4] != 47) {
                    ++n4;
                }
                n10 = n4;
                n9 = 1;
                if (byArray[n4] == 60) {
                    n4 += 2;
                    n5 = 1;
                    while (n5 > 0) {
                        if (byArray[n4] == 60 && byArray[n4 + 1] == 60) {
                            n4 += 2;
                            ++n5;
                            continue;
                        }
                        if (byArray[n4] == 62 && byArray[n4 + 1] == 62) {
                            n4 += 2;
                            --n5;
                            continue;
                        }
                        ++n4;
                    }
                } else if (byArray[n4] == 91) {
                    n5 = 1;
                    ++n4;
                    n8 = 0;
                    while (n5 > 0) {
                        if (n8 == 0 && byArray[n4] == 40) {
                            n8 = 1;
                        } else if (n8 != 0 && byArray[n4] == 41 && (byArray[n4 - 1] != 92 || byArray[n4 - 2] == 92)) {
                            n8 = 0;
                        }
                        if (n8 == 0) {
                            if (byArray[n4] == 91) {
                                ++n5;
                            } else if (byArray[n4] == 93) {
                                --n5;
                            }
                        }
                        ++n4;
                    }
                    n9 = 0;
                } else if (byArray[n4] == 47) {
                    ++n4;
                    while (byArray[n4] != 47 && byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && (++n4 >= byArray.length - 1 || byArray[n4] != 62 || byArray[n4 + 1] != 62)) {
                    }
                }
                if (bl) continue;
                n8 = n4 - n10;
                byArray3 = new byte[n8];
                System.arraycopy(byArray, n10, byArray3, 0, n8);
                object2[n3 - 1] = byArray3;
                String string2 = pdfObject.getObjectRefAsString();
                if (pdfObject.getObjectType() == 2087749783) {
                    if (n9 != 0) {
                        this.handleColorSpaces(pdfObject, 0, byArray3);
                        pdfObjectArray[n3 - 1] = pdfObject;
                        continue;
                    }
                    ColorSpaceObject colorSpaceObject = new ColorSpaceObject(string2);
                    if (bl3) {
                        colorSpaceObject.setRef(-1, 0);
                    }
                    this.handleColorSpaces(colorSpaceObject, 0, byArray3);
                    pdfObjectArray[n3 - 1] = colorSpaceObject;
                    continue;
                }
                if (n9 == 0) continue;
                PdfObject pdfObject3 = ObjectFactory.createObject(n, string2, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject3.setID(n);
                this.readDictionaryFromRefOrDirect(n, pdfObject3, string2, 0, byArray3, -1);
                pdfObjectArray[n3 - 1] = pdfObject3;
                continue;
            }
            n10 = n4;
            n9 = n4;
            n8 = 0;
            while (byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
                ++n4;
                ++n8;
            }
            int n13 = PdfReader.parseInt(n9, n4, byArray);
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 47 || byArray[n4] == 60) {
                ++n4;
            }
            n9 = n4;
            while (byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
                ++n4;
            }
            int n14 = PdfReader.parseInt(n9, n4, byArray);
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 47 || byArray[n4] == 60) {
                ++n4;
            }
            if (byArray[n4] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            ++n4;
            if (bl) continue;
            if (PdfDictionary.getKeyType(n, pdfObject.getObjectType()) == 5) {
                object3 = new String(byArray, n10, n4 - n10);
                PdfObject pdfObject4 = ObjectFactory.createObject(n, (String)object3, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject4.setStatus(1);
                pdfObject4.setUnresolvedData(((String)object3).getBytes(), n);
                pdfObjectArray[n3 - 1] = pdfObject4;
                continue;
            }
            object3 = this.readObjectAsByteArray(pdfObject, "", this.isCompressed(n13, n14), n13, n14);
            if (object3 == null) {
                pdfObject.setFullyResolved(false);
                LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (12)");
                return byArray.length;
            }
            int n15 = 0;
            while ((n15 < 3 || object3[n15 - 1] != 106 && object3[n15 - 2] != 98 && object3[n15 - 3] != 111) && object3[n15] != 47 && object3[n15] != 91 && object3[n15] != 60) {
                if (++n15 != ((Object)object3).length) continue;
                n15 = 0;
                break;
            }
            while (object3[n15] == 10 || object3[n15] == 13 || object3[n15] == 32) {
                ++n15;
            }
            int n16 = ((Object)object3).length - n15;
            byArray3 = new byte[n16];
            System.arraycopy(object3, n15, byArray3, 0, n16);
            object2[n3 - 1] = byArray3;
            String string3 = n13 + " " + n14 + " R";
            if (pdfObject.getObjectType() == 373243460 && n == 373243460) {
                pdfObjectArray[n3 - 1] = null;
                object2[n3 - 1] = string3.getBytes();
                continue;
            }
            if (pdfObject.getObjectType() == 979194486) {
                pdfObject2 = ObjectFactory.createObject(n, string3, 979194486, 979194486);
                pdfObject2.setStatus(1);
                pdfObject2.setUnresolvedData(string3.getBytes(), n);
                pdfObjectArray[n3 - 1] = pdfObject2;
                continue;
            }
            pdfObject2 = ObjectFactory.createObject(n, string3, pdfObject.getObjectType(), pdfObject.getID());
            pdfObject2.setID(n);
            if (pdfObject2.getObjectType() == 2087749783) {
                this.handleColorSpaces(pdfObject2, 0, byArray3);
            } else {
                this.readDictionaryFromRefOrDirect(n, pdfObject2, string3, 0, byArray3, -1);
            }
            pdfObjectArray[n3 - 1] = pdfObject2;
        }
        if (!bl) {
            pdfObject.setDictionaryPairs((byte[][])object, (byte[][])object2, pdfObjectArray);
        }
        if (bl2 || !bl) {
            return n4;
        }
        return n3;
    }

    private void readStreamIntoObject(PdfObject pdfObject, int n, byte[] byArray, PdfObject pdfObject2, String string) {
        int n2 = byArray.length;
        byte[] byArray2 = null;
        PdfArrayIterator pdfArrayIterator = pdfObject2.getMixedArray(1011108731);
        boolean bl = false;
        int n3 = -1;
        if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
            while (pdfArrayIterator.hasMoreTokens() && !bl) {
                n3 = pdfArrayIterator.getNextValueAsConstant(true);
                if (n3 != 1247500931) continue;
                bl = true;
            }
        }
        for (int i = n; i < n2; ++i) {
            int n4;
            if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
            i += 6;
            while (byArray[i] == 32) {
                ++i;
            }
            if (byArray[i] == 13 && byArray[i + 1] == 10) {
                i += 2;
            } else if (byArray[i] == 10 || byArray[i] == 13) {
                // empty if block
            }
            int n5 = ++i;
            --i;
            int n6 = 0;
            int n7 = pdfObject.getInt(1043816557);
            boolean bl2 = false;
            if (n7 != -1) {
                n6 = n7;
                i = n5 + n6;
                if (i < n2 && byArray[i] == 13 && i + 1 < n2 && byArray[i + 1] == 10) {
                    i += 2;
                }
                if (n2 <= i + 9 || byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) {
                    n4 = i;
                    if (i < n2) {
                        while (!bl2 && ++i != n2) {
                            if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
                            n6 = i - n5;
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        i = n4;
                        if (i > n2) {
                            i = n2;
                        }
                        while (!bl2 && --i >= 0) {
                            if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
                            n6 = i - n5;
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        i = n4;
                    }
                }
                if (this.isEncrypted) {
                    n6 = n7;
                }
            } else {
                while (++i != n2 && (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109)) {
                }
                n4 = i - 1;
                if (n4 > n5) {
                    n6 = n4 - n5 + 1;
                }
            }
            if (n6 > 1 && !this.isEncrypted && (n4 = n5 + n6 - 1) < byArray.length && n4 > 0 && (byArray[n4] == 10 || byArray[n4] == 13 && (pdfObject2 != null && bl || n4 > 0 && byArray[n4 - 1] == 10))) {
                --n6;
                --n4;
            }
            if (n5 + n6 > n2) {
                n6 = n2 - n5;
            }
            if (n6 < 0) {
                return;
            }
            if (n6 < 0) {
                throw new RuntimeException("Negative stream length " + n6 + " start=" + n5 + " count=" + n2);
            }
            byArray2 = new byte[n6];
            System.arraycopy(byArray, n5, byArray2, 0, n6);
            i = n2;
        }
        if (pdfObject2 != null) {
            pdfObject2.setStream(byArray2);
            if (pdfObject2.decompressStreamWhenRead()) {
                this.readStream(pdfObject2, true, true, false, pdfObject2.getObjectType() == 1365674082, pdfObject2.isCompressedStream(), null);
            }
        }
    }

    private int readNameString(PdfObject pdfObject, String string, int n, byte[] byArray, int n2, boolean bl, Object object) {
        byte[] byArray2;
        int n3;
        int n4;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 40) {
            ++n;
        }
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            ++n;
        }
        int n5 = n;
        byte[] byArray3 = byArray;
        boolean bl2 = byArray[n] != 47 && byArray[n] != 40;
        boolean bl3 = byArray[n] == 40;
        boolean bl4 = false;
        if (bl2) {
            for (n4 = n + 1; n4 < byArray.length && (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32); ++n4) {
            }
            if (byArray[n4] == 47 || byArray[n4] == 93) {
                bl2 = false;
                n = n4 + 1;
                bl4 = true;
            }
        }
        if (bl2) {
            int n6 = n;
            int n7 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
                ++n7;
            }
            n4 = PdfReader.parseInt(n6, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n6 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            n3 = PdfReader.parseInt(n6, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException(this.padding + "2. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byArray3 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n4, n3), n4, n3);
            if (byArray3 == null) {
                pdfObject.setFullyResolved(false);
                LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (13)");
                return byArray.length;
            }
            n5 = 3;
            while (byArray3[n5] != 47) {
                ++n5;
            }
        }
        if (byArray3[++n5] == 47) {
            return n5 - 1;
        }
        n4 = n5 + 1;
        if (bl4) {
            while (byArray3[n5] == 10 || byArray3[n5] == 13 || byArray3[n5] == 32 || byArray3[n5] == 47) {
                ++n5;
            }
            n3 = 0;
            int n8 = 0;
            while (byArray3[n4] != 93) {
                if (byArray3[n4] == 47 && (n8 == 32 || n8 == 10 || n8 == 13)) {
                    ++n3;
                }
                n8 = byArray3[n4];
                if (++n4 != byArray3.length) continue;
            }
            int n9 = n4 - n3;
            int n10 = 0;
            byArray2 = new byte[n9 - n5];
            int n11 = 0;
            for (int i = n5; i < n9; ++i) {
                int n12 = byArray3[i];
                if (n12 == 47) {
                    if (n11 != 32 && n11 != 10 && n11 != 13) {
                        byArray2[n10] = 32;
                        ++n10;
                    }
                } else {
                    byArray2[n10] = n12;
                    ++n10;
                }
                n11 = n12;
            }
        } else {
            while (!(!bl3 ? byArray3[n4] == 32 || byArray3[n4] == 10 || byArray3[n4] == 13 || byArray3[n4] == 47 || byArray3[n4] == 62 : byArray3[n4] == 41)) {
                if (++n4 != byArray3.length) continue;
            }
            n3 = n4 - n5;
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, n5, byArray2, 0, n3);
        }
        if (bl) {
            pdfObject.setName(object, PdfReader.getTextString(byArray2, false));
        } else {
            pdfObject.setName(n2, byArray2);
        }
        if (!bl2) {
            n = n4 - 1;
        }
        return n;
    }

    public int readArray(boolean bl, int n, int n2, int n3, byte[] byArray, String string, PdfObject pdfObject, int n4, Object[] objectArray, int n5) {
        int n6;
        int n7;
        Object[] objectArray2;
        boolean[] blArray;
        Object object;
        Object object2;
        Object object3;
        double[] dArray;
        int[] nArray;
        float[] fArray;
        boolean bl2;
        int n8;
        int n9;
        block169: {
            int n10;
            int n11;
            byte[] byArray2;
            int n12;
            int n13;
            boolean bl3;
            HashMap<Integer, String> hashMap;
            block167: {
                block171: {
                    block170: {
                        block168: {
                            if ((n3 != 14 || byArray[n] != 60) && byArray[n] != 91) {
                                ++n;
                            }
                            hashMap = new HashMap<Integer, String>();
                            bl3 = false;
                            boolean bl4 = n4 == 456733763 || n4 == 1044338049;
                            n13 = 0;
                            n9 = 0;
                            int n14 = 0;
                            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
                                ++n;
                            }
                            if (byArray[n] == 37) {
                                while (byArray[n] != 10 && byArray[n] != 13) {
                                    ++n;
                                }
                                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
                                    ++n;
                                }
                            }
                            n12 = n;
                            n8 = n;
                            byArray2 = byArray;
                            boolean bl5 = bl2 = byArray[n] != 91 && byArray[n] != 40 && n4 != 489767739 && n4 != 9250 && byArray[0] != 0;
                            if (byArray[n] == 110 && byArray[n + 1] == 117 && byArray[n + 2] == 108 && byArray[n + 2] == 108) {
                                bl2 = false;
                                n9 = 1;
                            }
                            if (bl2) {
                                n11 = n;
                                while (byArray[n11] != 93 && ++n11 < n2 && (byArray[n11] != 82 || byArray[n11 - 1] != 32 && byArray[n11 - 1] != 10 && byArray[n11 - 1] != 13)) {
                                    if (byArray[n11] == 62 && byArray[n11 - 1] == 62) {
                                        bl2 = false;
                                        break;
                                    }
                                    if (byArray[n11] != 47) continue;
                                    bl2 = false;
                                    break;
                                }
                            }
                            n11 = 0;
                            boolean bl6 = false;
                            boolean bl7 = true;
                            n10 = -1;
                            if ((byArray[n] == 47 || byArray[n] == 40 || byArray[n] == 60 && byArray[n + 1] == 102 && byArray[n + 2] == 101 && byArray[n + 3] == 102 && byArray[n + 4] == 102) && n3 != 20 && n4 != 9250) {
                                n9 = 1;
                                n11 = 1;
                            } else {
                                int n15;
                                int n16;
                                int n17;
                                int n18 = -1;
                                if (bl2) {
                                    n17 = n;
                                    while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                        ++n;
                                    }
                                    n16 = PdfReader.parseInt(n12, n, byArray);
                                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                        ++n;
                                    }
                                    n12 = n;
                                    while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                                        ++n;
                                    }
                                    n15 = PdfReader.parseInt(n12, n, byArray);
                                    while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                                        ++n;
                                    }
                                    if (byArray[n] != 82) {
                                        throw new RuntimeException(this.padding + "4. Unexpected value " + (char)byArray[n] + " in file - please send to IDRsolutions for analysis");
                                    }
                                    if (bl && !bl4) {
                                        return n;
                                    }
                                    byArray2 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n16, n15), n16, n15);
                                    if (byArray2 == null) {
                                        pdfObject.setFullyResolved(false);
                                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (14)");
                                        return byArray.length;
                                    }
                                    n8 = 0;
                                    while (byArray2[n8] != 91) {
                                        if (byArray2[n8] == 37) {
                                            while (byArray2[++n8] != 13 && byArray2[n8] != 10) {
                                            }
                                            while (byArray2[n8] == 13 || byArray2[n8] == 10) {
                                                ++n8;
                                            }
                                        }
                                        if (byArray2[n8] == 110 && byArray2[n8 + 1] == 117 && byArray2[n8 + 2] == 108 && byArray2[n8 + 3] == 108) break;
                                        if (byArray2[n8] == 47) {
                                            --n8;
                                            bl6 = true;
                                            break;
                                        }
                                        if (byArray2[n8] == 60 && byArray2[n8 + 1] == 60 || n8 + 4 < byArray2.length && byArray2[n8 + 3] == 60 && byArray2[n8 + 4] == 60) {
                                            n18 = n;
                                            n8 = n17;
                                            byArray2 = byArray;
                                            break;
                                        }
                                        ++n8;
                                    }
                                }
                                if (n8 < 0) {
                                    n8 = 0;
                                }
                                n17 = 0;
                                while (byArray2[n8] == 10 || byArray2[n8] == 13 || byArray2[n8] == 32 || byArray2[n8] == 91 && n17 == 0) {
                                    if (byArray2[n8] == 91) {
                                        n17 = 1;
                                    }
                                    ++n8;
                                }
                                n10 = n8;
                                n15 = 1;
                                int n19 = byArray2.length;
                                while (n10 < n19 && byArray2[n10] != 93) {
                                    int n20;
                                    boolean bl8 = false;
                                    while (byArray2[n10] == 60 && byArray2[n10 + 1] == 60) {
                                        n20 = 1;
                                        ++n9;
                                        while (n20 > 0) {
                                            if (byArray2[++n10] == 60 && byArray2[n10 + 1] == 60) {
                                                ++n10;
                                                ++n20;
                                                continue;
                                            }
                                            if (byArray2[n10] != 62 || byArray2[n10 - 1] != 62) continue;
                                            ++n10;
                                            --n20;
                                        }
                                        if (n3 != 14) continue;
                                        --n10;
                                    }
                                    if (n3 != 18 && byArray2[n10] == 110 && byArray2[n10 + 1] == 117 && byArray2[n10 + 2] == 108 && byArray2[n10 + 3] == 108) {
                                        n20 = 93;
                                        if (n4 == 826881374 || n4 == 1110717793) {
                                            for (int i = n10 + 3; i < byArray2.length; ++i) {
                                                if (byArray2[i] == 10 || byArray2[i] == 13 || byArray2[i] == 32 || byArray2[i] == 9) continue;
                                                n20 = byArray2[i];
                                                i = byArray2.length;
                                            }
                                        }
                                        if (n20 == 93) {
                                            bl7 = true;
                                            n9 = 1;
                                            break;
                                        }
                                        bl7 = false;
                                        n10 += 4;
                                        n15 = 1;
                                        continue;
                                    }
                                    if (bl6 && (byArray2[n10] == 32 || byArray2[n10] == 13 || byArray2[n10] == 10) || n18 != -1 && n10 > n18) break;
                                    if (n3 == 14) {
                                        if (byArray2[n10] == 32) {
                                            ++n14;
                                        }
                                        if (byArray2[n10] == 82 || (n4 == 9250 || n4 == 1248888446) && byArray2[n10] == 47) {
                                            ++n9;
                                        }
                                    } else if (byArray2[n10] == 40) {
                                        ++n9;
                                        while (byArray2[n10] != 41 || PdfReader.isEscaped(byArray2, n10)) {
                                            ++n10;
                                            n15 = 1;
                                        }
                                    } else if (byArray2[n10] == 60) {
                                        ++n9;
                                        while (byArray2[n10] != 62) {
                                            ++n10;
                                            n15 = 1;
                                        }
                                    } else if (byArray2[n10] == 91) {
                                        ++n9;
                                        n20 = 1;
                                        do {
                                            if (byArray2[++n10] == 93) {
                                                --n20;
                                                continue;
                                            }
                                            if (byArray2[n10] != 91) continue;
                                            ++n20;
                                        } while (n20 != 0);
                                        bl8 = true;
                                        n15 = 1;
                                    } else {
                                        int n21 = n16 = byArray2[n10] == 10 || byArray2[n10] == 13 || byArray2[n10] == 32 || byArray2[n10] == 47 ? 1 : 0;
                                        if (n15 != 0 && n16 == 0) {
                                            if ((n3 == 18 || n3 == 22) && byArray2[n10] == 82 && byArray2[n10 - 1] != 47) {
                                                hashMap.put(new Integer(--n9 - 1), "x");
                                            } else {
                                                ++n9;
                                            }
                                        }
                                        n15 = n16;
                                    }
                                    if (!bl8 && n10 < n19 && byArray2[n10] == 93 && n3 != 14) {
                                        n20 = n10 - 1;
                                        while (byArray2[n20] == 13 || byArray2[n20] == 10 || byArray2[n20] == 32) {
                                            --n20;
                                        }
                                        if (n20 != 91) break;
                                        n9 = 0;
                                        break;
                                    }
                                    ++n10;
                                }
                                if (n9 == 0) {
                                    // empty if block
                                }
                            }
                            if (bl && !bl4) {
                                return n10;
                            }
                            fArray = null;
                            nArray = null;
                            dArray = null;
                            object3 = null;
                            object2 = null;
                            object = null;
                            blArray = null;
                            objectArray2 = null;
                            if (n3 == 10) {
                                fArray = new float[n9];
                            } else if (n3 == 9) {
                                nArray = new int[n9];
                            } else if (n3 == 12) {
                                blArray = new boolean[n9];
                            } else if (n3 == 16) {
                                dArray = new double[n9];
                            } else if (n3 == 18) {
                                object3 = new byte[n9][];
                            } else if (n3 == 14) {
                                object2 = new byte[n9][];
                            } else if (n3 == 20) {
                                object = new byte[n9][];
                            } else if (n3 == 22) {
                                objectArray2 = new Object[n9];
                            }
                            if (byArray2[n8] != 110 || byArray2[n8 + 1] != 117 || byArray2[n8 + 2] != 108 || byArray2[n8 + 3] != 108 || !bl7 || n3 == 22 && n9 != 1) break block167;
                            n8 += 3;
                            if (n3 != 18) break block168;
                            object3[n13] = null;
                            break block169;
                        }
                        if (n3 != 14) break block170;
                        object2[n13] = null;
                        break block169;
                    }
                    if (n3 != 20) break block171;
                    object[n13] = null;
                    break block169;
                }
                if (n3 != 22) break block169;
                objectArray2[n13] = null;
                break block169;
            }
            while (byArray2[n8] != 93 && (n10 <= -1 || n8 < n10)) {
                while (byArray2[n8] == 10 || byArray2[n8] == 13 || byArray2[n8] == 32 || byArray2[n8] == 47) {
                    ++n8;
                }
                n12 = n8;
                boolean bl9 = byArray2[n8 - 1] == 47;
                n7 = 0;
                if (n3 == 14 || (n3 == 18 || n3 == 22) && (hashMap.containsKey(new Integer(n13)) || n4 == 1110717793 && byArray2[n8] >= 48 && byArray2[n8] <= 57 || byArray2[n8] == 60 && byArray2[n8 + 1] == 60)) {
                    while (byArray2[n8] != 82 && byArray2[n8] != 93) {
                        if (byArray2[n8] == 60 && byArray2[n8 + 1] == 60) {
                            int n22 = 1;
                            while (n22 > 0) {
                                if (byArray2[++n8] == 60 && byArray2[n8 + 1] == 60) {
                                    ++n8;
                                    ++n22;
                                    continue;
                                }
                                if (byArray2[n8] != 62 || byArray2[n8 + 1] != 62) continue;
                                ++n8;
                                --n22;
                            }
                            break;
                        }
                        if (bl9 && n4 == 9250 && byArray2[n8 + 1] == 32) break;
                        ++n8;
                    }
                    ++n8;
                } else if (byArray2[n8] == 40) {
                    n12 = n8 + 1;
                    while (byArray2[n8] != 41 || PdfReader.isEscaped(byArray2, n8)) {
                        ++n8;
                    }
                    bl3 = false;
                } else if (byArray2[n8] == 91 && n3 == 18 && n4 == 826094945) {
                    n12 = n8;
                    while (byArray2[n8] != 93) {
                        ++n8;
                    }
                    ++n8;
                } else if (byArray2[n8] == 60) {
                    bl3 = true;
                    n12 = n8 + 1;
                    while (byArray2[n8] != 62) {
                        if (byArray2[n8] == 47) {
                            bl3 = false;
                        }
                        ++n8;
                    }
                } else if (byArray2[n8] == 91 && n3 == 22) {
                    int n23 = n8 + 1;
                    int n24 = 1;
                    do {
                        if (byArray2[++n23] == 93) {
                            --n24;
                            continue;
                        }
                        if (byArray2[n23] != 91) continue;
                        ++n24;
                    } while (n24 != 0);
                    if (byArray2[n8 = this.readArray(bl, n8, ++n23, n3, byArray2, string, pdfObject, n4, objectArray2, n13)] != 91) {
                        ++n8;
                    }
                    n7 = 1;
                    while (byArray2[n8] == 93) {
                        ++n8;
                    }
                } else if (!bl9 && n9 - n13 == 1 && n3 == 18) {
                    while (byArray2[n8] != 93 && byArray2[n8] != 47 && (byArray2[n8] != 62 || byArray2[n8 + 1] != 62)) {
                        ++n8;
                    }
                } else {
                    if (n3 == 22 && byArray2[n8] == 110 && byArray2[n8 + 1] == 117 && byArray2[n8 + 2] == 108 && byArray2[n8 + 3] == 108) {
                        n8 += 4;
                        objectArray2[n13] = null;
                        ++n13;
                        continue;
                    }
                    while (byArray2[n8] != 10 && byArray2[n8] != 13 && byArray2[n8] != 32 && byArray2[n8] != 93 && byArray2[n8] != 47 && (byArray2[n8] != 62 || byArray2[n8 + 1] != 62) && ++n8 != byArray2.length) {
                    }
                }
                if (n3 == 10) {
                    fArray[n13] = PdfReader.parseFloat(n12, n8, byArray2);
                } else if (n3 == 9) {
                    nArray[n13] = PdfReader.parseInt(n12, n8, byArray2);
                } else if (n3 == 12) {
                    if (byArray[n12] == 116 && byArray[n12 + 1] == 114 && byArray[n12 + 2] == 117 && byArray[n12 + 3] == 101) {
                        blArray[n13] = true;
                    }
                } else if (n3 == 16) {
                    dArray[n13] = PdfReader.parseFloat(n12, n8, byArray2);
                } else if (n7 == 0) {
                    if (n12 > 0 && byArray2[n12 - 1] == 47) {
                        --n12;
                    }
                    if (n12 > 0 && byArray2[n12] == 91 && n4 != 826094945) {
                        ++n12;
                    }
                    if (n4 == 1110717793 || n4 == 826881374) {
                        while (byArray2[n12] == 110) {
                            while (byArray2[n12] == 110 && byArray2[n12 + 1] == 117 && byArray2[n12 + 2] == 108 && byArray2[n12 + 3] == 108) {
                                n12 += 4;
                                while (n12 >= 0 && (byArray2[n12] == 32 || byArray2[n12] == 10 || byArray2[n12] == 13 || byArray2[n12] == 9)) {
                                    ++n12;
                                }
                            }
                        }
                    }
                    while (n12 >= 0 && (byArray2[n12] == 32 || byArray2[n12] == 10 || byArray2[n12] == 13 || byArray2[n12] == 9)) {
                        ++n12;
                    }
                    byte[] byArray3 = PdfReader.readEscapedValue(n8, byArray2, n12, n4 == 6420);
                    if (n8 != byArray2.length) {
                        if (byArray2[n8] == 62) {
                            ++n8;
                        } else if (byArray2[n8] == 41) {
                            ++n8;
                            try {
                                if (!pdfObject.isInCompressedStream()) {
                                    byArray3 = this.decrypt(byArray3, string, false, null, false, false);
                                }
                            }
                            catch (PdfSecurityException pdfSecurityException) {
                                pdfSecurityException.printStackTrace();
                            }
                            if (n4 == 1110717793) {
                                byArray3 = PdfReader.getTextString(byArray3, false).getBytes();
                            }
                        }
                    }
                    if (n11 != 0) {
                        n = n8;
                    }
                    if (n3 == 18) {
                        object3[n13] = byArray3;
                    } else if (n3 == 14) {
                        object2[n13] = PdfReader.convertReturnsToSpaces(byArray3);
                    } else if (n3 == 20) {
                        if (bl3) {
                            String string2 = new String(byArray3);
                            byte[] byArray4 = new byte[byArray3.length / 2];
                            for (n6 = 0; n6 < byArray3.length; n6 += 2) {
                                if (n6 + 2 > byArray3.length) continue;
                                String string3 = string2.substring(n6, n6 + 2);
                                byArray4[n6 / 2] = (byte)Integer.parseInt(string3, 16);
                            }
                            byArray3 = byArray4;
                        }
                        object[n13] = byArray3;
                    } else if (n3 == 22) {
                        objectArray2[n13] = byArray3;
                    }
                }
                if (++n13 != n9) continue;
                break;
            }
        }
        if (!bl2) {
            n = n8;
        }
        if (n3 == 10) {
            pdfObject.setFloatArray(n4, fArray);
        } else if (n3 == 9) {
            pdfObject.setIntArray(n4, nArray);
        } else if (n3 == 12) {
            pdfObject.setBooleanArray(n4, blArray);
        } else if (n3 == 16) {
            pdfObject.setDoubleArray(n4, dArray);
        } else if (n3 == 18) {
            pdfObject.setMixedArray(n4, (byte[][])object3);
        } else if (n3 == 14) {
            if (n3 == 14 && n9 == 1 && n4 == 1044338049) {
                PdfObject pdfObject2;
                byte[] byArray5;
                byte[] byArray6 = object2[0];
                if (byArray6 == null) {
                    return n;
                }
                n7 = byArray6.length;
                if (byArray6[n7 - 1] == 82 && (byArray5 = this.readObjectData(pdfObject2 = new PdfObject(new String(byArray6)))) != null) {
                    int n25 = 0;
                    int n26 = byArray5.length;
                    n6 = 0;
                    while (n25 < n26 && ++n25 != byArray5.length) {
                        if (byArray5[n25] == 91) {
                            n6 = 1;
                            break;
                        }
                        if (byArray5[n25 - 1] != 60 || byArray5[n25] != 60) continue;
                        n6 = 0;
                        break;
                    }
                    if (n6 != 0) {
                        this.readArray(false, n25, n26, 14, byArray5, new String(byArray6), pdfObject, n4, null, -1);
                    } else {
                        pdfObject.setKeyArray(n4, (byte[][])object2);
                    }
                }
            } else {
                pdfObject.setKeyArray(n4, (byte[][])object2);
            }
        } else if (n3 == 20) {
            pdfObject.setStringArray(n4, (byte[][])object);
        } else if (n3 == 22) {
            byte[] byArray7;
            if (n4 == 1110717793 && objectArray2 != null && objectArray2.length == 1 && objectArray2[0] instanceof byte[] && (byArray7 = (byte[])objectArray2[0])[(n7 = byArray7.length) - 1] == 82) {
                OCObject oCObject = new OCObject(new String(byArray7));
                byte[] byArray8 = this.readObjectData(oCObject);
                int n27 = 0;
                int n28 = byArray8.length;
                n6 = 0;
                while (n27 < n28 && ++n27 != byArray8.length) {
                    if (byArray8[n27] != 91) continue;
                    n6 = 1;
                    break;
                }
                if (n6 != 0) {
                    this.readArray(false, n27, n28, 22, byArray8, new String(byArray7), pdfObject, n4, null, -1);
                }
                objectArray2 = null;
            }
            if (objectArray != null) {
                objectArray[n5] = objectArray2;
            } else if (objectArray2 != null) {
                pdfObject.setObjectArray(n4, objectArray2);
            }
        }
        if (n < byArray.length && (byArray[n] == 47 || byArray[n] == 62)) {
            --n;
        }
        return n;
    }

    private static byte[] convertReturnsToSpaces(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        int n2 = 0;
        int n3 = byArray.length;
        for (n = 0; n < n3; ++n) {
            if (byArray[n] != 13 || byArray[n + 1] != 10) continue;
            ++n;
            ++n2;
        }
        if (n2 > 0) {
            n = n3 - n2;
            int n4 = 0;
            byte[] byArray2 = byArray;
            byArray = new byte[n];
            for (int i = 0; i < n3; ++i) {
                if (byArray2[i] == 13 && i < n3 - 1 && byArray2[i + 1] == 10) {
                    byArray[n4] = 32;
                    ++i;
                } else {
                    byArray[n4] = byArray2[i];
                }
                ++n4;
            }
        }
        return byArray;
    }

    private static String showMixedValuesAsString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "null";
        }
        string = string + '[';
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == null) {
                string = string + "null ";
                continue;
            }
            if (objectArray[i] instanceof byte[]) {
                string = string + new String((byte[])objectArray[i]);
                if (n - i <= 1) continue;
                string = string + " , ";
                continue;
            }
            string = PdfReader.showMixedValuesAsString((Object[])objectArray[i], string) + "]";
            if (n - i <= 1) continue;
            string = string + " ,";
        }
        return string;
    }

    public final byte[] readStream(PdfObject pdfObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        byte[] byArray;
        boolean bl6 = pdfObject.isCached();
        byte[] byArray2 = null;
        if (!bl6) {
            byArray2 = pdfObject.getDecodedStream();
        }
        if (byArray2 == null) {
            int n;
            String string2 = pdfObject.getObjectRefAsString();
            byArray = pdfObject.stream;
            if (bl6) {
                try {
                    if (!(bl5 || !this.isMetaDataEncypted && bl4)) {
                        this.decrypt(null, string2, false, string, false, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    byArray = null;
                    LogWriter.writeLog("Exception " + exception);
                }
            }
            if (byArray != null) {
                try {
                    if (!(bl5 || !this.isMetaDataEncypted && bl4 || pdfObject.getObjectType() == 2087749783 && string2.startsWith("["))) {
                        byArray = this.decrypt(byArray, string2, false, null, false, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    byArray = null;
                    LogWriter.writeLog("Exception " + exception + " with " + string2);
                }
            }
            if (bl3) {
                pdfObject.stream = null;
            }
            int n2 = 1;
            if (byArray != null || bl6) {
                int n3;
                int n4;
                n = 1;
                int n5 = 1;
                int n6 = pdfObject.getInt(959926393);
                if (n6 != -1) {
                    n = n6;
                }
                if ((n4 = pdfObject.getInt(959726687)) != -1) {
                    n5 = n4;
                }
                if ((n3 = pdfObject.getInt(1043816557)) != -1) {
                    n2 = n3;
                }
                if (n * n5 == 1) {
                    n5 = n2;
                }
                PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
                int n7 = -1;
                if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                    n7 = pdfArrayIterator.getNextValueAsConstant(false);
                }
                if (pdfArrayIterator != null && n7 != -1 && n7 != 1399277700 && n7 != 1180911742) {
                    try {
                        byArray = this.decodeFilters(this.setupDecodeParms(pdfObject), byArray, pdfArrayIterator, n5, n, true, string);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Problem " + exception + " decompressing stream ");
                        byArray = null;
                        bl6 = false;
                    }
                    n2 = 1;
                } else if (byArray != null && n2 != -1 && n2 < byArray.length) {
                    if (byArray.length != n2 && n2 > 0) {
                        byte[] byArray3 = new byte[n2];
                        System.arraycopy(byArray, 0, byArray3, 0, n2);
                        byArray = byArray3;
                    } else if (byArray.length == 1 && n2 == 0) {
                        byArray = new byte[]{};
                    }
                }
            }
            if (byArray != null && bl) {
                pdfObject.setDecodedStream(byArray);
            }
            if (bl2 && bl6) {
                n = (int)new File(string).length();
                byte[] byArray4 = new byte[n];
                try {
                    new BufferedInputStream(new FileInputStream(string)).read(byArray4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (n2 != 1 && n2 < n) {
                    byte[] byArray5 = new byte[n2];
                    System.arraycopy(byArray4, 0, byArray5, 0, n2);
                    byArray4 = byArray5;
                }
                return byArray4;
            }
        } else {
            byArray = byArray2;
        }
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray, 0, byArray6, 0, n);
        return byArray6;
    }

    public PdfObject[] setupDecodeParms(PdfObject pdfObject) {
        PdfObject[] pdfObjectArray;
        Object[] objectArray = pdfObject.getObjectArray(1888135062);
        if (objectArray != null) {
            int n = objectArray.length;
            pdfObjectArray = new PdfObject[n];
            for (int i = 0; i < n; ++i) {
                byte[] byArray = (byte[])objectArray[i];
                if (byArray != null) {
                    String string = new String(byArray);
                    DecodeParmsObject decodeParmsObject = new DecodeParmsObject(string);
                    if (byArray[0] == 60) {
                        decodeParmsObject.setStatus(2);
                    } else {
                        decodeParmsObject.setStatus(1);
                    }
                    decodeParmsObject.setUnresolvedData(byArray, 1888135062);
                    this.checkResolved(decodeParmsObject);
                    pdfObjectArray[i] = decodeParmsObject;
                    continue;
                }
                pdfObjectArray[i] = null;
            }
        } else {
            pdfObjectArray = new PdfObject[]{pdfObject.getDictionary(1888135062)};
        }
        return pdfObjectArray;
    }

    public final void readObject(PdfObject pdfObject) {
        byte[] byArray;
        String string = pdfObject.getObjectRefAsString();
        if (pdfObject.isDataExternal() && this.linHintTable != null && pdfObject.isDataExternal() && this.linHintTable != null) {
            int n = pdfObject.getObjectRefID();
            int n2 = pdfObject.getObjectRefGeneration();
            byte[] byArray2 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n, n2), n, n2);
            pdfObject.setStatus(2);
            pdfObject.setUnresolvedData(byArray2, 540096309);
            this.resolveFully(pdfObject);
            return;
        }
        boolean bl = this.isCompressed(string);
        pdfObject.setCompressedStream(bl);
        if (bl) {
            int n = Integer.parseInt(string.substring(0, string.indexOf(32)));
            int n3 = this.getCompressedStreamObject(string);
            String string2 = n3 + " 0 R";
            String string3 = null;
            int n4 = this.lastFirst;
            boolean bl2 = true;
            byte[] byArray3 = this.lastCompressedStream;
            HashMap hashMap = this.lastOffsetStart;
            HashMap hashMap2 = this.lastOffsetEnd;
            PdfObject pdfObject2 = null;
            if (this.lastOffsetStart != null && n3 == this.lastCompressedID) {
                string3 = (String)this.lastOffsetStart.get(String.valueOf(n));
            }
            while (string3 == null) {
                if (pdfObject2 != null) {
                    this.compressedObj = pdfObject2;
                } else if (n3 != this.lastCompressedID) {
                    bl2 = false;
                    try {
                        this.movePointer(string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception moving pointer to " + string);
                    }
                    byArray = this.readObjectData(this.ObjLengthTable[n3], null);
                    this.compressedObj = new CompressedObject(string2);
                    this.readDictionaryAsObject(this.compressedObj, string, 0, byArray, -1, false);
                }
                hashMap = new HashMap();
                hashMap2 = new HashMap();
                n4 = this.compressedObj.getInt(960643930);
                byArray3 = this.compressedObj.getDecodedStream();
                this.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray3, n3);
                string3 = (String)hashMap.get(String.valueOf(n));
                pdfObject2 = this.compressedObj.getDictionary(894663815);
                if (pdfObject2 != null) continue;
            }
            if (!bl2) {
                this.lastCompressedStream = byArray3;
                this.lastCompressedID = n3;
                this.lastOffsetStart = hashMap;
                this.lastOffsetEnd = hashMap2;
                this.lastFirst = n4;
            }
            int n5 = n4 + Integer.parseInt(string3);
            int n6 = byArray3.length;
            String string4 = (String)hashMap2.get(String.valueOf(n));
            if (string4 != null) {
                n6 = n4 + Integer.parseInt(string4);
            }
            int n7 = n6 - n5;
            byArray = new byte[n7];
            System.arraycopy(byArray3, n5, byArray, 0, n7);
            pdfObject.setInCompressedStream(true);
        } else {
            try {
                this.movePointer(string);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception moving pointer to " + string);
            }
            if (string.charAt(0) == '<') {
                byArray = this.readObjectData(-1, pdfObject);
            } else {
                int n = string.indexOf(32);
                int n8 = Integer.parseInt(string.substring(0, n));
                if (this.ObjLengthTable == null || this.refTableInvalid) {
                    byArray = this.getPointer() == 0L ? new byte[]{} : this.readObjectData(-1, pdfObject);
                } else if (n8 > this.ObjLengthTable.length || this.ObjLengthTable[n8] == 0) {
                    LogWriter.writeLog(string + " cannot have offset 0");
                    byArray = new byte[]{};
                } else {
                    byArray = this.readObjectData(this.ObjLengthTable[n8], pdfObject);
                }
            }
        }
        if (byArray.length > 1) {
            this.readDictionaryAsObject(pdfObject, string, 0, byArray, -1, false);
        }
    }

    private byte[] readObjectData(PdfObject pdfObject) {
        byte[] byArray;
        byte[] byArray2;
        String string = pdfObject.getObjectRefAsString();
        if (pdfObject.isDataExternal() && (byArray2 = this.readObjectAsByteArray(pdfObject, string, false, pdfObject.getObjectRefID(), 0)) == null) {
            pdfObject.setFullyResolved(false);
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (15)");
            return byArray2;
        }
        boolean bl = this.isCompressed(string);
        pdfObject.setCompressedStream(bl);
        if (bl) {
            int n = Integer.parseInt(string.substring(0, string.indexOf(32)));
            int n2 = this.getCompressedStreamObject(string);
            String string2 = n2 + " 0 R";
            String string3 = null;
            int n3 = this.lastFirst;
            boolean bl2 = true;
            byte[] byArray3 = this.lastCompressedStream;
            HashMap hashMap = this.lastOffsetStart;
            HashMap hashMap2 = this.lastOffsetEnd;
            PdfObject pdfObject2 = null;
            if (this.lastOffsetStart != null) {
                string3 = (String)this.lastOffsetStart.get(String.valueOf(n));
            }
            while (string3 == null) {
                if (pdfObject2 != null) {
                    this.compressedObj = pdfObject2;
                } else if (n2 != this.lastCompressedID) {
                    bl2 = false;
                    try {
                        this.movePointer(string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception moving pointer to " + string);
                    }
                    byArray = this.readObjectData(this.ObjLengthTable[n2], null);
                    this.compressedObj = new CompressedObject(string2);
                    this.readDictionaryAsObject(this.compressedObj, string, 0, byArray, -1, false);
                }
                hashMap = new HashMap();
                hashMap2 = new HashMap();
                n3 = this.compressedObj.getInt(960643930);
                byArray3 = this.compressedObj.getDecodedStream();
                this.extractCompressedObjectOffset(hashMap, hashMap2, n3, byArray3, n2);
                string3 = (String)hashMap.get(String.valueOf(n));
                pdfObject2 = this.compressedObj.getDictionary(894663815);
                if (pdfObject2 != null) continue;
            }
            if (!bl2) {
                this.lastCompressedStream = byArray3;
                this.lastCompressedID = n2;
                this.lastOffsetStart = hashMap;
                this.lastOffsetEnd = hashMap2;
                this.lastFirst = n3;
            }
            int n4 = n3 + Integer.parseInt(string3);
            int n5 = byArray3.length;
            String string4 = (String)hashMap2.get(String.valueOf(n));
            if (string4 != null) {
                n5 = n3 + Integer.parseInt(string4);
            }
            int n6 = n5 - n4;
            byArray = new byte[n6];
            System.arraycopy(byArray3, n4, byArray, 0, n6);
            pdfObject.setInCompressedStream(true);
        } else {
            try {
                this.movePointer(string);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception moving pointer to " + string);
            }
            if (string.charAt(0) == '<') {
                byArray = this.readObjectData(-1, pdfObject);
            } else {
                int n = string.indexOf(32);
                int n7 = Integer.parseInt(string.substring(0, n));
                if (this.ObjLengthTable == null || this.refTableInvalid) {
                    byArray = this.getPointer() == 0L ? new byte[]{} : this.readObjectData(-1, pdfObject);
                } else if (n7 > this.ObjLengthTable.length || this.ObjLengthTable[n7] == 0) {
                    LogWriter.writeLog(string + " cannot have offset 0");
                    byArray = new byte[]{};
                } else {
                    byArray = this.readObjectData(this.ObjLengthTable[n7], pdfObject);
                }
            }
        }
        return byArray;
    }

    public byte[] readObjectAsByteArray(PdfObject pdfObject, String string, boolean bl, int n, int n2) {
        byte[] byArray;
        if (pdfObject.isDataExternal()) {
            if (this.linHintTable != null) {
                return this.linHintTable.getObjData(n);
            }
            return null;
        }
        if (bl) {
            int n3 = this.getCompressedStreamObject(n, n2);
            String string2 = null;
            HashMap hashMap = this.lastOffsetStart;
            HashMap hashMap2 = this.lastOffsetEnd;
            int n4 = this.lastFirst;
            boolean bl2 = true;
            byte[] byArray2 = this.lastCompressedStream;
            if (this.lastOffsetStart != null) {
                string2 = (String)this.lastOffsetStart.get(String.valueOf(n));
            }
            while (string2 == null) {
                bl2 = false;
                try {
                    this.movePointer(n3, 0);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception moving pointer to " + n);
                }
                byArray = this.readObjectData(this.ObjLengthTable[n3], null);
                String string3 = n3 + " " + n2 + " R";
                CompressedObject compressedObject = new CompressedObject(string3);
                this.readDictionaryAsObject(compressedObject, string, 0, byArray, -1, false);
                hashMap = new HashMap();
                hashMap2 = new HashMap();
                n4 = ((PdfObject)compressedObject).getInt(960643930);
                byArray2 = compressedObject.getDecodedStream();
                this.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray2, n3);
                string2 = (String)hashMap.get(String.valueOf(n));
                PdfObject pdfObject2 = ((PdfObject)compressedObject).getDictionary(894663815);
                String string4 = pdfObject2 == null ? null : pdfObject2.getObjectRefAsString();
                if (string4 == null) continue;
                n3 = Integer.parseInt(string4.substring(0, string4.indexOf(32)));
            }
            if (!bl2) {
                this.lastCompressedStream = byArray2;
                this.lastOffsetStart = hashMap;
                this.lastOffsetEnd = hashMap2;
                this.lastFirst = n4;
            }
            int n5 = n4 + Integer.parseInt(string2);
            int n6 = byArray2.length;
            String string5 = (String)hashMap2.get(String.valueOf(n));
            if (string5 != null) {
                n6 = n4 + Integer.parseInt(string5);
            }
            int n7 = n6 - n5;
            byArray = new byte[n7];
            System.arraycopy(byArray2, n5, byArray, 0, n7);
            pdfObject.setInCompressedStream(true);
        } else {
            try {
                this.movePointer(n, n2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception moving pointer to " + string);
            }
            if (this.ObjLengthTable == null || this.refTableInvalid) {
                byArray = this.readObjectData(-1, pdfObject);
            } else {
                if (n > this.ObjLengthTable.length) {
                    return null;
                }
                byArray = this.readObjectData(this.ObjLengthTable[n], pdfObject);
            }
        }
        return byArray;
    }

    public void storeLinearizedTables(LinearizedHintTable linearizedHintTable) {
        this.linHintTable = linearizedHintTable;
    }

    private void extractCompressedObjectOffset(Map map, Map map2, int n, byte[] byArray, int n2) {
        String string = null;
        Object var10_7 = null;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5 = i;
            while (byArray[i] != 32 && byArray[i] != 13 && byArray[i] != 10) {
                ++i;
            }
            int n6 = i - 1;
            int n7 = n6 - n5 + 1;
            char[] cArray = new char[n7];
            n3 = -1;
            for (n4 = 0; n4 < n7; ++n4) {
                cArray[n4] = (char)byArray[n5 + n4];
            }
            String string2 = new String(cArray);
            n3 = PdfReader.parseInt(n5, n5 + n7, byArray);
            while (byArray[i] == 32 || byArray[i] == 13 || byArray[i] == 10) {
                ++i;
            }
            int n8 = i;
            while (byArray[i] != 32 && byArray[i] != 13 && byArray[i] != 10 && i < n) {
                ++i;
            }
            int n9 = i - 1;
            n7 = n9 - n8 + 1;
            cArray = new char[n7];
            for (n4 = 0; n4 < n7; ++n4) {
                cArray[n4] = (char)byArray[n8 + n4];
            }
            String string3 = new String(cArray);
            if (n2 != this.offset.elementAt(n3)) continue;
            map.put(string2, string3);
            if (string != null) {
                map2.put(string, string3);
            }
            string = string2;
        }
    }

    public final PdfObject readFDF() throws PdfException {
        FDFObject fDFObject;
        int n = -1;
        int n2 = -1;
        try {
            int n3;
            n = (int)this.pdf_datafile.length();
            this.pdf_datafile.readLine();
            n2 = (int)this.pdf_datafile.getFilePointer();
            byte[] byArray = new byte[n -= n2];
            this.pdf_datafile.read(byArray);
            fDFObject = new FDFObject("1 0 R");
            for (n3 = 0; n3 < n && (byArray[n3] != 47 || byArray[n3 + 1] != 70 || byArray[n3 + 2] != 68 || byArray[n3 + 3] != 70); ++n3) {
            }
            n3 += 4;
            while (n3 < n && (byArray[n3] != 60 || byArray[n3 + 1] != 60)) {
                ++n3;
            }
            this.readDictionaryAsObject(fDFObject, "1 0 R", n3 += 2, byArray, byArray.length, false);
        }
        catch (Exception exception) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + exception + " closing file");
            }
            throw new PdfException("Exception " + exception + " reading trailer");
        }
        return fDFObject;
    }

    public int getPDFflag(Integer n) {
        if (n.equals(PDFflags.USER_ACCESS_PERMISSIONS)) {
            return this.P;
        }
        if (n.equals(PDFflags.VALID_PASSWORD_SUPPLIED)) {
            return this.passwordStatus;
        }
        return -1;
    }

    public final PdfObject readReferenceTable(PdfObject pdfObject) throws PdfException {
        int n = -1;
        int n2 = (int)this.eof;
        if (pdfObject == null) {
            n = this.readFirstStartRef();
        } else {
            byte[] byArray = this.getPdfBuffer();
            int n3 = byArray.length;
            for (int i = 0; i < n3; ++i) {
                if (byArray[i] != 120 || byArray[i + 1] != 114 || byArray[i + 2] != 101 || byArray[i + 3] != 102) continue;
                n = i;
                i = n3;
            }
        }
        this.xref.addElement(n);
        if (n >= n2) {
            LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            this.refTableInvalid = true;
            return this.findOffsets();
        }
        if (this.isCompressedStream(n, n2)) {
            return this.readCompressedStream(n);
        }
        return this.readLegacyReferenceTable(n, n2);
    }

    private static int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }

    private PdfObject readCompressedStream(int n) throws PdfException {
        PdfObject pdfObject = null;
        PdfObject pdfObject2 = null;
        while (n != -1) {
            int[] nArray;
            try {
                this.movePointer(n);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception moving pointer to " + n);
            }
            byte[] byArray = this.readObjectData(-1, null);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 32;
            int n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                char c = (char)byArray[i];
                if (c == '\n' || c == '\r') {
                    c = ' ';
                }
                if (c == ' ' && n2 == 32) {
                    n3 = 0;
                } else if (c == pattern.charAt(n3)) {
                    ++n3;
                } else {
                    n3 = 0;
                    stringBuffer.append(c);
                }
                if (n3 == 3) break;
                n2 = c;
            }
            stringBuffer.append('R');
            String string = stringBuffer.toString();
            CompressedObject compressedObject = new CompressedObject(string);
            compressedObject.setCompressedStream(true);
            this.readDictionaryAsObject(compressedObject, string, 0, byArray, -1, false);
            int[] nArray2 = ((PdfObject)compressedObject).getIntArray(39);
            byte[] byArray2 = compressedObject.getDecodedStream();
            if (byArray2 == null) {
                byArray2 = this.readStream(compressedObject, true, true, false, false, true, null);
            }
            if ((nArray = ((PdfObject)compressedObject).getIntArray(1043608929)) == null) {
                this.readCompressedOffsets(0, 0, ((PdfObject)compressedObject).getInt(590957109), nArray2, byArray2);
            } else {
                int n4 = nArray.length;
                int n5 = 0;
                for (int i = 0; i < n4; i += 2) {
                    n5 = this.readCompressedOffsets(n5, nArray[i], nArray[i + 1], nArray2, byArray2);
                }
            }
            if (pdfObject2 == null) {
                byte[][] byArray3;
                pdfObject2 = ((PdfObject)compressedObject).getDictionary(574570308);
                pdfObject = ((PdfObject)compressedObject).getDictionary(1113489015);
                if (pdfObject != null && (byArray3 = ((PdfObject)compressedObject).getStringArray(6420)) != null) {
                    this.ID = byArray3[0];
                }
                this.infoObject = ((PdfObject)compressedObject).getDictionary(423507519);
            }
            n = ((PdfObject)compressedObject).getInt(541209926);
        }
        if (pdfObject != null) {
            this.readEncryptionObject(pdfObject.getUnresolvedData());
        }
        this.calculateObjectLength();
        return pdfObject2;
    }

    private int readCompressedOffsets(int n, int n2, int n3, int[] nArray, byte[] byArray) throws PdfException {
        int[] nArray2 = new int[]{1, 0, 0};
        boolean bl = false;
        block5: for (int i = 0; i < n3; ++i) {
            int n4;
            int[] nArray3 = new int[3];
            for (n4 = 0; n4 < 3; ++n4) {
                if (nArray[n4] == 0) {
                    nArray3[n4] = nArray2[n4];
                    continue;
                }
                nArray3[n4] = PdfReader.getWord(byArray, n, nArray[n4]);
                n += nArray[n4];
            }
            switch (nArray3[0]) {
                case 0: {
                    ++n2;
                    bl = nArray3[1] == 0 && nArray3[2] == 0;
                    continue block5;
                }
                case 1: {
                    n4 = nArray3[1];
                    int n5 = nArray3[2];
                    boolean bl2 = true;
                    if (n2 == n4) {
                        int n6;
                        bl2 = false;
                        int n7 = 20;
                        byte[] byArray2 = this.getBytesFromPDF(n2, n7);
                        int n8 = 0;
                        for (n6 = 0; n6 < n7; ++n6) {
                            if (byArray2[n6] != 32 && byArray2[n6] != 10 && byArray2[n6] != 13) continue;
                            n8 = n6;
                            n6 = n7;
                        }
                        if (n8 > 0 && (n6 = PdfReader.parseInt(0, n8, byArray2)) == n2) {
                            bl2 = true;
                        }
                    }
                    if (bl2 || !bl) {
                        this.storeObjectOffset(n2, n4, n5, false);
                    }
                    ++n2;
                    continue block5;
                }
                case 2: {
                    n4 = nArray3[1];
                    int n5 = nArray3[2];
                    this.storeObjectOffset(n2, n4, 0, true);
                    ++n2;
                    continue block5;
                }
                default: {
                    throw new PdfException("Exception Unsupported Compression mode with value " + nArray3[0]);
                }
            }
        }
        return n;
    }

    private boolean isCompressedStream(int n, int n2) throws PdfException {
        int n3 = 50;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[]{79, 98, 106, 83, 116, 109};
        int[] nArray2 = new int[]{88, 82, 101, 102};
        int n7 = -1;
        while (true) {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            if (n3 < 0) {
                n3 = 50;
            }
            byte[] byArray = new byte[n3];
            this.movePointer(n);
            try {
                this.pdf_datafile.read(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new PdfException("Exception " + exception + " scanning trailer for ref or obj");
            }
            for (int i = 0; i < n3; ++i) {
                byte by = byArray[i];
                if (by == oldPattern[n4] && n7 != 1) {
                    ++n4;
                    n7 = 2;
                } else if (by == nArray[n5] && (n5 == 0 || n7 == 1)) {
                    ++n5;
                    n7 = 1;
                } else if (by == nArray2[n6] && (n6 == 0 || n7 == 1)) {
                    ++n6;
                    n7 = 1;
                } else {
                    n4 = 0;
                    n5 = 0;
                    n6 = 0;
                    n7 = -1;
                }
                if (n4 == 3 || n5 == 3 || n6 == 3) break;
            }
            if (n4 == 3 || n5 == 3 || n6 == 3) break;
            n += n3;
        }
        if (n7 == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception 1 closing file");
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return n7 == 1;
    }

    private PdfObject readLegacyReferenceTable(int n, int n2) throws PdfException {
        PdfObject pdfObject = null;
        PdfObject pdfObject2 = null;
        int n3 = 0;
        byte[] byArray = null;
        int n4 = 1024;
        int n5 = 0;
        do {
            int n6;
            try {
                byArray = this.readTrailer(n4, n, n2);
            }
            catch (Exception exception) {
                byArray = null;
                try {
                    this.pdf_datafile.close();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + exception + " closing file");
                }
                throw new PdfException("Exception " + exception + " reading trailer");
            }
            if (byArray == null) break;
            int n7 = byArray.length;
            for (n6 = 0; n6 < n7 && (byArray[n6] != 116 || byArray[n6 + 1] != 114 || byArray[n6 + 2] != 97 || byArray[n6 + 3] != 105 || byArray[n6 + 4] != 108 || byArray[n6 + 5] != 101 || byArray[n6 + 6] != 114); ++n6) {
            }
            n5 = n6;
            if (n6 == byArray.length) break;
            while (byArray[n6] != 60 && byArray[n6 - 1] != 60) {
                ++n6;
            }
            CompressedObject compressedObject = new CompressedObject("1 0 R");
            this.readDictionary(compressedObject, "1 0 R", ++n6, byArray, "", false, -1, true);
            int n8 = 0;
            while (true) {
                if (byArray[n6] == 60 && byArray[n6 - 1] == 60) {
                    ++n8;
                    ++n6;
                } else if (byArray[n6] == 91) {
                    ++n6;
                    while (byArray[n6] != 93 && ++n6 != byArray.length) {
                    }
                } else if (byArray[n6] == 62 && byArray[n6 - 1] == 62) {
                    --n8;
                    ++n6;
                }
                if (n8 == 0) break;
                ++n6;
            }
            int n9 = ((PdfObject)compressedObject).getInt(910911090);
            if (n9 != -1) {
                n = n9;
            } else {
                boolean bl = true;
                while (byArray[n6] != 116 && byArray[n6 + 1] != 120 && byArray[n6 + 2] != 114 && byArray[n6 + 3] != 101 && byArray[n6 + 4] != 102) {
                    if (byArray[n6] == 111 && byArray[n6 + 1] == 98 && byArray[n6 + 2] == 106) {
                        bl = false;
                        break;
                    }
                    ++n6;
                }
                if (bl) {
                    n6 += 8;
                    while (n6 < n7 && (byArray[n6] == 10 || byArray[n6] == 32 || byArray[n6] == 13)) {
                        ++n6;
                    }
                    int n10 = n6;
                    while (n6 < n7 && byArray[n6] != 10 && byArray[n6] != 32 && byArray[n6] != 13) {
                        ++n6;
                    }
                    if (n10 != n6) {
                        n = PdfReader.parseInt(n10, n6, byArray);
                    }
                }
            }
            n6 = 0;
            while (byArray[n6] == 13 || byArray[n6] == 10 || byArray[n6] == 9) {
                ++n6;
            }
            if (n == -1) {
                LogWriter.writeLog("No startRef");
                continue;
            }
            if (byArray[n6] == 120 && byArray[n6 + 1] == 114 && byArray[n6 + 2] == 101 && byArray[n6 + 3] == 102) {
                n6 = 5;
                while (byArray[n6] == 10 || byArray[n6] == 32 || byArray[n6] == 13) {
                    ++n6;
                }
                n3 = this.readXRefs(n3, byArray, n5, n6);
                n6 = n5;
                if (pdfObject2 == null) {
                    byte[][] byArray2;
                    pdfObject2 = ((PdfObject)compressedObject).getDictionary(574570308);
                    pdfObject = ((PdfObject)compressedObject).getDictionary(1113489015);
                    if (pdfObject != null && (byArray2 = ((PdfObject)compressedObject).getStringArray(6420)) != null) {
                        this.ID = byArray2[0];
                    }
                    this.infoObject = ((PdfObject)compressedObject).getDictionary(423507519);
                }
                if ((n = ((PdfObject)compressedObject).getInt(541209926)) != -1 && (long)n < this.eof) {
                    n4 = 1024;
                    this.xref.addElement(n);
                    continue;
                }
                n = -1;
                continue;
            }
            n = -1;
            pdfObject2 = this.findOffsets();
            this.refTableInvalid = true;
        } while (n != -1);
        if (pdfObject != null) {
            this.readEncryptionObject(pdfObject.getUnresolvedData());
        }
        if (!this.refTableInvalid) {
            this.calculateObjectLength();
        }
        return pdfObject2;
    }

    private void calculateObjectLength() {
        int n;
        int n2;
        this.xref.addElement((int)this.eof);
        int[] nArray = this.xref.get();
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = n2;
        }
        nArray2 = Sorts.quicksort(nArray, nArray2);
        n2 = this.offset.getCapacity();
        this.ObjLengthTable = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = this.offset.get();
        boolean[] blArray = this.isCompressed.get();
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            nArray4[n] = nArray5[n];
            nArray3[n] = n;
        }
        nArray3 = Sorts.quicksort(nArray4, nArray3);
        n = 0;
        while (nArray4[nArray3[n]] == 0) {
            ++n;
        }
        int n4 = nArray4[nArray3[n]];
        int n5 = 0;
        while (nArray[nArray2[n5]] < n4 + 1) {
            ++n5;
        }
        while (n < n2 - 1) {
            int n6 = nArray4[nArray3[n + 1]];
            int n7 = n6 - n4 - 1;
            if (nArray[nArray2[n5]] < n6) {
                n7 = nArray[nArray2[n5]] - n4 - 1;
                while (nArray[nArray2[n5]] < n6 + 1) {
                    ++n5;
                }
            }
            this.ObjLengthTable[nArray3[n]] = n7;
            n4 = n6;
            while (nArray[nArray2[n5]] < n4 + 1) {
                ++n5;
            }
            ++n;
        }
        this.ObjLengthTable[nArray3[n]] = nArray[nArray2[n5]] - n4 - 1;
    }

    private int readXRefs(int n, byte[] byArray, int n2, int n3) {
        boolean bl = false;
        boolean bl2 = true;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        while (n3 < n2) {
            int n4;
            int n5 = n3;
            int n6 = -1;
            while (byArray[n3] != 10 & byArray[n3] != 13) {
                if (n6 == -1 && byArray[n3] == 37) {
                    n6 = n3 - 1;
                }
                ++n3;
            }
            if (n6 == -1) {
                n6 = n3 - 1;
            }
            while (byArray[n5] == 32) {
                ++n5;
            }
            while (byArray[n6] == 32) {
                --n6;
            }
            ++n3;
            int n7 = 0;
            int n8 = n6 - n5 + 1;
            if (n8 <= 0) continue;
            int n9 = 1;
            for (n4 = 1; n4 < n8; ++n4) {
                int n10 = byArray[n5 + n4];
                if (n10 == 32 && n9 != 32) {
                    nArray[n7] = n4;
                    ++n7;
                } else if (n10 != 32 && n9 == 32) {
                    nArray2[n7] = n4;
                }
                n9 = n10;
            }
            nArray[n7] = n8;
            if (++n7 == 1) {
                if (bl) {
                    bl = false;
                    continue;
                }
                n = PdfReader.parseInt(n5, n5 + nArray[0], byArray);
                bl = true;
                continue;
            }
            if (n7 == 2) {
                n = PdfReader.parseInt(n5, n5 + nArray[0], byArray);
                continue;
            }
            int n11 = PdfReader.parseInt(n5, n5 + nArray[0], byArray);
            int n12 = PdfReader.parseInt(n5 + nArray2[1], n5 + nArray[1], byArray);
            char c = (char)byArray[n5 + nArray2[2]];
            if (c == 'n') {
                n4 = 0;
                int n13 = 20;
                if ((long)(n11 + n13) > this.eof) {
                    n13 = (int)(this.eof - (long)n11);
                }
                if (n13 > 0) {
                    byte[] byArray2 = new byte[n13];
                    this.movePointer(n11);
                    try {
                        this.pdf_datafile.read(byArray2);
                        for (int i = 4; i < n13; ++i) {
                            if (byArray2[i - 3] != 32 && byArray2[i - 3] != 10 || byArray2[i - 2] != 111 || byArray2[i - 1] != 98 || byArray2[i] != 106) continue;
                            n4 = 1;
                            i = n13;
                        }
                        if (n4 != 0 && bl2) {
                            bl2 = false;
                            if (byArray2[0] == 48 && byArray2[1] != 48 && n == 1) {
                                n = 0;
                            }
                        }
                        if (n4 != 0) {
                            this.storeObjectOffset(n, n11, n12, false);
                            this.xref.addElement(n11);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                ++n;
                continue;
            }
            if (c != 'f') continue;
            ++n;
        }
        return n;
    }

    public static int parseInt(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        --n;
        for (int i = n2 - 1; i > n; --i) {
            if (byArray[i] == 45) {
                bl = true;
                continue;
            }
            n3 += (byArray[i] - 48) * powers[n4];
            ++n4;
        }
        if (bl) {
            return -n3;
        }
        return n3;
    }

    public static double parseDouble(int n, int n2, byte[] byArray) {
        int n3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = n2;
        int n5 = n;
        boolean bl = false;
        for (n3 = n2 - 1; n3 > n - 1; --n3) {
            if (byArray[n3] != 46) continue;
            n4 = n3;
            break;
        }
        n3 = n4;
        int n6 = n4;
        if (byArray[n] == 43) {
            --n3;
            ++n5;
        } else if (byArray[n] == 45) {
            ++n5;
            bl = true;
        }
        int n7 = n3 - n5;
        int n8 = n2 - n4;
        if (n7 > 4) {
            bl = false;
            int n9 = n2 - n;
            byte[] byArray2 = new byte[n9];
            System.arraycopy(byArray, n, byArray2, 0, n9);
            d = Double.parseDouble(new String(byArray2));
        } else {
            int n10;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            if (n7 > 3) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        d4 = 1000.0;
                        break;
                    }
                    case 2: {
                        d4 = 2000.0;
                        break;
                    }
                    case 3: {
                        d4 = 3000.0;
                        break;
                    }
                    case 4: {
                        d4 = 4000.0;
                        break;
                    }
                    case 5: {
                        d4 = 5000.0;
                        break;
                    }
                    case 6: {
                        d4 = 6000.0;
                        break;
                    }
                    case 7: {
                        d4 = 7000.0;
                        break;
                    }
                    case 8: {
                        d4 = 8000.0;
                        break;
                    }
                    case 9: {
                        d4 = 9000.0;
                    }
                }
                ++n5;
            }
            if (n7 > 2) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        d7 = 100.0;
                        break;
                    }
                    case 2: {
                        d7 = 200.0;
                        break;
                    }
                    case 3: {
                        d7 = 300.0;
                        break;
                    }
                    case 4: {
                        d7 = 400.0;
                        break;
                    }
                    case 5: {
                        d7 = 500.0;
                        break;
                    }
                    case 6: {
                        d7 = 600.0;
                        break;
                    }
                    case 7: {
                        d7 = 700.0;
                        break;
                    }
                    case 8: {
                        d7 = 800.0;
                        break;
                    }
                    case 9: {
                        d7 = 900.0;
                    }
                }
                ++n5;
            }
            if (n7 > 1) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        d6 = 10.0;
                        break;
                    }
                    case 2: {
                        d6 = 20.0;
                        break;
                    }
                    case 3: {
                        d6 = 30.0;
                        break;
                    }
                    case 4: {
                        d6 = 40.0;
                        break;
                    }
                    case 5: {
                        d6 = 50.0;
                        break;
                    }
                    case 6: {
                        d6 = 60.0;
                        break;
                    }
                    case 7: {
                        d6 = 70.0;
                        break;
                    }
                    case 8: {
                        d6 = 80.0;
                        break;
                    }
                    case 9: {
                        d6 = 90.0;
                    }
                }
                ++n5;
            }
            if (n7 > 0) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        d5 = 1.0;
                        break;
                    }
                    case 2: {
                        d5 = 2.0;
                        break;
                    }
                    case 3: {
                        d5 = 3.0;
                        break;
                    }
                    case 4: {
                        d5 = 4.0;
                        break;
                    }
                    case 5: {
                        d5 = 5.0;
                        break;
                    }
                    case 6: {
                        d5 = 6.0;
                        break;
                    }
                    case 7: {
                        d5 = 7.0;
                        break;
                    }
                    case 8: {
                        d5 = 8.0;
                        break;
                    }
                    case 9: {
                        d5 = 9.0;
                    }
                }
            }
            if (n8 > 1) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        d8 = 0.1f;
                        break;
                    }
                    case 2: {
                        d8 = 0.2f;
                        break;
                    }
                    case 3: {
                        d8 = 0.3f;
                        break;
                    }
                    case 4: {
                        d8 = 0.4f;
                        break;
                    }
                    case 5: {
                        d8 = 0.5;
                        break;
                    }
                    case 6: {
                        d8 = 0.6f;
                        break;
                    }
                    case 7: {
                        d8 = 0.7f;
                        break;
                    }
                    case 8: {
                        d8 = 0.8f;
                        break;
                    }
                    case 9: {
                        d8 = 0.9f;
                    }
                }
            }
            if (n8 > 2) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        d9 = 0.01f;
                        break;
                    }
                    case 2: {
                        d9 = 0.02f;
                        break;
                    }
                    case 3: {
                        d9 = 0.03f;
                        break;
                    }
                    case 4: {
                        d9 = 0.04f;
                        break;
                    }
                    case 5: {
                        d9 = 0.05f;
                        break;
                    }
                    case 6: {
                        d9 = 0.06f;
                        break;
                    }
                    case 7: {
                        d9 = 0.07f;
                        break;
                    }
                    case 8: {
                        d9 = 0.08f;
                        break;
                    }
                    case 9: {
                        d9 = 0.09f;
                    }
                }
            }
            if (n8 > 3) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        d10 = 0.001f;
                        break;
                    }
                    case 2: {
                        d10 = 0.002f;
                        break;
                    }
                    case 3: {
                        d10 = 0.003f;
                        break;
                    }
                    case 4: {
                        d10 = 0.004f;
                        break;
                    }
                    case 5: {
                        d10 = 0.005f;
                        break;
                    }
                    case 6: {
                        d10 = 0.006f;
                        break;
                    }
                    case 7: {
                        d10 = 0.007f;
                        break;
                    }
                    case 8: {
                        d10 = 0.008f;
                        break;
                    }
                    case 9: {
                        d10 = 0.009f;
                    }
                }
            }
            if (n8 > 4) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        d11 = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        d11 = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        d11 = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        d11 = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        d11 = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        d11 = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        d11 = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        d11 = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        d11 = 9.0E-4f;
                    }
                }
            }
            if (n8 > 5) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        d12 = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        d12 = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        d12 = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        d12 = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        d12 = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        d12 = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        d12 = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        d12 = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        d12 = 9.0E-5f;
                    }
                }
            }
            if (n8 > 6) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        d13 = 1.0E-6f;
                        break;
                    }
                    case 2: {
                        d13 = 2.0E-6f;
                        break;
                    }
                    case 3: {
                        d13 = 3.0E-6f;
                        break;
                    }
                    case 4: {
                        d13 = 4.0E-6f;
                        break;
                    }
                    case 5: {
                        d13 = 5.0E-6f;
                        break;
                    }
                    case 6: {
                        d13 = 6.0E-6f;
                        break;
                    }
                    case 7: {
                        d13 = 7.0E-6f;
                        break;
                    }
                    case 8: {
                        d13 = 8.0E-6f;
                        break;
                    }
                    case 9: {
                        d13 = 9.0E-6f;
                    }
                }
            }
            d2 = d8 + d9 + d10 + d11 + d12 + d13;
            d3 = d4 + d7 + d6 + d5;
            d = d3 + d2;
        }
        if (bl) {
            return -d;
        }
        return d;
    }

    public static float parseFloat(int n, int n2, byte[] byArray) {
        float f;
        int n3;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n4 = n2;
        int n5 = n;
        boolean bl = false;
        for (n3 = n2 - 1; n3 > n - 1; --n3) {
            if (byArray[n3] != 46) continue;
            n4 = n3;
            break;
        }
        n3 = n4;
        int n6 = n4;
        if (byArray[n] == 43) {
            --n3;
            ++n5;
        } else if (byArray[n] == 45) {
            ++n5;
            bl = true;
        }
        int n7 = n3 - n5;
        int n8 = n2 - n4;
        if (n7 > 4) {
            bl = false;
            int n9 = n2 - n;
            byte[] byArray2 = new byte[n9];
            System.arraycopy(byArray, n, byArray2, 0, n9);
            f = Float.parseFloat(new String(byArray2));
        } else {
            int n10;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            if (n7 > 3) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        f4 = 1000.0f;
                        break;
                    }
                    case 2: {
                        f4 = 2000.0f;
                        break;
                    }
                    case 3: {
                        f4 = 3000.0f;
                        break;
                    }
                    case 4: {
                        f4 = 4000.0f;
                        break;
                    }
                    case 5: {
                        f4 = 5000.0f;
                        break;
                    }
                    case 6: {
                        f4 = 6000.0f;
                        break;
                    }
                    case 7: {
                        f4 = 7000.0f;
                        break;
                    }
                    case 8: {
                        f4 = 8000.0f;
                        break;
                    }
                    case 9: {
                        f4 = 9000.0f;
                    }
                }
                ++n5;
            }
            if (n7 > 2) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        f7 = 100.0f;
                        break;
                    }
                    case 2: {
                        f7 = 200.0f;
                        break;
                    }
                    case 3: {
                        f7 = 300.0f;
                        break;
                    }
                    case 4: {
                        f7 = 400.0f;
                        break;
                    }
                    case 5: {
                        f7 = 500.0f;
                        break;
                    }
                    case 6: {
                        f7 = 600.0f;
                        break;
                    }
                    case 7: {
                        f7 = 700.0f;
                        break;
                    }
                    case 8: {
                        f7 = 800.0f;
                        break;
                    }
                    case 9: {
                        f7 = 900.0f;
                    }
                }
                ++n5;
            }
            if (n7 > 1) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        f6 = 10.0f;
                        break;
                    }
                    case 2: {
                        f6 = 20.0f;
                        break;
                    }
                    case 3: {
                        f6 = 30.0f;
                        break;
                    }
                    case 4: {
                        f6 = 40.0f;
                        break;
                    }
                    case 5: {
                        f6 = 50.0f;
                        break;
                    }
                    case 6: {
                        f6 = 60.0f;
                        break;
                    }
                    case 7: {
                        f6 = 70.0f;
                        break;
                    }
                    case 8: {
                        f6 = 80.0f;
                        break;
                    }
                    case 9: {
                        f6 = 90.0f;
                    }
                }
                ++n5;
            }
            if (n7 > 0) {
                n10 = byArray[n5] - 48;
                switch (n10) {
                    case 1: {
                        f5 = 1.0f;
                        break;
                    }
                    case 2: {
                        f5 = 2.0f;
                        break;
                    }
                    case 3: {
                        f5 = 3.0f;
                        break;
                    }
                    case 4: {
                        f5 = 4.0f;
                        break;
                    }
                    case 5: {
                        f5 = 5.0f;
                        break;
                    }
                    case 6: {
                        f5 = 6.0f;
                        break;
                    }
                    case 7: {
                        f5 = 7.0f;
                        break;
                    }
                    case 8: {
                        f5 = 8.0f;
                        break;
                    }
                    case 9: {
                        f5 = 9.0f;
                    }
                }
            }
            if (n8 > 1) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f8 = 0.1f;
                        break;
                    }
                    case 2: {
                        f8 = 0.2f;
                        break;
                    }
                    case 3: {
                        f8 = 0.3f;
                        break;
                    }
                    case 4: {
                        f8 = 0.4f;
                        break;
                    }
                    case 5: {
                        f8 = 0.5f;
                        break;
                    }
                    case 6: {
                        f8 = 0.6f;
                        break;
                    }
                    case 7: {
                        f8 = 0.7f;
                        break;
                    }
                    case 8: {
                        f8 = 0.8f;
                        break;
                    }
                    case 9: {
                        f8 = 0.9f;
                    }
                }
            }
            if (n8 > 2) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f9 = 0.01f;
                        break;
                    }
                    case 2: {
                        f9 = 0.02f;
                        break;
                    }
                    case 3: {
                        f9 = 0.03f;
                        break;
                    }
                    case 4: {
                        f9 = 0.04f;
                        break;
                    }
                    case 5: {
                        f9 = 0.05f;
                        break;
                    }
                    case 6: {
                        f9 = 0.06f;
                        break;
                    }
                    case 7: {
                        f9 = 0.07f;
                        break;
                    }
                    case 8: {
                        f9 = 0.08f;
                        break;
                    }
                    case 9: {
                        f9 = 0.09f;
                    }
                }
            }
            if (n8 > 3) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f10 = 0.001f;
                        break;
                    }
                    case 2: {
                        f10 = 0.002f;
                        break;
                    }
                    case 3: {
                        f10 = 0.003f;
                        break;
                    }
                    case 4: {
                        f10 = 0.004f;
                        break;
                    }
                    case 5: {
                        f10 = 0.005f;
                        break;
                    }
                    case 6: {
                        f10 = 0.006f;
                        break;
                    }
                    case 7: {
                        f10 = 0.007f;
                        break;
                    }
                    case 8: {
                        f10 = 0.008f;
                        break;
                    }
                    case 9: {
                        f10 = 0.009f;
                    }
                }
            }
            if (n8 > 4) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f11 = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        f11 = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        f11 = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        f11 = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        f11 = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        f11 = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        f11 = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        f11 = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        f11 = 9.0E-4f;
                    }
                }
            }
            if (n8 > 5) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f12 = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        f12 = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        f12 = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        f12 = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        f12 = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        f12 = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        f12 = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        f12 = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        f12 = 9.0E-5f;
                    }
                }
            }
            if (n8 > 6) {
                n10 = byArray[++n6] - 48;
                switch (n10) {
                    case 1: {
                        f13 = 1.0E-6f;
                        break;
                    }
                    case 2: {
                        f13 = 2.0E-6f;
                        break;
                    }
                    case 3: {
                        f13 = 3.0E-6f;
                        break;
                    }
                    case 4: {
                        f13 = 4.0E-6f;
                        break;
                    }
                    case 5: {
                        f13 = 5.0E-6f;
                        break;
                    }
                    case 6: {
                        f13 = 6.0E-6f;
                        break;
                    }
                    case 7: {
                        f13 = 7.0E-6f;
                        break;
                    }
                    case 8: {
                        f13 = 8.0E-6f;
                        break;
                    }
                    case 9: {
                        f13 = 9.0E-6f;
                    }
                }
            }
            f2 = f8 + f9 + f10 + f11 + f12 + f13;
            f3 = f4 + f7 + f6 + f5;
            f = f3 + f2;
        }
        if (bl) {
            return -f;
        }
        return f;
    }

    private byte[] readTrailer(int n, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            if (n2 + n > n3) {
                n = n3 - n2;
            }
            if (n == 0) break;
            byte[] byArray = new byte[n];
            this.movePointer(n2);
            this.pdf_datafile.read(byArray);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                n4 = by == EOFpattern[n4] ? ++n4 : 0;
                n5 = by == trailerpattern[n5] ? ++n5 : 0;
                if (n5 == 7) {
                    ++n6;
                    n5 = 0;
                }
                if (n4 != 4 && n6 != 2) continue;
                for (int j = 0; j < i + 1; ++j) {
                    byteArrayOutputStream.write(byArray[j]);
                }
                i = n;
                bl = true;
            }
            if (!bl) {
                byteArrayOutputStream.write(byArray);
            }
            n2 += n;
        } while (n4 != 4 && n6 != 2);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public final PdfFileInformation readPdfFileMetadata(PdfObject pdfObject) {
        if (this.infoObject != null && (!this.isEncrypted || this.isPasswordSupplied)) {
            this.readInformationObject(this.infoObject);
        }
        if (pdfObject != null) {
            String string = new String(pdfObject.getUnresolvedData());
            MetadataObject metadataObject = new MetadataObject(string);
            this.readObject(metadataObject);
            byte[] byArray = metadataObject.getDecodedStream();
            this.currentFileInformation.setFileXMLMetaData(byArray);
        }
        return this.currentFileInformation;
    }

    public final boolean isEncrypted() {
        return this.isEncrypted;
    }

    public final boolean isPasswordSupplied() {
        return this.isPasswordSupplied;
    }

    public final boolean isExtractionAllowed() {
        return this.extractionIsAllowed;
    }

    public boolean isFileViewable() {
        return this.isFileViewable;
    }

    public synchronized boolean resolveFully(PdfObject pdfObject) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        try {
            if (pdfObject == null) {
                return false;
            }
            byte[] byArray = null;
            byArray = pdfObject.getStatus() == 0 ? pdfObject.getObjectRefAsString().getBytes() : pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            String string = pdfObject.getObjectRefAsString();
            if (byArray[0] != 101 || byArray[1] != 110 || byArray[2] != 100 || byArray[3] != 111 || byArray[4] != 98) {
                int n3 = 0;
                while (byArray[n3] == 91 || byArray[n3] == 32 || byArray[n3] == 13 || byArray[n3] == 10) {
                    ++n3;
                }
                int n4 = n3;
                int n5 = n3;
                while (byArray[n3] != 10 && byArray[n3] != 13 && byArray[n3] != 32 && byArray[n3] != 47 && byArray[n3] != 60 && byArray[n3] != 62) {
                    ++n3;
                }
                n = PdfReader.parseInt(n4, n3, byArray);
                while (byArray[n3] == 10 || byArray[n3] == 13 || byArray[n3] == 32) {
                    ++n3;
                }
                n4 = n3;
                while (byArray[n3] != 10 && byArray[n3] != 13 && byArray[n3] != 32 && byArray[n3] != 47 && byArray[n3] != 60 && byArray[n3] != 62) {
                    ++n3;
                }
                n2 = PdfReader.parseInt(n4, n3, byArray);
                if (byArray[byArray.length - 1] == 82) {
                    pdfObject.setRef(new String(byArray));
                    pdfObject.isDataExternal(true);
                    byte[] byArray2 = this.readObjectAsByteArray(pdfObject, string, this.isCompressed(n, n2), n, n2);
                    if (byArray2 == null) {
                        pdfObject.setFullyResolved(false);
                        return false;
                    }
                    pdfObject.setStatus(2);
                    pdfObject.setUnresolvedData(byArray2, 2004845231);
                    pdfObject.isDataExternal(true);
                    if (!this.resolveFully(pdfObject)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
                pdfObject.ignoreRecursion(false);
                this.readDictionaryAsObject(pdfObject, n + " " + n2 + " R", n3, byArray, byArray.length, false);
                if (!pdfObject.isFullyResolved()) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void checkResolved(PdfObject pdfObject) {
        String string = "";
        if (pdfObject == null || pdfObject.getStatus() == 0) {
            return;
        }
        byte[] byArray = pdfObject.getUnresolvedData();
        pdfObject.setStatus(0);
        if (byArray[0] != 101 || byArray[1] != 110 || byArray[2] != 100 || byArray[3] != 111 || byArray[4] != 98) {
            String string2 = pdfObject.getObjectRefAsString();
            if (byArray[byArray.length - 1] == 82) {
                pdfObject.setRef(new String(byArray));
            }
            this.readDictionaryFromRefOrDirect(-1, pdfObject, string2, 0, byArray, -1);
        }
    }

    public PdfObject getPDFObject(int n) {
        if (n == 1113489015) {
            return this.encyptionObj;
        }
        throw new RuntimeException("Access to " + n + " not supported");
    }

    private byte[] decrypt(byte[] byArray, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws PdfSecurityException {
        if (this.isEncrypted || bl) {
            int n;
            Object object;
            BufferedOutputStream bufferedOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            boolean bl4 = false;
            byte[] byArray2 = null;
            if (string2 != null) {
                try {
                    Object object2;
                    if (byArray == null) {
                        byArray2 = new byte[16];
                        object2 = new FileInputStream(string2);
                        ((FileInputStream)object2).read(byArray2);
                        ((FileInputStream)object2).close();
                    }
                    object2 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
                    this.cachedObjects.put(((File)object2).getAbsolutePath(), "x");
                    ObjectStore.copy(string2, ((File)object2).getAbsolutePath());
                    object = new File(string2);
                    ((File)object).delete();
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                    bufferedInputStream = new BufferedInputStream(new FileInputStream((File)object2));
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + iOException + " in decrypt");
                }
            }
            int n2 = this.keyLength;
            object = "RC4";
            String string3 = "RC4";
            IvParameterSpec ivParameterSpec = null;
            PdfObject pdfObject = !bl3 ? this.StmFObj : this.StrFObj;
            if (!bl2 && pdfObject == null && this.isAESIdentity) {
                return byArray;
            }
            if (pdfObject != null) {
                String string4;
                int n3 = pdfObject.getInt(1043816557);
                if (n3 != -1) {
                    n2 = n3;
                }
                if ((string4 = pdfObject.getName(1250845)) != null && string4.equals("AESV2") && !bl2) {
                    this.cipher = null;
                    object = "AES/CBC/PKCS5Padding";
                    string3 = "AES";
                    bl4 = true;
                    byte[] byArray3 = new byte[16];
                    if (byArray2 != null) {
                        System.arraycopy(byArray2, 0, byArray3, 0, 16);
                    } else {
                        System.arraycopy(byArray, 0, byArray3, 0, 16);
                    }
                    ivParameterSpec = new IvParameterSpec(byArray3);
                    if (byArray == null) {
                        try {
                            bufferedInputStream.skip(16L);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else {
                        int n4 = byArray.length;
                        n = n4 - 16;
                        byte[] byArray4 = new byte[n];
                        System.arraycopy(byArray, 16, byArray4, 0, n);
                        byArray = byArray4;
                        int n5 = byArray.length & 0xF;
                        int n6 = byArray.length;
                        if (n5 > 0) {
                            n6 = n6 + 16 - n5;
                            byArray4 = new byte[n6];
                            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
                            byArray = byArray4;
                        }
                    }
                }
            }
            byte[] byArray5 = new byte[n2];
            if (string.length() > 0) {
                byArray5 = new byte[n2 + 5];
            }
            System.arraycopy(this.encryptionKey, 0, byArray5, 0, n2);
            try {
                if (string.length() > 0) {
                    int n7 = string.indexOf(32);
                    int n8 = string.indexOf(32, n7 + 1);
                    int n9 = Integer.parseInt(string.substring(0, n7));
                    n = Integer.parseInt(string.substring(n7 + 1, n8));
                    byArray5[n2] = (byte)(n9 & 0xFF);
                    byArray5[n2 + 1] = (byte)(n9 >> 8 & 0xFF);
                    byArray5[n2 + 2] = (byte)(n9 >> 16 & 0xFF);
                    byArray5[n2 + 3] = (byte)(n & 0xFF);
                    byArray5[n2 + 4] = (byte)(n >> 8 & 0xFF);
                }
                byte[] byArray6 = new byte[Math.min(byArray5.length, 16)];
                if (string.length() > 0) {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.update(byArray5);
                    if (bl4 && n2 >= 16) {
                        byte[] byArray7 = new byte[]{115, 65, 108, 84};
                        messageDigest.update(byArray7);
                    }
                    System.arraycopy(messageDigest.digest(), 0, byArray6, 0, byArray6.length);
                } else {
                    System.arraycopy(byArray5, 0, byArray6, 0, byArray6.length);
                }
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance((String)object);
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray6, string3);
                if (bl) {
                    this.cipher.init(1, secretKeySpec);
                } else if (ivParameterSpec == null) {
                    this.cipher.init(2, secretKeySpec);
                } else {
                    this.cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                }
                if (bufferedOutputStream != null) {
                    CipherInputStream cipherInputStream = new CipherInputStream(bufferedInputStream, this.cipher);
                    while ((n = cipherInputStream.read()) != -1) {
                        bufferedOutputStream.write(n);
                    }
                    cipherInputStream.close();
                    bufferedOutputStream.close();
                    bufferedInputStream.close();
                }
                if (byArray != null) {
                    byArray = this.cipher.doFinal(byArray);
                }
            }
            catch (Exception exception) {
                throw new PdfSecurityException("Exception " + exception + " decrypting content");
            }
        }
        if (alwaysReinitCipher) {
            this.cipher = null;
        }
        return byArray;
    }

    private byte[] getPaddedKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        int n = byArray.length;
        if (n > 32) {
            n = 32;
        }
        System.arraycopy(this.encryptionPassword, 0, byArray2, 0, n);
        for (int i = n; i < 32; ++i) {
            byArray2[i] = (byte)Integer.parseInt(pad[i - n], 16);
        }
        return byArray2;
    }

    private boolean testPassword() throws PdfSecurityException {
        int n;
        int n2 = 32;
        byte[] byArray = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray[i] = (byte)Integer.parseInt(pad[i], 16);
        }
        byte[] byArray2 = ObjectCloneFactory.cloneArray(byArray);
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byArray2 = this.decrypt(byArray2, "", true, null, false, false);
        } else if (this.rev >= 3) {
            int n3;
            n = this.keyLength;
            if (this.rev == 4 && this.StmFObj != null && (n3 = this.StmFObj.getInt(1043816557)) != -1) {
                n = n3;
            }
            n2 = 16;
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byte[] byArray3 = ObjectCloneFactory.cloneArray(this.encryptionKey);
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with digest");
            }
            messageDigest.update(byArray2);
            byte[] byArray4 = messageDigest.digest(this.ID);
            byArray4 = this.decrypt(byArray4, "", true, null, true, false);
            byte[] byArray5 = new byte[n];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < n; ++j) {
                    byArray5[j] = (byte)(byArray3[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray4 = this.decrypt(byArray4, "", true, null, true, false);
            }
            this.encryptionKey = byArray3;
            byArray2 = new byte[32];
            System.arraycopy(byArray4, 0, byArray2, 0, 16);
            System.arraycopy(byArray, 0, byArray2, 16, 16);
        }
        n = 1;
        for (int i = 0; i < n2; ++i) {
            if (this.U[i] == byArray2[i]) continue;
            n = 0;
            i = this.U.length;
        }
        return n != 0;
    }

    private void computeEncryptionKey() throws PdfSecurityException {
        byte[] byArray = this.getPaddedKey(this.encryptionPassword);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            this.encryptionKey = messageDigest.digest(byArray);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    this.encryptionKey = messageDigest.digest(this.encryptionKey);
                }
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        int n;
        byte[] byArray = this.encryptionPassword;
        byte[] byArray2 = new byte[this.keyLength];
        byte[] byArray3 = ObjectCloneFactory.cloneArray(this.O);
        this.computeEncryptionKey();
        byte[] byArray4 = ObjectCloneFactory.cloneArray(this.encryptionKey);
        if (this.rev == 2) {
            byArray2 = this.decrypt(ObjectCloneFactory.cloneArray(this.O), "", false, null, false, false);
        } else if (this.rev >= 3) {
            int n2;
            n = this.keyLength;
            if (this.rev == 4 && this.StmFObj != null && (n2 = this.StmFObj.getInt(1043816557)) != -1) {
                n = n2;
            }
            byArray2 = byArray3;
            byte[] byArray5 = new byte[n];
            for (int i = 19; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    byArray5[j] = (byte)(byArray4[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray2 = this.decrypt(byArray2, "", false, null, true, false);
            }
        }
        this.encryptionPassword = byArray2;
        this.computeEncryptionKey();
        n = this.testPassword() ? 1 : 0;
        if (n == 0) {
            this.encryptionPassword = byArray;
            this.computeEncryptionKey();
        }
        return n != 0;
    }

    private PdfObject findOffsets() throws PdfSecurityException {
        Object object;
        String string;
        block7: {
            LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
            string = "";
            try {
                this.movePointer(0L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (true) {
                int n;
                object = null;
                int n2 = (int)this.getPointer();
                try {
                    object = this.pdf_datafile.readLine();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " reading line");
                }
                if (object == null) break block7;
                if (((String)object).indexOf(" obj") != -1) {
                    int n3 = ((String)object).indexOf(32);
                    if (n3 <= -1) continue;
                    n = Integer.parseInt(((String)object).substring(0, n3));
                    this.storeObjectOffset(n, n2, 1, false);
                    continue;
                }
                if (((String)object).indexOf("/Root") != -1) {
                    int n4 = ((String)object).indexOf("/Root") + 5;
                    n = ((String)object).indexOf(82, n4);
                    if (n <= -1) continue;
                    string = ((String)object).substring(n4, n + 1).trim();
                    continue;
                }
                if (((String)object).indexOf("/Encrypt") != -1) break;
            }
            throw new PdfSecurityException("Corrupted, encrypted file");
        }
        object = new PageObject(string);
        this.readObject((PdfObject)object);
        return object;
    }

    private void readEncryptionObject(byte[] byArray) throws PdfSecurityException {
        int n;
        int n2;
        this.stringsEncoded = false;
        this.isMetaDataEncypted = true;
        this.StmFObj = null;
        this.StrFObj = null;
        this.isAES = false;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        if (this.encyptionObj == null) {
            this.encyptionObj = new EncryptionObject(new String(byArray));
            this.readObject(this.encyptionObj);
        }
        if ((n2 = this.encyptionObj.getInt(38)) == 3) {
            throw new PdfSecurityException("Unsupported Custom Adobe Encryption method");
        }
        if (n2 > 4) {
            PdfArrayIterator pdfArrayIterator = this.encyptionObj.getMixedArray(1011108731);
            int n3 = -1;
            if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                n3 = pdfArrayIterator.getNextValueAsConstant(false);
            }
            if (n3 != 1467315058) {
                throw new PdfSecurityException("Unsupported Encryption method");
            }
        }
        if ((n = this.encyptionObj.getInt(1043816557) >> 3) != -1) {
            this.keyLength = n;
        }
        this.rev = this.encyptionObj.getInt(34);
        this.P = this.encyptionObj.getInt(32);
        this.O = this.encyptionObj.getTextStreamValueAsByte(31);
        this.U = this.encyptionObj.getTextStreamValueAsByte(37);
        if (n2 == 4) {
            PdfKeyPairsIterator pdfKeyPairsIterator;
            this.isAES = true;
            PdfObject pdfObject = this.encyptionObj.getDictionary(4886);
            this.isMetaDataEncypted = this.encyptionObj.getBoolean(-1815804199);
            this.isAESIdentity = false;
            String string = this.encyptionObj.getName(591675926);
            if (string != null) {
                this.isAESIdentity = string.equals("Identity");
                this.stringsEncoded = true;
                pdfKeyPairsIterator = pdfObject.getKeyPairsIterator();
                while (pdfKeyPairsIterator.hasMorePairs()) {
                    String string2 = pdfKeyPairsIterator.getNextKeyAsString();
                    if (string2.equals(string)) {
                        this.StrFObj = pdfKeyPairsIterator.getNextValueAsDictionary();
                    }
                    pdfKeyPairsIterator.nextPair();
                }
            }
            if ((string = this.encyptionObj.getName(591674646)) != null) {
                this.isAESIdentity = string.equals("Identity");
                pdfKeyPairsIterator = pdfObject.getKeyPairsIterator();
                while (pdfKeyPairsIterator.hasMorePairs()) {
                    String string3 = pdfKeyPairsIterator.getNextKeyAsString();
                    if (string3.equals(string)) {
                        this.StmFObj = pdfKeyPairsIterator.getNextValueAsDictionary();
                    }
                    pdfKeyPairsIterator.nextPair();
                }
            }
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        LogWriter.writeLog("File has encryption settings");
        try {
            this.verifyAccess();
        }
        catch (PdfSecurityException pdfSecurityException) {
            LogWriter.writeLog("File requires password");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        this.isPasswordSupplied = false;
        this.extractionIsAllowed = false;
        this.passwordStatus = 0;
        boolean bl = this.testOwnerPassword();
        boolean bl2 = this.testPassword();
        if (bl) {
            this.passwordStatus = 2;
        }
        if (bl2) {
            ++this.passwordStatus;
        }
        if (!bl) {
            if (!bl2) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword.length > 0) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) != 16) return;
            this.extractionIsAllowed = true;
            return;
        } else {
            LogWriter.writeLog("Correct owner password supplied");
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
        }
    }

    private byte[] calculateKey(byte[] byArray, int n, byte[] byArray2) throws PdfSecurityException {
        byte[] byArray3;
        MessageDigest messageDigest = null;
        byte[] byArray4 = null;
        byte[] byArray5 = this.getPaddedKey(this.encryptionPassword);
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray5);
            messageDigest.update(byArray);
            byArray3 = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
            messageDigest.update(byArray3);
            messageDigest.update(byArray2);
            byte[] byArray6 = new byte[]{-1, -1, -1, -1};
            if (this.rev == 4 && !this.isMetaDataEncypted) {
                messageDigest.update(byArray6);
            }
            byte[] byArray7 = new byte[this.keyLength];
            System.arraycopy(messageDigest.digest(), 0, byArray7, 0, this.keyLength);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    System.arraycopy(messageDigest.digest(byArray7), 0, byArray7, 0, this.keyLength);
                }
            }
            byArray4 = new byte[this.keyLength];
            System.arraycopy(byArray7, 0, byArray4, 0, this.keyLength);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
        byArray3 = new byte[this.keyLength];
        System.arraycopy(byArray4, 0, byArray3, 0, this.keyLength);
        return byArray3;
    }

    private void readInformationObject(PdfObject pdfObject) {
        try {
            this.checkResolved(pdfObject);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Info Object failed");
        }
        int n = PdfFileInformation.information_field_IDs.length;
        for (int i = 0; i < n; ++i) {
            String string;
            int n2 = PdfFileInformation.information_field_IDs[i];
            if (n2 == 1080325989) {
                string = pdfObject.getName(n2);
                if (string == null) {
                    string = "";
                }
            } else {
                byte[] byArray = pdfObject.getTextStreamValueAsByte(n2);
                string = byArray == null ? "" : PdfReader.getTextString(byArray, false);
            }
            this.currentFileInformation.setFieldValue(i, string);
        }
    }

    public byte[] getPdfBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    public static String getTextString(byte[] byArray, boolean bl) {
        String string = "";
        StandardFonts.checkLoaded(6);
        char[] cArray = null;
        if (byArray != null) {
            cArray = new char[byArray.length];
        }
        int n = 0;
        Object var6_5 = null;
        TextTokens textTokens = new TextTokens(byArray);
        if (textTokens.isUnicode()) {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextUnicodeToken();
                if (c == '\t') {
                    cArray[n] = 32;
                    ++n;
                    continue;
                }
                if (c <= '\u001f' && (!bl || c != '\n' && c != '\r')) continue;
                cArray[n] = c;
                ++n;
            }
        } else {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextToken();
                if (c == '\t') {
                    cArray[n] = 32;
                    ++n;
                    continue;
                }
                if (bl && (c == '\n' || c == '\r')) {
                    cArray[n] = c;
                    ++n;
                    continue;
                }
                if (c <= '\u001f' || c >= '\u00fd') continue;
                String string2 = StandardFonts.getEncodedChar(6, c);
                int n2 = string2.length();
                if (n + n2 >= cArray.length) {
                    char[] cArray2 = new char[n2 + n + 10];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                }
                for (int i = 0; i < n2; ++i) {
                    cArray[n] = string2.charAt(i);
                    ++n;
                }
            }
        }
        if (cArray != null) {
            string = String.copyValueOf(cArray, 0, n);
        }
        return string;
    }

    public void readNames(PdfObject pdfObject, Javascript javascript, boolean bl) {
        this.checkResolved(pdfObject);
        int[] nArray = new int[]{893600855, -2006286978};
        int n = nArray.length;
        if (bl) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            PdfArrayIterator pdfArrayIterator;
            int n2;
            PdfObject pdfObject2 = bl ? pdfObject : pdfObject.getDictionary(nArray[i]);
            if (pdfObject2 == null) continue;
            byte[][] byArray = pdfObject2.getKeyArray(456733763);
            if (byArray != null && (n2 = byArray.length) > 0) {
                for (int j = 0; j < n2; ++j) {
                    String string = new String(byArray[j]);
                    NamesObject namesObject = new NamesObject(string);
                    namesObject.ignoreRecursion(false);
                    this.readObject(namesObject);
                    this.readNames(namesObject, javascript, true);
                }
            }
            if ((pdfArrayIterator = pdfObject2.getMixedArray(826094945)) == null || pdfArrayIterator.getTokenCount() <= 0) continue;
            while (pdfArrayIterator.hasMoreTokens()) {
                String string = pdfArrayIterator.getNextValueAsString(true);
                String string2 = pdfArrayIterator.getNextValueAsString(true);
                if (nArray[i] == -2006286978) continue;
                this.nameLookup.put(string, string2);
            }
        }
    }

    public String convertNameToRef(String string) {
        return (String)this.nameLookup.get(string);
    }

    public void setCacheSize(int n) {
        this.newCacheSize = n;
    }

    public void dispose() {
        this.cachedColorspaces = null;
        this.cachedObjects = null;
        this.cipher = null;
        this.compressedObj = null;
        this.currentFileInformation = null;
        this.offset = null;
        this.generation = null;
        this.isCompressed = null;
        this.xref = null;
        try {
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.linHintTable != null) {
            this.linHintTable = null;
        }
        this.pdf_datafile = null;
    }

    static {
        String string = System.getProperty("org.jpedal.cipher.reinit");
        if (string != null && string.toLowerCase().equals("true")) {
            alwaysReinitCipher = true;
        }
        powers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }
}

