/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfException;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.io.RandomAccessMemoryMapBuffer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_boolean;

public class PdfFileReader {
    protected Map cachedObjects = new HashMap();
    protected Map cachedColorspaces = new HashMap();
    protected LinearizedHintTable linHintTable;
    boolean isFDF = false;
    protected RandomAccessBuffer pdf_datafile = null;
    protected int currentGeneration = 0;
    protected long eof = 0L;
    protected Vector_Int offset = new Vector_Int(2000);
    protected Vector_boolean isCompressed = new Vector_boolean(2000);
    protected Vector_Int generation = new Vector_Int(2000);
    public static int alwaysCacheInMemory = 16384;
    private String tempFileName = null;

    protected final long movePointer(int n, int n2) {
        this.currentGeneration = n2;
        long l = this.offset.elementAt(n);
        return this.movePointer(l);
    }

    protected final long movePointer(String string) {
        long l = this.getOffset(string);
        return this.movePointer(l);
    }

    public final String getType() {
        String string = "";
        try {
            this.movePointer(0L);
            string = this.pdf_datafile.readLine();
            int n = string.indexOf("%PDF");
            if (n != -1) {
                string = string.substring(n + 5);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in reading type");
        }
        return string;
    }

    public final void openPdfFile(InputStream inputStream) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessMemoryMapBuffer(inputStream);
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final void openPdfFile(String string) throws PdfException {
        this.isFDF = string.toLowerCase().endsWith(".fdf");
        try {
            this.pdf_datafile = new RandomAccessFileBuffer(string, "r");
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final void openPdfFile(byte[] byArray) throws PdfException {
        try {
            if (alwaysCacheInMemory == -1 || byArray.length < alwaysCacheInMemory) {
                this.pdf_datafile = new RandomAccessDataBuffer(byArray);
            } else {
                try {
                    File file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
                    this.tempFileName = file.getAbsolutePath();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    this.pdf_datafile = new RandomAccessFileBuffer(this.tempFileName, "r");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
        LogWriter.writeMethod("{openPdfFile} EOF=" + this.eof, 0);
    }

    protected final long movePointer(long l) {
        long l2 = 0L;
        try {
            if (l > this.eof) {
                LogWriter.writeLog("Attempting to access ref outside file");
            } else {
                l2 = this.getPointer();
                this.pdf_datafile.seek(l);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " moving pointer to  " + l + " in file. EOF =" + this.eof);
        }
        return l2;
    }

    protected final long getPointer() {
        long l = 0L;
        try {
            l = this.pdf_datafile.getFilePointer();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting pointer in file");
        }
        return l;
    }

    public final void closePdfFile() {
        try {
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
                this.pdf_datafile = null;
            }
            if (this.tempFileName != null) {
                File file = new File(this.tempFileName);
                file.delete();
                this.tempFileName = null;
            }
            if (this.cachedObjects != null) {
                for (String string : this.cachedObjects.keySet()) {
                    File file = new File(string);
                    file.delete();
                    if (!file.exists()) continue;
                    LogWriter.writeLog("Unable to delete temp file " + string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing file");
        }
        this.cachedColorspaces.clear();
    }

    protected final void storeObjectOffset(int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = 0;
        if (n < this.generation.getCapacity()) {
            n4 = this.generation.elementAt(n);
            n5 = this.offset.elementAt(n);
        }
        if (n4 < n3 || n5 == 0) {
            this.offset.setElementAt(n2, n);
            this.generation.setElementAt(n3, n);
            this.isCompressed.setElementAt(bl, n);
        }
    }

    protected final int getCompressedStreamObject(int n, int n2) {
        this.currentGeneration = n2;
        return this.offset.elementAt(n);
    }

    protected final int getCompressedStreamObject(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.currentGeneration = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("Error with reference ..value=" + string + "<");
        }
        return this.offset.elementAt(n);
    }

    public final long getOffsetForObjectID(int n) {
        return this.offset.elementAt(n);
    }

    protected final int getOffset(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.currentGeneration = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("2. Error with reference .." + string + "<<");
        }
        return this.offset.elementAt(n);
    }

    public final boolean isCompressed(int n, int n2) {
        this.currentGeneration = n2;
        return this.isCompressed.elementAt(n);
    }

    protected final boolean isCompressed(String string) {
        int n = 0;
        if (string.endsWith("R")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.currentGeneration = Integer.parseInt(stringTokenizer.nextToken());
        } else {
            LogWriter.writeLog("5.Error with reference .." + string + "<");
        }
        return this.isCompressed.elementAt(n);
    }
}

