/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class ImageTransformerDouble {
    double ny = 0.0;
    double nx = 0.0;
    private Area clip = null;
    private BufferedImage current_image;
    private float[][] Trm;
    private float[][] Trm1;
    private float[][] Trm2;
    private float[][] CTM;
    private int i_x = 0;
    private int i_y = 0;
    private int i_w = 0;
    private int i_h = 0;
    private float scale = 1.0f;
    private boolean scaleImage;
    private boolean hasClip = false;
    private boolean removeClippedBorder = true;

    public ImageTransformerDouble(int n, GraphicsState graphicsState, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        this.removeClippedBorder = bl2;
        this.scale = n / 72;
        this.current_image = bufferedImage;
        this.scaleImage = bl;
        this.CTM = graphicsState.CTM;
        this.createMatrices();
        if (graphicsState.getClippingShape() != null) {
            this.clip = (Area)graphicsState.getClippingShape().clone();
        }
        this.calcCoordinates();
    }

    public final void doubleScaleTransformShear(boolean bl) {
        float[][] fArray = this.Trm1;
        boolean bl2 = false;
        if (PdfDecoder.clipOnMac && PdfDecoder.isRunningOnMac && fArray[0][0] == 0.0f && fArray[1][1] == 0.0f && fArray[0][1] < 0.0f && fArray[1][0] > 0.0f) {
            bl2 = true;
            fArray[0][0] = -fArray[0][1];
            fArray[0][1] = 0.0f;
            fArray[1][1] = fArray[1][0];
            fArray[1][0] = 0.0f;
        }
        this.scale(fArray);
        this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
        if (!bl2 && this.clip != null) {
            Area area = (Area)this.clip.clone();
            this.clipImage(true, area, bl);
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = (int)(this.clip.getBounds2D().getMaxX() - (double)this.i_x);
            this.i_h = (int)(this.clip.getBounds2D().getMaxY() - (double)this.i_y);
        }
    }

    public final void doubleScaleTransformScale() {
        if ((double)this.CTM[0][0] != 0.0 & (double)this.CTM[1][1] != 0.0) {
            this.scale(this.Trm2);
        }
    }

    public final void completeImage() {
        if (this.hasClip) {
            this.i_x = (int)this.clip.getBounds2D().getMinX();
            this.i_y = (int)this.clip.getBounds2D().getMinY();
            this.i_w = this.current_image.getWidth();
            this.i_h = this.current_image.getHeight();
        }
    }

    private void scale(float[][] fArray) {
        if ((double)fArray[0][0] != 1.0 || (double)fArray[1][1] != 1.0 || (double)fArray[0][1] != 0.0 || (double)fArray[1][0] != 0.0 || this.scale != 1.0f) {
            int n = this.current_image.getWidth();
            int n2 = this.current_image.getHeight();
            AffineTransform affineTransform = new AffineTransform(fArray[0][0] * this.scale, -fArray[0][1] * this.scale, -fArray[1][0] * this.scale, fArray[1][1] * this.scale, 0.0f, 0.0f);
            Area area = new Area(new Rectangle(0, 0, n, n2));
            area.transform(affineTransform);
            this.ny = area.getBounds2D().getY();
            this.nx = area.getBounds2D().getX();
            affineTransform = new AffineTransform((double)(fArray[0][0] * this.scale), (double)(-fArray[0][1] * this.scale), (double)(-fArray[1][0] * this.scale), (double)(fArray[1][1] * this.scale), -this.nx, -this.ny);
            AffineTransformOp affineTransformOp = n > 10 & n2 > 10 ? new AffineTransformOp(affineTransform, ColorSpaces.hints) : new AffineTransformOp(affineTransform, null);
            if (this.scaleImage) {
                this.current_image = affineTransformOp.filter(this.current_image, null);
            }
        }
    }

    private void createMatrices() {
        int n;
        int n2;
        int n3 = this.current_image.getWidth();
        int n4 = this.current_image.getHeight();
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)n3;
        this.Trm[0][1] = this.CTM[0][1] / (float)n3;
        this.Trm[0][2] = 0.0f;
        this.Trm[1][0] = this.CTM[1][0] / (float)n4;
        this.Trm[1][1] = this.CTM[1][1] / (float)n4;
        this.Trm[1][2] = 0.0f;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!((double)this.Trm[j][i] > 0.99 & this.Trm[j][i] < 1.0f)) continue;
                this.Trm[j][i] = 1.0f;
            }
        }
        this.Trm1 = new float[3][3];
        this.Trm2 = new float[3][3];
        float f = 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.0f;
        f = this.CTM[0][0];
        if (f < 0.0f) {
            f = -f;
        }
        if ((f2 = this.CTM[0][1]) < 0.0f) {
            f2 = -f2;
        }
        if ((f3 = this.CTM[1][1]) < 0.0f) {
            f3 = -f3;
        }
        if ((f4 = this.CTM[1][0]) < 0.0f) {
            f4 = -f4;
        }
        if ((double)this.CTM[0][0] == 0.0 | (double)this.CTM[1][1] == 0.0) {
            this.Trm1 = this.Trm;
        } else if ((double)this.CTM[0][1] == 0.0 && (double)this.CTM[1][0] == 0.0) {
            this.Trm1[0][0] = (float)n3 / this.CTM[0][0];
            this.Trm1[0][1] = 0.0f;
            this.Trm1[0][2] = 0.0f;
            this.Trm1[1][0] = 0.0f;
            this.Trm1[1][1] = (float)n4 / this.CTM[1][1];
            this.Trm1[1][2] = 0.0f;
            this.Trm1[2][0] = 0.0f;
            this.Trm1[2][1] = 0.0f;
            this.Trm1[2][2] = 1.0f;
            this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    if (!((double)this.Trm1[n][n2] > 0.99 & this.Trm1[n][n2] < 1.0f)) continue;
                    this.Trm1[n][n2] = 1.0f;
                }
            }
        } else {
            this.Trm1[0][0] = f > f2 ? (float)n3 / this.CTM[0][0] : (float)n3 / this.CTM[0][1];
            if (this.Trm1[0][0] < 0.0f) {
                this.Trm1[0][0] = -this.Trm1[0][0];
            }
            this.Trm1[0][1] = 0.0f;
            this.Trm1[0][2] = 0.0f;
            this.Trm1[1][0] = 0.0f;
            this.Trm1[1][1] = f3 > f4 ? (float)n4 / this.CTM[1][1] : (float)n4 / this.CTM[1][0];
            if (this.Trm1[1][1] < 0.0f) {
                this.Trm1[1][1] = -this.Trm1[1][1];
            }
            this.Trm1[1][2] = 0.0f;
            this.Trm1[2][0] = 0.0f;
            this.Trm1[2][1] = 0.0f;
            this.Trm1[2][2] = 1.0f;
            this.Trm1 = Matrix.multiply(this.Trm, this.Trm1);
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    if (!((double)this.Trm1[n][n2] > 0.99 & this.Trm1[n][n2] < 1.0f)) continue;
                    this.Trm1[n][n2] = 1.0f;
                }
            }
        }
        this.Trm2[0][0] = f > f2 ? this.CTM[0][0] / (float)n3 : this.CTM[0][1] / (float)n3;
        if (this.Trm2[0][0] < 0.0f) {
            this.Trm2[0][0] = -this.Trm2[0][0];
        }
        this.Trm2[0][1] = 0.0f;
        this.Trm2[0][2] = 0.0f;
        this.Trm2[1][0] = 0.0f;
        this.Trm2[1][1] = f3 > f4 ? this.CTM[1][1] / (float)n4 : this.CTM[1][0] / (float)n4;
        if (this.Trm2[1][1] < 0.0f) {
            this.Trm2[1][1] = -this.Trm2[1][1];
        }
        this.Trm2[1][2] = 0.0f;
        this.Trm2[2][0] = 0.0f;
        this.Trm2[2][1] = 0.0f;
        this.Trm2[2][2] = 1.0f;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                if (!((double)this.Trm2[n][n2] > 0.99 & this.Trm2[n][n2] < 1.0f)) continue;
                this.Trm2[n][n2] = 1.0f;
            }
        }
    }

    private final void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f & this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f & this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else if (this.CTM[1][0] > 0.0f & this.CTM[0][1] > 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    private final void clipImage(boolean bl, Area area, boolean bl2) {
        if (this.scale != 1.0f) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(this.scale, this.scale);
            area.transform(affineTransform);
        }
        double d = area.getBounds2D().getX();
        double d2 = area.getBounds2D().getY();
        int n = this.current_image.getWidth();
        int n2 = this.current_image.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(0.0, -this.current_image.getHeight());
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
        this.current_image = affineTransformOp.filter(this.current_image, null);
        AffineTransform affineTransform2 = new AffineTransform();
        double d3 = -this.CTM[2][0] * this.scale;
        double d4 = -(this.CTM[2][1] * this.scale);
        if (this.CTM[1][0] < 0.0f) {
            d3 -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][0] < 0.0f && this.CTM[1][0] >= 0.0f) {
            d3 -= (double)this.CTM[1][0];
        }
        if (this.CTM[0][1] < 0.0f) {
            d4 -= (double)this.CTM[0][1];
        }
        if (this.CTM[1][1] < 0.0f) {
            if (this.CTM[0][1] > 0.0f) {
                d4 -= (double)this.CTM[0][1];
            } else if (this.CTM[1][1] < 0.0f) {
                d4 -= (double)this.CTM[1][1];
            }
        }
        affineTransform2.translate(d3, d4);
        area.transform(affineTransform2);
        AffineTransform affineTransform3 = new AffineTransform(1.0f / this.Trm2[0][0], 0.0f, 0.0f, 1.0f / this.Trm2[1][1], 0.0f, 0.0f);
        if (!bl2 || this.Trm[1][0] == 0.0f && this.Trm[0][1] == 0.0f) {
            area.transform(affineTransform3);
        }
        int n3 = (int)area.getBounds().getX();
        int n4 = (int)area.getBounds().getY();
        int n5 = (int)area.getBounds().getWidth();
        int n6 = (int)area.getBounds().getHeight();
        if (n3 < 0) {
            area.transform(AffineTransform.getTranslateInstance(-n3, 0.0));
        }
        Area area2 = new Area(new Rectangle(0, 0, n, n2));
        area2.exclusiveOr(area);
        Graphics2D graphics2D = this.current_image.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fill(area2);
        AffineTransform affineTransform4 = new AffineTransform();
        affineTransform4.scale(1.0, -1.0);
        affineTransform4.translate(0.0, -this.current_image.getHeight());
        AffineTransformOp affineTransformOp2 = new AffineTransformOp(affineTransform4, ColorSpaces.hints);
        this.current_image = this.current_image.getSubimage(0, 0, this.current_image.getWidth(), this.current_image.getHeight());
        this.current_image = affineTransformOp2.filter(this.current_image, null);
        if (n4 < 0) {
            n6 -= n4;
            n4 = 0;
        } else if ((n4 = n2 - n6 - n4) < 0) {
            n4 = 0;
        }
        if (n3 < 0) {
            n5 -= n3;
            n3 = 0;
        }
        if (n5 > n) {
            n5 = n;
        }
        if (n6 > n2) {
            n6 = n2;
        }
        if (n4 + n6 > n2) {
            n6 = n2 - n4;
        }
        if (n3 + n5 > n) {
            n5 = n - n3;
        }
        if (this.removeClippedBorder && (n3 != 0 || n4 != 0 || n5 != this.current_image.getWidth() || n6 != this.current_image.getHeight())) {
            try {
                this.current_image = this.current_image.getSubimage(n3, n4, n5, n6);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " extracting clipped image with values x=" + n3 + " y=" + n4 + " w=" + n5 + " h=" + n6 + " from image " + this.current_image);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        double d5 = (double)this.i_x > d ? (double)this.i_x : d;
        double d6 = (double)this.i_y > d2 ? (double)this.i_y : d2;
        this.i_x = (int)d5;
        this.i_y = (int)d6;
        this.i_w = n5;
        this.i_h = n6;
    }
}

