/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFStitching
extends PDFGenericFunction
implements PDFFunction {
    private PDFFunction[] functions;
    private float[] bounds;

    public PDFStitching(PDFFunction[] pDFFunctionArray, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        super(fArray3, fArray4);
        if (fArray2 != null) {
            this.bounds = fArray2;
        }
        if (fArray != null) {
            this.encode = fArray;
        }
        if (pDFFunctionArray != null) {
            this.functions = pDFFunctionArray;
        }
    }

    public float[] compute(float[] fArray) {
        int n;
        float f = PDFStitching.min(PDFStitching.max(fArray[0], this.domain[0]), this.domain[1]);
        for (n = this.bounds.length - 1; n >= 0 && !(f >= this.bounds[n]); --n) {
        }
        float[] fArray2 = new float[1];
        float f2 = this.domain[0];
        float f3 = this.domain[1];
        if (++n > 0) {
            f2 = this.bounds[n - 1];
        }
        if (n < this.bounds.length) {
            f3 = this.bounds[n];
        }
        float f4 = this.encode[n * 2];
        float f5 = this.encode[n * 2 + 1];
        fArray2[0] = PDFStitching.interpolate(f, f2, f3, f4, f5);
        float[] fArray3 = this.functions[n].computeStitch(fArray2);
        float[] fArray4 = new float[fArray3.length];
        if (this.range != null) {
            for (int i = 0; i != this.range.length / 2; ++i) {
                fArray4[i] = PDFStitching.min(PDFStitching.max(fArray3[i], this.range[0]), this.range[1]);
            }
        } else {
            for (int i = 0; i != fArray3.length; ++i) {
                fArray4[i] = fArray3[i];
            }
        }
        return fArray4;
    }

    public float[] computeStitch(float[] fArray) {
        int n;
        float f = PDFStitching.min(PDFStitching.max(fArray[0], this.domain[0]), this.domain[1]);
        for (n = this.bounds.length - 1; n >= 0 && !(f >= this.bounds[n]); --n) {
        }
        float[] fArray2 = new float[1];
        float f2 = this.domain[0];
        float f3 = this.domain[1];
        if (++n > 0) {
            f2 = this.bounds[n - 1];
        }
        if (n < this.bounds.length) {
            f3 = this.bounds[n];
        }
        float f4 = this.encode[n * 2];
        float f5 = this.encode[n * 2 + 1];
        fArray2[0] = PDFStitching.interpolate(f, f2, f3, f4, f5);
        float[] fArray3 = this.functions[n].compute(fArray2);
        float[] fArray4 = new float[fArray3.length];
        for (int i = 0; i != this.range.length / 2; ++i) {
            fArray4[i] = this.range != null ? PDFStitching.min(PDFStitching.max(fArray3[i], this.range[0]), this.range[1]) : fArray3[i];
        }
        return fArray4;
    }
}

