/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.paper.MarginPaper;
import org.jpedal.examples.simpleviewer.paper.PaperSizes;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.PrinterOptions;
import org.jpedal.utils.Messages;

public class PrintPanel
extends JPanel {
    private boolean debugPrinterChange = false;
    int pageCount;
    int currentPage;
    int currentPreviewedPage = 1;
    int pagePrintCount = 1;
    private boolean okClicked = false;
    private String[] printersList;
    private PaperSizes paperDefinitions;
    private int defaultResolution;
    private boolean isFirstTime = true;
    private static final double mmPerSubInch = 0.35277777777777775;
    private PdfDecoder pdf;
    private JCheckBox autoRotateCenter;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JSpinner left;
    private JSpinner right;
    private JSpinner top;
    private JSpinner bottom;
    private JComboBox resolution;
    private JButton okButton;
    private JPanel pageHandlingPanel;
    private JPanel previewPanel;
    private JComponent previewComponent;
    private CustomSlider previewSlider;
    private JComboBox pageSize;
    private JTextField pagesFrom;
    private JTextField pagesTo;
    private JCheckBox paperSourceByPDF;
    private JCheckBox grayscale;
    private JSpinner printHandlingCopies;
    private JComboBox printHandlingScaling;
    private JRadioButton printRangeAll;
    private JRadioButton printRangeCurrentPage;
    private JRadioButton printRangeCurrentView;
    private JRadioButton printRangeFrom;
    private JPanel printRangePanel;
    private JCheckBox printRangeReversePages;
    private JComboBox printRangeSubset;
    private JCheckBox printToFile;
    private JComboBox printerName;
    private JPanel printerPanel;
    private JTabbedPane tabbedPane;

    public PrintPanel(String[] stringArray, String string, PaperSizes paperSizes, int n, int n2, PdfDecoder pdfDecoder) {
        this.pdf = pdfDecoder;
        this.pageCount = this.pdf.getPageCount();
        this.currentPage = n2;
        this.defaultResolution = n;
        this.paperDefinitions = paperSizes;
        this.resetDefaults(stringArray, string, this.pageCount, this.currentPage);
        this.isFirstTime = false;
    }

    public void resetDefaults(String[] stringArray, String string, int n, int n2) {
        String string2;
        this.printersList = stringArray;
        this.pageCount = n;
        this.currentPage = n2;
        this.initComponents();
        if (this.pageSize.getItemCount() == 0) {
            return;
        }
        int n3 = this.paperDefinitions.getDefaultPageIndex();
        if (n3 < this.pageSize.getModel().getSize()) {
            this.pageSize.setSelectedIndex(n3);
        }
        if ((string2 = System.getProperty("org.jpedal.defaultPrinter")) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                this.printerName.setSelectedItem(stringArray[i]);
            }
        } else {
            this.printerName.setSelectedItem(string);
        }
    }

    private void initComponents() {
        if (this.isFirstTime) {
            this.buttonGroup1 = new ButtonGroup();
            this.printerPanel = new JPanel();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.tabbedPane = new JTabbedPane();
            this.printerName = new JComboBox();
            this.pageSize = new JComboBox();
            this.jLabel10 = new JLabel();
            this.jLabel11 = new JLabel();
            this.jLabel12 = new JLabel();
            this.jLabel13 = new JLabel();
            this.jLabel14 = new JLabel();
            this.jLabel15 = new JLabel();
            this.left = new JSpinner();
            this.right = new JSpinner();
            this.top = new JSpinner();
            this.bottom = new JSpinner();
            this.resolution = new JComboBox();
            this.printRangePanel = new JPanel();
            this.pagesFrom = new JTextField();
            this.printRangeCurrentPage = new JRadioButton();
            this.printRangeAll = new JRadioButton();
            this.printRangeCurrentView = new JRadioButton();
            this.printRangeFrom = new JRadioButton();
            this.jLabel4 = new JLabel();
            this.printRangeSubset = new JComboBox();
            this.printRangeReversePages = new JCheckBox();
            this.jLabel7 = new JLabel();
            this.pagesTo = new JTextField();
            this.pageHandlingPanel = new JPanel();
            this.previewPanel = new JPanel();
            this.previewComponent = new JComponent(){

                public void paintComponent(Graphics graphics) {
                    PrintPanel.this.printPreview((Graphics2D)graphics);
                }
            };
            this.previewSlider = new CustomSlider();
            this.jLabel8 = new JLabel();
            this.printHandlingCopies = new JSpinner();
            this.jLabel9 = new JLabel();
            this.printHandlingScaling = new JComboBox();
            this.autoRotateCenter = new JCheckBox();
            this.paperSourceByPDF = new JCheckBox();
            this.grayscale = new JCheckBox();
            this.printToFile = new JCheckBox();
            this.okButton = new JButton();
            this.cancelButton = new JButton();
        } else {
            this.removeAll();
        }
        this.setLayout(null);
        this.add(this.tabbedPane);
        this.tabbedPane.setBounds(10, 7, 400, 330);
        this.printerPanel.setLayout(null);
        this.jLabel1.setText(Messages.getMessage("PdfViewerPrint.Name"));
        this.printerPanel.add(this.jLabel1);
        this.jLabel1.setBounds(10, 20, 60, 14);
        this.jLabel2.setText(Messages.getMessage("PdfViewerPrint.PageSize"));
        this.printerPanel.add(this.jLabel2);
        this.jLabel2.setBounds(10, 52, 70, 14);
        this.printerName.setModel(new DefaultComboBoxModel<String>(this.printersList));
        this.printerPanel.add(this.printerName);
        this.printerName.setBounds(90, 20, 290, 22);
        this.printerName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (PrintPanel.this.debugPrinterChange) {
                    System.out.println("itemStateChanged");
                }
                PrintPanel.this.previewComponent.repaint();
                if (PrintPanel.this.debugPrinterChange) {
                    System.out.println("repainted preview component");
                }
                PrintPanel.this.okButton.setEnabled(false);
                PrintPanel.this.pageSize.setEnabled(false);
                PrintPanel.this.pageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
                PrintPanel.this.resolution.setEnabled(false);
                PrintPanel.this.resolution.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
                if (PrintPanel.this.debugPrinterChange) {
                    System.out.println("GUI options disabled");
                }
                Thread thread = new Thread(){

                    public void run() {
                        int n;
                        if (PrintPanel.this.debugPrinterChange) {
                            System.out.println("Thread invoked.");
                        }
                        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
                        if (PrintPanel.this.debugPrinterChange) {
                            System.out.println("Found print services.");
                        }
                        PrintService printService = null;
                        for (n = 0; n < printServiceArray.length; ++n) {
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("checking " + printServiceArray[n].getName());
                            }
                            if (!printServiceArray[n].getName().equals(PrintPanel.this.printerName.getSelectedItem())) continue;
                            printService = printServiceArray[n];
                            if (!PrintPanel.this.debugPrinterChange) continue;
                            System.out.println("Match!");
                        }
                        if (printService != null) {
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Getting available resolutions...");
                            }
                            PrintPanel.this.resolution.setModel(new DefaultComboBoxModel<String>(PrintPanel.this.getAvailableResolutions(printService)));
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Getting default resolution...");
                            }
                            n = PrintPanel.this.getDefaultResolutionIndex();
                            if (PrintPanel.this.resolution.getModel().getSize() > n) {
                                PrintPanel.this.resolution.setSelectedIndex(n);
                            }
                            PrintPanel.this.resolution.setEnabled(true);
                            PrintPanel.this.paperDefinitions.setPrintService(printService);
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Getting available paper sizes...");
                            }
                            PrintPanel.this.pageSize.setModel(new DefaultComboBoxModel<String>(PrintPanel.this.getAvailablePaperSizes()));
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Getting default pagesize...");
                            }
                            int n2 = PrintPanel.this.paperDefinitions.getDefaultPageIndex();
                            if (PrintPanel.this.pageSize.getModel().getSize() > n2) {
                                PrintPanel.this.pageSize.setSelectedIndex(n2);
                            }
                            PrintPanel.this.pageSize.setEnabled(true);
                            PrintPanel.this.okButton.setEnabled(true);
                            if (PrintPanel.this.debugPrinterChange) {
                                System.out.println("Reenabled GUI");
                            }
                        }
                        if (PrintPanel.this.debugPrinterChange) {
                            System.out.println("Updating margins");
                        }
                        PrintPanel.this.updateMargins();
                    }
                };
                if (PrintPanel.this.debugPrinterChange) {
                    System.out.println("Invoking update thread...");
                }
                SwingUtilities.invokeLater(thread);
            }
        });
        Thread thread = new Thread(){

            public void run() {
                int n;
                PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
                PrintService printService = null;
                for (n = 0; n < printServiceArray.length; ++n) {
                    if (!printServiceArray[n].getName().equals(PrintPanel.this.printerName.getSelectedItem())) continue;
                    printService = printServiceArray[n];
                }
                if (printService != null) {
                    PrintPanel.this.paperDefinitions.setPrintService(printService);
                    PrintPanel.this.resolution.setModel(new DefaultComboBoxModel<String>(PrintPanel.this.getAvailableResolutions(printService)));
                    n = PrintPanel.this.getDefaultResolutionIndex();
                    if (PrintPanel.this.resolution.getModel().getSize() > n) {
                        PrintPanel.this.resolution.setSelectedIndex(n);
                    }
                    PrintPanel.this.resolution.setEnabled(true);
                    PrintPanel.this.pageSize.setModel(new DefaultComboBoxModel<String>(PrintPanel.this.getAvailablePaperSizes()));
                    int n2 = PrintPanel.this.paperDefinitions.getDefaultPageIndex();
                    if (n2 < PrintPanel.this.pageSize.getModel().getSize()) {
                        PrintPanel.this.pageSize.setSelectedIndex(n2);
                    }
                    PrintPanel.this.pageSize.setEnabled(true);
                    PrintPanel.this.okButton.setEnabled(true);
                }
                PrintPanel.this.updateMargins();
            }
        };
        this.pageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        this.pageSize.setEnabled(false);
        this.resolution.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        this.resolution.setEnabled(false);
        this.okButton.setEnabled(false);
        thread.start();
        this.pageSize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.updatePreview();
                PrintPanel.this.updateMargins();
            }
        });
        this.printerPanel.add(this.pageSize);
        this.pageSize.setBounds(90, 49, 290, 22);
        this.jLabel10.setText("Margins (mm):");
        this.printerPanel.add(this.jLabel10);
        this.jLabel10.setBounds(10, 85, 150, 22);
        this.jLabel11.setText("Left:");
        this.printerPanel.add(this.jLabel11);
        this.jLabel11.setBounds(105, 85, 100, 22);
        this.left.setModel(new CustomSpinnerModel());
        this.left.setBounds(140, 85, 65, 22);
        this.printerPanel.add(this.left);
        this.jLabel12.setText("Right:");
        this.printerPanel.add(this.jLabel12);
        this.jLabel12.setBounds(255, 85, 100, 22);
        this.right.setModel(new CustomSpinnerModel());
        this.right.setBounds(300, 85, 65, 22);
        this.printerPanel.add(this.right);
        this.jLabel13.setText("Top:");
        this.printerPanel.add(this.jLabel13);
        this.jLabel13.setBounds(105, 116, 100, 22);
        this.top.setModel(new CustomSpinnerModel());
        this.top.setBounds(140, 116, 65, 22);
        this.printerPanel.add(this.top);
        this.jLabel14.setText("Bottom:");
        this.printerPanel.add(this.jLabel14);
        this.jLabel14.setBounds(255, 116, 100, 22);
        this.bottom.setModel(new CustomSpinnerModel());
        this.bottom.setBounds(300, 116, 65, 22);
        this.printerPanel.add(this.bottom);
        ChangeListener changeListener = new ChangeListener(){
            final double mmToSubInch = 2.834645669291339;

            public void stateChanged(ChangeEvent changeEvent) {
                MarginPaper marginPaper = PrintPanel.this.getSelectedPaper();
                if (marginPaper == null) {
                    return;
                }
                double d = (Double)PrintPanel.this.left.getValue() * 2.834645669291339;
                double d2 = (Double)PrintPanel.this.right.getValue() * 2.834645669291339;
                double d3 = (Double)PrintPanel.this.top.getValue() * 2.834645669291339;
                double d4 = (Double)PrintPanel.this.bottom.getValue() * 2.834645669291339;
                marginPaper.setImageableArea(d, d3, marginPaper.getWidth() - d - d2, marginPaper.getHeight() - d3 - d4);
                PrintPanel.this.updatePreview();
            }
        };
        this.left.addChangeListener(changeListener);
        this.right.addChangeListener(changeListener);
        this.top.addChangeListener(changeListener);
        this.bottom.addChangeListener(changeListener);
        this.jLabel15.setText("Resolution:");
        this.printerPanel.add(this.jLabel15);
        this.jLabel15.setBounds(10, 153, 80, 22);
        this.printerPanel.add(this.resolution);
        this.resolution.setBounds(90, 153, 290, 22);
        this.tabbedPane.addTab("Printer", this.printerPanel);
        this.printRangePanel.setLayout(null);
        this.pagesFrom.setText("1");
        this.pagesFrom.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PrintPanel.this.pagesBoxPressed(mouseEvent);
            }
        });
        this.printRangePanel.add(this.pagesFrom);
        this.pagesFrom.setBounds(110, 83, 60, 19);
        this.buttonGroup1.add(this.printRangeCurrentPage);
        this.printRangeCurrentPage.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printRangeCurrentPage.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeCurrentPage.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeCurrentPage.setOpaque(false);
        this.printRangeCurrentPage.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.currentPageStateChanged(itemEvent);
            }
        });
        this.printRangePanel.add(this.printRangeCurrentPage);
        this.printRangeCurrentPage.setBounds(20, 64, 120, 15);
        this.buttonGroup1.add(this.printRangeAll);
        this.printRangeAll.setSelected(true);
        this.printRangeAll.setText(Messages.getMessage("PdfViewerRadioButton.All"));
        this.printRangeAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeAll.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeAll.setOpaque(false);
        if (this.isFirstTime) {
            this.printRangeAll.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PrintPanel.this.allStateChanged(itemEvent);
                }
            });
        }
        this.printRangePanel.add(this.printRangeAll);
        this.printRangeAll.setBounds(20, 20, 70, 15);
        this.buttonGroup1.add(this.printRangeCurrentView);
        this.printRangeCurrentView.setText(Messages.getMessage("PdfViewerPrint.CurrentView"));
        this.printRangeCurrentView.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeCurrentView.setEnabled(true);
        this.printRangeCurrentView.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeCurrentView.setOpaque(false);
        this.printRangePanel.add(this.printRangeCurrentView);
        this.printRangeCurrentView.setBounds(20, 42, 140, 15);
        if (this.pdf.getDisplayView() != 1) {
            this.printRangeCurrentView.setEnabled(false);
            this.printRangeCurrentView.setToolTipText(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
        } else {
            this.printRangeCurrentView.setEnabled(true);
            this.printRangeCurrentView.setToolTipText(null);
        }
        if (this.isFirstTime) {
            this.printRangeCurrentView.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PrintPanel.this.printRangeCurrentView(itemEvent);
                }
            });
        }
        this.buttonGroup1.add(this.printRangeFrom);
        this.printRangeFrom.setText(Messages.getMessage("PdfViewerPrint.PagesFrom"));
        this.printRangeFrom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeFrom.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeFrom.setOpaque(false);
        if (this.isFirstTime) {
            this.printRangeFrom.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    PrintPanel.this.pagesFromStateChanged(itemEvent);
                }
            });
        }
        this.printRangePanel.add(this.printRangeFrom);
        this.printRangeFrom.setBounds(20, 86, 140, 15);
        this.jLabel4.setText(Messages.getMessage("PdfViewerPrint.Subset"));
        this.printRangePanel.add(this.jLabel4);
        this.jLabel4.setBounds(10, 125, 100, 14);
        this.printRangeSubset.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getMessage("PdfViewerPrint.AllPagesInRange"), Messages.getMessage("PdfViewerPrint.OddPagesOnly"), Messages.getMessage("PdfViewerPrint.EvenPagesOnly")}));
        this.printRangePanel.add(this.printRangeSubset);
        this.printRangeSubset.setBounds(90, 122, 290, 22);
        this.printRangeSubset.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.updatePreview();
            }
        });
        this.printRangeReversePages.setText(Messages.getMessage("PdfViewerPrint.ReversePages"));
        this.printRangeReversePages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeReversePages.setMargin(new Insets(0, 0, 0, 0));
        this.printRangePanel.add(this.printRangeReversePages);
        this.printRangeReversePages.setBounds(20, 160, 120, 15);
        this.printRangeReversePages.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.updatePreview();
            }
        });
        this.jLabel7.setText(Messages.getMessage("PdfViewerPrint.PagesTo"));
        this.printRangePanel.add(this.jLabel7);
        this.jLabel7.setBounds(190, 86, 30, 14);
        this.pagesTo.setText(String.valueOf(this.pageCount));
        if (this.isFirstTime) {
            this.pagesTo.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    PrintPanel.this.pagesBoxPressed(mouseEvent);
                }
            });
        }
        this.printRangePanel.add(this.pagesTo);
        this.pagesTo.setBounds(220, 83, 60, 19);
        this.tabbedPane.addTab("Range", this.printRangePanel);
        this.pageHandlingPanel.setLayout(null);
        this.jLabel8.setText(Messages.getMessage("PdfViewerPrint.Copies"));
        this.pageHandlingPanel.add(this.jLabel8);
        this.jLabel8.setBounds(10, 20, 50, 14);
        this.printHandlingCopies.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        this.pageHandlingPanel.add(this.printHandlingCopies);
        this.printHandlingCopies.setBounds(90, 17, 60, 20);
        this.jLabel9.setText(Messages.getMessage("PdfViewerPrint.PageScaling"));
        this.pageHandlingPanel.add(this.jLabel9);
        this.jLabel9.setBounds(10, 50, 120, 14);
        this.printHandlingScaling.setModel(new DefaultComboBoxModel<String>(PrinterOptions.PRINT_SCALING_OPTIONS));
        this.printHandlingScaling.setSelectedIndex(PrinterOptions.LAST_SCALING_CHOICE);
        this.pageHandlingPanel.add(this.printHandlingScaling);
        this.printHandlingScaling.setBounds(90, 47, 290, 22);
        this.printHandlingScaling.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.updatePreview();
            }
        });
        this.autoRotateCenter.setSelected(true);
        this.autoRotateCenter.setText(Messages.getMessage("PdfViewerPrint.AutoRotateAndCenter"));
        this.autoRotateCenter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoRotateCenter.setMargin(new Insets(0, 0, 0, 0));
        this.pageHandlingPanel.add(this.autoRotateCenter);
        this.autoRotateCenter.setBounds(20, 88, 260, 15);
        this.autoRotateCenter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.updatePreview();
            }
        });
        this.paperSourceByPDF.setText(Messages.getMessage("PdfViewerPrint.ChoosePaperByPdfSize"));
        this.paperSourceByPDF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.paperSourceByPDF.setMargin(new Insets(0, 0, 0, 0));
        this.pageHandlingPanel.add(this.paperSourceByPDF);
        this.paperSourceByPDF.setBounds(20, 112, 300, 15);
        this.paperSourceByPDF.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.updatePreview();
            }
        });
        this.grayscale.setText(Messages.getMessage("PdfViewerPrint.Grayscale"));
        this.grayscale.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pageHandlingPanel.add(this.grayscale);
        this.grayscale.setMargin(new Insets(0, 0, 0, 0));
        this.grayscale.setBounds(20, 137, 300, 15);
        this.grayscale.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrintPanel.this.updatePreview();
            }
        });
        this.tabbedPane.addTab("Handling", this.pageHandlingPanel);
        this.previewPanel.setLayout(null);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getMessage("PdfViewerLabel.PrintPreview"), 0, 0, new Font("Tahoma", 0, 11), Color.BLACK));
        this.previewPanel.add(this.previewComponent);
        this.previewComponent.setBounds(5, 5, 220, 275);
        this.previewPanel.add(this.previewSlider);
        this.previewSlider.setBounds(5, 280, 220, 40);
        this.previewSlider.setValue(1);
        this.updatePreview();
        this.add(this.previewPanel);
        this.previewPanel.setBounds(420, 7, 230, 330);
        this.okButton.setText(Messages.getMessage("PdfMessage.Ok"));
        if (this.isFirstTime) {
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrintPanel.this.okEvent(actionEvent);
                }
            });
        }
        this.add(this.okButton);
        this.okButton.setBounds(445, 348, 90, 23);
        this.cancelButton.setText(Messages.getMessage("PdfMessage.Cancel"));
        if (this.isFirstTime) {
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrintPanel.this.cancelEvent(actionEvent);
                }
            });
        }
        this.add(this.cancelButton);
        this.cancelButton.setBounds(560, 348, 90, 23);
    }

    private String[] getAvailableResolutions(PrintService printService) {
        PrinterResolution[] printerResolutionArray = (PrinterResolution[])printService.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (printerResolutionArray == null) {
            return new String[]{"Default"};
        }
        String[] stringArray = new String[printerResolutionArray.length];
        for (int i = 0; i < printerResolutionArray.length; ++i) {
            PrinterResolution printerResolution = printerResolutionArray[i];
            stringArray[i] = printerResolution.getCrossFeedResolution(100) + "x" + printerResolution.getFeedResolution(100) + " dpi";
        }
        return stringArray;
    }

    public PrinterResolution getResolution() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService printService = null;
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (!printServiceArray[i].getName().equals(this.printerName.getSelectedItem())) continue;
            printService = printServiceArray[i];
        }
        PrinterResolution[] printerResolutionArray = (PrinterResolution[])printService.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (printerResolutionArray == null) {
            return null;
        }
        return printerResolutionArray[this.resolution.getSelectedIndex()];
    }

    private int getDefaultResolutionIndex() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService printService = null;
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (!printServiceArray[i].getName().equals(this.printerName.getSelectedItem())) continue;
            printService = printServiceArray[i];
        }
        PrinterResolution[] printerResolutionArray = (PrinterResolution[])printService.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (printerResolutionArray == null) {
            return 0;
        }
        if (this.defaultResolution == -1) {
            this.defaultResolution = 600;
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i = 0; i < printerResolutionArray.length; ++i) {
            int n3;
            PrinterResolution printerResolution = printerResolutionArray[i];
            int n4 = printerResolution.getCrossFeedResolution(100) - this.defaultResolution;
            if (n4 < 0) {
                n4 = -n4;
            }
            if ((n3 = printerResolution.getFeedResolution(100) - this.defaultResolution) < 0) {
                n3 = -n3;
            }
            if (n4 + n3 >= n) continue;
            n = n4 + n3;
            n2 = i;
        }
        return n2;
    }

    private void updateMargins() {
        MarginPaper marginPaper = this.getSelectedPaper();
        if (marginPaper == null) {
            return;
        }
        ((CustomSpinnerModel)this.left.getModel()).setMinValue(marginPaper.getMinX() * 0.35277777777777775);
        ((CustomSpinnerModel)this.top.getModel()).setMinValue(marginPaper.getMinY() * 0.35277777777777775);
        ((CustomSpinnerModel)this.right.getModel()).setMinValue((marginPaper.getWidth() - marginPaper.getMaxRX()) * 0.35277777777777775);
        ((CustomSpinnerModel)this.bottom.getModel()).setMinValue((marginPaper.getHeight() - marginPaper.getMaxBY()) * 0.35277777777777775);
        Double d = new Double(0.0);
        this.left.setValue(d);
        this.top.setValue(d);
        this.right.setValue(d);
        this.bottom.setValue(d);
    }

    private void printPreview(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.previewComponent.getWidth();
        int n10 = this.previewComponent.getHeight();
        if (this.printRangeCurrentView.isSelected()) {
            n8 = (int)(this.pdf.getVisibleRect().getWidth() / (double)this.pdf.getScaling());
            n7 = (int)(this.pdf.getVisibleRect().getHeight() / (double)this.pdf.getScaling());
        } else {
            n8 = this.pdf.getPdfPageData().getCropBoxWidth(this.currentPreviewedPage);
            n7 = this.pdf.getPdfPageData().getCropBoxHeight(this.currentPreviewedPage);
        }
        if (this.paperSourceByPDF.isSelected()) {
            n6 = n8;
            n5 = n7;
            n4 = n6;
            n3 = n5;
            n2 = 0;
            n = 0;
        } else {
            MarginPaper marginPaper = this.paperDefinitions.getSelectedPaper(this.pageSize.getSelectedItem());
            if (marginPaper == null) {
                graphics2D.drawString("Loading...", n9 / 2 - 25, n10 / 2 - 5);
                return;
            }
            n6 = (int)marginPaper.getWidth();
            n5 = (int)marginPaper.getHeight();
            n2 = (int)marginPaper.getImageableX();
            n = (int)marginPaper.getImageableY();
            n4 = (int)marginPaper.getImageableWidth();
            n3 = (int)marginPaper.getImageableHeight();
        }
        if (this.autoRotateCenter.isSelected() && (n8 > n7 && n4 < n3 || n8 < n7 && n4 > n3)) {
            int n11 = n6;
            n6 = n5;
            n5 = n11;
            n11 = n4;
            n4 = n3;
            n3 = n11;
            n11 = n2;
            n2 = n;
            n = n11;
            n = n5 - n - n3;
        }
        int n12 = 25;
        int n13 = 30;
        int n14 = 5;
        int n15 = 25;
        double d = (double)n5 / 72.0;
        double d2 = (double)n6 / 72.0;
        double d3 = (double)(n9 - (n12 + n14)) / (double)n6;
        double d4 = (double)(n10 - (n13 + n15)) / (double)n5;
        double d5 = d3 < d4 ? d3 : d4;
        n6 = (int)(d5 * (double)n6);
        n5 = (int)(d5 * (double)n5);
        n2 = (int)(d5 * (double)n2);
        n = (int)(d5 * (double)n);
        n4 = (int)(d5 * (double)n4);
        n3 = (int)(d5 * (double)n3);
        n8 = (int)(d5 * (double)n8);
        n7 = (int)(d5 * (double)n7);
        double d6 = 1.0;
        if (this.printHandlingScaling.getSelectedIndex() == 1 || this.printHandlingScaling.getSelectedIndex() == 2 && (n8 > n4 || n7 > n3)) {
            d6 = (double)n4 / (double)n8;
            if ((double)n3 / (double)n7 < d6) {
                d6 = (double)n3 / (double)n7;
            }
            n8 = (int)(d6 * (double)n8);
            n7 = (int)(d6 * (double)n7);
        }
        n12 += (n9 - (n12 + n14 + n6)) / 2;
        n13 += (n10 - (n13 + n15 + n5)) / 2;
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(n12, n13, n6, n5);
        graphics2D.setPaint(Color.RED);
        graphics2D.drawLine(n12 + n2, n13, n12 + n2, n13 + n5);
        graphics2D.drawLine(n12, n13 + n, n12 + n6, n13 + n);
        graphics2D.drawLine(n12 + n4 + n2, n13, n12 + n4 + n2, n13 + n5);
        graphics2D.drawLine(n12, n13 + n3 + n, n12 + n6, n13 + n3 + n);
        ++n2;
        ++n;
        --n4;
        --n3;
        graphics2D.setPaint(Color.BLACK);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(1);
        String string = numberFormat.format(d2);
        int n16 = string.length() * 3;
        graphics2D.drawString(string, n12 + n6 / 2 - n16, n13 - 5);
        graphics2D.drawLine(n12, n13 - 15, n12, n13 - 5);
        graphics2D.drawLine(n12 + n6, n13 - 15, n12 + n6, n13 - 5);
        graphics2D.drawLine(n12, n13 - 10, n12 + n6 / 2 - n16 - 6, n13 - 10);
        graphics2D.drawLine(n12 + n6 / 2 + n16 + 6, n13 - 10, n12 + n6, n13 - 10);
        graphics2D.drawLine(n12, n13 - 10, n12 + 5, n13 - 15);
        graphics2D.drawLine(n12, n13 - 10, n12 + 5, n13 - 5);
        graphics2D.drawLine(n12 + n6, n13 - 10, n12 + n6 - 5, n13 - 15);
        graphics2D.drawLine(n12 + n6, n13 - 10, n12 + n6 - 5, n13 - 5);
        String string2 = numberFormat.format(d);
        n16 = string2.length() * 3;
        graphics2D.drawString(string2, n12 - 12 - n16, n13 + n5 / 2 + 5);
        graphics2D.drawLine(n12 - 15, n13, n12 - 5, n13);
        graphics2D.drawLine(n12 - 15, n13 + n5, n12 - 5, n13 + n5);
        graphics2D.drawLine(n12 - 10, n13, n12 - 10, n13 + n5 / 2 - 8);
        graphics2D.drawLine(n12 - 10, n13 + n5 / 2 + 8, n12 - 10, n13 + n5);
        graphics2D.drawLine(n12 - 10, n13, n12 - 5, n13 + 5);
        graphics2D.drawLine(n12 - 10, n13, n12 - 15, n13 + 5);
        graphics2D.drawLine(n12 - 10, n13 + n5, n12 - 15, n13 + n5 - 5);
        graphics2D.drawLine(n12 - 10, n13 + n5, n12 - 5, n13 + n5 - 5);
        try {
            BufferedImage bufferedImage;
            if (this.printRangeCurrentView.isSelected()) {
                bufferedImage = new BufferedImage((int)this.pdf.getVisibleRect().getWidth(), (int)this.pdf.getVisibleRect().getHeight(), 2);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.translate((int)(-this.pdf.getVisibleRect().getX()), (int)(-this.pdf.getVisibleRect().getY()));
                Border border = this.pdf.getBorder();
                Color color = this.pdf.getBackground();
                this.pdf.setBorder(BorderFactory.createEmptyBorder());
                this.pdf.setBackground(Color.WHITE);
                this.pdf.paintComponent(graphics);
                this.pdf.setBorder(border);
                this.pdf.setBackground(color);
            } else {
                bufferedImage = this.pdf.getPageAsImage(this.currentPreviewedPage);
            }
            if (this.grayscale.isSelected()) {
                bufferedImage = ColorSpaceConvertor.convertColorspace(bufferedImage, 10);
            }
            graphics2D.setClip(n12 + n2, n13 + n, n4, n3);
            int n17 = (int)((double)(n4 - n8) / 2.0);
            int n18 = (int)((double)(n3 - n7) / 2.0);
            graphics2D.drawImage(bufferedImage, n12 + n2 + n17, n13 + n + n18, n8, n7, null);
        }
        catch (PdfException pdfException) {
            // empty catch block
        }
        graphics2D.setClip(null);
        graphics2D.drawRect(n12, n13, n6, n5);
        numberFormat.setMaximumFractionDigits(0);
        graphics2D.drawString("Units: Inches    Scale: " + numberFormat.format(d6 * 100.0) + "%", 5, n10 - 5);
    }

    private void updatePreview() {
        int n = this.previewSlider.getValue();
        SetOfIntegerSyntax setOfIntegerSyntax = this.getPrintRange();
        if (setOfIntegerSyntax == null) {
            this.currentPreviewedPage = 0;
            this.pagePrintCount = 0;
        } else {
            int[][] nArray = setOfIntegerSyntax.getMembers();
            int n2 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                n2 += nArray[i][1] - (nArray[i][0] - 1);
            }
            int[] nArray2 = new int[n2];
            this.pagePrintCount = nArray2.length;
            n2 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i][1] - (nArray[i][0] - 1);
                for (int j = 0; j < n3; ++j) {
                    nArray2[n2] = nArray[i][0] + j;
                    ++n2;
                }
            }
            if (n > this.pagePrintCount) {
                n = 1;
                this.previewSlider.setValue(1);
            }
            this.currentPreviewedPage = this.printRangeReversePages.isSelected() ? nArray2[nArray2.length - n] : nArray2[n - 1];
        }
        this.previewSlider.setMaxValue(this.pagePrintCount);
        this.previewComponent.repaint();
    }

    private void pagesBoxPressed(MouseEvent mouseEvent) {
        this.printRangeFrom.setSelected(true);
        this.printRangeSubset.setEnabled(true);
        this.printRangeReversePages.setEnabled(true);
        this.updatePreview();
    }

    private void pagesFromStateChanged(ItemEvent itemEvent) {
        if (this.printRangeFrom.isSelected()) {
            this.printRangeSubset.setEnabled(true);
            this.printRangeReversePages.setEnabled(true);
            this.updatePreview();
        }
    }

    private void printRangeCurrentView(ItemEvent itemEvent) {
        if (this.printRangeCurrentView.isSelected()) {
            this.printRangeSubset.setEnabled(false);
            this.printRangeReversePages.setEnabled(false);
            this.updatePreview();
        }
    }

    private void currentPageStateChanged(ItemEvent itemEvent) {
        if (this.printRangeCurrentPage.isSelected()) {
            this.printRangeSubset.setEnabled(false);
            this.printRangeReversePages.setEnabled(false);
            this.updatePreview();
        }
    }

    private void allStateChanged(ItemEvent itemEvent) {
        if (this.printRangeAll.isSelected()) {
            this.printRangeSubset.setEnabled(true);
            this.printRangeReversePages.setEnabled(true);
            this.updatePreview();
        }
    }

    private void cancelEvent(ActionEvent actionEvent) {
        this.okClicked = false;
        this.getTopLevelAncestor().setVisible(false);
    }

    private void okEvent(ActionEvent actionEvent) {
        this.okClicked = true;
        this.getTopLevelAncestor().setVisible(false);
    }

    public SetOfIntegerSyntax getPrintRange() {
        PageRanges pageRanges = null;
        if (this.printRangeAll.isSelected()) {
            pageRanges = new PageRanges(1, this.pageCount);
            if (this.printRangeSubset.getSelectedIndex() == 0) {
                return pageRanges;
            }
            if (this.printRangeSubset.getSelectedIndex() == 1) {
                String string = "";
                int n = -1;
                while ((n = pageRanges.next(n)) != -1) {
                    if (n % 2 != 1) continue;
                    string = string + n + ",";
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.deleteCharAt(string.length() - 1);
                string = stringBuffer.toString();
                pageRanges = new PageRanges(string);
            } else if (this.printRangeSubset.getSelectedIndex() == 2) {
                String string = "";
                int n = -1;
                while ((n = pageRanges.next(n)) != -1) {
                    if (n % 2 != 0) continue;
                    string = string + n + ",";
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.deleteCharAt(string.length() - 1);
                string = stringBuffer.toString();
                pageRanges = new PageRanges(string);
            }
        } else if (this.printRangeCurrentPage.isSelected()) {
            pageRanges = new PageRanges(this.currentPage);
        } else if (this.printRangeCurrentView.isSelected()) {
            pageRanges = new PageRanges(this.currentPage);
        } else if (this.printRangeFrom.isSelected()) {
            int n;
            int n2;
            try {
                n2 = Integer.parseInt(this.pagesFrom.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.pagesFrom.setText("1");
                n2 = 1;
            }
            try {
                n = Integer.parseInt(this.pagesTo.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.pagesTo.setText("" + this.pageCount);
                n = this.pageCount;
            }
            if (n2 < 0) {
                n2 = 1;
                this.pagesFrom.setText("1");
            } else if (n2 > this.pageCount) {
                n2 = this.pageCount;
                this.pagesFrom.setText("" + this.pageCount);
            }
            if (n < 0) {
                n = 1;
                this.pagesTo.setText("1");
            } else if (n > this.pageCount) {
                n = this.pageCount;
                this.pagesTo.setText("" + this.pageCount);
            }
            if (n2 > n) {
                int n3 = n;
                n = n2;
                n2 = n3;
                if (SimpleViewer.showMessages) {
                    JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerPrint.SwapValues"));
                }
            }
            pageRanges = new PageRanges(n2, n);
            if (this.printRangeSubset.getSelectedIndex() == 0) {
                return pageRanges;
            }
            if (this.printRangeSubset.getSelectedIndex() == 1) {
                String string = "";
                int n4 = -1;
                while ((n4 = pageRanges.next(n4)) != -1) {
                    if (n4 % 2 != 1) continue;
                    string = string + n4 + ",";
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                if (string.length() == 0) {
                    return null;
                }
                stringBuffer.deleteCharAt(string.length() - 1);
                string = stringBuffer.toString();
                pageRanges = new PageRanges(string);
            } else if (this.printRangeSubset.getSelectedIndex() == 2) {
                String string = "";
                int n5 = -1;
                while ((n5 = pageRanges.next(n5)) != -1) {
                    if (n5 % 2 != 0) continue;
                    string = string + n5 + ",";
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                int n6 = string.length();
                if (n6 > 0) {
                    stringBuffer.deleteCharAt(n6 - 1);
                }
                pageRanges = (string = stringBuffer.toString()).length() > 0 ? new PageRanges(string) : null;
            }
        }
        return pageRanges;
    }

    public int getCopies() {
        String string = this.printHandlingCopies.getValue().toString();
        return Integer.parseInt(string);
    }

    public int getPageScaling() {
        int n = this.printHandlingScaling.getSelectedIndex();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        PrinterOptions.LAST_SCALING_CHOICE = n2;
        return n2;
    }

    public String getPrinter() {
        if (this.printerName == null) {
            return "";
        }
        if (this.printerName.getSelectedItem() == null) {
            return null;
        }
        return this.printerName.getSelectedItem().toString();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public boolean isAutoRotateAndCenter() {
        return this.autoRotateCenter.isSelected();
    }

    public boolean isPaperSourceByPDFSize() {
        return this.paperSourceByPDF.isSelected();
    }

    public boolean isPrintingCurrentView() {
        return this.printRangeCurrentView.isSelected();
    }

    public String[] getAvailablePaperSizes() {
        return this.paperDefinitions.getAvailablePaperSizes();
    }

    public MarginPaper getSelectedPaper() {
        return this.paperDefinitions.getSelectedPaper(this.pageSize.getSelectedItem());
    }

    public boolean isPagesReversed() {
        return this.printRangeReversePages.isSelected();
    }

    public boolean isOddPagesOnly() {
        return this.printRangeSubset.getSelectedIndex() == 1;
    }

    public boolean isEvenPagesOnly() {
        return this.printRangeSubset.getSelectedIndex() == 2;
    }

    public boolean isMonochrome() {
        return this.grayscale.isSelected();
    }

    private class CustomSpinnerModel
    extends SpinnerNumberModel {
        private double value = 0.0;
        private ArrayList listeners = new ArrayList();
        private double minValue = 0.0;

        private CustomSpinnerModel() {
        }

        public Object getPreviousValue() {
            if (this.value <= this.minValue) {
                return null;
            }
            if (this.value - 0.5 < this.minValue) {
                return new Double(this.minValue);
            }
            return new Double(this.value - 0.5);
        }

        public Object getNextValue() {
            return new Double(this.value + 0.5);
        }

        public Object getValue() {
            return new Double(this.value);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public void setValue(Object object) {
            try {
                double d = (Double)object;
                this.value = d < this.minValue ? this.minValue : d;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ChangeListener)this.listeners.get(i)).stateChanged(changeEvent);
            }
        }

        public void setMinValue(double d) {
            this.minValue = d;
            this.setValue(this.getValue());
        }
    }

    private class CustomSlider
    extends JPanel {
        private int value = 1;
        private int maxValue = 100;
        private final int rightMargin = 9;
        private final int leftMargin = 9;
        private boolean dragging = false;

        public CustomSlider() {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (CustomSlider.this.dragging) {
                        CustomSlider.this.value = (int)((double)(mouseEvent.getX() - 9) / (double)(CustomSlider.this.getWidth() - 18) * (double)(CustomSlider.this.maxValue - 1) + 1.5);
                        if (CustomSlider.this.value > CustomSlider.this.maxValue) {
                            CustomSlider.this.value = CustomSlider.this.maxValue;
                        }
                        if (CustomSlider.this.value < 1) {
                            CustomSlider.this.value = 1;
                        }
                        PrintPanel.this.updatePreview();
                        CustomSlider.this.repaint();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getY() < 20) {
                        double d = (double)(mouseEvent.getX() - 9) / (double)(CustomSlider.this.getWidth() - 18) * (double)(CustomSlider.this.maxValue - 1) + 1.0;
                        if (d > (double)CustomSlider.this.value) {
                            CustomSlider.this.value++;
                        } else if (d < (double)CustomSlider.this.value) {
                            CustomSlider.this.value--;
                        }
                        if (CustomSlider.this.value > CustomSlider.this.maxValue) {
                            CustomSlider.this.value = CustomSlider.this.maxValue;
                        }
                        if (CustomSlider.this.value < 1) {
                            CustomSlider.this.value = 1;
                        }
                        PrintPanel.this.updatePreview();
                        CustomSlider.this.repaint();
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getY() < 20) {
                        CustomSlider.this.dragging = true;
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    CustomSlider.this.dragging = false;
                }
            });
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setPaint(new Color(240, 240, 240));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.drawString("Sheet " + this.value + " of " + this.maxValue, 2, n2 - 3);
            graphics2D.setPaint(Color.LIGHT_GRAY);
            graphics2D.fillRect(10, 11, n - 19, 3);
            graphics2D.setPaint(Color.GRAY);
            graphics2D.drawLine(9, 12, n - 9, 12);
            float f = 9.0f + (float)(this.value - 1) / (float)(this.maxValue - 1) * (float)(n - 18);
            Ellipse2D.Float float_ = new Ellipse2D.Float(f - 6.0f, 6.5f, 12.0f, 12.0f);
            Ellipse2D.Float float_2 = new Ellipse2D.Float(f - 4.0f, 8.5f, 8.0f, 8.0f);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.fill(float_);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(float_2);
        }

        public void setValue(int n) {
            this.value = n;
            this.repaint();
        }

        public void setMaxValue(int n) {
            if (n != this.maxValue) {
                this.value = 1;
                this.maxValue = n;
                PrintPanel.this.updatePreview();
                return;
            }
            this.maxValue = n;
            this.repaint();
        }

        public int getValue() {
            return this.value;
        }
    }
}

