/*
 * Decompiled with CFR 0.152.
 */
package org.jfr.parser;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.TextState;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class GenericStreamDecoder {
    static final boolean debug = false;
    public static final String version = "0.1";
    protected TextState currentTextState = new TextState();
    protected int glyphCount = 0;
    protected PdfFont currentFontData;
    protected GlyphFactory factory = null;
    protected boolean renderDirectly;
    protected DynamicVectorRenderer current;
    protected float charSpacing = 0.0f;
    protected Graphics2D g2;
    protected GenericColorSpace strokeColorSpace = new DeviceRGBColorSpace();
    protected GenericColorSpace nonstrokeColorSpace = new DeviceRGBColorSpace();
    protected GraphicsState currentGraphicsState = new GraphicsState();
    private static final String separator = System.getProperty("file.separator");
    public static Map fontSubstitutionTable = new HashMap();
    public static Map fontSubstitutionLocation = new HashMap();
    public static Map fontSubstitutionAliasTable = new HashMap();
    public static boolean enforceFontSubstitution = false;
    private double leftMargin;
    private double rightMargin;
    private static final int MEASURE = 1;
    private static final int DRAW = 2;
    String[] fontList = null;
    private Map fontPool = new HashMap();
    private int fontSize = 0;
    private String pageErrorMessages = "";

    public GenericStreamDecoder(DynamicVectorRenderer dynamicVectorRenderer) {
        String string;
        this.current = dynamicVectorRenderer;
        try {
            string = System.getProperty("org.jpedal.fontmaps");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=:");
                    int n = stringTokenizer2.countTokens() - 1;
                    String[] stringArray = new String[n];
                    String string3 = stringTokenizer2.nextToken();
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = stringTokenizer2.nextToken();
                    }
                    this.setSubstitutedFontAliases(string3, stringArray);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to read FontMaps " + exception.getMessage());
        }
        try {
            string = System.getProperty("org.jpedal.fontdirs");
            if (string == null) {
                this.addFontDirs("/Library/Fonts/,C:/win/fonts/,C:/WINDOWS/fonts/,/usr/X11R6/lib/X11/fonts/truetype/");
            } else {
                this.addFontDirs(string);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to read fontDirs " + exception.getMessage());
        }
    }

    private void addFontDirs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.endsWith("/") & !string2.endsWith("\\")) {
                string2 = string2 + separator;
            }
            LogWriter.writeLog("Looking in " + string2 + " for fonts");
            this.addFont(string2);
        }
    }

    private void addFont(String string) {
        String[] stringArray;
        File file = new File(string);
        if (file.exists() && file.isDirectory() && (stringArray = file.list()) != null) {
            for (String string2 : stringArray) {
                if (!string2.toLowerCase().endsWith(".ttf")) continue;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(string + string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                if (fileInputStream != null) {
                    int n = string2.indexOf(46);
                    String string3 = n == -1 ? string2 : string2.substring(0, n);
                    fontSubstitutionTable.put(string3.toLowerCase(), "/TrueType");
                    fontSubstitutionLocation.put(string3.toLowerCase(), string + string2);
                    LogWriter.writeLog("Added truetype font " + string3 + " path=" + string + string2);
                    continue;
                }
                LogWriter.writeLog("No fonts found at " + string);
            }
        }
    }

    public void setSubstitutedFontAliases(String string, String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                fontSubstitutionAliasTable.put(stringArray[i].toLowerCase(), string.toLowerCase());
            }
        }
    }

    public double getStringLength(String string) {
        return this.setText(string, 1) - this.currentTextState.Tm[2][0];
    }

    public double setText(String string) {
        return this.setText(string, 2);
    }

    public final void setTextLocationMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.currentTextState.Tm[0][0] = f;
        this.currentTextState.Tm[0][1] = f2;
        this.currentTextState.Tm[0][2] = 0.0f;
        this.currentTextState.Tm[1][0] = f3;
        this.currentTextState.Tm[1][1] = f4;
        this.currentTextState.Tm[1][2] = 0.0f;
        this.currentTextState.Tm[2][0] = f5;
        this.currentTextState.Tm[2][1] = f6;
        this.currentTextState.Tm[2][2] = 1.0f;
        this.currentTextState.setLeading(1.0f);
        this.currentTextState.setTMAtLineStart();
    }

    private float setText(String string, int n) {
        float[][] fArray = new float[3][3];
        float[][] fArray2 = new float[3][3];
        int n2 = 32;
        int n3 = 0;
        int n4 = 0;
        float f = 0.0f;
        String string2 = "";
        float f2 = this.currentTextState.getTfs();
        this.charSpacing = this.currentTextState.getCharacterSpacing() / f2;
        boolean bl = this.currentFontData.isCIDFont();
        PdfJavaGlyphs pdfJavaGlyphs = this.currentFontData.getGlyphData();
        this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
        this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
        fArray = Matrix.multiply(this.currentTextState.Tm, this.currentGraphicsState.CTM);
        fArray[0][0] = fArray[0][0];
        fArray[0][1] = fArray[0][1];
        fArray[1][0] = fArray[1][0];
        fArray[1][1] = fArray[1][1];
        fArray2[0][0] = f2 * this.currentTextState.getHorizontalScaling();
        fArray2[1][1] = f2;
        fArray2[2][1] = this.currentTextState.getTextRise();
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        if (fArray[1][1] != 0.0f) {
            n3 = Math.round(fArray[1][1]);
            if (n3 == 0) {
                n3 = Math.round(fArray[0][1]);
            }
        } else {
            n3 = Math.round(fArray[1][0]);
            if (n3 == 0) {
                n3 = Math.round(fArray[0][0]);
            }
            if (n3 < 0) {
                n3 = -n3;
            }
        }
        if (n3 == 0) {
            n3 = 1;
        }
        int n5 = string.length();
        for (int i = 0; i < n5; ++i) {
            block25: {
                n4 = n2 = (int)string.charAt(i);
                string2 = String.valueOf((char)n2);
                fArray2[0][0] = 1.0f;
                fArray2[0][1] = 0.0f;
                fArray2[0][2] = 0.0f;
                fArray2[1][0] = 0.0f;
                fArray2[1][1] = 1.0f;
                fArray2[1][2] = 0.0f;
                fArray2[2][0] = f;
                fArray2[2][1] = 0.0f;
                fArray2[2][2] = 1.0f;
                fArray = Matrix.multiply(fArray2, fArray);
                if (n == 2 && (double)fArray[2][0] > this.rightMargin) {
                    this.relativeMove(0.0f, -this.currentTextState.getLeading() * f2);
                    fArray[2][0] = (float)this.leftMargin;
                    fArray[2][1] = this.currentTextState.Tm[2][1];
                }
                String string3 = "notdef";
                f = this.currentFontData.getGlyphWidth(string3, n4, string2);
                if (!bl) {
                    if (n4 > 255) {
                        n2 = 32;
                    } else {
                        string3 = this.currentFontData.getMappedChar(n4, false);
                    }
                }
                if (n != 1 && n2 != 32) {
                    boolean bl2;
                    PdfPaint pdfPaint;
                    Cloneable cloneable;
                    if (this.currentFontData.isFontEmbedded) {
                        PdfGlyph pdfGlyph = pdfJavaGlyphs.getEmbeddedGlyph(this.factory, string3, fArray, n4, string2, f, null);
                        try {
                            if (pdfGlyph == null) break block25;
                            cloneable = new AffineTransform(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1] - (float)this.fontSize);
                            ((AffineTransform)cloneable).scale(this.currentFontData.FontMatrix[0], this.currentFontData.FontMatrix[3]);
                            int n6 = 4;
                            if (this.renderDirectly) {
                                pdfPaint = null;
                                PdfPaint pdfPaint2 = null;
                                int n7 = this.currentGraphicsState.getTextRenderType();
                                if ((n7 & 2) == 2) {
                                    pdfPaint2 = this.currentGraphicsState.getNonstrokeColor();
                                }
                                if ((n7 & 1) == 1) {
                                    pdfPaint = this.currentGraphicsState.getStrokeColor();
                                }
                                this.current.renderEmbeddedText(this.currentGraphicsState, n7, pdfGlyph, n6, this.g2, (AffineTransform)cloneable, null, pdfPaint, pdfPaint2, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha(), null, 0);
                                break block25;
                            }
                            this.current.drawEmbeddedText(fArray, n3, pdfGlyph, null, n6, this.currentGraphicsState, (AffineTransform)cloneable);
                        }
                        catch (Exception exception) {
                            this.addPageFailureMessage("Exception " + exception + " on embedded font renderer");
                        }
                    } else if (string2.length() > 0 && !string2.startsWith("&#") && (cloneable = pdfJavaGlyphs.getStandardGlyph(fArray, n4, string2, f, bl2 = PdfDecoder.isRunningOnMac || StandardFonts.isStandardFont(pdfJavaGlyphs.getBaseFontName(), false))) != null) {
                        if (this.renderDirectly) {
                            PdfPaint pdfPaint3 = null;
                            pdfPaint = null;
                            int n8 = this.currentGraphicsState.getTextRenderType();
                            if ((n8 & 2) == 2) {
                                pdfPaint = this.currentGraphicsState.getNonstrokeColor();
                            }
                            if ((n8 & 1) == 1) {
                                pdfPaint3 = this.currentGraphicsState.getStrokeColor();
                            }
                            AffineTransform affineTransform = this.g2.getTransform();
                            this.g2.translate(fArray[2][0], fArray[2][1]);
                            this.g2.scale(fArray[0][0], -fArray[1][1]);
                            this.current.renderText(fArray[2][0], fArray[2][1], n8, (Area)cloneable, this.g2, null, pdfPaint3, pdfPaint, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha());
                            this.g2.setTransform(affineTransform);
                        } else {
                            this.current.drawEmbeddedText(fArray, n3, null, cloneable, 1, this.currentGraphicsState, null);
                        }
                    }
                }
            }
            f += this.charSpacing;
        }
        fArray2[0][0] = 1.0f;
        fArray2[0][1] = 0.0f;
        fArray2[0][2] = 0.0f;
        fArray2[1][0] = 0.0f;
        fArray2[1][1] = 1.0f;
        fArray2[1][2] = 0.0f;
        fArray2[2][0] = f;
        fArray2[2][1] = 0.0f;
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        if (n != 1) {
            this.currentTextState.Tm[2][0] = fArray[2][0];
            this.currentTextState.Tm[2][1] = fArray[2][1];
        }
        return fArray[2][0];
    }

    public void setFont(String string, int n) throws Exception {
        string = string.toLowerCase();
        this.currentTextState.setFontTfs(n);
        String string2 = (String)fontSubstitutionLocation.get(string);
        if (string2 == null) {
            throw new Exception("Font " + string + " does not have a truetype font available");
        }
        this.currentFontData = (PdfFont)this.fontPool.get(string);
        if (this.currentFontData == null) {
            this.currentFontData = this.readFont(string);
            this.fontPool.put(string, this.currentFontData);
        }
        this.fontSize = n;
    }

    private PdfFont readFont(String string) {
        LogWriter.writeMethod("{readFonts}", 0);
        String string2 = null;
        TrueType trueType = null;
        if (fontSubstitutionTable != null) {
            string2 = (String)fontSubstitutionLocation.get(string);
        }
        try {
            trueType = new TrueType(string2);
            ((PdfFont)trueType).createFont(string);
        }
        catch (Exception exception) {
            LogWriter.writeLog("[PDF] Problem " + exception + " reading Font  type " + string2);
            this.addPageFailureMessage("Problem " + exception + " reading Font  type " + string2);
        }
        return trueType;
    }

    public void lineDown(int n) {
        this.relativeMove(0.0f, -this.currentTextState.getLeading() * this.currentTextState.getTfs() * (float)n);
    }

    public void tab() {
        this.setCurrentXpt(this.getCurrentXpt() + 50.0f);
    }

    public void setForeground(PdfPaint pdfPaint) {
        this.nonstrokeColorSpace.setColor(pdfPaint);
    }

    public void setRightMargin(double d) {
        this.rightMargin = d;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public void setLeftMargin(double d) {
        this.leftMargin = d;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public float getCurrentXpt() {
        return this.currentTextState.Tm[2][0];
    }

    public float getCurrentYpt() {
        return this.currentTextState.Tm[2][1];
    }

    public void setCurrentXpt(double d) {
        this.currentTextState.Tm[2][0] = (float)d;
    }

    public void setCurrentYpt(double d) {
        this.currentTextState.Tm[2][1] = (float)d;
    }

    public String[] getFontList() {
        if (this.fontList == null) {
            Object[] objectArray = fontSubstitutionLocation.keySet().toArray();
            System.out.println(fontSubstitutionLocation);
            int n = objectArray.length;
            this.fontList = new String[n];
            for (int i = 0; i < n; ++i) {
                this.fontList[i] = objectArray[i].toString();
            }
        }
        return this.fontList;
    }

    protected final void relativeMove(float f, float f2) {
        float[][] fArray = new float[3][3];
        this.currentTextState.Tm = this.currentTextState.getTMAtLineStart();
        fArray[0][0] = 1.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = f;
        fArray[2][1] = f2;
        fArray[2][2] = 1.0f;
        this.currentTextState.Tm = Matrix.multiply(fArray, this.currentTextState.Tm);
        this.currentTextState.setTMAtLineStart();
    }

    public void addPageFailureMessage(String string) {
        this.pageErrorMessages = this.pageErrorMessages + string + '\n';
    }
}

