/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.util;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;

public final class Util {
    private static final char[] HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private static final char[] SHA_256_CHARS = new char[64];
    private static final char[] SHA_1_CHARS = new char[40];

    private Util() {
    }

    public static String sha256BytesToHex(byte[] bytes) {
        char[] cArray = SHA_256_CHARS;
        synchronized (SHA_256_CHARS) {
            byte[] byArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Util.bytesToHex(byArray, SHA_256_CHARS);
        }
    }

    public static String sha1BytesToHex(byte[] bytes) {
        char[] cArray = SHA_1_CHARS;
        synchronized (SHA_1_CHARS) {
            byte[] byArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Util.bytesToHex(byArray, SHA_1_CHARS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String bytesToHex(byte[] bytes, char[] hexChars) {
        void var1_1;
        int n2 = 0;
        while (n2 < bytes.length) {
            int n3 = bytes[n2] & 0xFF;
            hexChars[n2 * 2] = HEX_CHAR_ARRAY[n3 >>> 4];
            hexChars[n2 * 2 + 1] = HEX_CHAR_ARRAY[n3 & 0xF];
            ++n2;
        }
        return new String((char[])var1_1);
    }

    @Deprecated
    public static int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    @TargetApi(value=19)
    public static int getBitmapByteSize(Bitmap bitmap) {
        Bitmap bitmap2;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (NullPointerException nullPointerException) {}
        }
        return bitmap.getHeight() * bitmap2.getRowBytes();
    }

    /*
     * WARNING - void declaration
     */
    public static int getBitmapByteSize(int width, int height, Bitmap.Config config) {
        void var2_2;
        void var1_1;
        return width * var1_1 * Util.getBytesPerPixel((Bitmap.Config)var2_2);
    }

    private static int getBytesPerPixel(Bitmap.Config config) {
        int n2;
        Bitmap.Config config2;
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        switch (config2) {
            case ALPHA_8: {
                n2 = 1;
                break;
            }
            case ARGB_4444: 
            case RGB_565: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidDimensions(int width, int height) {
        void var1_1;
        return Util.isValidDimension(width) && Util.isValidDimension((int)var1_1);
    }

    private static boolean isValidDimension(int dimen) {
        int n2;
        return dimen > 0 || n2 == Integer.MIN_VALUE;
    }

    public static void assertMainThread() {
        if (!Util.isOnMainThread()) {
            throw new IllegalArgumentException("You must call this method on the main thread");
        }
    }

    public static void assertBackgroundThread() {
        if (!Util.isOnBackgroundThread()) {
            throw new IllegalArgumentException("YOu must call this method on a background thread");
        }
    }

    public static boolean isOnMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean isOnBackgroundThread() {
        return !Util.isOnMainThread();
    }

    public static <T> Queue<T> createQueue(int size) {
        int n2;
        return new ArrayDeque(n2);
    }

    public static <T> List<T> getSnapshot(Collection<T> other) {
        ArrayList<Collection<T>> arrayList = new ArrayList<Collection<T>>(other.size());
        for (Collection<T> collection : collection) {
            arrayList.add(collection);
        }
        return arrayList;
    }
}

