/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.util;

import com.thirdparty.bumptech.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;

public class ExceptionCatchingInputStream
extends InputStream {
    private static final Queue<ExceptionCatchingInputStream> QUEUE = Util.createQueue(0);
    private InputStream wrapped;
    private IOException exception;

    public static ExceptionCatchingInputStream obtain(InputStream toWrap) {
        InputStream inputStream;
        ExceptionCatchingInputStream exceptionCatchingInputStream;
        Queue<ExceptionCatchingInputStream> queue = QUEUE;
        synchronized (queue) {
            exceptionCatchingInputStream = QUEUE.poll();
        }
        if (exceptionCatchingInputStream == null) {
            exceptionCatchingInputStream = new ExceptionCatchingInputStream();
        }
        exceptionCatchingInputStream.setInputStream(inputStream);
        return exceptionCatchingInputStream;
    }

    static void clearQueue() {
        while (!QUEUE.isEmpty()) {
            QUEUE.remove();
        }
    }

    ExceptionCatchingInputStream() {
    }

    /*
     * WARNING - void declaration
     */
    void setInputStream(InputStream toWrap) {
        void var1_1;
        this.wrapped = var1_1;
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mark(int readlimit) {
        void var1_1;
        this.wrapped.mark((int)var1_1);
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] buffer) {
        int n2;
        try {
            void var1_1;
            n2 = this.wrapped.read((byte[])var1_1);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            n2 = -1;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) {
        int n2;
        try {
            void var3_5;
            void var2_4;
            void var1_1;
            n2 = this.wrapped.read((byte[])var1_1, (int)var2_4, (int)var3_5);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            n2 = -1;
        }
        return n2;
    }

    @Override
    public synchronized void reset() {
        this.wrapped.reset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long byteCount) {
        long l2;
        try {
            void var1_1;
            l2 = this.wrapped.skip((long)var1_1);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            l2 = 0L;
        }
        return l2;
    }

    @Override
    public int read() {
        int n2;
        try {
            n2 = this.wrapped.read();
        }
        catch (IOException iOException) {
            this.exception = iOException;
            n2 = -1;
        }
        return n2;
    }

    public IOException getException() {
        return this.exception;
    }

    public void release() {
        this.exception = null;
        this.wrapped = null;
        Queue<ExceptionCatchingInputStream> queue = QUEUE;
        synchronized (queue) {
            QUEUE.offer(this);
            return;
        }
    }
}

