/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.util;

import android.text.TextUtils;
import android.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentLengthInputStream
extends FilterInputStream {
    private static final String TAG = "ContentLengthStream";
    private static final int UNKNOWN = -1;
    private final long contentLength;
    private int readSoFar;

    /*
     * WARNING - void declaration
     */
    public static InputStream obtain(InputStream other, String contentLengthHeader) {
        void var1_1;
        return ContentLengthInputStream.obtain(other, ContentLengthInputStream.parseContentLength((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream obtain(InputStream other, long contentLength) {
        void var1_1;
        InputStream inputStream;
        return new ContentLengthInputStream(inputStream, (long)var1_1);
    }

    private static int parseContentLength(String contentLengthHeader) {
        int n2;
        block3: {
            n2 = -1;
            if (!TextUtils.isEmpty((CharSequence)contentLengthHeader)) {
                try {
                    n2 = Integer.parseInt(contentLengthHeader);
                }
                catch (NumberFormatException numberFormatException) {
                    String string;
                    if (!Log.isLoggable((String)TAG, (int)3)) break block3;
                    Log.d((String)TAG, (String)("failed to parse content length header: " + string), (Throwable)numberFormatException);
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    ContentLengthInputStream(InputStream in, long contentLength) {
        super((InputStream)var1_1);
        void var2_2;
        void var1_1;
        this.contentLength = var2_2;
    }

    @Override
    public final synchronized int available() {
        return (int)Math.max(this.contentLength - (long)this.readSoFar, (long)this.in.available());
    }

    @Override
    public final synchronized int read() {
        return this.checkReadSoFarOrThrow(super.read());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(byte[] buffer) {
        void var1_1;
        return this.read(buffer, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int read(byte[] buffer, int byteOffset, int byteCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.checkReadSoFarOrThrow(super.read((byte[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private int checkReadSoFarOrThrow(int read) {
        void var1_1;
        if (read >= 0) {
            this.readSoFar += read;
        } else if (this.contentLength - (long)this.readSoFar > 0L) {
            throw new IOException("Failed to read all expected data, expected: " + this.contentLength + ", but read: " + this.readSoFar);
        }
        return (int)var1_1;
    }
}

