/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.util;

import android.util.Log;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.Queue;

public final class ByteArrayPool {
    private static final String TAG = "ByteArrayPool";
    private static final int TEMP_BYTES_SIZE = 65536;
    private static final int MAX_SIZE = 0x20C000;
    private static final int MAX_BYTE_ARRAY_COUNT = 32;
    private final Queue<byte[]> tempQueue = Util.createQueue(0);
    private static final ByteArrayPool BYTE_ARRAY_POOL = new ByteArrayPool();

    public static ByteArrayPool get() {
        return BYTE_ARRAY_POOL;
    }

    private ByteArrayPool() {
    }

    public final void clear() {
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            this.tempQueue.clear();
            return;
        }
    }

    public final byte[] getBytes() {
        byte[] byArray;
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            byArray = this.tempQueue.poll();
        }
        if (byArray == null) {
            byArray = new byte[65536];
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Created temp bytes");
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean releaseBytes(byte[] bytes) {
        if (bytes.length != 65536) {
            return false;
        }
        boolean bl = false;
        Queue<byte[]> queue = this.tempQueue;
        synchronized (queue) {
            if (this.tempQueue.size() < 32) {
                void var1_1;
                bl = true;
                this.tempQueue.offer((byte[])var1_1);
            }
        }
        return bl;
    }
}

