/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.signature;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.thirdparty.bumptech.glide.load.Key;
import com.thirdparty.bumptech.glide.signature.StringSignature;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class ApplicationVersionSignature {
    private static final ConcurrentHashMap<String, Key> PACKAGE_NAME_TO_KEY = new ConcurrentHashMap();

    public static Key obtain(Context context) {
        Object object;
        String string = context.getPackageName();
        Key key = PACKAGE_NAME_TO_KEY.get(string);
        if (key == null && (key = PACKAGE_NAME_TO_KEY.putIfAbsent(string, (Key)(object = ApplicationVersionSignature.obtainVersionSignature(object)))) == null) {
            key = object;
        }
        return key;
    }

    static void reset() {
        PACKAGE_NAME_TO_KEY.clear();
    }

    private static Key obtainVersionSignature(Context context) {
        Object object;
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(object.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = null;
            nameNotFoundException.printStackTrace();
        }
        object = packageInfo != null ? String.valueOf(packageInfo.versionCode) : UUID.randomUUID().toString();
        return new StringSignature((String)object);
    }

    private ApplicationVersionSignature() {
    }
}

