/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.module;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.thirdparty.bumptech.glide.module.GlideModule;
import java.util.ArrayList;
import java.util.List;

public final class ManifestParser {
    private static final String GLIDE_MODULE_VALUE = "GlideModule";
    private final Context context;

    /*
     * WARNING - void declaration
     */
    public ManifestParser(Context context) {
        void var1_1;
        this.context = var1_1;
    }

    public final List<GlideModule> parse() {
        ArrayList<GlideModule> arrayList = new ArrayList<GlideModule>();
        try {
            ApplicationInfo applicationInfo = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                for (String string : applicationInfo.metaData.keySet()) {
                    if (!GLIDE_MODULE_VALUE.equals(applicationInfo.metaData.get(string))) continue;
                    arrayList.add(ManifestParser.parseModule(string));
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new RuntimeException("Unable to find metadata to parse GlideModules", nameNotFoundException);
        }
        return arrayList;
    }

    private static GlideModule parseModule(String className) {
        Object t2;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unable to find GlideModule implementation", classNotFoundException);
        }
        try {
            t2 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Unable to instantiate GlideModule implementation for " + clazz, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Unable to instantiate GlideModule implementation for " + clazz, illegalAccessException);
        }
        if (!(t2 instanceof GlideModule)) {
            throw new RuntimeException("Expected instanceof GlideModule, but found: " + t2);
        }
        return (GlideModule)t2;
    }
}

