/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.manager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import com.thirdparty.bumptech.glide.RequestManager;
import com.thirdparty.bumptech.glide.manager.ApplicationLifecycle;
import com.thirdparty.bumptech.glide.manager.EmptyRequestManagerTreeNode;
import com.thirdparty.bumptech.glide.manager.RequestManagerFragment;
import com.thirdparty.bumptech.glide.manager.SupportRequestManagerFragment;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.HashMap;
import java.util.Map;

public class RequestManagerRetriever
implements Handler.Callback {
    private static final String TAG = "RMRetriever";
    static final String FRAGMENT_TAG = "com.third.bumptech.glide.manager";
    private static final RequestManagerRetriever INSTANCE = new RequestManagerRetriever();
    private static final int ID_REMOVE_FRAGMENT_MANAGER = 1;
    private static final int ID_REMOVE_SUPPORT_FRAGMENT_MANAGER = 2;
    private volatile RequestManager applicationManager;
    final Map<android.app.FragmentManager, RequestManagerFragment> pendingRequestManagerFragments = new HashMap<android.app.FragmentManager, RequestManagerFragment>();
    final Map<FragmentManager, SupportRequestManagerFragment> pendingSupportRequestManagerFragments = new HashMap<FragmentManager, SupportRequestManagerFragment>();
    private final Handler handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);

    public static RequestManagerRetriever get() {
        return INSTANCE;
    }

    RequestManagerRetriever() {
    }

    /*
     * WARNING - void declaration
     */
    private RequestManager getApplicationManager(Context context) {
        if (this.applicationManager == null) {
            RequestManagerRetriever requestManagerRetriever = this;
            synchronized (requestManagerRetriever) {
                if (this.applicationManager == null) {
                    void var1_1;
                    this.applicationManager = new RequestManager(var1_1.getApplicationContext(), new ApplicationLifecycle(), new EmptyRequestManagerTreeNode());
                }
            }
        }
        return this.applicationManager;
    }

    /*
     * WARNING - void declaration
     */
    public RequestManager get(Context context) {
        void var1_1;
        if (context == null) {
            throw new IllegalArgumentException("You cannot start a load on a null Context");
        }
        if (Util.isOnMainThread() && !(context instanceof Application)) {
            if (context instanceof FragmentActivity) {
                return this.get((FragmentActivity)context);
            }
            if (context instanceof Activity) {
                return this.get((Activity)context);
            }
            if (context instanceof ContextWrapper) {
                return this.get(((ContextWrapper)context).getBaseContext());
            }
        }
        return this.getApplicationManager((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public RequestManager get(FragmentActivity activity) {
        void var1_1;
        if (Util.isOnBackgroundThread()) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed((Activity)activity);
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        return this.supportFragmentGet((Context)var1_1, fragmentManager);
    }

    /*
     * WARNING - void declaration
     */
    public RequestManager get(android.support.v4.app.Fragment fragment) {
        void var1_1;
        if (fragment.getActivity() == null) {
            throw new IllegalArgumentException("You cannot start a load on a fragment before it is attached");
        }
        if (Util.isOnBackgroundThread()) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        FragmentManager fragmentManager = fragment.getChildFragmentManager();
        return this.supportFragmentGet((Context)var1_1.getActivity(), fragmentManager);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=11)
    public RequestManager get(Activity activity) {
        void var1_1;
        if (Util.isOnBackgroundThread() || Build.VERSION.SDK_INT < 11) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed(activity);
        android.app.FragmentManager fragmentManager = activity.getFragmentManager();
        return this.fragmentGet((Context)var1_1, fragmentManager);
    }

    @TargetApi(value=17)
    private static void assertNotDestroyed(Activity activity) {
        Activity activity2;
        if (Build.VERSION.SDK_INT >= 17 && activity2.isDestroyed()) {
            throw new IllegalArgumentException("You cannot start a load for a destroyed activity");
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=17)
    public RequestManager get(Fragment fragment) {
        void var1_1;
        if (fragment.getActivity() == null) {
            throw new IllegalArgumentException("You cannot start a load on a fragment before it is attached");
        }
        if (Util.isOnBackgroundThread() || Build.VERSION.SDK_INT < 17) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        android.app.FragmentManager fragmentManager = fragment.getChildFragmentManager();
        return this.fragmentGet((Context)var1_1.getActivity(), fragmentManager);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=17)
    RequestManagerFragment getRequestManagerFragment(android.app.FragmentManager fm) {
        RequestManagerFragment requestManagerFragment = (RequestManagerFragment)fm.findFragmentByTag(FRAGMENT_TAG);
        if (requestManagerFragment == null && (requestManagerFragment = this.pendingRequestManagerFragments.get(fm)) == null) {
            void var1_1;
            requestManagerFragment = new RequestManagerFragment();
            this.pendingRequestManagerFragments.put(fm, requestManagerFragment);
            fm.beginTransaction().add((Fragment)requestManagerFragment, FRAGMENT_TAG).commitAllowingStateLoss();
            this.handler.obtainMessage(1, (Object)var1_1).sendToTarget();
        }
        return requestManagerFragment;
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=11)
    RequestManager fragmentGet(Context context, android.app.FragmentManager fm) {
        RequestManagerFragment requestManagerFragment;
        RequestManager requestManager = (requestManagerFragment = this.getRequestManagerFragment((android.app.FragmentManager)requestManagerFragment)).getRequestManager();
        if (requestManager == null) {
            void var1_1;
            requestManager = new RequestManager((Context)var1_1, requestManagerFragment.getLifecycle(), requestManagerFragment.getRequestManagerTreeNode());
            requestManagerFragment.setRequestManager(requestManager);
        }
        return requestManager;
    }

    /*
     * WARNING - void declaration
     */
    SupportRequestManagerFragment getSupportRequestManagerFragment(FragmentManager fm) {
        SupportRequestManagerFragment supportRequestManagerFragment = (SupportRequestManagerFragment)fm.findFragmentByTag(FRAGMENT_TAG);
        if (supportRequestManagerFragment == null && (supportRequestManagerFragment = this.pendingSupportRequestManagerFragments.get(fm)) == null) {
            void var1_1;
            supportRequestManagerFragment = new SupportRequestManagerFragment();
            this.pendingSupportRequestManagerFragments.put(fm, supportRequestManagerFragment);
            fm.beginTransaction().add((android.support.v4.app.Fragment)supportRequestManagerFragment, FRAGMENT_TAG).commitAllowingStateLoss();
            this.handler.obtainMessage(2, (Object)var1_1).sendToTarget();
        }
        return supportRequestManagerFragment;
    }

    /*
     * WARNING - void declaration
     */
    RequestManager supportFragmentGet(Context context, FragmentManager fm) {
        SupportRequestManagerFragment supportRequestManagerFragment;
        RequestManager requestManager = (supportRequestManagerFragment = this.getSupportRequestManagerFragment((FragmentManager)supportRequestManagerFragment)).getRequestManager();
        if (requestManager == null) {
            void var1_1;
            requestManager = new RequestManager((Context)var1_1, supportRequestManagerFragment.getLifecycle(), supportRequestManagerFragment.getRequestManagerTreeNode());
            supportRequestManagerFragment.setRequestManager(requestManager);
        }
        return requestManager;
    }

    public boolean handleMessage(Message message) {
        boolean bl = true;
        Object object = null;
        android.app.FragmentManager fragmentManager = null;
        switch (message.what) {
            case 1: {
                android.app.FragmentManager fragmentManager2;
                fragmentManager = fragmentManager2 = (android.app.FragmentManager)fragmentManager2.obj;
                object = this.pendingRequestManagerFragments.remove(fragmentManager2);
                break;
            }
            case 2: {
                android.app.FragmentManager fragmentManager2;
                fragmentManager = fragmentManager2 = (FragmentManager)fragmentManager2.obj;
                object = this.pendingSupportRequestManagerFragments.remove(fragmentManager2);
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && object == null && Log.isLoggable((String)TAG, (int)5)) {
            Log.w((String)TAG, (String)("Failed to remove expected request manager fragment, manager: " + fragmentManager));
        }
        return bl;
    }
}

