/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.manager;

import com.thirdparty.bumptech.glide.manager.Lifecycle;
import com.thirdparty.bumptech.glide.manager.LifecycleListener;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

class ActivityFragmentLifecycle
implements Lifecycle {
    private final Set<LifecycleListener> lifecycleListeners = Collections.newSetFromMap(new WeakHashMap());
    private boolean isStarted;
    private boolean isDestroyed;

    ActivityFragmentLifecycle() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addListener(LifecycleListener listener) {
        void var1_1;
        this.lifecycleListeners.add(listener);
        if (this.isDestroyed) {
            listener.onDestroy();
            return;
        }
        if (this.isStarted) {
            listener.onStart();
            return;
        }
        var1_1.onStop();
    }

    void onStart() {
        this.isStarted = true;
        Iterator<LifecycleListener> iterator = Util.getSnapshot(this.lifecycleListeners).iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    void onStop() {
        this.isStarted = false;
        Iterator<LifecycleListener> iterator = Util.getSnapshot(this.lifecycleListeners).iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    void onDestroy() {
        this.isDestroyed = true;
        Iterator<LifecycleListener> iterator = Util.getSnapshot(this.lifecycleListeners).iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }
}

