/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.gifbitmap;

import android.graphics.Bitmap;
import com.thirdparty.bumptech.glide.load.ResourceDecoder;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.model.ImageVideoWrapper;
import com.thirdparty.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.thirdparty.bumptech.glide.load.resource.bitmap.ImageHeaderParser$ImageType;
import com.thirdparty.bumptech.glide.load.resource.gif.GifDrawable;
import com.thirdparty.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapper;
import com.thirdparty.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapperResource;
import com.thirdparty.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapperResourceDecoder$BufferedStreamFactory;
import com.thirdparty.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapperResourceDecoder$ImageTypeParser;
import com.thirdparty.bumptech.glide.util.ByteArrayPool;
import java.io.InputStream;

public class GifBitmapWrapperResourceDecoder
implements ResourceDecoder<ImageVideoWrapper, GifBitmapWrapper> {
    private static final GifBitmapWrapperResourceDecoder$ImageTypeParser DEFAULT_PARSER = new GifBitmapWrapperResourceDecoder$ImageTypeParser();
    private static final GifBitmapWrapperResourceDecoder$BufferedStreamFactory DEFAULT_STREAM_FACTORY = new GifBitmapWrapperResourceDecoder$BufferedStreamFactory();
    static final int MARK_LIMIT_BYTES = 2048;
    private final ResourceDecoder<ImageVideoWrapper, Bitmap> bitmapDecoder;
    private final ResourceDecoder<InputStream, GifDrawable> gifDecoder;
    private final BitmapPool bitmapPool;
    private final GifBitmapWrapperResourceDecoder$ImageTypeParser parser;
    private final GifBitmapWrapperResourceDecoder$BufferedStreamFactory streamFactory;
    private String id;

    /*
     * WARNING - void declaration
     */
    public GifBitmapWrapperResourceDecoder(ResourceDecoder<ImageVideoWrapper, Bitmap> bitmapDecoder, ResourceDecoder<InputStream, GifDrawable> gifDecoder, BitmapPool bitmapPool) {
        this((ResourceDecoder<ImageVideoWrapper, Bitmap>)var1_1, (ResourceDecoder<InputStream, GifDrawable>)var2_2, (BitmapPool)var3_3, DEFAULT_PARSER, DEFAULT_STREAM_FACTORY);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    GifBitmapWrapperResourceDecoder(ResourceDecoder<ImageVideoWrapper, Bitmap> bitmapDecoder, ResourceDecoder<InputStream, GifDrawable> gifDecoder, BitmapPool bitmapPool, GifBitmapWrapperResourceDecoder$ImageTypeParser parser, GifBitmapWrapperResourceDecoder$BufferedStreamFactory streamFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.bitmapDecoder = var1_1;
        this.gifDecoder = var2_2;
        this.bitmapPool = var3_3;
        this.parser = parser;
        this.streamFactory = streamFactory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Resource<GifBitmapWrapper> decode(ImageVideoWrapper source, int width, int height) {
        ByteArrayPool byteArrayPool = ByteArrayPool.get();
        byte[] byArray = byteArrayPool.getBytes();
        GifBitmapWrapper gifBitmapWrapper = null;
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            gifBitmapWrapper = this.decode((ImageVideoWrapper)var1_1, (int)var2_3, (int)var3_4, byArray);
        }
        finally {
            byteArrayPool.releaseBytes(byArray);
        }
        if (gifBitmapWrapper != null) {
            return new GifBitmapWrapperResource(gifBitmapWrapper);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private GifBitmapWrapper decode(ImageVideoWrapper source, int width, int height, byte[] bytes) {
        void var3_3;
        void var2_2;
        GifBitmapWrapper gifBitmapWrapper;
        gifBitmapWrapper = source.getStream() != null ? this.decodeStream((ImageVideoWrapper)((Object)gifBitmapWrapper), width, height, bytes) : this.decodeBitmapWrapper((ImageVideoWrapper)((Object)gifBitmapWrapper), (int)var2_2, (int)var3_3);
        return gifBitmapWrapper;
    }

    /*
     * WARNING - void declaration
     */
    private GifBitmapWrapper decodeStream(ImageVideoWrapper source, int width, int height, byte[] bytes) {
        InputStream inputStream = this.streamFactory.build(source.getStream(), bytes);
        inputStream.mark(2048);
        ImageHeaderParser$ImageType imageHeaderParser$ImageType = this.parser.parse(inputStream);
        inputStream.reset();
        GifBitmapWrapper gifBitmapWrapper = null;
        if (imageHeaderParser$ImageType == ImageHeaderParser$ImageType.GIF) {
            gifBitmapWrapper = this.decodeGifWrapper(inputStream, width, height);
        }
        if (gifBitmapWrapper == null) {
            void var3_3;
            void var2_2;
            ImageVideoWrapper imageVideoWrapper;
            imageVideoWrapper = new ImageVideoWrapper(inputStream, imageVideoWrapper.getFileDescriptor());
            gifBitmapWrapper = this.decodeBitmapWrapper(imageVideoWrapper, (int)var2_2, (int)var3_3);
        }
        return gifBitmapWrapper;
    }

    /*
     * WARNING - void declaration
     */
    private GifBitmapWrapper decodeGifWrapper(InputStream bis, int width, int height) {
        void var3_4;
        void var2_2;
        BitmapResource bitmapResource;
        GifBitmapWrapper gifBitmapWrapper = null;
        if ((bitmapResource = this.gifDecoder.decode((InputStream)((Object)bitmapResource), (int)var2_2, (int)var3_4)) != null) {
            GifDrawable gifDrawable = bitmapResource.get();
            if (gifDrawable.getFrameCount() > 1) {
                gifBitmapWrapper = new GifBitmapWrapper(null, bitmapResource);
            } else {
                bitmapResource = new BitmapResource(gifDrawable.getFirstFrame(), this.bitmapPool);
                gifBitmapWrapper = new GifBitmapWrapper(bitmapResource, null);
            }
        }
        return gifBitmapWrapper;
    }

    /*
     * WARNING - void declaration
     */
    private GifBitmapWrapper decodeBitmapWrapper(ImageVideoWrapper toDecode, int width, int height) {
        void var3_3;
        void var2_2;
        Resource<Bitmap> resource;
        GifBitmapWrapper gifBitmapWrapper = null;
        if ((resource = this.bitmapDecoder.decode((ImageVideoWrapper)((Object)resource), (int)var2_2, (int)var3_3)) != null) {
            gifBitmapWrapper = new GifBitmapWrapper(resource, null);
        }
        return gifBitmapWrapper;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = String.valueOf(this.gifDecoder.getId()) + this.bitmapDecoder.getId();
        }
        return this.id;
    }
}

