/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.gif;

import android.graphics.Bitmap;
import android.util.Log;
import com.thirdparty.bumptech.glide.gifdecoder.GifDecoder;
import com.thirdparty.bumptech.glide.gifdecoder.GifDecoder$BitmapProvider;
import com.thirdparty.bumptech.glide.gifdecoder.GifHeader;
import com.thirdparty.bumptech.glide.gifdecoder.GifHeaderParser;
import com.thirdparty.bumptech.glide.gifencoder.AnimatedGifEncoder;
import com.thirdparty.bumptech.glide.load.ResourceEncoder;
import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.resource.UnitTransformation;
import com.thirdparty.bumptech.glide.load.resource.gif.GifBitmapProvider;
import com.thirdparty.bumptech.glide.load.resource.gif.GifDrawable;
import com.thirdparty.bumptech.glide.load.resource.gif.GifResourceEncoder$Factory;
import com.thirdparty.bumptech.glide.util.LogTime;
import java.io.IOException;
import java.io.OutputStream;

public class GifResourceEncoder
implements ResourceEncoder<GifDrawable> {
    private static final GifResourceEncoder$Factory FACTORY = new GifResourceEncoder$Factory();
    private static final String TAG = "GifEncoder";
    private final GifDecoder$BitmapProvider provider;
    private final BitmapPool bitmapPool;
    private final GifResourceEncoder$Factory factory;

    /*
     * WARNING - void declaration
     */
    public GifResourceEncoder(BitmapPool bitmapPool) {
        this((BitmapPool)var1_1, FACTORY);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    GifResourceEncoder(BitmapPool bitmapPool, GifResourceEncoder$Factory factory) {
        void var2_2;
        void var1_1;
        this.bitmapPool = bitmapPool;
        this.provider = new GifBitmapProvider((BitmapPool)var1_1);
        this.factory = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean encode(Resource<GifDrawable> resource, OutputStream os) {
        void var2_3;
        GifDrawable gifDrawable;
        long l2 = LogTime.getLogTime();
        Transformation<Bitmap> transformation = (gifDrawable = (GifDrawable)gifDrawable.get()).getFrameTransformation();
        if (transformation instanceof UnitTransformation) {
            return this.writeDataDirect(gifDrawable.getData(), os);
        }
        GifDecoder gifDecoder = this.decodeHeaders(gifDrawable.getData());
        AnimatedGifEncoder animatedGifEncoder = this.factory.buildEncoder();
        if (!animatedGifEncoder.start((OutputStream)var2_3)) {
            return false;
        }
        int n2 = 0;
        while (n2 < gifDecoder.getFrameCount()) {
            Object object = gifDecoder.getNextFrame();
            object = this.getTransformedFrame((Bitmap)object, transformation, gifDrawable);
            try {
                if (!animatedGifEncoder.addFrame((Bitmap)object.get())) {
                    return false;
                }
                int n3 = gifDecoder.getCurrentFrameIndex();
                n3 = gifDecoder.getDelay(n3);
                animatedGifEncoder.setDelay(n3);
                gifDecoder.advance();
            }
            finally {
                object.recycle();
            }
            ++n2;
        }
        n2 = animatedGifEncoder.finish() ? 1 : 0;
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Encoded gif with " + gifDecoder.getFrameCount() + " frames and " + gifDrawable.getData().length + " bytes in " + LogTime.getElapsedMillis(l2) + " ms"));
        }
        return n2 != 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean writeDataDirect(byte[] data, OutputStream os) {
        boolean bl = true;
        try {
            void var1_1;
            void var2_3;
            var2_3.write((byte[])var1_1);
        }
        catch (IOException iOException) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to write data to output stream in GifResourceEncoder", (Throwable)iOException);
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private GifDecoder decodeHeaders(byte[] data) {
        void var1_1;
        Object object = this.factory.buildParser();
        ((GifHeaderParser)object).setData(data);
        object = ((GifHeaderParser)object).parseHeader();
        GifDecoder gifDecoder = this.factory.buildDecoder(this.provider);
        gifDecoder.setData((GifHeader)object, (byte[])var1_1);
        gifDecoder.advance();
        return gifDecoder;
    }

    /*
     * WARNING - void declaration
     */
    private Resource<Bitmap> getTransformedFrame(Bitmap currentFrame, Transformation<Bitmap> transformation, GifDrawable drawable) {
        void var3_3;
        Resource<Bitmap> resource;
        Resource<Bitmap> resource2;
        if (!(resource2 = this.factory.buildFrameResource((Bitmap)resource2, this.bitmapPool)).equals(resource = resource.transform(resource2, drawable.getIntrinsicWidth(), var3_3.getIntrinsicHeight()))) {
            resource2.recycle();
        }
        return resource;
    }

    @Override
    public String getId() {
        return "";
    }
}

