/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.thirdparty.bumptech.glide.GenericRequestBuilder;
import com.thirdparty.bumptech.glide.Glide;
import com.thirdparty.bumptech.glide.gifdecoder.GifDecoder;
import com.thirdparty.bumptech.glide.load.Encoder;
import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.engine.DiskCacheStrategy;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.resource.NullEncoder;
import com.thirdparty.bumptech.glide.load.resource.gif.GifFrameLoader$DelayTarget;
import com.thirdparty.bumptech.glide.load.resource.gif.GifFrameLoader$FrameCallback;
import com.thirdparty.bumptech.glide.load.resource.gif.GifFrameLoader$FrameLoaderCallback;
import com.thirdparty.bumptech.glide.load.resource.gif.GifFrameLoader$FrameSignature;
import com.thirdparty.bumptech.glide.load.resource.gif.GifFrameModelLoader;
import com.thirdparty.bumptech.glide.load.resource.gif.GifFrameResourceDecoder;

class GifFrameLoader {
    private final GifFrameLoader$FrameCallback callback;
    private final GifDecoder gifDecoder;
    private final Handler handler;
    private boolean isRunning = false;
    private boolean isLoadPending = false;
    private GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> requestBuilder;
    private GifFrameLoader$DelayTarget current;
    private boolean isCleared;

    /*
     * WARNING - void declaration
     */
    public GifFrameLoader(Context context, GifFrameLoader$FrameCallback callback, GifDecoder gifDecoder, int width, int height) {
        this((GifFrameLoader$FrameCallback)var2_2, gifDecoder, null, GifFrameLoader.getRequestBuilder(context, (GifDecoder)var3_3, width, height, Glide.get((Context)var1_1).getBitmapPool()));
        void var1_1;
        void var3_3;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    GifFrameLoader(GifFrameLoader$FrameCallback callback, GifDecoder gifDecoder, Handler handler, GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> requestBuilder) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new GifFrameLoader$FrameLoaderCallback(this, null));
        }
        this.callback = var1_1;
        this.gifDecoder = var2_2;
        this.handler = var3_3;
        this.requestBuilder = requestBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameTransformation(Transformation<Bitmap> transformation) {
        void var1_1;
        if (transformation == null) {
            throw new NullPointerException("Transformation must not be null");
        }
        this.requestBuilder = this.requestBuilder.transform(new Transformation[]{var1_1});
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.isCleared = false;
        this.loadNextFrame();
    }

    public void stop() {
        this.isRunning = false;
    }

    public void clear() {
        this.stop();
        if (this.current != null) {
            Glide.clear(this.current);
            this.current = null;
        }
        this.isCleared = true;
    }

    public Bitmap getCurrentFrame() {
        if (this.current != null) {
            return this.current.getResource();
        }
        return null;
    }

    private void loadNextFrame() {
        if (!this.isRunning || this.isLoadPending) {
            return;
        }
        this.isLoadPending = true;
        this.gifDecoder.advance();
        long l2 = SystemClock.uptimeMillis() + (long)this.gifDecoder.getNextDelay();
        GifFrameLoader$DelayTarget gifFrameLoader$DelayTarget = new GifFrameLoader$DelayTarget(this.handler, this.gifDecoder.getCurrentFrameIndex(), l2);
        this.requestBuilder.signature(new GifFrameLoader$FrameSignature()).into(gifFrameLoader$DelayTarget);
    }

    /*
     * WARNING - void declaration
     */
    void onFrameReady(GifFrameLoader$DelayTarget delayTarget) {
        void var1_1;
        if (this.isCleared) {
            this.handler.obtainMessage(2, (Object)delayTarget).sendToTarget();
            return;
        }
        GifFrameLoader$DelayTarget gifFrameLoader$DelayTarget = this.current;
        this.current = delayTarget;
        this.callback.onFrameReady(GifFrameLoader$DelayTarget.access$1((GifFrameLoader$DelayTarget)var1_1));
        if (gifFrameLoader$DelayTarget != null) {
            this.handler.obtainMessage(2, (Object)gifFrameLoader$DelayTarget).sendToTarget();
        }
        this.isLoadPending = false;
        this.loadNextFrame();
    }

    /*
     * WARNING - void declaration
     */
    private static GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> getRequestBuilder(Context context, GifDecoder gifDecoder, int width, int height, BitmapPool bitmapPool) {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        GifFrameResourceDecoder gifFrameResourceDecoder = new GifFrameResourceDecoder(bitmapPool);
        GifFrameModelLoader gifFrameModelLoader = new GifFrameModelLoader();
        Encoder encoder = NullEncoder.get();
        return Glide.with(context2).using(gifFrameModelLoader, GifDecoder.class).load((GifDecoder)var1_1).as(Bitmap.class, gifFrameModelLoader, GifDecoder.class).sourceEncoder(encoder).decoder(gifFrameResourceDecoder).skipMemoryCache(true).diskCacheStrategy(DiskCacheStrategy.NONE).override((int)var2_2, (int)var3_3);
    }
}

