/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.gif;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.Gravity;
import com.thirdparty.bumptech.glide.gifdecoder.GifDecoder;
import com.thirdparty.bumptech.glide.gifdecoder.GifDecoder$BitmapProvider;
import com.thirdparty.bumptech.glide.gifdecoder.GifHeader;
import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.thirdparty.bumptech.glide.load.resource.gif.GifDrawable$GifState;
import com.thirdparty.bumptech.glide.load.resource.gif.GifFrameLoader;
import com.thirdparty.bumptech.glide.load.resource.gif.GifFrameLoader$FrameCallback;

public class GifDrawable
extends GlideDrawable
implements GifFrameLoader$FrameCallback {
    private final Paint paint;
    private final Rect destRect = new Rect();
    private final GifDrawable$GifState state;
    private final GifDecoder decoder;
    private final GifFrameLoader frameLoader;
    private boolean isRunning;
    private boolean isStarted;
    private boolean isRecycled;
    private boolean isVisible = true;
    private int loopCount;
    private int maxLoopCount = -1;
    private boolean applyGravity;

    /*
     * WARNING - void declaration
     */
    public GifDrawable(Context context, GifDecoder$BitmapProvider bitmapProvider, BitmapPool bitmapPool, Transformation<Bitmap> frameTransformation, int targetFrameWidth, int targetFrameHeight, GifHeader gifHeader, byte[] data, Bitmap firstFrame) {
        this(new GifDrawable$GifState(gifHeader, data, (Context)var1_1, frameTransformation, targetFrameWidth, targetFrameHeight, (GifDecoder$BitmapProvider)var2_2, (BitmapPool)var3_3, firstFrame));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GifDrawable(GifDrawable other, Bitmap firstFrame, Transformation<Bitmap> frameTransformation) {
        this(new GifDrawable$GifState(other.state.gifHeader, other.state.data, other.state.context, (Transformation<Bitmap>)var3_3, other.state.targetWidth, other.state.targetHeight, other.state.bitmapProvider, var1_1.state.bitmapPool, (Bitmap)var2_2));
        void var2_2;
        void var1_1;
        void var3_3;
    }

    /*
     * WARNING - void declaration
     */
    GifDrawable(GifDrawable$GifState state) {
        void var1_1;
        if (state == null) {
            throw new NullPointerException("GifState must not be null");
        }
        this.state = state;
        this.decoder = new GifDecoder(state.bitmapProvider);
        this.paint = new Paint();
        this.decoder.setData(state.gifHeader, state.data);
        this.frameLoader = new GifFrameLoader(state.context, this, this.decoder, state.targetWidth, state.targetHeight);
        this.frameLoader.setFrameTransformation(var1_1.frameTransformation);
    }

    /*
     * WARNING - void declaration
     */
    GifDrawable(GifDecoder decoder, GifFrameLoader frameLoader, Bitmap firstFrame, BitmapPool bitmapPool, Paint paint) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.decoder = var1_1;
        this.frameLoader = var2_2;
        this.state = new GifDrawable$GifState(null);
        this.paint = paint;
        this.state.bitmapPool = bitmapPool;
        this.state.firstFrame = var3_3;
    }

    public Bitmap getFirstFrame() {
        return this.state.firstFrame;
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameTransformation(Transformation<Bitmap> frameTransformation, Bitmap firstFrame) {
        void var1_1;
        void var2_2;
        if (firstFrame == null) {
            throw new NullPointerException("The first frame of the GIF must not be null");
        }
        if (frameTransformation == null) {
            throw new NullPointerException("The frame transformation must not be null");
        }
        this.state.frameTransformation = frameTransformation;
        this.state.firstFrame = var2_2;
        this.frameLoader.setFrameTransformation((Transformation<Bitmap>)var1_1);
    }

    public GifDecoder getDecoder() {
        return this.decoder;
    }

    public Transformation<Bitmap> getFrameTransformation() {
        return this.state.frameTransformation;
    }

    public byte[] getData() {
        return this.state.data;
    }

    public int getFrameCount() {
        return this.decoder.getFrameCount();
    }

    private void resetLoopCount() {
        this.loopCount = 0;
    }

    public void start() {
        this.isStarted = true;
        this.loopCount = 0;
        if (this.isVisible) {
            this.startRunning();
        }
    }

    public void stop() {
        this.isStarted = false;
        this.stopRunning();
        if (Build.VERSION.SDK_INT < 11) {
            this.reset();
        }
    }

    private void reset() {
        this.frameLoader.clear();
        this.invalidateSelf();
    }

    private void startRunning() {
        if (this.decoder.getFrameCount() == 1) {
            this.invalidateSelf();
            return;
        }
        if (!this.isRunning) {
            this.isRunning = true;
            this.frameLoader.start();
            this.invalidateSelf();
        }
    }

    private void stopRunning() {
        this.isRunning = false;
        this.frameLoader.stop();
    }

    /*
     * WARNING - void declaration
     */
    public boolean setVisible(boolean visible, boolean restart) {
        void var2_2;
        void var1_1;
        this.isVisible = visible;
        if (!visible) {
            this.stopRunning();
        } else if (this.isStarted) {
            this.startRunning();
        }
        return super.setVisible((boolean)var1_1, (boolean)var2_2);
    }

    public int getIntrinsicWidth() {
        return this.state.firstFrame.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.state.firstFrame.getHeight();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - void declaration
     */
    void setIsRunning(boolean isRunning) {
        void var1_1;
        this.isRunning = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void onBoundsChange(Rect bounds) {
        void var1_1;
        super.onBoundsChange((Rect)var1_1);
        this.applyGravity = true;
    }

    /*
     * WARNING - void declaration
     */
    public void draw(Canvas canvas) {
        void var1_1;
        Bitmap bitmap;
        if (this.isRecycled) {
            return;
        }
        if (this.applyGravity) {
            Gravity.apply((int)119, (int)this.getIntrinsicWidth(), (int)this.getIntrinsicHeight(), (Rect)this.getBounds(), (Rect)this.destRect);
            this.applyGravity = false;
        }
        bitmap = (bitmap = this.frameLoader.getCurrentFrame()) != null ? bitmap : this.state.firstFrame;
        var1_1.drawBitmap(bitmap, null, this.destRect, this.paint);
    }

    /*
     * WARNING - void declaration
     */
    public void setAlpha(int i2) {
        void var1_1;
        this.paint.setAlpha((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setColorFilter(ColorFilter colorFilter) {
        void var1_1;
        this.paint.setColorFilter((ColorFilter)var1_1);
    }

    public int getOpacity() {
        return -2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @TargetApi(value=11)
    public void onFrameReady(int frameIndex) {
        void var1_1;
        if (Build.VERSION.SDK_INT >= 11 && this.getCallback() == null) {
            this.stop();
            this.reset();
            return;
        }
        this.invalidateSelf();
        if (var1_1 == this.decoder.getFrameCount() - 1) {
            ++this.loopCount;
        }
        if (this.maxLoopCount != -1 && this.loopCount >= this.maxLoopCount) {
            this.stop();
        }
    }

    public Drawable.ConstantState getConstantState() {
        return this.state;
    }

    public void recycle() {
        this.isRecycled = true;
        this.state.bitmapPool.put(this.state.firstFrame);
        this.frameLoader.clear();
        this.frameLoader.stop();
    }

    boolean isRecycled() {
        return this.isRecycled;
    }

    @Override
    public boolean isAnimated() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLoopCount(int loopCount) {
        void var1_1;
        if (loopCount <= 0 && loopCount != -1 && loopCount != 0) {
            throw new IllegalArgumentException("Loop count must be greater than 0, or equal to GlideDrawable.LOOP_FOREVER, or equal to GlideDrawable.LOOP_INTRINSIC");
        }
        if (loopCount == 0) {
            this.maxLoopCount = this.decoder.getLoopCount();
            return;
        }
        this.maxLoopCount = var1_1;
    }
}

