/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.os.Build;
import android.util.Log;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;

public final class TransformationUtils {
    private static final String TAG = "TransformationUtils";
    public static final int PAINT_FLAGS = 6;

    private TransformationUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap centerCrop(Bitmap recycled, Bitmap toCrop, int width, int height) {
        void var1_1;
        Bitmap bitmap;
        float f2;
        if (toCrop == null) {
            return null;
        }
        if (toCrop.getWidth() == width && toCrop.getHeight() == height) {
            return toCrop;
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        Matrix matrix = new Matrix();
        if (toCrop.getWidth() * height > width * toCrop.getHeight()) {
            f2 = (float)height / (float)toCrop.getHeight();
            f3 = ((float)width - (float)toCrop.getWidth() * f2) * 0.5f;
        } else {
            f2 = (float)width / (float)toCrop.getWidth();
            f4 = ((float)height - (float)toCrop.getHeight() * f2) * 0.5f;
        }
        matrix.setScale(f2, f2);
        matrix.postTranslate((float)((int)(f3 + 0.5f)), (float)((int)(f4 + 0.5f)));
        if (recycled == null) {
            void var3_4;
            void var2_2;
            bitmap = Bitmap.createBitmap((int)var2_2, (int)var3_4, (Bitmap.Config)TransformationUtils.getSafeConfig(toCrop));
        }
        TransformationUtils.setAlpha(toCrop, bitmap);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint(6);
        canvas.drawBitmap((Bitmap)var1_1, matrix, paint);
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap fitCenter(Bitmap toFit, BitmapPool pool, int width, int height) {
        Bitmap bitmap;
        Bitmap bitmap2;
        if (toFit.getWidth() == width && toFit.getHeight() == height) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"requested target size matches input, returning input");
            }
            return toFit;
        }
        float f2 = (float)width / (float)toFit.getWidth();
        float f3 = (float)height / (float)toFit.getHeight();
        f2 = Math.min(f2, f3);
        int n2 = (int)(f2 * (float)toFit.getWidth());
        int n3 = (int)(f2 * (float)toFit.getHeight());
        if (toFit.getWidth() == n2 && toFit.getHeight() == n3) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"adjusted target size matches input, returning input");
            }
            return toFit;
        }
        Bitmap.Config config = TransformationUtils.getSafeConfig(toFit);
        if ((bitmap2 = bitmap2.get(n2, n3, config)) == null) {
            bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
        }
        TransformationUtils.setAlpha(toFit, bitmap2);
        if (Log.isLoggable((String)TAG, (int)2)) {
            void var3_4;
            void var2_2;
            Log.v((String)TAG, (String)("request: " + (int)var2_2 + "x" + (int)var3_4));
            Log.v((String)TAG, (String)("toFit:   " + toFit.getWidth() + "x" + toFit.getHeight()));
            Log.v((String)TAG, (String)("toReuse: " + bitmap2.getWidth() + "x" + bitmap2.getHeight()));
            Log.v((String)TAG, (String)("minPct:   " + f2));
        }
        Canvas canvas = new Canvas(bitmap2);
        Matrix matrix = new Matrix();
        matrix.setScale(f2, f2);
        Paint paint = new Paint(6);
        canvas.drawBitmap(bitmap, matrix, paint);
        return bitmap2;
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=12)
    public static void setAlpha(Bitmap toTransform, Bitmap outBitmap) {
        if (Build.VERSION.SDK_INT >= 12 && outBitmap != null) {
            Bitmap bitmap;
            void var1_1;
            var1_1.setHasAlpha(bitmap.hasAlpha());
        }
    }

    @Deprecated
    @TargetApi(value=5)
    public static int getOrientation(String pathToOriginal) {
        try {
            return TransformationUtils.getExifOrientationDegrees(new ExifInterface(pathToOriginal).getAttributeInt("Orientation", 0));
        }
        catch (Exception exception) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                String string;
                Log.e((String)TAG, (String)("Unable to get orientation for image with path=" + string), (Throwable)exception);
            }
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Bitmap orientImage(String pathToOriginal, Bitmap imageToOrient) {
        void var1_2;
        int n2 = TransformationUtils.getOrientation(pathToOriginal);
        return TransformationUtils.rotateImage((Bitmap)var1_2, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap rotateImage(Bitmap imageToOrient, int degreesToRotate) {
        Bitmap bitmap;
        block3: {
            bitmap = imageToOrient;
            try {
                if (degreesToRotate != 0) {
                    Bitmap bitmap2;
                    void var1_1;
                    Matrix matrix = new Matrix();
                    matrix.setRotate((float)var1_1);
                    bitmap = Bitmap.createBitmap((Bitmap)imageToOrient, (int)0, (int)0, (int)imageToOrient.getWidth(), (int)bitmap2.getHeight(), (Matrix)matrix, (boolean)true);
                }
            }
            catch (Exception exception) {
                if (!Log.isLoggable((String)TAG, (int)6)) break block3;
                Log.e((String)TAG, (String)"Exception when trying to orient image", (Throwable)exception);
            }
        }
        return bitmap;
    }

    public static int getExifOrientationDegrees(int exifOrientation) {
        int n2;
        switch (exifOrientation) {
            case 5: 
            case 6: {
                n2 = 90;
                break;
            }
            case 3: 
            case 4: {
                n2 = 180;
                break;
            }
            case 7: 
            case 8: {
                n2 = 270;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap rotateImageExif(Bitmap toOrient, BitmapPool pool, int exifOrientation) {
        Bitmap bitmap;
        Bitmap bitmap2;
        void var2_2;
        Matrix matrix = new Matrix();
        TransformationUtils.initializeMatrixForRotation((int)var2_2, matrix);
        if (matrix.isIdentity()) {
            return toOrient;
        }
        RectF rectF = new RectF(0.0f, 0.0f, (float)toOrient.getWidth(), (float)toOrient.getHeight());
        matrix.mapRect(rectF);
        int n2 = Math.round(rectF.width());
        int n3 = Math.round(rectF.height());
        Bitmap.Config config = TransformationUtils.getSafeConfig(toOrient);
        bitmap2 = bitmap2.get(n2, n3, config);
        if (bitmap2 == null) {
            bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
        }
        matrix.postTranslate(-rectF.left, -rectF.top);
        rectF = new Canvas(bitmap2);
        Paint paint = new Paint(6);
        rectF.drawBitmap(bitmap, matrix, paint);
        return bitmap2;
    }

    private static Bitmap.Config getSafeConfig(Bitmap bitmap) {
        if (bitmap.getConfig() != null) {
            Bitmap bitmap2;
            return bitmap2.getConfig();
        }
        return Bitmap.Config.ARGB_8888;
    }

    /*
     * WARNING - void declaration
     */
    static void initializeMatrixForRotation(int exifOrientation, Matrix matrix) {
        switch (exifOrientation) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                return;
            }
            case 3: {
                matrix.setRotate(180.0f);
                return;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                return;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                return;
            }
            case 6: {
                matrix.setRotate(90.0f);
                return;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                return;
            }
            case 8: {
                void var1_1;
                var1_1.setRotate(-90.0f);
            }
        }
    }
}

