/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import com.thirdparty.bumptech.glide.load.DecodeFormat;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.resource.bitmap.BitmapDecoder;
import com.thirdparty.bumptech.glide.load.resource.bitmap.Downsampler$1;
import com.thirdparty.bumptech.glide.load.resource.bitmap.Downsampler$2;
import com.thirdparty.bumptech.glide.load.resource.bitmap.Downsampler$3;
import com.thirdparty.bumptech.glide.load.resource.bitmap.ImageHeaderParser;
import com.thirdparty.bumptech.glide.load.resource.bitmap.ImageHeaderParser$ImageType;
import com.thirdparty.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import com.thirdparty.bumptech.glide.load.resource.bitmap.TransformationUtils;
import com.thirdparty.bumptech.glide.util.ByteArrayPool;
import com.thirdparty.bumptech.glide.util.ExceptionCatchingInputStream;
import com.thirdparty.bumptech.glide.util.MarkEnforcingInputStream;
import com.thirdparty.bumptech.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Queue;
import java.util.Set;

public abstract class Downsampler
implements BitmapDecoder<InputStream> {
    private static final String TAG = "Downsampler";
    private static final Set<ImageHeaderParser$ImageType> TYPES_THAT_USE_POOL = EnumSet.of(ImageHeaderParser$ImageType.JPEG, ImageHeaderParser$ImageType.PNG_A, ImageHeaderParser$ImageType.PNG);
    private static final Queue<BitmapFactory.Options> OPTIONS_QUEUE = Util.createQueue(0);
    public static final Downsampler AT_LEAST = new Downsampler$1();
    public static final Downsampler AT_MOST = new Downsampler$2();
    public static final Downsampler NONE = new Downsampler$3();
    private static final int MARK_POSITION = 0x500000;

    /*
     * WARNING - void declaration
     */
    @Override
    public Bitmap decode(InputStream is, BitmapPool pool, int outWidth, int outHeight, DecodeFormat decodeFormat) {
        Object object;
        ByteArrayPool byteArrayPool = ByteArrayPool.get();
        byte[] byArray = byteArrayPool.getBytes();
        byte[] byArray2 = byteArrayPool.getBytes();
        BitmapFactory.Options options = Downsampler.getDefaultOptions();
        object = new RecyclableBufferedInputStream((InputStream)object, byArray2);
        ExceptionCatchingInputStream exceptionCatchingInputStream = ExceptionCatchingInputStream.obtain((InputStream)object);
        MarkEnforcingInputStream markEnforcingInputStream = new MarkEnforcingInputStream(exceptionCatchingInputStream);
        try {
            void var2_3;
            int n2;
            int n3;
            block18: {
                exceptionCatchingInputStream.mark(0x500000);
                n3 = 0;
                try {
                    try {
                        n3 = new ImageHeaderParser(exceptionCatchingInputStream).getOrientation();
                    }
                    catch (IOException iOException) {
                        if (Log.isLoggable((String)TAG, (int)5)) {
                            Log.w((String)TAG, (String)"Cannot determine the image orientation from header", (Throwable)iOException);
                        }
                        try {
                            exceptionCatchingInputStream.reset();
                        }
                        catch (IOException iOException2) {
                            if (Log.isLoggable((String)TAG, (int)5)) {
                                Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException2);
                            }
                            break block18;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block19: {
                        try {
                            exceptionCatchingInputStream.reset();
                        }
                        catch (IOException iOException) {
                            if (!Log.isLoggable((String)TAG, (int)5)) break block19;
                            Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException);
                        }
                    }
                    throw throwable;
                }
                try {
                    exceptionCatchingInputStream.reset();
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)TAG, (int)5)) break block18;
                    Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException);
                }
            }
            options.inTempStorage = byArray;
            int[] nArray = this.getDimensions(markEnforcingInputStream, (RecyclableBufferedInputStream)object, options);
            int n4 = nArray[0];
            int n5 = nArray[1];
            int n6 = TransformationUtils.getExifOrientationDegrees(n3);
            n2 = this.getRoundedSampleSize(n6, n4, n5, n2, outHeight);
            object = this.downsampleWithSize(markEnforcingInputStream, (RecyclableBufferedInputStream)object, options, pool, n4, n5, n2, decodeFormat);
            IOException iOException = exceptionCatchingInputStream.getException();
            if (iOException != null) {
                throw new RuntimeException(iOException);
            }
            iOException = null;
            if (object != null && !object.equals(iOException = TransformationUtils.rotateImageExif((Bitmap)object, pool, n3)) && !var2_3.put((Bitmap)object)) {
                object.recycle();
            }
            object = iOException;
            return object;
        }
        finally {
            byteArrayPool.releaseBytes(byArray);
            byteArrayPool.releaseBytes(byArray2);
            exceptionCatchingInputStream.release();
            Downsampler.releaseOptions(options);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getRoundedSampleSize(int degreesToRotate, int inWidth, int inHeight, int outWidth, int outHeight) {
        void var3_3;
        void var2_2;
        int n2;
        int n3 = outHeight == Integer.MIN_VALUE ? inHeight : outHeight;
        int n4 = outWidth == Integer.MIN_VALUE ? inWidth : outWidth;
        n2 = degreesToRotate == 90 || n2 == 270 ? this.getSampleSize(inHeight, inWidth, n4, n3) : this.getSampleSize((int)var2_2, (int)var3_3, n4, n3);
        n2 = n2 == 0 ? 0 : Integer.highestOneBit(n2);
        return Math.max(1, n2);
    }

    /*
     * WARNING - void declaration
     */
    private Bitmap downsampleWithSize(MarkEnforcingInputStream is, RecyclableBufferedInputStream bufferedStream, BitmapFactory.Options options, BitmapPool pool, int inWidth, int inHeight, int sampleSize, DecodeFormat decodeFormat) {
        void var3_3;
        void var2_2;
        void var1_1;
        Bitmap.Config config = Downsampler.getConfig(is, decodeFormat);
        options.inSampleSize = sampleSize;
        options.inPreferredConfig = config;
        if ((options.inSampleSize == 1 || 19 <= Build.VERSION.SDK_INT) && Downsampler.shouldUsePool(is)) {
            int n2 = (int)Math.ceil((double)inWidth / (double)sampleSize);
            int n3 = (int)Math.ceil((double)inHeight / (double)sampleSize);
            Downsampler.setInBitmap(options, pool.getDirty(n2, n3, config));
        }
        return Downsampler.decodeStream((MarkEnforcingInputStream)var1_1, (RecyclableBufferedInputStream)var2_2, (BitmapFactory.Options)var3_3);
    }

    private static boolean shouldUsePool(InputStream is) {
        if (19 <= Build.VERSION.SDK_INT) {
            return true;
        }
        is.mark(1024);
        try {
            ImageHeaderParser$ImageType imageHeaderParser$ImageType = new ImageHeaderParser(is).getType();
            boolean bl = TYPES_THAT_USE_POOL.contains((Object)imageHeaderParser$ImageType);
            return bl;
        }
        catch (IOException iOException) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Cannot determine the image type from header", (Throwable)iOException);
            }
        }
        finally {
            block14: {
                try {
                    InputStream inputStream;
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)TAG, (int)5)) break block14;
                    Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Bitmap.Config getConfig(InputStream is, DecodeFormat format) {
        boolean bl;
        block15: {
            InputStream inputStream;
            if (format == DecodeFormat.ALWAYS_ARGB_8888 || format == DecodeFormat.PREFER_ARGB_8888 || Build.VERSION.SDK_INT == 16) {
                return Bitmap.Config.ARGB_8888;
            }
            bl = false;
            is.mark(1024);
            try {
                try {
                    bl = new ImageHeaderParser(is).hasAlpha();
                }
                catch (IOException iOException) {
                    if (Log.isLoggable((String)TAG, (int)5)) {
                        void var1_4;
                        Log.w((String)TAG, (String)("Cannot determine whether the image has alpha or not from header for format " + var1_4), (Throwable)iOException);
                    }
                    try {
                        inputStream.reset();
                    }
                    catch (IOException iOException2) {
                        if (Log.isLoggable((String)TAG, (int)5)) {
                            Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException2);
                        }
                        break block15;
                    }
                }
            }
            catch (Throwable throwable) {
                block16: {
                    try {
                        inputStream.reset();
                    }
                    catch (IOException iOException) {
                        if (!Log.isLoggable((String)TAG, (int)5)) break block16;
                        Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException);
                    }
                }
                throw throwable;
            }
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block15;
                Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)iOException);
            }
        }
        if (bl) {
            return Bitmap.Config.ARGB_8888;
        }
        return Bitmap.Config.RGB_565;
    }

    protected abstract int getSampleSize(int var1, int var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    public int[] getDimensions(MarkEnforcingInputStream is, RecyclableBufferedInputStream bufferedStream, BitmapFactory.Options options) {
        void var3_3;
        void var2_2;
        void var1_1;
        options.inJustDecodeBounds = true;
        Downsampler.decodeStream((MarkEnforcingInputStream)var1_1, (RecyclableBufferedInputStream)var2_2, options);
        options.inJustDecodeBounds = false;
        return new int[]{options.outWidth, var3_3.outHeight};
    }

    /*
     * WARNING - void declaration
     */
    private static Bitmap decodeStream(MarkEnforcingInputStream is, RecyclableBufferedInputStream bufferedStream, BitmapFactory.Options options) {
        Bitmap bitmap;
        block5: {
            if (options.inJustDecodeBounds) {
                is.mark(0x500000);
            } else {
                bitmap.fixMarkLimit();
            }
            bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            try {
                if (options.inJustDecodeBounds) {
                    MarkEnforcingInputStream markEnforcingInputStream;
                    markEnforcingInputStream.reset();
                }
            }
            catch (IOException iOException) {
                void var2_3;
                if (!Log.isLoggable((String)TAG, (int)6)) break block5;
                Log.e((String)TAG, (String)("Exception loading inDecodeBounds=" + options.inJustDecodeBounds + " sample=" + var2_3.inSampleSize), (Throwable)iOException);
            }
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=11)
    private static void setInBitmap(BitmapFactory.Options options, Bitmap recycled) {
        if (11 <= Build.VERSION.SDK_INT) {
            void var1_1;
            var0.inBitmap = var1_1;
        }
    }

    @TargetApi(value=11)
    private static synchronized BitmapFactory.Options getDefaultOptions() {
        BitmapFactory.Options options;
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            options = OPTIONS_QUEUE.poll();
        }
        if (options == null) {
            options = new BitmapFactory.Options();
            Downsampler.resetOptions(options);
        }
        return options;
    }

    private static void releaseOptions(BitmapFactory.Options decodeBitmapOptions) {
        Downsampler.resetOptions(decodeBitmapOptions);
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            BitmapFactory.Options options;
            OPTIONS_QUEUE.offer(options);
            return;
        }
    }

    @TargetApi(value=11)
    private static void resetOptions(BitmapFactory.Options decodeBitmapOptions) {
        decodeBitmapOptions.inTempStorage = null;
        decodeBitmapOptions.inDither = false;
        decodeBitmapOptions.inScaled = false;
        decodeBitmapOptions.inSampleSize = 1;
        decodeBitmapOptions.inPreferredConfig = null;
        decodeBitmapOptions.inJustDecodeBounds = false;
        decodeBitmapOptions.outWidth = 0;
        decodeBitmapOptions.outHeight = 0;
        decodeBitmapOptions.outMimeType = null;
        if (11 <= Build.VERSION.SDK_INT) {
            decodeBitmapOptions.inBitmap = null;
            var0.inMutable = true;
        }
    }
}

