/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.model;

import android.util.Log;
import com.thirdparty.bumptech.glide.load.Encoder;
import com.thirdparty.bumptech.glide.util.ByteArrayPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamEncoder
implements Encoder<InputStream> {
    private static final String TAG = "StreamEncoder";

    @Override
    public boolean encode(InputStream data, OutputStream os) {
        byte[] byArray = ByteArrayPool.get().getBytes();
        try {
            int n2;
            while ((n2 = data.read(byArray)) != -1) {
                os.write(byArray, 0, n2);
            }
            return true;
        }
        catch (IOException iOException) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to encode data onto the OutputStream", (Throwable)iOException);
            }
            return false;
        }
        finally {
            ByteArrayPool.get().releaseBytes(byArray);
        }
    }

    @Override
    public String getId() {
        return "";
    }
}

