/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.model;

import com.thirdparty.bumptech.glide.load.model.Headers;
import com.thirdparty.bumptech.glide.load.model.LazyHeaderFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LazyHeaders
implements Headers {
    private final Map<String, List<LazyHeaderFactory>> headers;
    private volatile Map<String, String> combinedHeaders;

    /*
     * WARNING - void declaration
     */
    LazyHeaders(Map<String, List<LazyHeaderFactory>> headers) {
        void var1_1;
        this.headers = Collections.unmodifiableMap(var1_1);
    }

    @Override
    public final Map<String, String> getHeaders() {
        if (this.combinedHeaders == null) {
            LazyHeaders lazyHeaders = this;
            synchronized (lazyHeaders) {
                if (this.combinedHeaders == null) {
                    this.combinedHeaders = Collections.unmodifiableMap(this.generateHeaders());
                }
            }
        }
        return this.combinedHeaders;
    }

    private Map<String, String> generateHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<LazyHeaderFactory>> entry : this.headers.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            List<LazyHeaderFactory> list = entry.getValue();
            int n2 = 0;
            while (n2 < list.size()) {
                LazyHeaderFactory lazyHeaderFactory = list.get(n2);
                stringBuilder.append(lazyHeaderFactory.buildHeader());
                if (n2 != list.size() - 1) {
                    stringBuilder.append(',');
                }
                ++n2;
            }
            hashMap.put(entry.getKey(), stringBuilder.toString());
        }
        return hashMap;
    }

    public final String toString() {
        return "LazyHeaders{headers=" + this.headers + '}';
    }

    public final boolean equals(Object o2) {
        if (o2 instanceof LazyHeaders) {
            LazyHeaders lazyHeaders;
            lazyHeaders = lazyHeaders;
            return this.headers.equals(lazyHeaders.headers);
        }
        return false;
    }

    public final int hashCode() {
        return this.headers.hashCode();
    }
}

