/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.engine.cache.MemoryCache;
import com.thirdparty.bumptech.glide.load.engine.prefill.BitmapPreFillRunner$Clock;
import com.thirdparty.bumptech.glide.load.engine.prefill.BitmapPreFillRunner$UniqueKey;
import com.thirdparty.bumptech.glide.load.engine.prefill.PreFillQueue;
import com.thirdparty.bumptech.glide.load.engine.prefill.PreFillType;
import com.thirdparty.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

final class BitmapPreFillRunner
implements Runnable {
    private static final String TAG = "PreFillRunner";
    private static final BitmapPreFillRunner$Clock DEFAULT_CLOCK = new BitmapPreFillRunner$Clock();
    static final long MAX_DURATION_MS = 32L;
    static final long INITIAL_BACKOFF_MS = 40L;
    static final int BACKOFF_RATIO = 4;
    static final long MAX_BACKOFF_MS = TimeUnit.SECONDS.toMillis(1L);
    private final BitmapPool bitmapPool;
    private final MemoryCache memoryCache;
    private final PreFillQueue toPrefill;
    private final BitmapPreFillRunner$Clock clock;
    private final Set<PreFillType> seenTypes = new HashSet<PreFillType>();
    private final Handler handler;
    private long currentDelay = 40L;
    private boolean isCancelled;

    /*
     * WARNING - void declaration
     */
    public BitmapPreFillRunner(BitmapPool bitmapPool, MemoryCache memoryCache, PreFillQueue allocationOrder) {
        this((BitmapPool)var1_1, (MemoryCache)var2_2, (PreFillQueue)var3_3, DEFAULT_CLOCK, new Handler(Looper.getMainLooper()));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    BitmapPreFillRunner(BitmapPool bitmapPool, MemoryCache memoryCache, PreFillQueue allocationOrder, BitmapPreFillRunner$Clock clock, Handler handler) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.bitmapPool = var1_1;
        this.memoryCache = var2_2;
        this.toPrefill = var3_3;
        this.clock = clock;
        this.handler = handler;
    }

    public final void cancel() {
        this.isCancelled = true;
    }

    private boolean allocate() {
        long l2 = this.clock.now();
        while (!this.toPrefill.isEmpty() && !this.isGcDetected(l2)) {
            PreFillType preFillType = this.toPrefill.remove();
            Bitmap bitmap = Bitmap.createBitmap((int)preFillType.getWidth(), (int)preFillType.getHeight(), (Bitmap.Config)preFillType.getConfig());
            if (this.getFreeMemoryCacheBytes() >= Util.getBitmapByteSize(bitmap)) {
                this.memoryCache.put(new BitmapPreFillRunner$UniqueKey(null), BitmapResource.obtain(bitmap, this.bitmapPool));
            } else {
                this.addToBitmapPool(preFillType, bitmap);
            }
            if (!Log.isLoggable((String)TAG, (int)3)) continue;
            Log.d((String)TAG, (String)("allocated [" + preFillType.getWidth() + "x" + preFillType.getHeight() + "] " + preFillType.getConfig() + " size: " + Util.getBitmapByteSize(bitmap)));
        }
        return !this.isCancelled && !this.toPrefill.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isGcDetected(long startTimeMs) {
        void var1_1;
        return this.clock.now() - var1_1 >= 32L;
    }

    private int getFreeMemoryCacheBytes() {
        return this.memoryCache.getMaxSize() - this.memoryCache.getCurrentSize();
    }

    /*
     * WARNING - void declaration
     */
    private void addToBitmapPool(PreFillType toAllocate, Bitmap bitmap) {
        void var2_2;
        Bitmap bitmap2;
        if (this.seenTypes.add(toAllocate) && (bitmap2 = this.bitmapPool.get(toAllocate.getWidth(), toAllocate.getHeight(), bitmap2.getConfig())) != null) {
            this.bitmapPool.put(bitmap2);
        }
        this.bitmapPool.put((Bitmap)var2_2);
    }

    @Override
    public final void run() {
        if (this.allocate()) {
            this.handler.postDelayed((Runnable)this, this.getNextDelay());
        }
    }

    private long getNextDelay() {
        long l2 = this.currentDelay;
        this.currentDelay = Math.min(this.currentDelay * 4L, MAX_BACKOFF_MS);
        return l2;
    }
}

