/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine.cache;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.text.format.Formatter;
import android.util.Log;
import com.thirdparty.bumptech.glide.load.engine.cache.MemorySizeCalculator$DisplayMetricsScreenDimensions;
import com.thirdparty.bumptech.glide.load.engine.cache.MemorySizeCalculator$ScreenDimensions;

public class MemorySizeCalculator {
    private static final String TAG = "MemorySizeCalculator";
    static final int BYTES_PER_ARGB_8888_PIXEL = 4;
    static final int MEMORY_CACHE_TARGET_SCREENS = 2;
    static final int BITMAP_POOL_TARGET_SCREENS = 4;
    static final float MAX_SIZE_MULTIPLIER = 0.4f;
    static final float LOW_MEMORY_MAX_SIZE_MULTIPLIER = 0.33f;
    private final int bitmapPoolSize;
    private final int memoryCacheSize;
    private final Context context;

    /*
     * WARNING - void declaration
     */
    public MemorySizeCalculator(Context context) {
        this(context, (ActivityManager)context.getSystemService("activity"), new MemorySizeCalculator$DisplayMetricsScreenDimensions(var1_1.getResources().getDisplayMetrics()));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    MemorySizeCalculator(Context context, ActivityManager activityManager, MemorySizeCalculator$ScreenDimensions screenDimensions) {
        void var3_4;
        void var1_1;
        this.context = var1_1;
        int n2 = MemorySizeCalculator.getMaxSize(activityManager);
        int n3 = screenDimensions.getWidthPixels() * var3_4.getHeightPixels() * 4;
        int n4 = n3 * 4;
        if ((n3 *= 2) + n4 <= n2) {
            this.memoryCacheSize = n3;
            this.bitmapPoolSize = n4;
        } else {
            int n5 = Math.round((float)n2 / 6.0f);
            this.memoryCacheSize = n5 * 2;
            this.bitmapPoolSize = n5 * 4;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            void var2_3;
            Log.d((String)TAG, (String)("Calculated memory cache size: " + this.toMb(this.memoryCacheSize) + " pool size: " + this.toMb(this.bitmapPoolSize) + " memory class limited? " + (n3 + n4 > n2) + " max size: " + this.toMb(n2) + " memoryClass: " + activityManager.getMemoryClass() + " isLowMemoryDevice: " + MemorySizeCalculator.isLowMemoryDevice((ActivityManager)var2_3)));
        }
    }

    public int getMemoryCacheSize() {
        return this.memoryCacheSize;
    }

    public int getBitmapPoolSize() {
        return this.bitmapPoolSize;
    }

    private static int getMaxSize(ActivityManager activityManager) {
        ActivityManager activityManager2;
        int n2 = activityManager.getMemoryClass() * 1024 * 1024;
        boolean bl = MemorySizeCalculator.isLowMemoryDevice(activityManager2);
        return Math.round((float)n2 * (bl ? 0.33f : 0.4f));
    }

    /*
     * WARNING - void declaration
     */
    private String toMb(int bytes) {
        void var1_1;
        return Formatter.formatFileSize((Context)this.context, (long)((long)var1_1));
    }

    @TargetApi(value=19)
    private static boolean isLowMemoryDevice(ActivityManager activityManager) {
        ActivityManager activityManager2;
        int n2 = Build.VERSION.SDK_INT;
        return n2 < 11 || n2 >= 19 && activityManager2.isLowRamDevice();
    }
}

