/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine.bitmap_recycle;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.PrettyPrintTreeMap;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.SizeStrategy$Key;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.SizeStrategy$KeyPool;
import com.thirdparty.bumptech.glide.util.Util;
import java.util.TreeMap;

@TargetApi(value=19)
class SizeStrategy
implements LruPoolStrategy {
    private static final int MAX_SIZE_MULTIPLE = 8;
    private final SizeStrategy$KeyPool keyPool = new SizeStrategy$KeyPool();
    private final GroupedLinkedMap<SizeStrategy$Key, Bitmap> groupedMap = new GroupedLinkedMap();
    private final TreeMap<Integer, Integer> sortedSizes = new PrettyPrintTreeMap<Integer, Integer>();

    SizeStrategy() {
    }

    @Override
    public void put(Bitmap bitmap) {
        Integer n2;
        int n3 = Util.getBitmapByteSize(bitmap);
        SizeStrategy$Key sizeStrategy$Key = this.keyPool.get(n3);
        this.groupedMap.put(sizeStrategy$Key, (Bitmap)n2);
        n2 = this.sortedSizes.get(SizeStrategy$Key.access$0(sizeStrategy$Key));
        this.sortedSizes.put(SizeStrategy$Key.access$0(sizeStrategy$Key), n2 == null ? 1 : n2 + 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Bitmap get(int width, int height, Bitmap.Config config) {
        Bitmap bitmap;
        int n2 = Util.getBitmapByteSize(width, height, config);
        SizeStrategy$Key sizeStrategy$Key = this.keyPool.get(n2);
        Integer n3 = this.sortedSizes.ceilingKey(n2);
        if (n3 != null && n3 != n2 && n3 <= n2 * 8) {
            this.keyPool.offer(sizeStrategy$Key);
            sizeStrategy$Key = this.keyPool.get(n3);
        }
        if ((bitmap = this.groupedMap.get(sizeStrategy$Key)) != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            bitmap.reconfigure((int)var1_1, (int)var2_2, (Bitmap.Config)var3_3);
            this.decrementBitmapOfSize(n3);
        }
        return bitmap;
    }

    @Override
    public Bitmap removeLast() {
        Bitmap bitmap = this.groupedMap.removeLast();
        if (bitmap != null) {
            int n2 = Util.getBitmapByteSize(bitmap);
            this.decrementBitmapOfSize(n2);
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    private void decrementBitmapOfSize(Integer size) {
        void var1_1;
        Integer n2 = this.sortedSizes.get(size);
        if (n2 == 1) {
            this.sortedSizes.remove(size);
            return;
        }
        this.sortedSizes.put((Integer)var1_1, n2 - 1);
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        return SizeStrategy.getBitmapString(bitmap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String logBitmap(int width, int height, Bitmap.Config config) {
        void var3_3;
        void var2_2;
        return SizeStrategy.getBitmapString(Util.getBitmapByteSize(width, (int)var2_2, (Bitmap.Config)var3_3));
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    public final String toString() {
        return "SizeStrategy:\n  " + this.groupedMap + "\n  SortedSizes" + this.sortedSizes;
    }

    private static String getBitmapString(Bitmap bitmap) {
        return SizeStrategy.getBitmapString(Util.getBitmapByteSize(bitmap));
    }

    private static String getBitmapString(int size) {
        int n2;
        return "[" + n2 + "]";
    }

    static /* synthetic */ String access$0(int n2) {
        return SizeStrategy.getBitmapString(n2);
    }
}

