/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine.bitmap_recycle;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.AttributeStrategy;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool$BitmapTracker;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool$NullBitmapTracker;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.thirdparty.bumptech.glide.load.engine.bitmap_recycle.SizeConfigStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LruBitmapPool
implements BitmapPool {
    private static final String TAG = "LruBitmapPool";
    private static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.ARGB_8888;
    private final LruPoolStrategy strategy;
    private final Set<Bitmap.Config> allowedConfigs;
    private final int initialMaxSize;
    private final LruBitmapPool$BitmapTracker tracker;
    private int maxSize;
    private int currentSize;
    private int hits;
    private int misses;
    private int puts;
    private int evictions;

    /*
     * WARNING - void declaration
     */
    LruBitmapPool(int maxSize, LruPoolStrategy strategy, Set<Bitmap.Config> allowedConfigs) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initialMaxSize = maxSize;
        this.maxSize = var1_1;
        this.strategy = var2_2;
        this.allowedConfigs = var3_3;
        this.tracker = new LruBitmapPool$NullBitmapTracker(null);
    }

    /*
     * WARNING - void declaration
     */
    public LruBitmapPool(int maxSize) {
        this((int)var1_1, LruBitmapPool.getDefaultStrategy(), LruBitmapPool.getDefaultAllowedConfigs());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LruBitmapPool(int maxSize, Set<Bitmap.Config> allowedConfigs) {
        this((int)var1_1, LruBitmapPool.getDefaultStrategy(), (Set<Bitmap.Config>)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setSizeMultiplier(float sizeMultiplier) {
        void var1_1;
        this.maxSize = Math.round((float)this.initialMaxSize * var1_1);
        this.evict();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean put(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("Bitmap must not be null");
        }
        if (!bitmap.isMutable() || this.strategy.getSize(bitmap) > this.maxSize || !this.allowedConfigs.contains(bitmap.getConfig())) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Reject bitmap from pool, bitmap: " + this.strategy.logBitmap(bitmap) + ", is mutable: " + bitmap.isMutable() + ", is allowed config: " + this.allowedConfigs.contains(bitmap.getConfig())));
            }
            return false;
        }
        int n2 = this.strategy.getSize(bitmap);
        this.strategy.put(bitmap);
        this.tracker.add(bitmap);
        ++this.puts;
        this.currentSize += n2;
        if (Log.isLoggable((String)TAG, (int)2)) {
            void var1_1;
            Log.v((String)TAG, (String)("Put bitmap in pool=" + this.strategy.logBitmap((Bitmap)var1_1)));
        }
        this.dump();
        this.evict();
        return true;
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized Bitmap get(int width, int height, Bitmap.Config config) {
        void var3_4;
        void var2_3;
        void var1_1;
        Bitmap bitmap = this.getDirty((int)var1_1, (int)var2_3, (Bitmap.Config)var3_4);
        if (bitmap != null) {
            bitmap.eraseColor(0);
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @TargetApi(value=12)
    public synchronized Bitmap getDirty(int width, int height, Bitmap.Config config) {
        Bitmap bitmap = this.strategy.get(width, height, config != null ? config : DEFAULT_CONFIG);
        if (bitmap == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Missing bitmap=" + this.strategy.logBitmap(width, height, config)));
            }
            ++this.misses;
        } else {
            ++this.hits;
            this.currentSize -= this.strategy.getSize(bitmap);
            this.tracker.remove(bitmap);
            if (Build.VERSION.SDK_INT >= 12) {
                bitmap.setHasAlpha(true);
            }
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Log.v((String)TAG, (String)("Get bitmap=" + this.strategy.logBitmap((int)var1_1, (int)var2_2, (Bitmap.Config)var3_3)));
        }
        this.dump();
        return bitmap;
    }

    @Override
    public void clearMemory() {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"clearMemory");
        }
        this.trimToSize(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"InlinedApi"})
    public void trimMemory(int level) {
        void var1_1;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("trimMemory, level=" + level));
        }
        if (level >= 60) {
            this.clearMemory();
            return;
        }
        if (var1_1 >= 40) {
            this.trimToSize(this.maxSize / 2);
        }
    }

    private synchronized void trimToSize(int size) {
        while (this.currentSize > size) {
            Bitmap bitmap = this.strategy.removeLast();
            if (bitmap == null) {
                if (Log.isLoggable((String)TAG, (int)5)) {
                    Log.w((String)TAG, (String)"Size mismatch, resetting");
                    this.dumpUnchecked();
                }
                this.currentSize = 0;
                return;
            }
            this.tracker.remove(bitmap);
            this.currentSize -= this.strategy.getSize(bitmap);
            bitmap.recycle();
            ++this.evictions;
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Evicting bitmap=" + this.strategy.logBitmap(bitmap)));
            }
            this.dump();
        }
    }

    private void dump() {
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.dumpUnchecked();
        }
    }

    private void dumpUnchecked() {
        Log.v((String)TAG, (String)("Hits=" + this.hits + ", misses=" + this.misses + ", puts=" + this.puts + ", evictions=" + this.evictions + ", currentSize=" + this.currentSize + ", maxSize=" + this.maxSize + "\nStrategy=" + this.strategy));
    }

    private static LruPoolStrategy getDefaultStrategy() {
        LruPoolStrategy lruPoolStrategy = Build.VERSION.SDK_INT >= 19 ? new SizeConfigStrategy() : new AttributeStrategy();
        return lruPoolStrategy;
    }

    private static Set<Bitmap.Config> getDefaultAllowedConfigs() {
        HashSet<Bitmap.Config> hashSet = new HashSet<Bitmap.Config>();
        hashSet.addAll(Arrays.asList(Bitmap.Config.values()));
        if (Build.VERSION.SDK_INT >= 19) {
            hashSet.add(null);
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

