/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine;

import android.os.Looper;
import com.thirdparty.bumptech.glide.load.Key;
import com.thirdparty.bumptech.glide.load.engine.EngineResource$ResourceListener;
import com.thirdparty.bumptech.glide.load.engine.Resource;

class EngineResource<Z>
implements Resource<Z> {
    private final Resource<Z> resource;
    private final boolean isCacheable;
    private EngineResource$ResourceListener listener;
    private Key key;
    private int acquired;
    private boolean isRecycled;

    /*
     * WARNING - void declaration
     */
    EngineResource(Resource<Z> toWrap, boolean isCacheable) {
        void var2_2;
        void var1_1;
        if (toWrap == null) {
            throw new NullPointerException("Wrapped resource must not be null");
        }
        this.resource = var1_1;
        this.isCacheable = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void setResourceListener(Key key, EngineResource$ResourceListener listener) {
        void var2_2;
        void var1_1;
        this.key = var1_1;
        this.listener = var2_2;
    }

    boolean isCacheable() {
        return this.isCacheable;
    }

    @Override
    public Z get() {
        return this.resource.get();
    }

    @Override
    public int getSize() {
        return this.resource.getSize();
    }

    @Override
    public void recycle() {
        if (this.acquired > 0) {
            throw new IllegalStateException("Cannot recycle a resource while it is still acquired");
        }
        if (this.isRecycled) {
            throw new IllegalStateException("Cannot recycle a resource that has already been recycled");
        }
        this.isRecycled = true;
        this.resource.recycle();
    }

    void acquire() {
        if (this.isRecycled) {
            throw new IllegalStateException("Cannot acquire a recycled resource");
        }
        if (!Looper.getMainLooper().equals(Looper.myLooper())) {
            throw new IllegalThreadStateException("Must call acquire on the main thread");
        }
        ++this.acquired;
    }

    void release() {
        if (this.acquired <= 0) {
            throw new IllegalStateException("Cannot release a recycled or not yet acquired resource");
        }
        if (!Looper.getMainLooper().equals(Looper.myLooper())) {
            throw new IllegalThreadStateException("Must call release on the main thread");
        }
        if (--this.acquired == 0) {
            this.listener.onResourceReleased(this.key, this);
        }
    }
}

