/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.engine;

import android.util.Log;
import com.thirdparty.bumptech.glide.Priority;
import com.thirdparty.bumptech.glide.load.Encoder;
import com.thirdparty.bumptech.glide.load.Key;
import com.thirdparty.bumptech.glide.load.Transformation;
import com.thirdparty.bumptech.glide.load.data.DataFetcher;
import com.thirdparty.bumptech.glide.load.engine.DecodeJob$DiskCacheProvider;
import com.thirdparty.bumptech.glide.load.engine.DecodeJob$FileOpener;
import com.thirdparty.bumptech.glide.load.engine.DecodeJob$SourceWriter;
import com.thirdparty.bumptech.glide.load.engine.DiskCacheStrategy;
import com.thirdparty.bumptech.glide.load.engine.EngineKey;
import com.thirdparty.bumptech.glide.load.engine.Resource;
import com.thirdparty.bumptech.glide.load.engine.cache.DiskCache$Writer;
import com.thirdparty.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.thirdparty.bumptech.glide.provider.DataLoadProvider;
import com.thirdparty.bumptech.glide.util.LogTime;
import java.io.File;

class DecodeJob<A, T, Z> {
    private static final String TAG = "DecodeJob";
    private static final DecodeJob$FileOpener DEFAULT_FILE_OPENER = new DecodeJob$FileOpener();
    private final EngineKey resultKey;
    private final int width;
    private final int height;
    private final DataFetcher<A> fetcher;
    private final DataLoadProvider<A, T> loadProvider;
    private final Transformation<T> transformation;
    private final ResourceTranscoder<T, Z> transcoder;
    private final DecodeJob$DiskCacheProvider diskCacheProvider;
    private final DiskCacheStrategy diskCacheStrategy;
    private final Priority priority;
    private final DecodeJob$FileOpener fileOpener;
    private volatile boolean isCancelled;

    /*
     * WARNING - void declaration
     */
    public DecodeJob(EngineKey resultKey, int width, int height, DataFetcher<A> fetcher, DataLoadProvider<A, T> loadProvider, Transformation<T> transformation, ResourceTranscoder<T, Z> transcoder, DecodeJob$DiskCacheProvider diskCacheProvider, DiskCacheStrategy diskCacheStrategy, Priority priority) {
        this((EngineKey)var1_1, (int)var2_2, (int)var3_3, fetcher, loadProvider, transformation, transcoder, diskCacheProvider, diskCacheStrategy, priority, DEFAULT_FILE_OPENER);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    DecodeJob(EngineKey resultKey, int width, int height, DataFetcher<A> fetcher, DataLoadProvider<A, T> loadProvider, Transformation<T> transformation, ResourceTranscoder<T, Z> transcoder, DecodeJob$DiskCacheProvider diskCacheProvider, DiskCacheStrategy diskCacheStrategy, Priority priority, DecodeJob$FileOpener fileOpener) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.resultKey = var1_1;
        this.width = var2_2;
        this.height = var3_3;
        this.fetcher = fetcher;
        this.loadProvider = loadProvider;
        this.transformation = transformation;
        this.transcoder = transcoder;
        this.diskCacheProvider = diskCacheProvider;
        this.diskCacheStrategy = diskCacheStrategy;
        this.priority = priority;
        this.fileOpener = fileOpener;
    }

    public Resource<Z> decodeResultFromCache() {
        if (!this.diskCacheStrategy.cacheResult()) {
            return null;
        }
        long l2 = LogTime.getLogTime();
        Resource<Object> resource = this.loadFromCache(this.resultKey);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Decoded transformed from cache", l2);
        }
        l2 = LogTime.getLogTime();
        resource = this.transcode(resource);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transcoded transformed from cache", l2);
        }
        return resource;
    }

    public Resource<Z> decodeSourceFromCache() {
        if (!this.diskCacheStrategy.cacheSource()) {
            return null;
        }
        long l2 = LogTime.getLogTime();
        Resource<T> resource = this.loadFromCache(this.resultKey.getOriginalKey());
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Decoded source from cache", l2);
        }
        return this.transformEncodeAndTranscode(resource);
    }

    public Resource<Z> decodeFromSource() {
        Resource<T> resource = this.decodeSource();
        return this.transformEncodeAndTranscode(resource);
    }

    public void cancel() {
        this.isCancelled = true;
        this.fetcher.cancel();
    }

    private Resource<Z> transformEncodeAndTranscode(Resource<T> decoded) {
        Resource<Object> resource;
        long l2 = LogTime.getLogTime();
        resource = this.transform(resource);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transformed resource from source", l2);
        }
        this.writeTransformedToCache(resource);
        l2 = LogTime.getLogTime();
        resource = this.transcode(resource);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transcoded transformed from source", l2);
        }
        return resource;
    }

    private void writeTransformedToCache(Resource<T> transformed) {
        DecodeJob$SourceWriter<void> decodeJob$SourceWriter;
        if (transformed == null || !this.diskCacheStrategy.cacheResult()) {
            return;
        }
        long l2 = LogTime.getLogTime();
        decodeJob$SourceWriter = new DecodeJob$SourceWriter<void>(this, (Encoder<void>)this.loadProvider.getEncoder(), (void)decodeJob$SourceWriter);
        this.diskCacheProvider.getDiskCache().put(this.resultKey, decodeJob$SourceWriter);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Wrote transformed from source to cache", l2);
        }
    }

    private Resource<T> decodeSource() {
        Resource<T> resource = null;
        try {
            long l2 = LogTime.getLogTime();
            resource = (Resource<T>)this.fetcher.loadData(this.priority);
            if (Log.isLoggable((String)TAG, (int)2)) {
                this.logWithTimeAndKey("Fetched data", l2);
            }
            if (this.isCancelled) {
                return null;
            }
            resource = this.decodeFromSourceData(resource);
        }
        finally {
            this.fetcher.cleanup();
        }
        return resource;
    }

    private Resource<T> decodeFromSourceData(A data) {
        Resource<T> resource;
        if (this.diskCacheStrategy.cacheSource()) {
            resource = this.cacheAndDecodeSourceData(resource);
        } else {
            long l2 = LogTime.getLogTime();
            resource = this.loadProvider.getSourceDecoder().decode(resource, this.width, this.height);
            if (Log.isLoggable((String)TAG, (int)2)) {
                this.logWithTimeAndKey("Decoded from source", l2);
            }
        }
        return resource;
    }

    private Resource<T> cacheAndDecodeSourceData(A data) {
        Object object;
        long l2 = LogTime.getLogTime();
        object = new DecodeJob$SourceWriter<void>(this, (Encoder<void>)this.loadProvider.getSourceEncoder(), (void)object);
        this.diskCacheProvider.getDiskCache().put(this.resultKey.getOriginalKey(), (DiskCache$Writer)object);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Wrote source to cache", l2);
        }
        l2 = LogTime.getLogTime();
        object = this.loadFromCache(this.resultKey.getOriginalKey());
        if (Log.isLoggable((String)TAG, (int)2) && object != null) {
            this.logWithTimeAndKey("Decoded source from cache", l2);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Resource<T> loadFromCache(Key key) {
        File file = this.diskCacheProvider.getDiskCache().get(key);
        if (file == null) {
            return null;
        }
        Resource<T> resource = null;
        try {
            resource = this.loadProvider.getCacheDecoder().decode(file, this.width, this.height);
        }
        catch (Throwable throwable) {
            if (resource == null) {
                this.diskCacheProvider.getDiskCache().delete(key);
            }
            throw throwable;
        }
        if (resource == null) {
            void var1_1;
            this.diskCacheProvider.getDiskCache().delete((Key)var1_1);
        }
        return resource;
    }

    /*
     * WARNING - void declaration
     */
    private Resource<T> transform(Resource<T> decoded) {
        if (decoded == null) {
            return null;
        }
        Resource<T> resource = this.transformation.transform(decoded, this.width, this.height);
        if (!decoded.equals(resource)) {
            void var1_1;
            var1_1.recycle();
        }
        return resource;
    }

    /*
     * WARNING - void declaration
     */
    private Resource<Z> transcode(Resource<T> transformed) {
        void var1_1;
        if (transformed == null) {
            return null;
        }
        return this.transcoder.transcode((Resource<T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void logWithTimeAndKey(String message, long startTime) {
        void var2_2;
        void var1_1;
        Log.v((String)TAG, (String)(String.valueOf(var1_1) + " in " + LogTime.getElapsedMillis((long)var2_2) + ", key: " + this.resultKey));
    }

    static /* synthetic */ DecodeJob$FileOpener access$0(DecodeJob decodeJob) {
        return decodeJob.fileOpener;
    }
}

