/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.data;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.thirdparty.bumptech.glide.Priority;
import com.thirdparty.bumptech.glide.load.data.DataFetcher;
import com.thirdparty.bumptech.glide.load.data.ExifOrientationStream;
import com.thirdparty.bumptech.glide.load.data.MediaStoreThumbFetcher$ThumbnailStreamOpener;
import com.thirdparty.bumptech.glide.load.data.MediaStoreThumbFetcher$ThumbnailStreamOpenerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MediaStoreThumbFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "MediaStoreThumbFetcher";
    private static final int MINI_WIDTH = 512;
    private static final int MINI_HEIGHT = 384;
    private static final MediaStoreThumbFetcher$ThumbnailStreamOpenerFactory DEFAULT_FACTORY = new MediaStoreThumbFetcher$ThumbnailStreamOpenerFactory();
    private final Context context;
    private final Uri mediaStoreUri;
    private final DataFetcher<InputStream> defaultFetcher;
    private final int width;
    private final int height;
    private final MediaStoreThumbFetcher$ThumbnailStreamOpenerFactory factory;
    private InputStream inputStream;

    /*
     * WARNING - void declaration
     */
    public MediaStoreThumbFetcher(Context context, Uri mediaStoreUri, DataFetcher<InputStream> defaultFetcher, int width, int height) {
        this((Context)var1_1, (Uri)var2_2, (DataFetcher<InputStream>)var3_3, width, height, DEFAULT_FACTORY);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    MediaStoreThumbFetcher(Context context, Uri mediaStoreUri, DataFetcher<InputStream> defaultFetcher, int width, int height, MediaStoreThumbFetcher$ThumbnailStreamOpenerFactory factory) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.mediaStoreUri = var2_2;
        this.defaultFetcher = var3_3;
        this.width = width;
        this.height = height;
        this.factory = factory;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream loadData(Priority priority) {
        MediaStoreThumbFetcher$ThumbnailStreamOpener mediaStoreThumbFetcher$ThumbnailStreamOpener = this.factory.build(this.mediaStoreUri, this.width, this.height);
        if (mediaStoreThumbFetcher$ThumbnailStreamOpener != null) {
            this.inputStream = this.openThumbInputStream(mediaStoreThumbFetcher$ThumbnailStreamOpener);
        }
        if (this.inputStream == null) {
            void var1_1;
            this.inputStream = this.defaultFetcher.loadData((Priority)var1_1);
        }
        return this.inputStream;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream openThumbInputStream(MediaStoreThumbFetcher$ThumbnailStreamOpener fetcher) {
        InputStream inputStream;
        block4: {
            inputStream = null;
            try {
                inputStream = fetcher.open(this.context, this.mediaStoreUri);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block4;
                Log.d((String)TAG, (String)"Failed to find thumbnail file", (Throwable)fileNotFoundException);
            }
        }
        int n2 = -1;
        if (inputStream != null) {
            void var1_1;
            n2 = var1_1.getOrientation(this.context, this.mediaStoreUri);
        }
        if (n2 != -1) {
            inputStream = new ExifOrientationStream(inputStream, n2);
        }
        return inputStream;
    }

    @Override
    public void cleanup() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.defaultFetcher.cleanup();
    }

    @Override
    public String getId() {
        return this.mediaStoreUri.toString();
    }

    @Override
    public void cancel() {
    }

    private static boolean isMediaStoreUri(Uri uri) {
        Uri uri2;
        return uri != null && "content".equals(uri.getScheme()) && "media".equals(uri2.getAuthority());
    }

    private static boolean isMediaStoreVideo(Uri uri) {
        Uri uri2;
        return MediaStoreThumbFetcher.isMediaStoreUri(uri) && uri2.getPathSegments().contains("video");
    }

    static /* synthetic */ boolean access$1(Uri uri) {
        return MediaStoreThumbFetcher.isMediaStoreUri(uri);
    }

    static /* synthetic */ boolean access$2(Uri uri) {
        return MediaStoreThumbFetcher.isMediaStoreVideo(uri);
    }
}

