/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.load.data;

import java.io.FilterInputStream;
import java.io.InputStream;

public class ExifOrientationStream
extends FilterInputStream {
    private static final int SEGMENT_START_POSITION = 2;
    private static final byte[] EXIF_SEGMENT;
    private static final int SEGMENT_LENGTH;
    private static final int ORIENTATION_POSITION;
    private final byte orientation;
    private int position;

    static {
        byte[] byArray = new byte[29];
        byArray[0] = -1;
        byArray[1] = -31;
        byArray[3] = 28;
        byArray[4] = 69;
        byArray[5] = 120;
        byArray[6] = 105;
        byArray[7] = 102;
        byArray[10] = 77;
        byArray[11] = 77;
        byArray[17] = 8;
        byArray[19] = 1;
        byArray[20] = 1;
        byArray[21] = 18;
        byArray[23] = 2;
        byArray[27] = 1;
        EXIF_SEGMENT = byArray;
        SEGMENT_LENGTH = byArray.length;
        ORIENTATION_POSITION = SEGMENT_LENGTH + 2;
    }

    /*
     * WARNING - void declaration
     */
    public ExifOrientationStream(InputStream in, int orientation) {
        super((InputStream)var1_1);
        void var2_2;
        void var1_1;
        if (orientation < -1 || orientation > 8) {
            throw new IllegalArgumentException("Cannot add invalid orientation: " + orientation);
        }
        this.orientation = (byte)var2_2;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() {
        int n2 = this.position < 2 || this.position > ORIENTATION_POSITION ? super.read() : (this.position == ORIENTATION_POSITION ? (int)this.orientation : EXIF_SEGMENT[this.position - 2] & 0xFF);
        if (n2 != -1) {
            ++this.position;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) {
        int n2;
        if (this.position > ORIENTATION_POSITION) {
            n2 = super.read(buffer, byteOffset, n2);
        } else if (this.position == ORIENTATION_POSITION) {
            buffer[byteOffset] = this.orientation;
            n2 = 1;
        } else if (this.position < 2) {
            n2 = super.read(buffer, byteOffset, 2 - this.position);
        } else {
            void var2_2;
            void var1_1;
            n2 = Math.min(ORIENTATION_POSITION - this.position, n2);
            System.arraycopy(EXIF_SEGMENT, this.position - 2, var1_1, (int)var2_2, n2);
        }
        if (n2 > 0) {
            this.position += n2;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long byteCount) {
        void var1_1;
        long l2 = super.skip((long)var1_1);
        if (l2 > 0L) {
            this.position = (int)((long)this.position + l2);
        }
        return l2;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }
}

