/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.gifencoder;

class NeuQuant {
    protected static final int netsize = 256;
    protected static final int prime1 = 499;
    protected static final int prime2 = 491;
    protected static final int prime3 = 487;
    protected static final int prime4 = 503;
    protected static final int minpicturebytes = 1509;
    protected static final int maxnetpos = 255;
    protected static final int netbiasshift = 4;
    protected static final int ncycles = 100;
    protected static final int intbiasshift = 16;
    protected static final int intbias = 65536;
    protected static final int gammashift = 10;
    protected static final int gamma = 1024;
    protected static final int betashift = 10;
    protected static final int beta = 64;
    protected static final int betagamma = 65536;
    protected static final int initrad = 32;
    protected static final int radiusbiasshift = 6;
    protected static final int radiusbias = 64;
    protected static final int initradius = 2048;
    protected static final int radiusdec = 30;
    protected static final int alphabiasshift = 10;
    protected static final int initalpha = 1024;
    protected int alphadec;
    protected static final int radbiasshift = 8;
    protected static final int radbias = 256;
    protected static final int alpharadbshift = 18;
    protected static final int alpharadbias = 262144;
    protected byte[] thepicture;
    protected int lengthcount;
    protected int samplefac;
    protected int[][] network;
    protected int[] netindex = new int[256];
    protected int[] bias = new int[256];
    protected int[] freq = new int[256];
    protected int[] radpower = new int[32];

    /*
     * WARNING - void declaration
     */
    public NeuQuant(byte[] thepic, int len, int sample) {
        void var3_5;
        void var2_3;
        void var1_1;
        this.thepicture = var1_1;
        this.lengthcount = var2_3;
        this.samplefac = var3_5;
        this.network = new int[256][];
        int n2 = 0;
        while (n2 < 256) {
            this.network[n2] = new int[4];
            int[] nArray = this.network[n2];
            int[] nArray2 = nArray;
            nArray2[1] = nArray2[2] = (n2 << 12) / 256;
            nArray[0] = nArray2[2];
            this.freq[n2] = 256;
            this.bias[n2] = 0;
            ++n2;
        }
    }

    public byte[] colorMap() {
        byte[] byArray = new byte[768];
        int[] nArray = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            nArray[this.network[n2][3]] = n2;
            ++n2;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < 256) {
            int n4 = nArray[n3];
            byArray[n2++] = (byte)this.network[n4][0];
            byArray[n2++] = (byte)this.network[n4][1];
            byArray[n2++] = (byte)this.network[n4][2];
            ++n3;
        }
        return byArray;
    }

    public void inxbuild() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 256) {
            int[] nArray;
            int[] nArray2 = this.network[n5];
            int n6 = n5;
            int n7 = nArray2[1];
            n2 = n5 + 1;
            while (n2 < 256) {
                nArray = this.network[n2];
                if (nArray[1] < n7) {
                    n6 = n2;
                    n7 = nArray[1];
                }
                ++n2;
            }
            nArray = this.network[n6];
            if (n5 != n6) {
                n2 = nArray[0];
                nArray[0] = nArray2[0];
                nArray2[0] = n2;
                n2 = nArray[1];
                nArray[1] = nArray2[1];
                nArray2[1] = n2;
                n2 = nArray[2];
                nArray[2] = nArray2[2];
                nArray2[2] = n2;
                n2 = nArray[3];
                nArray[3] = nArray2[3];
                nArray2[3] = n2;
            }
            if (n7 != n3) {
                this.netindex[n3] = n4 + n5 >> 1;
                n2 = n3 + 1;
                while (n2 < n7) {
                    this.netindex[n2] = n5;
                    ++n2;
                }
                n3 = n7;
                n4 = n5;
            }
            ++n5;
        }
        this.netindex[n3] = n4 + 255 >> 1;
        n2 = n3 + 1;
        while (n2 < 256) {
            this.netindex[n2] = 255;
            ++n2;
        }
    }

    public void learn() {
        if (this.lengthcount < 1509) {
            this.samplefac = 1;
        }
        this.alphadec = 30 + (this.samplefac - 1) / 3;
        byte[] byArray = this.thepicture;
        int n2 = 0;
        int n3 = this.lengthcount;
        int n4 = this.lengthcount / (3 * this.samplefac);
        int n5 = n4 / 100;
        int n6 = 1024;
        int n7 = 2048;
        int n8 = 32;
        int n9 = 0;
        while (n9 < 32) {
            this.radpower[n9] = 1024 * ((1024 - n9 * n9) * 256 / 1024);
            ++n9;
        }
        int n10 = this.lengthcount < 1509 ? 3 : (this.lengthcount % 499 != 0 ? 1497 : (this.lengthcount % 491 != 0 ? 1473 : (this.lengthcount % 487 != 0 ? 1461 : 1509)));
        n9 = 0;
        while (n9 < n4) {
            int n11 = (byArray[n2 + 0] & 0xFF) << 4;
            int n12 = (byArray[n2 + 1] & 0xFF) << 4;
            int n13 = (byArray[n2 + 2] & 0xFF) << 4;
            int n14 = this.contest(n11, n12, n13);
            this.altersingle(n6, n14, n11, n12, n13);
            if (n8 != 0) {
                this.alterneigh(n8, n14, n11, n12, n13);
            }
            if ((n2 += n10) >= n3) {
                n2 -= this.lengthcount;
            }
            ++n9;
            if (n5 == 0) {
                n5 = 1;
            }
            if (n9 % n5 != 0) continue;
            n6 -= n6 / this.alphadec;
            if ((n8 = (n7 -= n7 / 30) >> 6) <= 1) {
                n8 = 0;
            }
            n14 = 0;
            while (n14 < n8) {
                this.radpower[n14] = n6 * ((n8 * n8 - n14 * n14) * 256 / (n8 * n8));
                ++n14;
            }
        }
    }

    public int map(int b2, int g2, int r2) {
        int n2 = 1000;
        int n3 = -1;
        int n4 = this.netindex[g2];
        int n5 = n4 - 1;
        while (n4 < 256 || n5 >= 0) {
            int n6;
            int n7;
            int[] nArray;
            if (n4 < 256) {
                nArray = this.network[n4];
                n7 = nArray[1] - g2;
                if (n7 >= n2) {
                    n4 = 256;
                } else {
                    ++n4;
                    if (n7 < 0) {
                        n7 = -n7;
                    }
                    if ((n6 = nArray[0] - b2) < 0) {
                        n6 = -n6;
                    }
                    if ((n7 += n6) < n2) {
                        n6 = nArray[2] - r2;
                        if (n6 < 0) {
                            n6 = -n6;
                        }
                        if ((n7 += n6) < n2) {
                            n2 = n7;
                            n3 = nArray[3];
                        }
                    }
                }
            }
            if (n5 < 0) continue;
            nArray = this.network[n5];
            n7 = g2 - nArray[1];
            if (n7 >= n2) {
                n5 = -1;
                continue;
            }
            --n5;
            if (n7 < 0) {
                n7 = -n7;
            }
            if ((n6 = nArray[0] - b2) < 0) {
                n6 = -n6;
            }
            if ((n7 += n6) >= n2) continue;
            n6 = nArray[2] - r2;
            if (n6 < 0) {
                n6 = -n6;
            }
            if ((n7 += n6) >= n2) continue;
            n2 = n7;
            n3 = nArray[3];
        }
        return n3;
    }

    public byte[] process() {
        this.learn();
        this.unbiasnet();
        this.inxbuild();
        return this.colorMap();
    }

    public void unbiasnet() {
        int n2 = 0;
        while (n2 < 256) {
            int[] nArray = this.network[n2];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[n2];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[n2];
            nArray3[2] = nArray3[2] >> 4;
            this.network[n2][3] = n2;
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void alterneigh(int rad, int i2, int b2, int g2, int r2) {
        void var2_2;
        int n2;
        int n3;
        int n4 = i2 - rad;
        if (n4 < -1) {
            n4 = -1;
        }
        if ((n3 = i2 + n2) > 256) {
            n3 = 256;
        }
        n2 = i2 + 1;
        --var2_2;
        int n5 = 1;
        while (n2 < n3 || var2_2 > n4) {
            int[] nArray;
            int n6 = this.radpower[n5++];
            if (n2 < n3) {
                nArray = this.network[n2++];
                try {
                    nArray[0] = nArray[0] - n6 * (nArray[0] - b2) / 262144;
                    nArray[1] = nArray[1] - n6 * (nArray[1] - g2) / 262144;
                    nArray[2] = nArray[2] - n6 * (nArray[2] - r2) / 262144;
                }
                catch (Exception exception) {}
            }
            if (var2_2 <= n4) continue;
            nArray = this.network[var2_2--];
            try {
                nArray[0] = nArray[0] - n6 * (nArray[0] - b2) / 262144;
                nArray[1] = nArray[1] - n6 * (nArray[1] - g2) / 262144;
                nArray[2] = nArray[2] - n6 * (nArray[2] - r2) / 262144;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void altersingle(int alpha, int i2, int b2, int g2, int r2) {
        void var1_1;
        void var3_4;
        void var2_2;
        int[] nArray = this.network[var2_2];
        int[] nArray2 = nArray;
        nArray[0] = nArray[0] - alpha * (nArray2[0] - var3_4) / 1024;
        nArray2[1] = nArray2[1] - alpha * (nArray2[1] - g2) / 1024;
        nArray2[2] = nArray2[2] - var1_1 * (nArray2[2] - r2) / 1024;
    }

    protected int contest(int b2, int g2, int r2) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < 256) {
            int n7;
            int[] nArray = this.network[n6];
            int n8 = nArray[0] - b2;
            if (n8 < 0) {
                n8 = -n8;
            }
            if ((n7 = nArray[1] - g2) < 0) {
                n7 = -n7;
            }
            n8 += n7;
            n7 = nArray[2] - r2;
            if (n7 < 0) {
                n7 = -n7;
            }
            if ((n8 += n7) < n2) {
                n2 = n8;
                n4 = n6;
            }
            if ((n8 -= this.bias[n6] >> 12) < n3) {
                n3 = n8;
                n5 = n6;
            }
            n8 = this.freq[n6] >> 10;
            int n9 = n6;
            this.freq[n9] = this.freq[n9] - n8;
            int n10 = n6++;
            this.bias[n10] = this.bias[n10] + (n8 << 10);
        }
        int n11 = n4;
        this.freq[n11] = this.freq[n11] + 64;
        int n12 = n4;
        this.bias[n12] = this.bias[n12] - 65536;
        return n5;
    }
}

