/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.gifencoder;

import java.io.OutputStream;

class LZWEncoder {
    private static final int EOF = -1;
    private int imgW;
    private int imgH;
    private byte[] pixAry;
    private int initCodeSize;
    private int remaining;
    private int curPixel;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks;
    int a_count;
    byte[] accum;

    /*
     * WARNING - void declaration
     */
    LZWEncoder(int width, int height, byte[] pixels, int color_depth) {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        this.masks = nArray;
        this.accum = new byte[256];
        this.imgW = var1_1;
        this.imgH = var2_2;
        this.pixAry = var3_3;
        this.initCodeSize = Math.max(2, color_depth);
    }

    /*
     * WARNING - void declaration
     */
    void char_out(byte c2, OutputStream outs) {
        void var1_1;
        this.accum[this.a_count++] = var1_1;
        if (this.a_count >= 254) {
            void var2_2;
            this.flush_char((OutputStream)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    void cl_block(OutputStream outs) {
        void var1_1;
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, (OutputStream)var1_1);
    }

    void cl_hash(int hsize) {
        int n2 = 0;
        while (n2 < hsize) {
            this.htab[n2] = -1;
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    void compress(int init_bits, OutputStream outs) {
        void var2_2;
        int n2;
        int n3;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n3 - true;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.a_count = 0;
        int n4 = this.nextPixel();
        int n5 = 0;
        n3 = this.hsize;
        while (n3 < 65536) {
            ++n5;
            n3 *= 2;
        }
        n5 = 8 - n5;
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outs);
        block1: while ((n2 = this.nextPixel()) != -1) {
            int n7 = n2 << n5 ^ n4;
            n3 = (n2 << this.maxbits) + n4;
            if (this.htab[n7] == n3) {
                n4 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n3) continue;
                    n4 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n4, outs);
            n4 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n3;
                continue;
            }
            this.cl_block(outs);
        }
        this.output(n4, outs);
        this.output(this.EOFCode, (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void encode(OutputStream os) {
        void var1_1;
        os.write(this.initCodeSize);
        this.remaining = this.imgW * this.imgH;
        this.curPixel = 0;
        this.compress(this.initCodeSize + 1, os);
        var1_1.write(0);
    }

    /*
     * WARNING - void declaration
     */
    void flush_char(OutputStream outs) {
        if (this.a_count > 0) {
            void var1_1;
            outs.write(this.a_count);
            var1_1.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int MAXCODE(int n_bits) {
        void var1_1;
        return (1 << var1_1) - 1;
    }

    private int nextPixel() {
        if (this.remaining == 0) {
            return -1;
        }
        --this.remaining;
        return this.pixAry[this.curPixel++] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    void output(int code, OutputStream outs) {
        void var1_1;
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outs);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (var1_1 == this.EOFCode) {
            void var2_2;
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char((OutputStream)var2_2);
        }
    }
}

