/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.gifencoder;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.util.Log;
import com.thirdparty.bumptech.glide.gifencoder.LZWEncoder;
import com.thirdparty.bumptech.glide.gifencoder.NeuQuant;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AnimatedGifEncoder {
    private static final String TAG = "AnimatedGifEncoder";
    private static final double MIN_TRANSPARENT_PERCENTAGE = 4.0;
    private int width;
    private int height;
    private Integer transparent = null;
    private int transIndex;
    private int repeat = -1;
    private int delay = 0;
    private boolean started = false;
    private OutputStream out;
    private Bitmap image;
    private byte[] pixels;
    private byte[] indexedPixels;
    private int colorDepth;
    private byte[] colorTab;
    private boolean[] usedEntry = new boolean[256];
    private int palSize = 7;
    private int dispose = -1;
    private boolean closeStream = false;
    private boolean firstFrame = true;
    private boolean sizeSet = false;
    private int sample = 10;
    private boolean hasTransparentPixels;

    /*
     * WARNING - void declaration
     */
    public void setDelay(int ms) {
        void var1_1;
        this.delay = Math.round((float)var1_1 / 10.0f);
    }

    /*
     * WARNING - void declaration
     */
    public void setDispose(int code) {
        if (code >= 0) {
            void var1_1;
            this.dispose = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRepeat(int iter) {
        if (iter >= 0) {
            void var1_1;
            this.repeat = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTransparent(int color) {
        void var1_1;
        this.transparent = (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addFrame(Bitmap im) {
        if (im == null || !this.started) {
            return false;
        }
        boolean bl = true;
        try {
            void var1_1;
            if (!this.sizeSet) {
                this.setSize(im.getWidth(), im.getHeight());
            }
            this.image = var1_1;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean bl = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameRate(float fps) {
        if (fps != 0.0f) {
            void var1_1;
            this.delay = Math.round(100.0f / var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setQuality(int quality) {
        void var1_1;
        if (quality <= 0) {
            quality = 1;
        }
        this.sample = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSize(int w2, int h2) {
        void var2_2;
        void var1_1;
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = var1_1;
        this.height = var2_2;
        if (this.width <= 0) {
            this.width = 320;
        }
        if (this.height <= 0) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean start(OutputStream os) {
        void var1_1;
        if (os == null) {
            return false;
        }
        boolean bl = true;
        this.closeStream = false;
        this.out = var1_1;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    /*
     * WARNING - void declaration
     */
    public boolean start(String file) {
        boolean bl = false;
        try {
            void var1_1;
            this.out = new BufferedOutputStream(new FileOutputStream((String)var1_1));
            bl = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    private void analyzePixels() {
        int n2;
        int n3 = this.pixels.length;
        int n4 = n3 / 3;
        this.indexedPixels = new byte[n4];
        NeuQuant neuQuant = new NeuQuant(this.pixels, n3, this.sample);
        this.colorTab = neuQuant.process();
        int n5 = 0;
        while (n5 < this.colorTab.length) {
            n2 = this.colorTab[n5];
            this.colorTab[n5] = this.colorTab[n5 + 2];
            this.colorTab[n5 + 2] = n2;
            this.usedEntry[n5 / 3] = false;
            n5 += 3;
        }
        n5 = 0;
        n2 = 0;
        while (n2 < n4) {
            int n6 = neuQuant.map(this.pixels[n5++] & 0xFF, this.pixels[n5++] & 0xFF, this.pixels[n5++] & 0xFF);
            this.usedEntry[n6] = true;
            this.indexedPixels[n2] = (byte)n6;
            ++n2;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            this.transIndex = this.findClosest(this.transparent);
            return;
        }
        if (this.hasTransparentPixels) {
            this.transIndex = this.findClosest(0);
        }
    }

    private int findClosest(int color) {
        int n2;
        if (this.colorTab == null) {
            return -1;
        }
        int n3 = Color.red((int)color);
        int n4 = Color.green((int)color);
        n2 = Color.blue((int)n2);
        int n5 = 0;
        int n6 = 0x1000000;
        int n7 = this.colorTab.length;
        int n8 = 0;
        while (n8 < n7) {
            int n9 = n3 - (this.colorTab[n8++] & 0xFF);
            int n10 = n4 - (this.colorTab[n8++] & 0xFF);
            int n11 = n2 - (this.colorTab[n8] & 0xFF);
            n9 = n9 * n9 + n10 * n10 + n11 * n11;
            n10 = n8 / 3;
            if (this.usedEntry[n10] && n9 < n6) {
                n6 = n9;
                n5 = n10;
            }
            ++n8;
        }
        return n5;
    }

    private void getImagePixels() {
        Object object;
        int n2 = this.image.getWidth();
        int n3 = this.image.getHeight();
        if (n2 != this.width || n3 != this.height) {
            object = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas(object).drawBitmap(object, 0.0f, 0.0f, null);
            this.image = object;
        }
        object = new int[n2 * n3];
        this.image.getPixels((int[])object, 0, n2, 0, 0, n2, n3);
        this.pixels = new byte[((Bitmap)object).length * 3];
        int n4 = 0;
        this.hasTransparentPixels = false;
        n2 = 0;
        Object object2 = object;
        n3 = ((Bitmap)object2).length;
        int n5 = 0;
        while (n5 < n3) {
            Bitmap bitmap = object2[n5];
            if (bitmap == false) {
                ++n2;
            }
            this.pixels[n4++] = (byte)(bitmap & 0xFF);
            this.pixels[n4++] = (byte)(bitmap >> 8 & 0xFF);
            this.pixels[n4++] = (byte)(bitmap >> 16 & 0xFF);
            ++n5;
        }
        double d2 = (double)(100 * n2) / (double)((Bitmap)object).length;
        boolean bl = this.hasTransparentPixels = d2 > 4.0;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("got pixels for frame with " + d2 + "% transparent pixels"));
        }
    }

    private void writeGraphicCtrlExt() {
        int n2;
        int n3;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null && !this.hasTransparentPixels) {
            n3 = 0;
            n2 = 0;
        } else {
            n3 = 1;
            n2 = 2;
        }
        if (this.dispose >= 0) {
            n2 = this.dispose & 7;
        }
        this.out.write((n2 <<= 2) | n3);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    private void writeImageDesc() {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
            return;
        }
        this.out.write(0x80 | this.palSize);
    }

    private void writeLSD() {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    private void writeNetscapeExt() {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    private void writePalette() {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n2 = 768 - this.colorTab.length;
        int n3 = 0;
        while (n3 < n2) {
            this.out.write(0);
            ++n3;
        }
    }

    private void writePixels() {
        new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth).encode(this.out);
    }

    /*
     * WARNING - void declaration
     */
    private void writeShort(int value) {
        void var1_1;
        this.out.write(value & 0xFF);
        this.out.write((int)(var1_1 >> 8 & 0xFF));
    }

    private void writeString(String s2) {
        int n2 = 0;
        while (n2 < s2.length()) {
            this.out.write((byte)s2.charAt(n2));
            ++n2;
        }
    }
}

