/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.gifdecoder;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.thirdparty.bumptech.glide.gifdecoder.GifDecoder$BitmapProvider;
import com.thirdparty.bumptech.glide.gifdecoder.GifFrame;
import com.thirdparty.bumptech.glide.gifdecoder.GifHeader;
import com.thirdparty.bumptech.glide.gifdecoder.GifHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;

public class GifDecoder {
    private static final String TAG = GifDecoder.class.getSimpleName();
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    public static final int STATUS_PARTIAL_DECODE = 3;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static final int NULL_CODE = -1;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private int[] act;
    private ByteBuffer rawData;
    private final byte[] block = new byte[256];
    private GifHeaderParser parser;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] mainPixels;
    private int[] mainScratch;
    private int framePointer;
    private byte[] data;
    private GifHeader header;
    private GifDecoder$BitmapProvider bitmapProvider;
    private Bitmap previousImage;
    private boolean savePrevious;
    private int status;

    /*
     * WARNING - void declaration
     */
    public GifDecoder(GifDecoder$BitmapProvider provider) {
        void var1_1;
        this.bitmapProvider = var1_1;
        this.header = new GifHeader();
    }

    public int getWidth() {
        return this.header.width;
    }

    public int getHeight() {
        return this.header.height;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getStatus() {
        return this.status;
    }

    public void advance() {
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
    }

    /*
     * WARNING - void declaration
     */
    public int getDelay(int n2) {
        int n3 = -1;
        if (n2 >= 0 && n2 < this.header.frameCount) {
            void var1_1;
            n3 = this.header.frames.get((int)var1_1).delay;
        }
        return n3;
    }

    public int getNextDelay() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            return -1;
        }
        return this.getDelay(this.framePointer);
    }

    public int getFrameCount() {
        return this.header.frameCount;
    }

    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    public void resetFrameIndex() {
        this.framePointer = -1;
    }

    public int getLoopCount() {
        return this.header.loopCount;
    }

    public synchronized Bitmap getNextFrame() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("unable to decode frame, frameCount=" + this.header.frameCount + " framePointer=" + this.framePointer));
            }
            this.status = 1;
        }
        if (this.status == 1 || this.status == 2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to decode frame, status=" + this.status));
            }
            return null;
        }
        this.status = 0;
        GifFrame gifFrame = this.header.frames.get(this.framePointer);
        int n2 = this.framePointer - 1;
        GifFrame gifFrame2 = n2 >= 0 ? this.header.frames.get(n2) : this.header.frames.get(this.getFrameCount() - 1);
        if (gifFrame.lct == null) {
            this.act = this.header.gct;
        } else {
            this.act = gifFrame.lct;
            if (this.header.bgIndex == gifFrame.transIndex) {
                this.header.bgColor = 0;
            }
        }
        int n3 = 0;
        if (gifFrame.transparency) {
            n3 = this.act[gifFrame.transIndex];
            this.act[gifFrame.transIndex] = 0;
        }
        if (this.act == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"No Valid Color Table");
            }
            this.status = 1;
            return null;
        }
        gifFrame2 = this.setPixels(gifFrame, gifFrame2);
        if (gifFrame.transparency) {
            this.act[gifFrame.transIndex] = n3;
        }
        return gifFrame2;
    }

    /*
     * WARNING - void declaration
     */
    public int read(InputStream is, int contentLength) {
        if (is != null) {
            try {
                int n2;
                int n3;
                n3 = contentLength > 0 ? n3 + 4096 : 16384;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
                byte[] byArray = new byte[16384];
                while ((n2 = is.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byteArrayOutputStream.flush();
                this.read(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)iOException);
            }
        } else {
            this.status = 2;
        }
        try {
            if (is != null) {
                void var1_1;
                var1_1.close();
            }
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Error closing stream", (Throwable)iOException);
        }
        return this.status;
    }

    public void clear() {
        this.header = null;
        this.data = null;
        this.mainPixels = null;
        this.mainScratch = null;
        if (this.previousImage != null) {
            this.bitmapProvider.release(this.previousImage);
        }
        this.previousImage = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setData(GifHeader header, byte[] data) {
        void var1_1;
        Iterator<GifFrame> iterator;
        this.header = header;
        this.data = data;
        this.status = 0;
        this.framePointer = -1;
        this.rawData = ByteBuffer.wrap((byte[])iterator);
        this.rawData.rewind();
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        iterator = header.frames.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().dispose != 3) continue;
            this.savePrevious = true;
            break;
        }
        this.mainPixels = new byte[header.width * header.height];
        this.mainScratch = new int[header.width * var1_1.height];
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    public int read(byte[] data) {
        this.data = data;
        this.header = this.getHeaderParser().setData(data).parseHeader();
        if (data != null) {
            Iterator<GifFrame> iterator;
            this.rawData = ByteBuffer.wrap((byte[])iterator);
            this.rawData.rewind();
            this.rawData.order(ByteOrder.LITTLE_ENDIAN);
            this.mainPixels = new byte[this.header.width * this.header.height];
            this.mainScratch = new int[this.header.width * this.header.height];
            this.savePrevious = false;
            iterator = this.header.frames.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().dispose != 3) continue;
                this.savePrevious = true;
                break;
            }
        }
        return this.status;
    }

    /*
     * WARNING - void declaration
     */
    private Bitmap setPixels(GifFrame currentFrame, GifFrame previousFrame) {
        void var1_1;
        int n2 = this.header.width;
        int n3 = this.header.height;
        int[] nArray = this.mainScratch;
        if (previousFrame != null && previousFrame.dispose > 0) {
            void var2_2;
            if (previousFrame.dispose == 2) {
                int n4 = 0;
                if (!currentFrame.transparency) {
                    n4 = this.header.bgColor;
                }
                Arrays.fill(nArray, n4);
            } else if (var2_2.dispose == 3 && this.previousImage != null) {
                this.previousImage.getPixels(nArray, 0, n2, 0, 0, n2, n3);
            }
        }
        this.decodeBitmapData(currentFrame);
        int n5 = 1;
        int n6 = 8;
        int n7 = 0;
        int n8 = 0;
        while (n8 < currentFrame.ih) {
            int n9 = n8;
            if (currentFrame.interlace) {
                if (n7 >= currentFrame.ih) {
                    switch (++n5) {
                        case 2: {
                            n7 = 4;
                            break;
                        }
                        case 3: {
                            n7 = 2;
                            n6 = 4;
                            break;
                        }
                        case 4: {
                            n7 = 1;
                            n6 = 2;
                        }
                    }
                }
                n9 = n7;
                n7 += n6;
            }
            if ((n9 += currentFrame.iy) < this.header.height) {
                int n10;
                int n11;
                if ((n9 *= this.header.width) + this.header.width < (n11 = (n10 = n9 + currentFrame.ix) + currentFrame.iw)) {
                    n11 = n9 + this.header.width;
                }
                n9 = n8 * currentFrame.iw;
                while (n10 < n11) {
                    int n12 = this.mainPixels[n9++] & 0xFF;
                    if ((n12 = this.act[n12]) != 0) {
                        nArray[n10] = n12;
                    }
                    ++n10;
                }
            }
            ++n8;
        }
        if (this.savePrevious && (currentFrame.dispose == 0 || var1_1.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.getNextBitmap();
            }
            this.previousImage.setPixels(nArray, 0, n2, 0, 0, n2, n3);
        }
        Bitmap bitmap = this.getNextBitmap();
        bitmap.setPixels(nArray, 0, n2, 0, 0, n2, n3);
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    private void decodeBitmapData(GifFrame frame) {
        void var1_1;
        int n2;
        if (frame != null) {
            this.rawData.position(frame.bufferFrameStart);
        }
        int n3 = n2 = frame == null ? this.header.width * this.header.height : frame.iw * var1_1.ih;
        if (this.mainPixels == null || this.mainPixels.length < n2) {
            this.mainPixels = new byte[n2];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n4 = this.read();
        int n5 = 1 << n4;
        int n6 = n5 + 1;
        int n7 = n5 + 2;
        int n8 = -1;
        int n9 = n4 + 1;
        int n10 = (1 << n9) - 1;
        int n11 = 0;
        while (n11 < n5) {
            this.prefix[n11] = 0;
            this.suffix[n11] = (byte)n11;
            ++n11;
        }
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        block1: while (n19 < n2) {
            if (n16 == 0) {
                n16 = this.readBlock();
                if (n16 <= 0) {
                    this.status = 3;
                    break;
                }
                n12 = 0;
            }
            n18 += (this.block[n12] & 0xFF) << n17;
            n17 += 8;
            ++n12;
            --n16;
            while (n17 >= n9) {
                n11 = n18 & n10;
                n18 >>= n9;
                n17 -= n9;
                if (n11 == n5) {
                    n9 = n4 + 1;
                    n10 = (1 << n9) - 1;
                    n7 = n5 + 2;
                    n8 = -1;
                    continue;
                }
                if (n11 > n7) {
                    this.status = 3;
                    continue block1;
                }
                if (n11 == n6) continue block1;
                if (n8 == -1) {
                    this.pixelStack[n14++] = this.suffix[n11];
                    n8 = n11;
                    n15 = n11;
                    continue;
                }
                int n20 = n11;
                if (n11 >= n7) {
                    this.pixelStack[n14++] = (byte)n15;
                    n11 = n8;
                }
                while (n11 >= n5) {
                    this.pixelStack[n14++] = this.suffix[n11];
                    n11 = this.prefix[n11];
                }
                n15 = this.suffix[n11] & 0xFF;
                this.pixelStack[n14++] = (byte)n15;
                if (n7 < 4096) {
                    this.prefix[n7] = (short)n8;
                    this.suffix[n7] = (byte)n15;
                    if ((++n7 & n10) == 0 && n7 < 4096) {
                        ++n9;
                        n10 += n7;
                    }
                }
                n8 = n20;
                while (n14 > 0) {
                    this.mainPixels[n13++] = this.pixelStack[--n14];
                    ++n19;
                }
            }
        }
        n19 = n13;
        while (n19 < n2) {
            this.mainPixels[n19] = 0;
            ++n19;
        }
    }

    private int read() {
        int n2 = 0;
        try {
            n2 = this.rawData.get() & 0xFF;
        }
        catch (Exception exception) {
            this.status = 1;
        }
        return n2;
    }

    private int readBlock() {
        int n2 = this.read();
        int n3 = 0;
        if (n2 > 0) {
            try {
                while (n3 < n2) {
                    int n4 = n2 - n3;
                    this.rawData.get(this.block, n3, n4);
                    n3 += n4;
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Error Reading Block", (Throwable)exception);
                this.status = 1;
            }
        }
        return n3;
    }

    private Bitmap getNextBitmap() {
        Bitmap bitmap = this.bitmapProvider.obtain(this.header.width, this.header.height, BITMAP_CONFIG);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)this.header.width, (int)this.header.height, (Bitmap.Config)BITMAP_CONFIG);
        }
        GifDecoder.setAlpha(bitmap);
        return bitmap;
    }

    @TargetApi(value=12)
    private static void setAlpha(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            Bitmap bitmap2;
            bitmap2.setHasAlpha(true);
        }
    }
}

