/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.disklrucache;

import com.thirdparty.bumptech.glide.disklrucache.StrictLineReader$1;
import com.thirdparty.bumptech.glide.disklrucache.Util;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

class StrictLineReader
implements Closeable {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final InputStream in;
    private final Charset charset;
    private byte[] buf;
    private int pos;
    private int end;

    /*
     * WARNING - void declaration
     */
    public StrictLineReader(InputStream in, Charset charset) {
        this((InputStream)var1_1, 8192, (Charset)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrictLineReader(InputStream in, int capacity, Charset charset) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (in == null || charset == null) {
            throw new NullPointerException();
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        if (!charset.equals(Util.US_ASCII)) {
            throw new IllegalArgumentException("Unsupported encoding");
        }
        this.in = var1_1;
        this.charset = var3_3;
        this.buf = new byte[var2_2];
    }

    @Override
    public void close() {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf != null) {
                this.buf = null;
                this.in.close();
            }
            return;
        }
    }

    public String readLine() {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf == null) {
                throw new IOException("LineReader is closed");
            }
            if (this.pos >= this.end) {
                this.fillBuf();
            }
            int n2 = this.pos;
            while (n2 != this.end) {
                if (this.buf[n2] == 10) {
                    int n3 = n2 != this.pos && this.buf[n2 - 1] == 13 ? n2 - 1 : n2;
                    String string = new String(this.buf, this.pos, n3 - this.pos, this.charset.name());
                    this.pos = n2 + 1;
                    return string;
                }
                ++n2;
            }
            StrictLineReader$1 strictLineReader$1 = new StrictLineReader$1(this, this.end - this.pos + 80);
            block4: while (true) {
                strictLineReader$1.write(this.buf, this.pos, this.end - this.pos);
                this.end = -1;
                this.fillBuf();
                int n4 = this.pos;
                while (true) {
                    if (n4 == this.end) continue block4;
                    if (this.buf[n4] == 10) {
                        if (n4 != this.pos) {
                            strictLineReader$1.write(this.buf, this.pos, n4 - this.pos);
                        }
                        this.pos = n4 + 1;
                        return ((ByteArrayOutputStream)strictLineReader$1).toString();
                    }
                    ++n4;
                }
                break;
            }
        }
    }

    public boolean hasUnterminatedLine() {
        return this.end == -1;
    }

    private void fillBuf() {
        int n2 = this.in.read(this.buf, 0, this.buf.length);
        if (n2 == -1) {
            throw new EOFException();
        }
        this.pos = 0;
        this.end = n2;
    }

    static /* synthetic */ Charset access$0(StrictLineReader strictLineReader) {
        return strictLineReader.charset;
    }
}

