/*
 * Decompiled with CFR 0.152.
 */
package com.thirdparty.bumptech.glide.disklrucache;

import com.thirdparty.bumptech.glide.disklrucache.DiskLruCache$1;
import com.thirdparty.bumptech.glide.disklrucache.DiskLruCache$Editor;
import com.thirdparty.bumptech.glide.disklrucache.DiskLruCache$Entry;
import com.thirdparty.bumptech.glide.disklrucache.DiskLruCache$Value;
import com.thirdparty.bumptech.glide.disklrucache.StrictLineReader;
import com.thirdparty.bumptech.glide.disklrucache.Util;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DiskLruCache
implements Closeable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    private final int valueCount;
    private long size = 0L;
    private Writer journalWriter;
    private final LinkedHashMap<String, DiskLruCache$Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private int redundantOpCount;
    private long nextSequenceNumber = 0L;
    final ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> cleanupCallable = new DiskLruCache$1(this);

    /*
     * WARNING - void declaration
     */
    private DiskLruCache(File directory, int appVersion, int valueCount, long maxSize) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.directory = directory;
        this.appVersion = var2_2;
        this.journalFile = new File(directory, JOURNAL_FILE);
        this.journalFileTmp = new File(directory, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File((File)var1_1, JOURNAL_FILE_BACKUP);
        this.valueCount = var3_3;
        this.maxSize = maxSize;
    }

    /*
     * WARNING - void declaration
     */
    public static DiskLruCache open(File directory, int appVersion, int valueCount, long maxSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        File file;
        Object object;
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (valueCount <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        File file2 = new File(directory, JOURNAL_FILE_BACKUP);
        if (file2.exists()) {
            object = new File(directory, JOURNAL_FILE);
            if (((File)object).exists()) {
                file2.delete();
            } else {
                DiskLruCache.renameTo(file2, (File)object, false);
            }
        }
        object = new DiskLruCache(directory, appVersion, valueCount, maxSize);
        if (((DiskLruCache)object).journalFile.exists()) {
            try {
                super.readJournal();
                super.processJournal();
                return object;
            }
            catch (IOException iOException) {
                System.out.println("DiskLruCache " + directory + " is corrupt: " + iOException.getMessage() + ", removing");
                ((DiskLruCache)object).delete();
            }
        }
        directory.mkdirs();
        object = new DiskLruCache(file, (int)var1_1, (int)var2_2, (long)var3_3);
        ((DiskLruCache)object).rebuildJournal();
        return object;
    }

    private void readJournal() {
        StrictLineReader strictLineReader = new StrictLineReader(new FileInputStream(this.journalFile), Util.US_ASCII);
        try {
            String string = strictLineReader.readLine();
            String string2 = strictLineReader.readLine();
            String string3 = strictLineReader.readLine();
            String string4 = strictLineReader.readLine();
            String string5 = strictLineReader.readLine();
            if (!(MAGIC.equals(string) && VERSION_1.equals(string2) && Integer.toString(this.appVersion).equals(string3) && Integer.toString(this.valueCount).equals(string4) && "".equals(string5))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + "]");
            }
            int n2 = 0;
            try {
                while (true) {
                    this.readJournalLine(strictLineReader.readLine());
                    ++n2;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = n2 - this.lruEntries.size();
                if (strictLineReader.hasUnterminatedLine()) {
                    this.rebuildJournal();
                } else {
                    this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), Util.US_ASCII));
                }
            }
        }
        finally {
            Util.closeQuietly(strictLineReader);
        }
    }

    private void readJournalLine(String line) {
        String[] stringArray;
        DiskLruCache$Entry diskLruCache$Entry;
        String string;
        int n2 = line.indexOf(32);
        if (n2 == -1) {
            throw new IOException("unexpected journal line: " + line);
        }
        int n3 = n2 + 1;
        int n4 = line.indexOf(32, n3);
        if (n4 == -1) {
            string = line.substring(n3);
            if (n2 == 6 && line.startsWith(REMOVE)) {
                this.lruEntries.remove(string);
                return;
            }
        } else {
            string = line.substring(n3, n4);
        }
        if ((diskLruCache$Entry = this.lruEntries.get(string)) == null) {
            diskLruCache$Entry = new DiskLruCache$Entry(this, string, null);
            this.lruEntries.put(string, diskLruCache$Entry);
        }
        if (n4 != -1 && n2 == 5 && line.startsWith(CLEAN)) {
            stringArray = stringArray.substring(n4 + 1).split(" ");
            DiskLruCache$Entry.access$3(diskLruCache$Entry, true);
            DiskLruCache$Entry.access$4(diskLruCache$Entry, null);
            DiskLruCache$Entry.access$5(diskLruCache$Entry, stringArray);
            return;
        }
        if (n4 == -1 && n2 == 5 && stringArray.startsWith(DIRTY)) {
            DiskLruCache$Entry.access$4(diskLruCache$Entry, new DiskLruCache$Editor(this, diskLruCache$Entry, null));
            return;
        }
        if (n4 != -1 || n2 != 4 || !stringArray.startsWith(READ)) {
            throw new IOException("unexpected journal line: " + (String)stringArray);
        }
    }

    private void processJournal() {
        DiskLruCache.deleteIfExists(this.journalFileTmp);
        Iterator<DiskLruCache$Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            DiskLruCache$Entry diskLruCache$Entry = iterator.next();
            if (DiskLruCache$Entry.access$1(diskLruCache$Entry) == null) {
                n2 = 0;
                while (n2 < this.valueCount) {
                    this.size += DiskLruCache$Entry.access$6(diskLruCache$Entry)[n2];
                    ++n2;
                }
                continue;
            }
            DiskLruCache$Entry.access$4(diskLruCache$Entry, null);
            n2 = 0;
            while (n2 < this.valueCount) {
                DiskLruCache.deleteIfExists(diskLruCache$Entry.getCleanFile(n2));
                DiskLruCache.deleteIfExists(diskLruCache$Entry.getDirtyFile(n2));
                ++n2;
            }
            iterator.remove();
        }
    }

    private synchronized void rebuildJournal() {
        if (this.journalWriter != null) {
            this.journalWriter.close();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFileTmp), Util.US_ASCII));){
            bufferedWriter.write(MAGIC);
            bufferedWriter.write("\n");
            bufferedWriter.write(VERSION_1);
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.appVersion));
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.valueCount));
            bufferedWriter.write("\n");
            bufferedWriter.write("\n");
            for (DiskLruCache$Entry diskLruCache$Entry : this.lruEntries.values()) {
                if (DiskLruCache$Entry.access$1(diskLruCache$Entry) != null) {
                    bufferedWriter.write("DIRTY " + DiskLruCache$Entry.access$7(diskLruCache$Entry) + '\n');
                    continue;
                }
                bufferedWriter.write("CLEAN " + DiskLruCache$Entry.access$7(diskLruCache$Entry) + diskLruCache$Entry.getLengths() + '\n');
            }
        }
        if (this.journalFile.exists()) {
            DiskLruCache.renameTo(this.journalFile, this.journalFileBackup, true);
        }
        DiskLruCache.renameTo(this.journalFileTmp, this.journalFile, false);
        this.journalFileBackup.delete();
        this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), Util.US_ASCII));
    }

    private static void deleteIfExists(File file) {
        File file2;
        if (file.exists() && !file2.delete()) {
            throw new IOException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void renameTo(File from, File to, boolean deleteDestination) {
        void var1_1;
        File file;
        if (deleteDestination) {
            DiskLruCache.deleteIfExists(to);
        }
        if (!file.renameTo((File)var1_1)) {
            throw new IOException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized DiskLruCache$Value get(String key) {
        void var1_1;
        this.checkNotClosed();
        DiskLruCache$Entry diskLruCache$Entry = this.lruEntries.get(key);
        if (diskLruCache$Entry == null) {
            return null;
        }
        if (!DiskLruCache$Entry.access$0(diskLruCache$Entry)) {
            return null;
        }
        File[] fileArray = diskLruCache$Entry.cleanFiles;
        int n2 = diskLruCache$Entry.cleanFiles.length;
        int n3 = 0;
        while (n3 < n2) {
            if (!fileArray[n3].exists()) {
                return null;
            }
            ++n3;
        }
        ++this.redundantOpCount;
        this.journalWriter.append(READ);
        this.journalWriter.append(' ');
        this.journalWriter.append(key);
        this.journalWriter.append('\n');
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return new DiskLruCache$Value(this, (String)var1_1, DiskLruCache$Entry.access$8(diskLruCache$Entry), diskLruCache$Entry.cleanFiles, DiskLruCache$Entry.access$6(diskLruCache$Entry), null);
    }

    /*
     * WARNING - void declaration
     */
    public final DiskLruCache$Editor edit(String key) {
        void var1_1;
        return this.edit((String)var1_1, -1L);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized DiskLruCache$Editor edit(String key, long expectedSequenceNumber) {
        void var1_1;
        void var2_2;
        this.checkNotClosed();
        DiskLruCache$Entry diskLruCache$Entry = this.lruEntries.get(key);
        if (expectedSequenceNumber != -1L && (diskLruCache$Entry == null || DiskLruCache$Entry.access$8(diskLruCache$Entry) != var2_2)) {
            return null;
        }
        if (diskLruCache$Entry == null) {
            diskLruCache$Entry = new DiskLruCache$Entry(this, key, null);
            this.lruEntries.put(key, diskLruCache$Entry);
        } else if (DiskLruCache$Entry.access$1(diskLruCache$Entry) != null) {
            return null;
        }
        DiskLruCache$Editor diskLruCache$Editor = new DiskLruCache$Editor(this, diskLruCache$Entry, null);
        DiskLruCache$Entry.access$4(diskLruCache$Entry, diskLruCache$Editor);
        this.journalWriter.append(DIRTY);
        this.journalWriter.append(' ');
        this.journalWriter.append((CharSequence)var1_1);
        this.journalWriter.append('\n');
        this.journalWriter.flush();
        return diskLruCache$Editor;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final synchronized long getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void setMaxSize(long maxSize) {
        void var1_1;
        this.maxSize = var1_1;
        this.executorService.submit(this.cleanupCallable);
    }

    public final synchronized long size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void completeEdit(DiskLruCache$Editor editor, boolean success) {
        int n2;
        DiskLruCache$Entry diskLruCache$Entry = DiskLruCache$Editor.access$1(editor);
        if (DiskLruCache$Entry.access$1(diskLruCache$Entry) != editor) {
            throw new IllegalStateException();
        }
        if (success && !DiskLruCache$Entry.access$0(diskLruCache$Entry)) {
            n2 = 0;
            while (n2 < this.valueCount) {
                if (!DiskLruCache$Editor.access$2(editor)[n2]) {
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + n2);
                }
                if (!diskLruCache$Entry.getDirtyFile(n2).exists()) {
                    editor.abort();
                    return;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.valueCount) {
            File file = diskLruCache$Entry.getDirtyFile(n2);
            if (success) {
                if (file.exists()) {
                    long l2;
                    File file2 = diskLruCache$Entry.getCleanFile(n2);
                    file.renameTo(file2);
                    long l3 = DiskLruCache$Entry.access$6(diskLruCache$Entry)[n2];
                    DiskLruCache$Entry.access$6((DiskLruCache$Entry)diskLruCache$Entry)[n2] = l2 = file2.length();
                    this.size = this.size - l3 + l2;
                }
            } else {
                DiskLruCache.deleteIfExists(file);
            }
            ++n2;
        }
        ++this.redundantOpCount;
        DiskLruCache$Entry.access$4(diskLruCache$Entry, null);
        if (DiskLruCache$Entry.access$0(diskLruCache$Entry) | success) {
            void var2_2;
            DiskLruCache$Entry.access$3(diskLruCache$Entry, true);
            this.journalWriter.append(CLEAN);
            this.journalWriter.append(' ');
            this.journalWriter.append(DiskLruCache$Entry.access$7(diskLruCache$Entry));
            this.journalWriter.append(diskLruCache$Entry.getLengths());
            this.journalWriter.append('\n');
            if (var2_2 != false) {
                DiskLruCache$Entry.access$9(diskLruCache$Entry, this.nextSequenceNumber++);
            }
        } else {
            this.lruEntries.remove(DiskLruCache$Entry.access$7(diskLruCache$Entry));
            this.journalWriter.append(REMOVE);
            this.journalWriter.append(' ');
            this.journalWriter.append(DiskLruCache$Entry.access$7(diskLruCache$Entry));
            this.journalWriter.append('\n');
        }
        this.journalWriter.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
    }

    private boolean journalRebuildRequired() {
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean remove(String key) {
        void var1_1;
        this.checkNotClosed();
        DiskLruCache$Entry diskLruCache$Entry = this.lruEntries.get(key);
        if (diskLruCache$Entry == null || DiskLruCache$Entry.access$1(diskLruCache$Entry) != null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.valueCount) {
            File file = diskLruCache$Entry.getCleanFile(n2);
            if (file.exists() && !file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.size -= DiskLruCache$Entry.access$6(diskLruCache$Entry)[n2];
            DiskLruCache$Entry.access$6((DiskLruCache$Entry)diskLruCache$Entry)[n2] = 0L;
            ++n2;
        }
        ++this.redundantOpCount;
        this.journalWriter.append(REMOVE);
        this.journalWriter.append(' ');
        this.journalWriter.append(key);
        this.journalWriter.append('\n');
        this.lruEntries.remove(var1_1);
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return true;
    }

    public final synchronized boolean isClosed() {
        return this.journalWriter == null;
    }

    private void checkNotClosed() {
        if (this.journalWriter == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public final synchronized void flush() {
        this.checkNotClosed();
        this.trimToSize();
        this.journalWriter.flush();
    }

    @Override
    public final synchronized void close() {
        if (this.journalWriter == null) {
            return;
        }
        for (DiskLruCache$Entry diskLruCache$Entry : new ArrayList<DiskLruCache$Entry>(this.lruEntries.values())) {
            if (DiskLruCache$Entry.access$1(diskLruCache$Entry) == null) continue;
            DiskLruCache$Entry.access$1(diskLruCache$Entry).abort();
        }
        this.trimToSize();
        this.journalWriter.close();
        this.journalWriter = null;
    }

    private void trimToSize() {
        while (this.size > this.maxSize) {
            Map.Entry<String, DiskLruCache$Entry> entry = this.lruEntries.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public final void delete() {
        this.close();
        Util.deleteContents(this.directory);
    }

    private static String inputStreamToString(InputStream in) {
        InputStream inputStream;
        return Util.readFully(new InputStreamReader(inputStream, Util.UTF_8));
    }

    static /* synthetic */ Writer access$0(DiskLruCache diskLruCache) {
        return diskLruCache.journalWriter;
    }

    static /* synthetic */ void access$1(DiskLruCache diskLruCache) {
        diskLruCache.trimToSize();
    }

    static /* synthetic */ boolean access$2(DiskLruCache diskLruCache) {
        return diskLruCache.journalRebuildRequired();
    }

    static /* synthetic */ void access$3(DiskLruCache diskLruCache) {
        diskLruCache.rebuildJournal();
    }

    static /* synthetic */ void access$4(DiskLruCache diskLruCache, int n2) {
        diskLruCache.redundantOpCount = n2;
    }

    static /* synthetic */ DiskLruCache$Editor access$5(DiskLruCache diskLruCache, String string, long l2) {
        return diskLruCache.edit(string, l2);
    }

    static /* synthetic */ String access$6(InputStream inputStream) {
        return DiskLruCache.inputStreamToString(inputStream);
    }

    static /* synthetic */ int access$7(DiskLruCache diskLruCache) {
        return diskLruCache.valueCount;
    }

    static /* synthetic */ File access$8(DiskLruCache diskLruCache) {
        return diskLruCache.directory;
    }

    static /* synthetic */ void access$9(DiskLruCache diskLruCache, DiskLruCache$Editor diskLruCache$Editor, boolean bl) {
        diskLruCache.completeEdit(diskLruCache$Editor, bl);
    }
}

